# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['rocketchat_async']

package_data = \
{'': ['*']}

install_requires = \
['websockets>=10.4,<11.0']

setup_kwargs = {
    'name': 'rocketchat-async',
    'version': '1.0.1',
    'description': 'asyncio-based Python wrapper for the Rocket.Chat Realtime API.',
    'long_description': '# rocketchat-async\n\nasyncio-based Python wrapper for the Rocket.Chat Realtime API.\n\n## When should you use this library?\n\nUse this library if you:\n\n- want to integrate with Rocket.Chat from Python\n- are using [asyncio](https://docs.python.org/3/library/asyncio.html) to drive your code\n- want to use Rocket.Chat\'s efficient websockets-based Realtime API\n\n## Installation\n\n`pip install rocketchat-async`\n\n## Example usage\n\n```python\nimport asyncio\nfrom rocketchat_async import RocketChat\n\n\ndef handle_message(channel_id, sender_id, msg_id, thread_id, msg, qualifier):\n    """Simply print the message that arrived."""\n    print(msg)\n\n\nasync def main(address, username, password):\n    rc = RocketChat()\n    await rc.start(address, username, password)\n    # A possible workflow consists of two steps:\n    #\n    # 1. Set up the desired callbacks...\n    for channel_id, channel_type in await rc.get_channels():\n        await rc.subscribe_to_channel_messages(channel_id, handle_message)\n    # 2. ...and then simply wait for the registered events.\n    await rc.run_forever()\n\n\n# Side note: Don\'t forget to use the wss:// scheme when TLS is used.\nasyncio.run(main(\'ws://localhost:3000/websocket\', \'username\', \'password\'))\n```\n\n## API Overview\n\nBrief overview of the currently implemented methods.\n\nAs of now, Rocket.Chat\'s API is only covered partially (based on my original\nneeds). I am open to both feature requests as well as pull requests.\n\n### Methods\n\n#### `RocketChat.get_channels()`\n\nGet a list of channels the logged-in user is currently member of.\n\n#### `RocketChat.send_message(text, channel_id, thread_id=None)`\n\nSend a text message to a channel.\n\n#### `RocketChat.send_reaction(orig_msg_id, emoji)`\n\nSend a reaction to a specific message.\n\n#### `RocketChat.send_typing_event(channel_id, is_typing)`\n\nSend the "typing" event to a channel.\n\n#### `RocketChat.subscribe_to_channel_messages(channel_id, callback)`\n\nSubscribe to all messages in the given channel. Returns the subscription ID.\n\nThe provided callback should accept six arguments: `channel_id`,\n`sender_id`, `msg_id`, `thread_id`, `msg_text` and\n`msg_qualifier`. The qualifier can help to determine if e.g. the\nmessage is a system message about the user being removed from\nthe channel.\n\n#### `RocketChat.subscribe_to_channel_changes(callback)`\n\nSubscribe to all changes in channels. Returns the subscription ID.\n\nThe provided callback should accept two arguments: `channel_id`\nand `channel_qualifier`. The qualifier helps to determine e.g.\nif it\'s a direct message or a normal room.\n\n#### `RocketChat.unsubscribe(subscription_id)`\n\nCancel a subscription.\n',
    'author': 'Hynek Urban',
    'author_email': 'hynek.urban@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'https://github.com/hynek-urban/rocketchat-async',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.7',
}


setup(**setup_kwargs)
