# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class UpdateTimeOffPlanRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        UpdateTimeOffPlanRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'activity_code_ids': 'SetWrapperString',
            'time_off_limit_ids': 'SetWrapperString',
            'auto_approval_rule': 'str',
            'days_before_start_to_expire_from_waitlist': 'int',
            'active': 'bool',
            'metadata': 'WfmVersionedEntityMetadata'
        }

        self.attribute_map = {
            'name': 'name',
            'activity_code_ids': 'activityCodeIds',
            'time_off_limit_ids': 'timeOffLimitIds',
            'auto_approval_rule': 'autoApprovalRule',
            'days_before_start_to_expire_from_waitlist': 'daysBeforeStartToExpireFromWaitlist',
            'active': 'active',
            'metadata': 'metadata'
        }

        self._name = None
        self._activity_code_ids = None
        self._time_off_limit_ids = None
        self._auto_approval_rule = None
        self._days_before_start_to_expire_from_waitlist = None
        self._active = None
        self._metadata = None

    @property
    def name(self):
        """
        Gets the name of this UpdateTimeOffPlanRequest.
        The name of this time off plan.

        :return: The name of this UpdateTimeOffPlanRequest.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this UpdateTimeOffPlanRequest.
        The name of this time off plan.

        :param name: The name of this UpdateTimeOffPlanRequest.
        :type: str
        """
        

        self._name = name

    @property
    def activity_code_ids(self):
        """
        Gets the activity_code_ids of this UpdateTimeOffPlanRequest.
        The set of activity code IDs to associate with this time off plan.

        :return: The activity_code_ids of this UpdateTimeOffPlanRequest.
        :rtype: SetWrapperString
        """
        return self._activity_code_ids

    @activity_code_ids.setter
    def activity_code_ids(self, activity_code_ids):
        """
        Sets the activity_code_ids of this UpdateTimeOffPlanRequest.
        The set of activity code IDs to associate with this time off plan.

        :param activity_code_ids: The activity_code_ids of this UpdateTimeOffPlanRequest.
        :type: SetWrapperString
        """
        

        self._activity_code_ids = activity_code_ids

    @property
    def time_off_limit_ids(self):
        """
        Gets the time_off_limit_ids of this UpdateTimeOffPlanRequest.
        The set of time off limit IDs to associate with this time off plan.

        :return: The time_off_limit_ids of this UpdateTimeOffPlanRequest.
        :rtype: SetWrapperString
        """
        return self._time_off_limit_ids

    @time_off_limit_ids.setter
    def time_off_limit_ids(self, time_off_limit_ids):
        """
        Sets the time_off_limit_ids of this UpdateTimeOffPlanRequest.
        The set of time off limit IDs to associate with this time off plan.

        :param time_off_limit_ids: The time_off_limit_ids of this UpdateTimeOffPlanRequest.
        :type: SetWrapperString
        """
        

        self._time_off_limit_ids = time_off_limit_ids

    @property
    def auto_approval_rule(self):
        """
        Gets the auto_approval_rule of this UpdateTimeOffPlanRequest.
        Auto approval rule for the time off plan.

        :return: The auto_approval_rule of this UpdateTimeOffPlanRequest.
        :rtype: str
        """
        return self._auto_approval_rule

    @auto_approval_rule.setter
    def auto_approval_rule(self, auto_approval_rule):
        """
        Sets the auto_approval_rule of this UpdateTimeOffPlanRequest.
        Auto approval rule for the time off plan.

        :param auto_approval_rule: The auto_approval_rule of this UpdateTimeOffPlanRequest.
        :type: str
        """
        allowed_values = ["Never", "Always", "CheckLimits"]
        if auto_approval_rule.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for auto_approval_rule -> " + auto_approval_rule)
            self._auto_approval_rule = "outdated_sdk_version"
        else:
            self._auto_approval_rule = auto_approval_rule

    @property
    def days_before_start_to_expire_from_waitlist(self):
        """
        Gets the days_before_start_to_expire_from_waitlist of this UpdateTimeOffPlanRequest.
        The number of days before the time off request start date for when the request will be expired from the waitlist.

        :return: The days_before_start_to_expire_from_waitlist of this UpdateTimeOffPlanRequest.
        :rtype: int
        """
        return self._days_before_start_to_expire_from_waitlist

    @days_before_start_to_expire_from_waitlist.setter
    def days_before_start_to_expire_from_waitlist(self, days_before_start_to_expire_from_waitlist):
        """
        Sets the days_before_start_to_expire_from_waitlist of this UpdateTimeOffPlanRequest.
        The number of days before the time off request start date for when the request will be expired from the waitlist.

        :param days_before_start_to_expire_from_waitlist: The days_before_start_to_expire_from_waitlist of this UpdateTimeOffPlanRequest.
        :type: int
        """
        

        self._days_before_start_to_expire_from_waitlist = days_before_start_to_expire_from_waitlist

    @property
    def active(self):
        """
        Gets the active of this UpdateTimeOffPlanRequest.
        Whether this time off plan should be used by agents.

        :return: The active of this UpdateTimeOffPlanRequest.
        :rtype: bool
        """
        return self._active

    @active.setter
    def active(self, active):
        """
        Sets the active of this UpdateTimeOffPlanRequest.
        Whether this time off plan should be used by agents.

        :param active: The active of this UpdateTimeOffPlanRequest.
        :type: bool
        """
        

        self._active = active

    @property
    def metadata(self):
        """
        Gets the metadata of this UpdateTimeOffPlanRequest.
        Version metadata for the time off plan

        :return: The metadata of this UpdateTimeOffPlanRequest.
        :rtype: WfmVersionedEntityMetadata
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata):
        """
        Sets the metadata of this UpdateTimeOffPlanRequest.
        Version metadata for the time off plan

        :param metadata: The metadata of this UpdateTimeOffPlanRequest.
        :type: WfmVersionedEntityMetadata
        """
        

        self._metadata = metadata

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

