'''
Author: ZHANG XIANRUI
Date: 2021-08-16 23:16:12
LastEditTime: 2021-08-17 13:11:52
LastEditors: ZHANG XIANRUI
Description: 
'''
# Always prefer setuptools over distutils
from setuptools import setup, find_packages
from codecs import open  # To use a consistent encoding
from os import path

here = path.abspath(path.dirname(__file__))

# Get the long description from the relevant file
with open(path.join(here, 'README.md'), encoding='utf-8') as f:
    long_description = f.read()

# This will add __version__ to version dict
version = {}
with open(path.join(here, 'version.py'), encoding='utf-8') as (version_file):
    exec(version_file.read(), version)

setup(
    name='deepslide',
    version=version['__version__'],
    description='A python toolbox to split whole slide image.',
    long_description=long_description,
    long_description_content_type='text/markdown',

    # The project's main homepage.
    url='https://github.com/xu-kun-cai/deepslide',

    # Author details
    author='Xianrui ZHANG and ...',
    author_email='zhangxianrui89@gmail.com',

    # Choose your license
    license='BSD 3-Clause',
    install_requires=['openslide-python', 'Pillow', 'numpy', 'matplotlib'],
    #tests_require = [...]
    classifiers=[
        'Development Status :: 3 - Alpha',
        # Indicate who your project is intended for
        "Intended Audience :: Developers",
        "Intended Audience :: Science/Research",
        'Topic :: Software Development :: Build Tools',
        "Topic :: Scientific/Engineering :: Artificial Intelligence",

        # Pick your license as you wish (should match "license" above)
        'License :: OSI Approved :: BSD License',

        # Specify the Python versions you support here. In particular, ensure
        # that you indicate whether you support Python 2, Python 3 or both.
        'Programming Language :: Python :: 3.8',
    ],

    # What does your project relate to?
    keywords='open ultils for wsi',
    packages=find_packages(),
    include_package_data=False,
    zip_safe=False,
)
