# Generated by Django 4.0.8 on 2022-10-28 15:54

import django.db.models.deletion
import modelcluster.fields
from django.db import migrations, models
from wagtail import VERSION as WAGTAIL_VERSION

if WAGTAIL_VERSION >= (3, 0):
    import wagtail.blocks as wagtail_blocks
    import wagtail.fields as wagtail_fields
else:
    import wagtail.core.blocks as wagtail_blocks
    import wagtail.core.fields as wagtail_fields

import wagtail.images.blocks

streamfield_kwargs = {"use_json_field": True} if WAGTAIL_VERSION >= (3, 0) else {}


class Migration(migrations.Migration):

    streamfield_kwargs = {"use_json_field": True} if WAGTAIL_VERSION >= (3, 0) else {}

    initial = True

    dependencies = [
        ("wagtailcore", "0066_collection_management_permissions"),
    ]

    operations = [
        migrations.CreateModel(
            name="Category",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=255, unique=True)),
            ],
            options={
                "verbose_name": "category",
                "verbose_name_plural": "categories",
            },
        ),
        migrations.CreateModel(
            name="TestPage",
            fields=[
                (
                    "page_ptr",
                    models.OneToOneField(
                        auto_created=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        parent_link=True,
                        primary_key=True,
                        serialize=False,
                        to="wagtailcore.page",
                    ),
                ),
                ("wp_post_id", models.IntegerField(blank=True, null=True)),
                (
                    "wp_post_type",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                ("wp_link", models.TextField(blank=True, null=True)),
                ("wp_raw_content", models.TextField(blank=True, null=True)),
                ("wp_processed_content", models.TextField(blank=True, null=True)),
                ("wp_block_json", models.TextField(blank=True, null=True)),
                ("wp_normalized_styles", models.TextField(blank=True, null=True)),
                ("wp_post_meta", models.JSONField(blank=True, null=True)),
                (
                    "body",
                    wagtail_fields.StreamField(
                        [
                            ("rich_text", wagtail_blocks.RichTextBlock()),
                            (
                                "heading",
                                wagtail_blocks.StructBlock(
                                    [
                                        (
                                            "text",
                                            wagtail_blocks.CharBlock(
                                                form_classname="title"
                                            ),
                                        ),
                                        (
                                            "importance",
                                            wagtail_blocks.ChoiceBlock(
                                                choices=[
                                                    ("h1", "H1"),
                                                    ("h2", "H2"),
                                                    ("h3", "H3"),
                                                    ("h4", "H4"),
                                                    ("h5", "H5"),
                                                    ("h6", "H6"),
                                                ]
                                            ),
                                        ),
                                    ]
                                ),
                            ),
                            (
                                "image",
                                wagtail_blocks.StructBlock(
                                    [
                                        (
                                            "image",
                                            wagtail.images.blocks.ImageChooserBlock(),
                                        ),
                                        (
                                            "caption",
                                            wagtail_blocks.CharBlock(required=False),
                                        ),
                                        (
                                            "link",
                                            wagtail_blocks.URLBlock(required=False),
                                        ),
                                        (
                                            "alignment",
                                            wagtail_blocks.ChoiceBlock(
                                                choices=[
                                                    ("left", "Left"),
                                                    ("right", "Right"),
                                                    ("center", "Center"),
                                                ]
                                            ),
                                        ),
                                    ]
                                ),
                            ),
                            (
                                "block_quote",
                                wagtail_blocks.StructBlock(
                                    [
                                        (
                                            "quote",
                                            wagtail_blocks.CharBlock(
                                                form_classname="title"
                                            ),
                                        ),
                                        (
                                            "attribution",
                                            wagtail_blocks.CharBlock(required=False),
                                        ),
                                    ]
                                ),
                            ),
                            ("raw_html", wagtail_blocks.RawHTMLBlock()),
                        ],
                        **streamfield_kwargs,
                    ),
                ),
                (
                    "categories",
                    modelcluster.fields.ParentalManyToManyField(
                        blank=True, to="wagtail_wordpress_import_test.category"
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=("wagtailcore.page",),
        ),
    ]
