# SciScripts  
Scripts for controlling devices/running experiments/analyzing data  

## Dependencies

### Mandatory
1) System:
    - Linux
2) Python:
    - numpy
    - scipy

### Optional (partial loss of funcionality if not installed)
1) System:
    - Portaudio
    - sounddevice
    - xdpyinfo
    - Open-ephys analysis-tools [at github.com/open-ephys/analysis-tools, Python3 folder]
2) Python:
    - pandas
    - matplotlib
    - pyserial
    - rpy2
    - h5py
    - asdf

Also, some environment variables are expected to be set. You can add it to `~/.bashrc`, or `~/.profile`, or wherever your desktop environment searches for exported variables:
```bash
export DATAPATH=~/Data
export ANALYSISPATH=~/Analysis
```
changing the path to where you find appropriate.


## Examples

```python
In [1]: from sciscripts.IO import IO

In [2]: from sciscripts.Analysis import Analysis

In [3]: from sciscripts.Analysis.Plot import Plot

In [4]: Data, Rate = IO.DataLoader('DataSet/2018-08-13_13-25-45_1416/')
Loading recording1 ...
Loading recording2 ...
Loading recording3 ...
Loading recording4 ...
Loading recording5 ...
Loading recording6 ...
Loading recording7 ...
Loading recording8 ...
Converting to uV...

In [5]: Data.keys()                     # Get open-ephys recording processors
Out[5]: dict_keys(['100'])

In [6]: Rec0 = Data['100']['0'][:,:16]  # Work with the 1st rec and 1st 16ch

In [7]: Rec0Theta = Analysis.FilterSignal(Rec0, Rate['100'], Frequency=[4,12], FilterOrder=2)
Filtering channel 1 ...
Filtering channel 2 ...
Filtering channel 3 ...
Filtering channel 4 ...
Filtering channel 5 ...
Filtering channel 6 ...
Filtering channel 7 ...
Filtering channel 8 ...
Filtering channel 9 ...
Filtering channel 10 ...
Filtering channel 11 ...
Filtering channel 12 ...
Filtering channel 13 ...
Filtering channel 14 ...
Filtering channel 15 ...
Filtering channel 16 ...

In [8]: Rec0Gamma = Analysis.FilterSignal(Rec0, Rate['100'], Frequency=[30,100], FilterOrder=2)
Filtering channel 1 ...
Filtering channel 2 ...
Filtering channel 3 ...
Filtering channel 4 ...
Filtering channel 5 ...
Filtering channel 6 ...
Filtering channel 7 ...
Filtering channel 8 ...
Filtering channel 9 ...
Filtering channel 10 ...
Filtering channel 11 ...
Filtering channel 12 ...
Filtering channel 13 ...
Filtering channel 14 ...
Filtering channel 15 ...
Filtering channel 16 ...

In [9]: Plot.AllCh(Rec0[:int(Rate['100']*0.5),:])   # Plot the 1st 0.5s from all ch

In [10]: Window = int(Rate['100']*0.5)              # Plot the 1st 0.5s from all ch from raw, theta and gamma
    ...: plt = Plot.Return('plt')
    ...: Fig, Axes = plt.subplots(1,3)
    ...: Axes[0] = Plot.AllCh(Rec0[:Window,:], Ax=Axes[0])
    ...: Axes[1] = Plot.AllCh(Rec0Theta[:Window,:], Ax=Axes[1])
    ...: Axes[2] = Plot.AllCh(Rec0Gamma[:Window,:], Ax=Axes[2])
    ...: Plot.Set(Fig=Fig)
    ...: plt.show()

```

Scripts using this package for real experiments and analysis can be found [here](https://gitlab.com/malfatti/LabScripts/-/tree/master/Python3/Exps) and [here](https://gitlab.com/malfatti/LabScripts/-/tree/master/Python3/Analysis), respectively.

