import sys
import logging

import logs_client.config_client_log

# метод определения модуля, источника запуска.
if sys.argv[0].find('client') == -1:
    # если не клиент то сервер!
    logger = logging.getLogger('server')
else:
    # ну, раз не сервер, то клиент
    logger = logging.getLogger('client')


# Декоратор логирования для сохранения дополнительной информации о
# вызываемой функции в режиме debug


def log(func_to_log):
    """Декоратор логирования для сохранения дополнительной информации о
    вызываемой функции в режиме debug"""

    def log_saver(*args, **kwargs):
        logger.debug(
            f'Была вызвана функция {func_to_log.__name__} c параметрами {args} , {kwargs}. '
            f'Вызов из модуля {func_to_log.__module__}')
        ret = func_to_log(*args, **kwargs)
        return ret

    return log_saver
