import { cdk } from 'projen';
const project = new cdk.JsiiProject({
  author: 'Marcio Almeida',
  authorAddress: 'marcioadev@gmail.com',
  defaultReleaseBranch: 'main',
  name: 'lazy-constructs',
  projenrcTs: true,
  repositoryUrl: 'https://github.com/lazinessdevs/lazy-constructs.git',

  codeCov: true,

  release: true,
  publishTasks: true,
  publishToPypi: {
    distName: 'lazy-constructs',
    module: 'lazy_constructs',
  },
  publishToMaven: {
    javaPackage: 'com.lazinessdevs.lazyconstructs',
    mavenArtifactId: 'lazy-constructs',
    mavenGroupId: 'com.lazinessdevs',
    mavenEndpoint: 'https://s01.oss.sonatype.org',
  },
  publishToNuget: {
    dotNetNamespace: 'LazinessDevs.Lazy',
    packageId: 'LazyConstructs',
  },


  peerDeps: [
    'constructs@^10.0.5',
    'aws-cdk-lib@^2.27.0',
  ],
  // description: undefined,  /* The description is just a string that helps people understand the purpose of the package. */
  // devDeps: [],             /* Build dependencies for this module. */
  // packageName: undefined,  /* The "name" in package.json. */
});

project.synth();