# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: anduril/taskmanager/v1/generic_spec.pub.proto, anduril/taskmanager/v1/task.pub.proto, anduril/taskmanager/v1/task_api.pub.proto, anduril/taskmanager/v1/task_manager_grpcapi.pub.proto
# plugin: python-betterproto
# This file has been @generated

from dataclasses import dataclass
from datetime import datetime
from typing import (
    TYPE_CHECKING,
    AsyncIterator,
    Dict,
    List,
    Optional,
)

import betterproto
import betterproto.lib.google.protobuf as betterproto_lib_google_protobuf
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from ...entitymanager import v1 as __entitymanager_v1__


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


class Status(betterproto.Enum):
    """
    The Status of a Task definition through its lifecycle. Each Definition Version can have its own Status.
     For example, Definition v1 could go CREATED -> SENT -> WILCO -> REPLACED, with v2 then potentially in sent Status.
    """

    INVALID = 0
    CREATED = 1
    """Initial creation Status."""

    SCHEDULED_IN_MANAGER = 2
    """Scheduled within Task Manager to be sent at a future time."""

    SENT = 3
    """Sent to another system (Asset), no receipt yet."""

    MACHINE_RECEIPT = 4
    """
    Task was sent to Assignee, and some system was reachable and responded.
     However, the system responsible for execution on the Assignee has not yet acknowledged the Task.
    """

    ACK = 5
    """
    System responsible for execution on the Assignee has acknowledged the Task.
    """

    WILCO = 6
    """Assignee confirmed they "will comply" / intend to execute Task."""

    EXECUTING = 7
    """Task was started and is actively executing."""

    WAITING_FOR_UPDATE = 8
    """
    Task is on hold, waiting for additional updates/information before proceeding.
    """

    DONE_OK = 9
    """Task was completed successfully."""

    DONE_NOT_OK = 10
    """
    Task has reached a terminal state but did not complete successfully, see error code/message.
    """

    REPLACED = 11
    """This definition version was replaced."""

    CANCEL_REQUESTED = 12
    """
    A Task was requested to be cancelled but not yet confirmed, will eventually move to DONE_NOT_OK.
    """

    COMPLETE_REQUESTED = 13
    """
    A Task was requested to be completed successfully but not yet confirmed, will eventually move to DONE_NOT_OK / DONE_OK.
    """

    VERSION_REJECTED = 14
    """
    This definition version was rejected, intended to be used when an Agent does not accept a new version of a task
     and continues using previous version
    """


class ErrorCode(betterproto.Enum):
    """Error code associated with a Task error."""

    INVALID = 0
    CANCELLED = 1
    """Task was cancelled by requester."""

    REJECTED = 2
    """Task was rejected by assignee, see message for details."""

    TIMEOUT = 3
    """Task Manager gave up waiting for a receipt/ack from assignee."""

    FAILED = 4
    """Task attempted to execute, but failed."""


class EventType(betterproto.Enum):
    """The type of Task event."""

    INVALID = 0
    CREATED = 1
    """Task was created."""

    UPDATE = 2
    """Task was updated."""

    PREEXISTING = 3
    """Task already existed, but sent on a new stream connection."""


class TaskView(betterproto.Enum):
    """
    View of a Task through its lifecycle.
     For example, a definition v1 of a task may be running on an agent, indicated by TASK_VIEW_AGENT,
     while the definition v2 may not have been received yet, indicated by TASK_VIEW_MANAGER.
    """

    INVALID = 0
    MANAGER = 1
    """Represents the most recent version of the Task known to Task Manager"""

    AGENT = 2
    """
    Represents the most recent version of the Task acknowledged or updated by an Agent
    """


class QueryTasksRequestFilterType(betterproto.Enum):
    """The type of filter."""

    FILTER_TYPE_INVALID = 0
    FILTER_TYPE_INCLUSIVE = 1
    FILTER_TYPE_EXCLUSIVE = 2


@dataclass(eq=False, repr=False)
class GenericSpec(betterproto.Message):
    """
    GenericSpec is a wrapper for arbitrary JSON payloads. Meant for wrapping a Task's specification field, if needed.
    """

    payload: "betterproto_lib_google_protobuf.Value" = betterproto.message_field(1)
    """Can represent any JSON value."""


@dataclass(eq=False, repr=False)
class Task(betterproto.Message):
    """A Task is something an agent can be asked to do."""

    version: "TaskVersion" = betterproto.message_field(1)
    """Version of this Task."""

    display_name: str = betterproto.string_field(2)
    """
    Human readable display name for this Task, should be short (<100 chars).
    """

    specification: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(3)
    """
    Full Task parameterization, must be a message under anduril/tasks/v*/
    """

    created_by: "Principal" = betterproto.message_field(16)
    """
    Records who created this Task. This field will not change after the Task has been created.
    """

    last_updated_by: "Principal" = betterproto.message_field(4)
    """Records who updated this Task last."""

    last_update_time: datetime = betterproto.message_field(9)
    """Records the time of last update."""

    status: "TaskStatus" = betterproto.message_field(5)
    """The status of this Task."""

    scheduled_time: datetime = betterproto.message_field(6)
    """
    If the Task has been scheduled to execute, what time it should execute at.
    """

    relations: "Relations" = betterproto.message_field(8)
    """
    Any related Tasks associated with this, typically includes an assignee for this Task and/or a parent.
    """

    description: str = betterproto.string_field(10)
    """Longer, free form human readable description of this Task"""

    is_executed_elsewhere: bool = betterproto.bool_field(11)
    """
    If set, execution of this Task is managed elsewhere, not by Task Manager.
     In other words, Task manager will not attempt to update the assigned agent with execution instructions.
    """

    create_time: datetime = betterproto.message_field(13)
    """Time of Task creation."""

    replication: "Replication" = betterproto.message_field(14)
    """If populated, designates this to be a replicated Task."""

    initial_entities: List["TaskEntity"] = betterproto.message_field(15)
    """
    If populated, indicates an initial set of entities that can be used to execute an entity aware task
     For example, an entity Objective, an entity Keep In Zone, etc.
     These will not be updated during execution. If a taskable agent needs continuous updates on the entities from the
     COP, can call entity-manager, or use an AlternateId escape hatch.
    """

    owner: "Owner" = betterproto.message_field(12)
    """
    The networked owner of this Task. It is used to ensure that linear writes occur on the node responsible
     for replication of task data to other nodes running Task Manager.
    """


@dataclass(eq=False, repr=False)
class TaskStatus(betterproto.Message):
    """
    TaskStatus is contains information regarding the status of a Task at any given time. Can include related information
      such as any progress towards Task completion, or any associated results if Task completed.
    """

    status: "Status" = betterproto.enum_field(1)
    """Status of the Task."""

    task_error: "TaskError" = betterproto.message_field(2)
    """Any errors associated with the Task."""

    progress: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(4)
    """
    Any incremental progress on the Task, should be from the tasks/v*/progress folder.
    """

    result: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(5)
    """Any final result of the Task, should be from tasks/v*/result folder."""

    start_time: datetime = betterproto.message_field(6)
    """
    Time the Task began execution, may not be known even for executing Tasks.
    """

    estimate: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(7)
    """
    Any estimate for how the Task will progress, should be from tasks/v*/estimates folder.
    """

    allocation: "Allocation" = betterproto.message_field(8)
    """Any allocated agents of the Task."""


@dataclass(eq=False, repr=False)
class TaskError(betterproto.Message):
    """
    TaskError contains an error code and message typically associated to a Task.
    """

    code: "ErrorCode" = betterproto.enum_field(1)
    """Error code for Task error."""

    message: str = betterproto.string_field(2)
    """Descriptive human-readable string regarding this error."""

    error_details: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(3)
    """Any additional details regarding this error."""


@dataclass(eq=False, repr=False)
class Principal(betterproto.Message):
    """A Principal is an entity that has authority over this Task."""

    system: "System" = betterproto.message_field(1, group="agent")
    user: "User" = betterproto.message_field(2, group="agent")
    team: "Team" = betterproto.message_field(4, group="agent")
    on_behalf_of: "Principal" = betterproto.message_field(3)
    """
    The Principal _this_ Principal is acting on behalf of.
    
     Likely only populated once in the nesting (i.e. the "on_behalf_of" Principal would not have another "on_behalf_of" in most cases).
    """


@dataclass(eq=False, repr=False)
class System(betterproto.Message):
    """System Principal representing some autonomous system."""

    service_name: str = betterproto.string_field(1)
    """Name of the service associated with this System."""

    entity_id: str = betterproto.string_field(2)
    """The Entity ID of the System."""

    manages_own_scheduling: bool = betterproto.bool_field(4)
    """
    Whether the System Principal (for example, an Asset) can own scheduling.
     This means we bypass manager-owned scheduling and defer to the system
     Principal to handle scheduling and give us status updates for the Task.
     Regardless of the value defined by the client, the Task Manager will
     determine and set this value appropriately.
    """


@dataclass(eq=False, repr=False)
class User(betterproto.Message):
    """A User Principal representing a human."""

    user_id: str = betterproto.string_field(1)
    """The User ID associated with this User."""


@dataclass(eq=False, repr=False)
class Relations(betterproto.Message):
    """
    Relations describes the relationships of this Task, such as assignment, or if the Task has any parents.
    """

    assignee: "Principal" = betterproto.message_field(1)
    """Who or what, if anyone, this Task is currently assigned to."""

    parent_task_id: str = betterproto.string_field(2)
    """If this Task is a "sub-Task", what is its parent, none if empty."""


@dataclass(eq=False, repr=False)
class TaskEvent(betterproto.Message):
    """Holds Tasks and its associated Events, e.g. CREATED."""

    event_type: "EventType" = betterproto.enum_field(1)
    """Type of Event."""

    task: "Task" = betterproto.message_field(2)
    """Task associated with this TaskEvent."""

    task_view: "TaskView" = betterproto.enum_field(3)
    """View associated with this task."""

    time: datetime = betterproto.message_field(4)
    """
    ===== Time Series Updates =====
    
     Timestamp for time-series to index.
    """


@dataclass(eq=False, repr=False)
class TaskVersion(betterproto.Message):
    """Version of a Task."""

    task_id: str = betterproto.string_field(1)
    """The unique ID for this Task."""

    definition_version: int = betterproto.uint32_field(2)
    """
    Increments on definition (i.e. not TaskStatus) change. 0 is unset, starts at 1 on creation.
    """

    status_version: int = betterproto.uint32_field(3)
    """
    Increments on changes to TaskStatus. 0 is unset, starts at 1 on creation.
    """


@dataclass(eq=False, repr=False)
class StatusUpdate(betterproto.Message):
    """a Task status update"""

    version: "TaskVersion" = betterproto.message_field(1)
    """Version of the Task."""

    status: "TaskStatus" = betterproto.message_field(2)
    """Status of the Task."""

    author: "Principal" = betterproto.message_field(3)
    """
    Author of the StatusUpdate message. Used to set the LastUpdatedBy field of the Task.
    """

    scheduled_time: datetime = betterproto.message_field(4)
    """
    Typically provided if a user is manually managing a Task, or if an asset owns scheduling.
    """


@dataclass(eq=False, repr=False)
class DefinitionUpdate(betterproto.Message):
    """Message representing a Task create or update."""

    task: "Task" = betterproto.message_field(1)
    """
    New task definition being created or updated.
     The last_updated_by and specification fields inside the task object must be defined.
     Definition version must also be incremented by the publisher on updates.
     We do not look at the fields create_time or last_update_time in this object,
     they are instead set by task-manager.
    """


@dataclass(eq=False, repr=False)
class Owner(betterproto.Message):
    """Owner designates the entity responsible for writes of Task data."""

    entity_id: str = betterproto.string_field(2)
    """Entity ID of the owner."""


@dataclass(eq=False, repr=False)
class Replication(betterproto.Message):
    """Any metadata associated with the replication of a Task."""

    stale_time: datetime = betterproto.message_field(1)
    """Time by which this Task should be assumed to be stale."""


@dataclass(eq=False, repr=False)
class Allocation(betterproto.Message):
    """Allocation contains a list of agents allocated to a Task."""

    active_agents: List["Agent"] = betterproto.message_field(1)
    """Agents actively being utilized in a Task."""


@dataclass(eq=False, repr=False)
class Team(betterproto.Message):
    """Represents a team of agents"""

    entity_id: str = betterproto.string_field(1)
    """Entity ID of the team"""

    members: List["Agent"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class Agent(betterproto.Message):
    """Represents an Agent in the COP."""

    entity_id: str = betterproto.string_field(2)
    """Entity ID of the agent."""


@dataclass(eq=False, repr=False)
class TaskEntity(betterproto.Message):
    """
    Wrapper of an entity passed in Tasking, used to hold an additional information, and as a future extension point.
    """

    entity: "__entitymanager_v1__.Entity" = betterproto.message_field(1)
    """The wrapped entity-manager entity."""

    snapshot: bool = betterproto.bool_field(2)
    """
    Indicates that this entity was generated from a snapshot of a live entity.
    """


@dataclass(eq=False, repr=False)
class ExecuteRequest(betterproto.Message):
    """Request to execute a Task."""

    task: "Task" = betterproto.message_field(1)
    """Task to execute."""


@dataclass(eq=False, repr=False)
class CancelRequest(betterproto.Message):
    """Request to Cancel a Task."""

    task_id: str = betterproto.string_field(1)
    """ID of the Task to cancel."""

    assignee: "Principal" = betterproto.message_field(2)
    """
    The assignee of the Task. Useful for agent routing where an endpoint owns multiple agents,
     especially onBehalfOf assignees.
    """


@dataclass(eq=False, repr=False)
class CompleteRequest(betterproto.Message):
    """Request to Complete a Task."""

    task_id: str = betterproto.string_field(1)
    """ID of the task to complete."""


@dataclass(eq=False, repr=False)
class CreateTaskRequest(betterproto.Message):
    """Request to create a Task."""

    display_name: str = betterproto.string_field(1)
    """
    Human-readable display name for this Task, should be short (<100 chars).
    """

    specification: "betterproto_lib_google_protobuf.Any" = betterproto.message_field(2)
    """
    Full task parameterization, must be a message under anduril/tasks/v*/.
    """

    author: "Principal" = betterproto.message_field(3)
    """
    Who or what is creating this Task. For example, if a user created this Task via a UI, it would
      contain the "user" Principal type with the user ID of that user. Or if a service is calling the
      CreateTask endpoint, then a "service" Principal type is to be provided.
    """

    relations: "Relations" = betterproto.message_field(5)
    """
    Any relationships associated with this Task, such as a parent Task or an assignee this Task is designated to
      for execution.
    """

    description: str = betterproto.string_field(6)
    """Longer, free-form, human-readable description of this Task."""

    is_executed_elsewhere: bool = betterproto.bool_field(7)
    """
    If set, then task-manager will not trigger execution of this task on an agent. Useful for when ingesting
     tasks from an external system that is triggering execution of tasks on agents.
    """

    task_id: str = betterproto.string_field(8)
    """
    If non-empty, will set the requested Task ID, otherwise will generate a new random GUID.
      Will reject if supplied Task ID does not match `[A-Za-z0-9_-.]{5,36}`.
    """

    initial_entities: List["TaskEntity"] = betterproto.message_field(9)
    """
    Indicates an initial set of entities that can be used to execute an entity aware task.
     For example, an entity Objective, an entity Keep In Zone, etc.
    """


@dataclass(eq=False, repr=False)
class CreateTaskResponse(betterproto.Message):
    """Response to a Create Task request."""

    task: "Task" = betterproto.message_field(1)
    """Task that was created."""


@dataclass(eq=False, repr=False)
class GetTaskRequest(betterproto.Message):
    """Request to get a Task."""

    task_id: str = betterproto.string_field(1)
    """ID of Task to get."""

    definition_version: int = betterproto.uint32_field(2)
    """
    Optional - if > 0, will get specific definition_version, otherwise latest (highest) definition_version is used.
    """

    task_view: "TaskView" = betterproto.enum_field(3)
    """
    Optional - select which view of the task to fetch. If not set, defaults to TASK_VIEW_MANAGER.
    """


@dataclass(eq=False, repr=False)
class GetTaskResponse(betterproto.Message):
    """Response to a Get Task request."""

    task: "Task" = betterproto.message_field(1)
    """Task that was returned."""


@dataclass(eq=False, repr=False)
class QueryTasksRequest(betterproto.Message):
    """
    Request to query for Tasks. Returns the each latest Task by Status ID and Version ID by default with no filters.
    """

    parent_task_id: str = betterproto.string_field(1)
    """
    If present matches Tasks with this parent Task ID.
     Note: this is mutually exclusive with all other query parameters, i.e., either provide parent Task ID, or
      any of the remaining parameters, but not both.
    """

    page_token: str = betterproto.string_field(3)
    """If set, returns results starting from the given page token."""

    status_filter: "QueryTasksRequestStatusFilter" = betterproto.message_field(4)
    """Filters on provided status types in the filter."""

    update_time_range: "QueryTasksRequestTimeRange" = betterproto.message_field(5)
    """If provided, only provides Tasks updated within the time range."""

    view: "TaskView" = betterproto.enum_field(6)
    """
    Optional filter for view of a Task.
     If not set, defaults to TASK_VIEW_MANAGER.
    """


@dataclass(eq=False, repr=False)
class QueryTasksRequestTimeRange(betterproto.Message):
    """A time range query for Tasks."""

    update_start_time: datetime = betterproto.message_field(1)
    """If provided, returns Tasks only updated after this time."""

    update_end_time: datetime = betterproto.message_field(2)
    """If provided, returns Tasks only updated before this time."""


@dataclass(eq=False, repr=False)
class QueryTasksRequestStatusFilter(betterproto.Message):
    """A filter for statuses."""

    status: List["Status"] = betterproto.enum_field(1)
    """Statuses to be part of the filter."""

    filter_type: "QueryTasksRequestFilterType" = betterproto.enum_field(2)
    """The type of filter to apply."""


@dataclass(eq=False, repr=False)
class QueryTasksResponse(betterproto.Message):
    """Response to a Query Task request."""

    tasks: List["Task"] = betterproto.message_field(1)
    """Tasks matching the Query Task request."""

    page_token: str = betterproto.string_field(2)
    """Page token to the next page of Tasks."""


@dataclass(eq=False, repr=False)
class UpdateStatusRequest(betterproto.Message):
    """Request to update a Task's status."""

    status_update: "StatusUpdate" = betterproto.message_field(1)
    """The updated status."""


@dataclass(eq=False, repr=False)
class UpdateStatusResponse(betterproto.Message):
    """Response to an Update Status request."""

    task: "Task" = betterproto.message_field(1)
    """The updated Task."""


@dataclass(eq=False, repr=False)
class ListenAsAgentRequest(betterproto.Message):
    """Request for streaming Tasks ready for agent execution."""

    entity_ids: "EntityIds" = betterproto.message_field(1, group="agent_selector")
    """
    The requesting agent will only receive Agent Tasks in the stream that have any of these specified entity ids as the task's assignee
    """


@dataclass(eq=False, repr=False)
class ListenAsAgentResponse(betterproto.Message):
    """Response for streaming Tasks ready for agent execution."""

    execute_request: "ExecuteRequest" = betterproto.message_field(1, group="request")
    cancel_request: "CancelRequest" = betterproto.message_field(2, group="request")
    complete_request: "CompleteRequest" = betterproto.message_field(3, group="request")


@dataclass(eq=False, repr=False)
class RateLimit(betterproto.Message):
    """Rate limiting / down-sampling parameters."""

    update_per_task_limit_ms: int = betterproto.uint32_field(1)
    """
    Specifies a minimum duration in milliseconds after an update for a given task before another one
     will be sent for the same task.
     A value of 0 is treated as unset. If set, value must be >= 250.
     Example: if set to 1000, and 4 events occur (ms since start) at T0, T500, T900, T2100, then
     event from T0 will be sent at T0, T500 will be dropped, T900 will be sent at minimum of T1000,
     and T2100 will be sent on time (2100)
     This will only limit updates, other events will be sent immediately, with a delete clearing anything held
    """


@dataclass(eq=False, repr=False)
class Heartbeat(betterproto.Message):
    timestamp: datetime = betterproto.message_field(1)
    """The time at which the Heartbeat was sent."""


@dataclass(eq=False, repr=False)
class EntityIds(betterproto.Message):
    """Entity IDs wrapper."""

    entity_ids: List[str] = betterproto.string_field(1)


class TaskManagerApiStub(betterproto.ServiceStub):
    async def create_task(
        self,
        create_task_request: "CreateTaskRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "CreateTaskResponse":
        return await self._unary_unary(
            "/anduril.taskmanager.v1.TaskManagerAPI/CreateTask",
            create_task_request,
            CreateTaskResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_task(
        self,
        get_task_request: "GetTaskRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetTaskResponse":
        return await self._unary_unary(
            "/anduril.taskmanager.v1.TaskManagerAPI/GetTask",
            get_task_request,
            GetTaskResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def query_tasks(
        self,
        query_tasks_request: "QueryTasksRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "QueryTasksResponse":
        return await self._unary_unary(
            "/anduril.taskmanager.v1.TaskManagerAPI/QueryTasks",
            query_tasks_request,
            QueryTasksResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def update_status(
        self,
        update_status_request: "UpdateStatusRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "UpdateStatusResponse":
        return await self._unary_unary(
            "/anduril.taskmanager.v1.TaskManagerAPI/UpdateStatus",
            update_status_request,
            UpdateStatusResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def listen_as_agent(
        self,
        listen_as_agent_request: "ListenAsAgentRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator[ListenAsAgentResponse]:
        async for response in self._unary_stream(
            "/anduril.taskmanager.v1.TaskManagerAPI/ListenAsAgent",
            listen_as_agent_request,
            ListenAsAgentResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response


class TaskManagerApiBase(ServiceBase):

    async def create_task(
        self, create_task_request: "CreateTaskRequest"
    ) -> "CreateTaskResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_task(self, get_task_request: "GetTaskRequest") -> "GetTaskResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def query_tasks(
        self, query_tasks_request: "QueryTasksRequest"
    ) -> "QueryTasksResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def update_status(
        self, update_status_request: "UpdateStatusRequest"
    ) -> "UpdateStatusResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def listen_as_agent(
        self, listen_as_agent_request: "ListenAsAgentRequest"
    ) -> AsyncIterator[ListenAsAgentResponse]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)
        yield ListenAsAgentResponse()

    async def __rpc_create_task(
        self, stream: "grpclib.server.Stream[CreateTaskRequest, CreateTaskResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.create_task(request)
        await stream.send_message(response)

    async def __rpc_get_task(
        self, stream: "grpclib.server.Stream[GetTaskRequest, GetTaskResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_task(request)
        await stream.send_message(response)

    async def __rpc_query_tasks(
        self, stream: "grpclib.server.Stream[QueryTasksRequest, QueryTasksResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.query_tasks(request)
        await stream.send_message(response)

    async def __rpc_update_status(
        self, stream: "grpclib.server.Stream[UpdateStatusRequest, UpdateStatusResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.update_status(request)
        await stream.send_message(response)

    async def __rpc_listen_as_agent(
        self,
        stream: "grpclib.server.Stream[ListenAsAgentRequest, ListenAsAgentResponse]",
    ) -> None:
        request = await stream.recv_message()
        await self._call_rpc_handler_server_stream(
            self.listen_as_agent,
            stream,
            request,
        )

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/anduril.taskmanager.v1.TaskManagerAPI/CreateTask": grpclib.const.Handler(
                self.__rpc_create_task,
                grpclib.const.Cardinality.UNARY_UNARY,
                CreateTaskRequest,
                CreateTaskResponse,
            ),
            "/anduril.taskmanager.v1.TaskManagerAPI/GetTask": grpclib.const.Handler(
                self.__rpc_get_task,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetTaskRequest,
                GetTaskResponse,
            ),
            "/anduril.taskmanager.v1.TaskManagerAPI/QueryTasks": grpclib.const.Handler(
                self.__rpc_query_tasks,
                grpclib.const.Cardinality.UNARY_UNARY,
                QueryTasksRequest,
                QueryTasksResponse,
            ),
            "/anduril.taskmanager.v1.TaskManagerAPI/UpdateStatus": grpclib.const.Handler(
                self.__rpc_update_status,
                grpclib.const.Cardinality.UNARY_UNARY,
                UpdateStatusRequest,
                UpdateStatusResponse,
            ),
            "/anduril.taskmanager.v1.TaskManagerAPI/ListenAsAgent": grpclib.const.Handler(
                self.__rpc_listen_as_agent,
                grpclib.const.Cardinality.UNARY_STREAM,
                ListenAsAgentRequest,
                ListenAsAgentResponse,
            ),
        }
