# Generated by the protocol buffer compiler.  DO NOT EDIT!
# sources: anduril/entitymanager/v1/classification.pub.proto, anduril/entitymanager/v1/contact_details.pub.proto, anduril/entitymanager/v1/correlations.pub.proto, anduril/entitymanager/v1/dimensions.pub.proto, anduril/entitymanager/v1/entity.pub.proto, anduril/entitymanager/v1/entity_manager_grpcapi.pub.proto, anduril/entitymanager/v1/filter.pub.proto, anduril/entitymanager/v1/filter_dynamic.pub.proto, anduril/entitymanager/v1/geoentity.pub.proto, anduril/entitymanager/v1/group.pub.proto, anduril/entitymanager/v1/health_status.pub.proto, anduril/entitymanager/v1/location.pub.proto, anduril/entitymanager/v1/media.pub.proto, anduril/entitymanager/v1/notification.pub.proto, anduril/entitymanager/v1/ontology.pub.proto, anduril/entitymanager/v1/options.pub.proto, anduril/entitymanager/v1/orbit.pub.proto, anduril/entitymanager/v1/payloads.pub.proto, anduril/entitymanager/v1/power.pub.proto, anduril/entitymanager/v1/rate_limit.pub.proto, anduril/entitymanager/v1/relationship.pub.proto, anduril/entitymanager/v1/route_details.pub.proto, anduril/entitymanager/v1/schedule.pub.proto, anduril/entitymanager/v1/sensors.pub.proto, anduril/entitymanager/v1/signal.pub.proto, anduril/entitymanager/v1/supplies.pub.proto, anduril/entitymanager/v1/target_priority.pub.proto, anduril/entitymanager/v1/transponder_codes.pub.proto, anduril/entitymanager/v1/types.pub.proto
# plugin: python-betterproto
# This file has been @generated
import warnings
from dataclasses import dataclass
from datetime import datetime
from typing import (
    TYPE_CHECKING,
    AsyncIterable,
    AsyncIterator,
    Dict,
    Iterable,
    List,
    Optional,
    Union,
)

import betterproto
import grpclib
from betterproto.grpc.grpclib_server import ServiceBase

from ... import type as __type__
from ...ontology import v1 as __ontology_v1__
from ...tasks import v2 as __tasks_v2__


if TYPE_CHECKING:
    import grpclib.server
    from betterproto.grpc.grpclib_client import MetadataLike
    from grpclib.metadata import Deadline


class ClassificationLevels(betterproto.Enum):
    """An enumeration of security classification levels."""

    INVALID = 0
    UNCLASSIFIED = 1
    CONTROLLED_UNCLASSIFIED = 2
    CONFIDENTIAL = 3
    SECRET = 4
    TOP_SECRET = 5


class CorrelationStatus(betterproto.Enum):
    """The status of the correlation."""

    INVALID = 0
    MANUAL_INSPECTION = 1
    """
    potential correlation requested by manual inspection, not yet confirmed.
    """

    AUTO_SUGGESTED = 2
    """potential correlation suggested by system, not yet confirmed."""

    START_CORRELATE = 3
    """deprecated"""

    CONFIRMED = 4
    """correlation has been confirmed, treat non primary as hidden."""

    DENIED = 5
    """correlation was explicitly rejected, treat as non correlated."""


class ScoreInterpretation(betterproto.Enum):
    """The interpretation of the correlation score."""

    INVALID = 0
    UNLIKELY = 1
    """unlikely these are the same entity"""

    LIKELY = 2
    """likely these are the same entity"""

    VERY_LIKELY = 3
    """very likely these are the same entity"""


class GeoType(betterproto.Enum):
    """The type of geo entity."""

    INVALID = 0
    GENERAL = 1
    HAZARD = 2
    EMERGENCY = 3
    ENGAGEMENT_ZONE = 5
    """
    Engagement zones allow for engaging an entity if it comes within the zone of another entity.
    """

    CONTROL_AREA = 6
    BULLSEYE = 7


class ArmyEchelon(betterproto.Enum):
    """Military units defined by the Army."""

    INVALID = 0
    FIRE_TEAM = 1
    SQUAD = 2
    PLATOON = 3
    COMPANY = 4
    BATTALION = 5
    REGIMENT = 6
    BRIGADE = 7
    DIVISION = 8
    CORPS = 9
    ARMY = 10


class ConnectionStatus(betterproto.Enum):
    """Enumeration of possible connection states."""

    INVALID = 0
    ONLINE = 1
    OFFLINE = 2


class HealthStatus(betterproto.Enum):
    """Enumeration of possible health states."""

    INVALID = 0
    HEALTHY = 1
    """Indicates that the component is operating as intended."""

    WARN = 2
    """
    Indicates that the component is at risk of transitioning into a HEALTH_STATUS_FAIL
     state or that the component is operating in a degraded state.
    """

    FAIL = 3
    """Indicates that the component is not functioning as intended."""

    OFFLINE = 4
    """Indicates that the component is offline."""

    NOT_READY = 5
    """
    Indicates that the component is not yet functioning, but it is transitioning into a
     HEALTH_STATUS_HEALTHY state. A component should only report this state temporarily.
    """


class AlertLevel(betterproto.Enum):
    """
    Alerts are categorized into one of three levels - Warnings, Cautions, and Advisories (WCAs).
    """

    INVALID = 0
    ADVISORY = 1
    """
    For conditions that require awareness and may require subsequent response.
    """

    CAUTION = 2
    """
    For conditions that require immediate awareness and subsequent response.
    """

    WARNING = 3
    """For conditions that require immediate awareness and response."""


class AltIdType(betterproto.Enum):
    """The type of alternate id."""

    INVALID = 0
    TRACK_ID_2 = 1
    """an Anduril trackId_2"""

    TRACK_ID_1 = 12
    """an Anduril trackId_1"""

    SPI_ID = 2
    """an Anduril Sensor Point of Interest ID"""

    NITF_FILE_TITLE = 3
    """NITF file title"""

    TRACK_REPO_ALERT_ID = 4
    """Track repo alert ID"""

    ASSET_ID = 5
    """an Anduril AssetId"""

    LINK16_TRACK_NUMBER = 6
    """Use for Link 16 track identifiers for non-JTIDS Unit entities."""

    LINK16_JU = 7
    """Use for Link 16 JTIDS Unit identifiers."""

    NCCT_MESSAGE_ID = 8
    """an NCCT message ID"""

    CALLSIGN = 9
    """callsign for the entity. e.g. a TAK callsign or an aircraft callsign"""

    MMSI_ID = 10
    """
    the Maritime Mobile Service Identity for a maritime object (vessel, offshore installation, etc.)
    """

    VMF_URN = 11
    """A VMF URN that uniquely identifies the URN on the VMF network."""

    IMO_ID = 13
    """
    the International Maritime Organization number for identifying maritime objects (vessel, offshore installation, etc.)
    """

    VMF_TARGET_NUMBER = 14
    """
    A VMF target number that uniquely identifies the target on the VMF network
    """

    SERIAL_NUMBER = 15
    """
    A serial number that uniquely identifies the entity and is permanently associated with only one entity. This
     identifier is assigned by some authority and only ever identifies a single thing. Examples include a
     Vehicle Identification Number (VIN) or ship hull identification number (hull number). This is a generalized
     component and should not be used if a more specific registration type is already defined (i.e., ALT_ID_TYPE_VMF_URN).
    """

    REGISTRATION_ID = 16
    """
    A registration identifier assigned by a local or national authority. This identifier is not permanently fixed
     to one specific entity and may be reassigned on change of ownership, destruction, or other conditions set
     forth by the authority. Examples include a vehicle license plate or aircraft tail number. This is a generalized
     component and should not be used if a more specific registration type is already defined (i.e., ALT_ID_TYPE_IMO_ID).
    """

    IBS_GID = 17
    """Integrated Broadcast Service Common Message Format Global Identifier"""

    DODAAC = 18
    """Department of Defense Activity Address Code."""

    UIC = 19
    """
    Unit Identification Code uniquely identifies each US Department of Defense entity
    """

    NORAD_CAT_ID = 20
    """
    A NORAD Satellite Catalog Number, a 9-digit number uniquely representing orbital objects around Earth.
     of strictly numeric.
    """

    UNOOSA_NAME = 23
    """
    Space object name. If populated, use names from the UN Office
     of Outer Space Affairs designator index, otherwise set field to UNKNOWN.
    """

    UNOOSA_ID = 24
    """
    Space object identifier. If populated, use the international spacecraft designator
     as published in the UN Office of Outer Space Affairs designator index, otherwise set to UNKNOWN.
     Recommended values have the format YYYYNNNP{PP}, where:
      YYYY = Year of launch.
      NNN = Three-digit serial number of launch
      in year YYYY (with leading zeros).
      P{PP} = At least one capital letter for the
      identification of the part brought
      into space by the launch.
    """


class Template(betterproto.Enum):
    """
    Set of possible templates used when creating an entity.
     This impacts minimum required component sets and can be used by edge systems that need to distinguish.
    """

    INVALID = 0
    TRACK = 1
    """
    additional track required components:
       * location
       * mil_view
    """

    SENSOR_POINT_OF_INTEREST = 2
    """
    additional SPI required components:
       * location
       * mil_view
       * produced_by
    """

    ASSET = 3
    """
    additional asset required components:
       * location
       * mil_view
       * ontology
    """

    GEO = 4
    """
    additional geo required components:
       * geo_shape
       * geo_details
    """

    SIGNAL_OF_INTEREST = 5
    """
    additional SOI required components:
       * signal
       * location field should be populated if there is a fix.
       * mil_view
       * ontology
    """


class OverrideStatus(betterproto.Enum):
    """The state of an override."""

    INVALID = 0
    APPLIED = 1
    """the override was applied to the entity."""

    PENDING = 2
    """the override is pending action."""

    TIMEOUT = 3
    """the override has been timed out."""

    REJECTED = 4
    """the override has been rejected"""

    DELETION_PENDING = 5
    """The override is pending deletion."""


class OverrideType(betterproto.Enum):
    INVALID = 0
    """
    The override type value was not set. This value is interpreted as OVERRIDE_TYPE_LIVE for backward compatibility.
    """

    LIVE = 1
    """
    Override was requested when the entity was live according to the Entity Manager instance that handled the request.
    """

    POST_EXPIRY = 2
    """
    Override was requested after the entity expired according to the Entity Manager instance that handled the request.
    """


class PayloadOperationalState(betterproto.Enum):
    """Describes the current operational state of a payload configuration."""

    INVALID = 0
    OFF = 1
    NON_OPERATIONAL = 2
    DEGRADED = 3
    OPERATIONAL = 4
    OUT_OF_SERVICE = 5
    UNKNOWN = 6


class PowerStatus(betterproto.Enum):
    INVALID = 0
    UNKNOWN = 1
    """
    Indeterminate condition of whether the power system is present or absent.
    """

    NOT_PRESENT = 2
    """
    Power system is not configured/present. This is considered a normal/expected condition, as opposed to the
     system is expected to be present but is missing.
    """

    OPERATING = 3
    """Power system is present and operating normally."""

    DISABLED = 4
    """
    Power system is present and is in an expected disabled state. For example, if the generator was shut off for
     operational reasons.
    """

    ERROR = 5
    """Power system is non-functional."""


class PowerType(betterproto.Enum):
    INVALID = 0
    UNKNOWN = 1
    GAS = 2
    BATTERY = 3


class ScanType(betterproto.Enum):
    """Enumerates the possible scan types"""

    INVALID = 0
    CIRCULAR = 1
    BIDIRECTIONAL_HORIZONTAL_SECTOR = 2
    BIDIRECTIONAL_VERTICAL_SECTOR = 3
    NON_SCANNING = 4
    IRREGULAR = 5
    CONICAL = 6
    LOBE_SWITCHING = 7
    RASTER = 8
    CIRCULAR_VERTICAL_SECTOR = 9
    CIRCULAR_CONICAL = 10
    SECTOR_CONICAL = 11
    AGILE_BEAM = 12
    UNIDIRECTIONAL_VERTICAL_SECTOR = 13
    UNIDIRECTIONAL_HORIZONTAL_SECTOR = 14
    UNIDIRECTIONAL_SECTOR = 15
    BIDIRECTIONAL_SECTOR = 16


class OperationalState(betterproto.Enum):
    """Describes the current operational state of a system."""

    INVALID = 0
    OFF = 1
    """sensor exists but is deliberately turned off"""

    NON_OPERATIONAL = 2
    """
    sensor is not operational but some reason other than being "Off" (e.g., equipment malfunction)
    """

    DEGRADED = 3
    """
    sensor is receiving information but in some reduced status (e.g., off calibration)
    """

    OPERATIONAL = 4
    """fully functional"""

    DENIED = 5
    """sensor is being actively denied"""


class SensorMode(betterproto.Enum):
    """
    Enumerates the possible sensor modes which were active for this sensor field of view.
    """

    INVALID = 0
    SEARCH = 1
    TRACK = 2
    WEAPON_SUPPORT = 3
    AUTO = 4
    MUTE = 5


class SensorType(betterproto.Enum):
    INVALID = 0
    RADAR = 1
    CAMERA = 2
    TRANSPONDER = 3
    RF = 4
    GPS = 5
    PTU_POS = 6
    PERIMETER = 8
    SONAR = 9


class ScheduleType(betterproto.Enum):
    """The type of Schedule."""

    INVALID = 0
    ZONE_ENABLED = 1
    ZONE_TEMP_ENABLED = 2


class InterrogationResponse(betterproto.Enum):
    """Indicates the interrogation status of a target."""

    INVALID = 0
    """
    Note that INTERROGATION_INVALID indicates that the target has not been interrogated.
    """

    CORRECT = 1
    INCORRECT = 2
    NO_RESPONSE = 3


class CorrelationType(betterproto.Enum):
    """The type of correlation indicating how it was made."""

    INVALID = 0
    MANUAL = 1
    """
    The correlation was made manually by a human.
     Manual is higher precedence than automated assuming the same replication mode.
    """

    AUTOMATED = 2
    """
    The correlation was automatically made by a service or some other automated process.
     Automated is lower precedence than manual assuming the same replication mode.
    """


class CorrelationReplicationMode(betterproto.Enum):
    """
    The replication mode of the correlation indicating how the correlation will be replication to
     other nodes in the mesh.
    """

    INVALID = 0
    LOCAL = 1
    """
    The correlation is local only to the originating node and will not be distributed to other
     nodes in the mesh. In the case of conflicts, this correlation will override ones coming from
     other nodes. Local is always higher precedence than global regardless of the correlation type.
    """

    GLOBAL = 2
    """
    The correlation is distributed globally across all nodes in the mesh. Because an entity can
     only be part of one correlation, this is based on last-write-wins semantics, however, the
     correlation will also be stored locally in the originating node preventing any overrides.
     Global is always lower precedence than local regardless of the correlation type.
    """


class Comparator(betterproto.Enum):
    """
    The Comparator specifies the set of supported comparison operations. It also provides the
     mapping information about which comparators are supported for which values. Services that wish
     to implement entity filters must provide validation functionality to strictly enforce these
     mappings.
    """

    INVALID = 0
    MATCH_ALL = 11
    """
    Comparators for: boolean, numeric, string, enum, position, timestamp, positions, and bounded shapes.
    """

    EQUALITY = 1
    """
    Comparators for: boolean, numeric, string, enum, position, and timestamp.
    """

    IN = 9
    LESS_THAN = 2
    """Comparators for: numeric, string, and timestamp."""

    GREATER_THAN = 3
    LESS_THAN_EQUAL_TO = 4
    GREATER_THAN_EQUAL_TO = 5
    WITHIN = 6
    """Comparators for: positions and bounded shapes."""

    EXISTS = 7
    """
    Comparators for: existential checks.
     TRUE if path to field exists (parent message is present), and either:
       1. the field is a primitive: all values including default pass check.
       2. the field is a message and set/present.
       3. the field is repeated or map with size > 0.
     FALSE unless path exists and one of the above 3 conditions is met
    """

    CASE_INSENSITIVE_EQUALITY = 8
    """Comparator for string type only."""

    CASE_INSENSITIVE_EQUALITY_IN = 10
    RANGE_CLOSED = 12
    """
    Comparators for range types only.
     Closed (inclusive endpoints) [a, b]
    """


class ListComparator(betterproto.Enum):
    """
    The ListComparator determines how to compose statement evaluations for members of a list. For
     example, if ANY_OF is specified, the ListOperation in which the ListComparator is embedded
     will return TRUE if any of the values in the list returns true for the ListOperation's child
     statement.
    """

    INVALID = 0
    ANY_OF = 1


class EventType(betterproto.Enum):
    """The type of entity event."""

    INVALID = 0
    CREATED = 1
    """entity was created."""

    UPDATE = 2
    """entity was updated."""

    DELETED = 3
    """entity was deleted."""

    PREEXISTING = 4
    """entity already existed, but sent on a new stream connection."""

    POST_EXPIRY_OVERRIDE = 5
    """entity override was set after the entity expiration."""


class MediaType(betterproto.Enum):
    INVALID = 0
    THUMBNAIL = 1
    IMAGE = 2
    VIDEO = 3
    SLIPPY_TILES = 4


@dataclass(eq=False, repr=False)
class Classification(betterproto.Message):
    """
    A component that describes an entity's security classification levels.
    """

    default: "ClassificationInformation" = betterproto.message_field(2)
    """
    The default classification information which should be assumed to apply to everything in
     the entity unless a specific field level classification is present.
    """

    fields: List["FieldClassificationInformation"] = betterproto.message_field(3)
    """
    The set of individual field classification information which should always precedence
     over the default classification information.
    """


@dataclass(eq=False, repr=False)
class FieldClassificationInformation(betterproto.Message):
    """A field specific classification information definition."""

    field_path: str = betterproto.string_field(1)
    """
    Proto field path which is the string representation of a field.
     > example: signal.bandwidth_hz would be bandwidth_hz in the signal component
    """

    classification_information: "ClassificationInformation" = betterproto.message_field(
        2
    )
    """
    The information which makes up the field level classification marking.
    """


@dataclass(eq=False, repr=False)
class ClassificationInformation(betterproto.Message):
    """
    Represents all of the necessary information required to generate a summarized
     classification marking.

     > example: A summarized classification marking of "TOPSECRET//NOFORN//FISA"
                would be defined as: { "level": 5, "caveats": [ "NOFORN, "FISA" ] }
    """

    level: "ClassificationLevels" = betterproto.enum_field(1)
    """Classification level to be applied to the information in question."""

    caveats: List[str] = betterproto.string_field(2)
    """
    Caveats that may further restrict how the information can be disseminated.
    """


@dataclass(eq=False, repr=False)
class ContactDetails(betterproto.Message):
    """Contains details on how to make contact with an entity."""

    phone_number: str = betterproto.string_field(1)
    """The primary phone number for this entity."""


@dataclass(eq=False, repr=False)
class Correlated(betterproto.Message):
    """
    Available for Entities that are a correlated (N to 1) set of entities. This will be present on each entity in the
     set.
    """

    primary_entity_id: str = betterproto.string_field(1)
    """primary entity id"""

    status: "CorrelationStatus" = betterproto.enum_field(2)
    """status representing this correlation"""

    scores: List["CorrelationScore"] = betterproto.message_field(3)
    """score pairings between this and other entity ids"""

    expires_time: datetime = betterproto.message_field(4)
    """if not present, does not expire"""


@dataclass(eq=False, repr=False)
class CorrelationScore(betterproto.Message):
    """A correlation scoring between two entities."""

    other_entity_id: str = betterproto.string_field(1)
    score: float = betterproto.float_field(2)
    interpretation: "ScoreInterpretation" = betterproto.enum_field(3)
    link16_compliant: bool = betterproto.bool_field(4)
    """Deprecated: do not use"""

    other_status: "CorrelationStatus" = betterproto.enum_field(5)
    """
    status of other_entity_id correlation, expresses relationship of other to correlation set this entity is part of.
    """

    def __post_init__(self) -> None:
        super().__post_init__()
        if self.is_set("link16_compliant"):
            warnings.warn(
                "CorrelationScore.link16_compliant is deprecated", DeprecationWarning
            )


@dataclass(eq=False, repr=False)
class Dimensions(betterproto.Message):
    length_m: float = betterproto.float_field(1)
    """Length of the entity in meters"""


@dataclass(eq=False, repr=False)
class Location(betterproto.Message):
    """Available for Entities that have a single or primary Location."""

    position: "Position" = betterproto.message_field(1)
    """see Position definition for details."""

    velocity_enu: "__type__.Enu" = betterproto.message_field(2)
    """
    Velocity in an ENU reference frame centered on the corresponding position. All units are meters per second.
    """

    speed_mps: Optional[float] = betterproto.message_field(
        5, wraps=betterproto.TYPE_DOUBLE
    )
    """
    Speed is the magnitude of velocity_enu vector [sqrt(e^2 + n^2 + u^2)] when present, measured in m/s.
    """

    acceleration: "__type__.Enu" = betterproto.message_field(4)
    """The entity's acceleration in meters/s^2."""

    attitude_enu: "__type__.Quaternion" = betterproto.message_field(3)
    """quaternion to translate from entity body frame to it's ENU frame"""


@dataclass(eq=False, repr=False)
class Position(betterproto.Message):
    """
    WGS84 position. Position includes four altitude references.
     The data model does not currently support Mean Sea Level (MSL) references,
     such as the Earth Gravitational Model 1996 (EGM-96) and the Earth Gravitational Model 2008 (EGM-08).
     If the only altitude reference available to your integration is MSL, convert it to
     Height Above Ellipsoid (HAE) and populate the altitude_hae_meters field.
    """

    latitude_degrees: float = betterproto.double_field(1)
    """WGS84 geodetic latitude in decimal degrees."""

    longitude_degrees: float = betterproto.double_field(2)
    """WGS84 longitude in decimal degrees."""

    altitude_hae_meters: Optional[float] = betterproto.message_field(
        3, wraps=betterproto.TYPE_DOUBLE
    )
    """
    altitude as height above ellipsoid (WGS84) in meters. DoubleValue wrapper is used to distinguish optional from
     default 0.
    """

    altitude_agl_meters: Optional[float] = betterproto.message_field(
        4, wraps=betterproto.TYPE_DOUBLE
    )
    """
    Altitude as AGL (Above Ground Level) if the upstream data source has this value set. This value represents the
     entity's height above the terrain. This is typically measured with a radar altimeter or by using a terrain tile
     set lookup. If the value is not set from the upstream, this value is not set.
    """

    altitude_asf_meters: Optional[float] = betterproto.message_field(
        5, wraps=betterproto.TYPE_DOUBLE
    )
    """
    Altitude as ASF (Above Sea Floor) if the upstream data source has this value set. If the value is not set from the upstream, this value is
     not set.
    """

    pressure_depth_meters: Optional[float] = betterproto.message_field(
        6, wraps=betterproto.TYPE_DOUBLE
    )
    """
    The depth of the entity from the surface of the water through sensor measurements based on differential pressure
     between the interior and exterior of the vessel. If the value is not set from the upstream, this value is not set.
    """


@dataclass(eq=False, repr=False)
class LocationUncertainty(betterproto.Message):
    """Uncertainty of entity position and velocity, if available."""

    position_enu_cov: "TMat3" = betterproto.message_field(1)
    """
    Positional covariance represented by the upper triangle of the covariance matrix. It is valid to populate
     only the diagonal of the matrix if the full covariance matrix is unknown.
    """

    velocity_enu_cov: "TMat3" = betterproto.message_field(2)
    """
    Velocity covariance represented by the upper triangle of the covariance matrix. It is valid to populate
     only the diagonal of the matrix if the full covariance matrix is unknown.
    """

    position_error_ellipse: "ErrorEllipse" = betterproto.message_field(3)
    """
    An ellipse that describes the certainty probability and error boundary for a given geolocation.
    """


@dataclass(eq=False, repr=False)
class ErrorEllipse(betterproto.Message):
    """
    Indicates ellipse characteristics and probability that an entity lies within the defined ellipse.
    """

    probability: Optional[float] = betterproto.message_field(
        1, wraps=betterproto.TYPE_DOUBLE
    )
    """
    Defines the probability in percentage that an entity lies within the given ellipse: 0-1.
    """

    semi_major_axis_m: Optional[float] = betterproto.message_field(
        2, wraps=betterproto.TYPE_DOUBLE
    )
    """
    Defines the distance from the center point of the ellipse to the furthest distance on the perimeter in meters.
    """

    semi_minor_axis_m: Optional[float] = betterproto.message_field(
        3, wraps=betterproto.TYPE_DOUBLE
    )
    """
    Defines the distance from the center point of the ellipse to the shortest distance on the perimeter in meters.
    """

    orientation_d: Optional[float] = betterproto.message_field(
        4, wraps=betterproto.TYPE_DOUBLE
    )
    """
    The orientation of the semi-major relative to true north in degrees from clockwise: 0-180 due to symmetry across the semi-minor axis.
    """


@dataclass(eq=False, repr=False)
class Pose(betterproto.Message):
    pos: "Position" = betterproto.message_field(1)
    """Geospatial location defined by this Pose."""

    orientation: "__type__.Quaternion" = betterproto.message_field(2)
    """
    The quaternion to transform a point in the Pose frame to the ENU frame. The Pose frame could be Body, Turret,
     etc and is determined by the context in which this Pose is used.
     The normal convention for defining orientation is to list the frames of transformation, for example
     att_gimbal_to_enu is the quaternion which transforms a point in the gimbal frame to the body frame, but
     in this case we truncate to att_enu because the Pose frame isn't defined. A potentially better name for this
     field would have been att_pose_to_enu.
    
     Implementations of this quaternion should left multiply this quaternion to transform a point from the Pose frame
     to the enu frame.
    """


@dataclass(eq=False, repr=False)
class TMat3(betterproto.Message):
    """Symmetric 3d matrix only representing the upper right triangle."""

    mxx: float = betterproto.float_field(1)
    mxy: float = betterproto.float_field(2)
    mxz: float = betterproto.float_field(3)
    myy: float = betterproto.float_field(4)
    myz: float = betterproto.float_field(5)
    mzz: float = betterproto.float_field(6)


@dataclass(eq=False, repr=False)
class GeoDetails(betterproto.Message):
    """A component that describes a geo-entity."""

    type: "GeoType" = betterproto.enum_field(1)


@dataclass(eq=False, repr=False)
class GeoShape(betterproto.Message):
    """A component that describes the shape of a geo-entity."""

    point: "GeoPoint" = betterproto.message_field(1, group="shape")
    line: "GeoLine" = betterproto.message_field(2, group="shape")
    polygon: "GeoPolygon" = betterproto.message_field(3, group="shape")
    ellipse: "GeoEllipse" = betterproto.message_field(4, group="shape")
    ellipsoid: "GeoEllipsoid" = betterproto.message_field(5, group="shape")


@dataclass(eq=False, repr=False)
class GeoPoint(betterproto.Message):
    """
    A point shaped geo-entity.
     See https://datatracker.ietf.org/doc/html/rfc7946#section-3.1.2
    """

    position: "Position" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GeoLine(betterproto.Message):
    """
    A line shaped geo-entity.
     See https://datatracker.ietf.org/doc/html/rfc7946#section-3.1.4
    """

    positions: List["Position"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class GeoPolygon(betterproto.Message):
    """
    A polygon shaped geo-entity.
     See https://datatracker.ietf.org/doc/html/rfc7946#section-3.1.6, only canonical representations accepted
    """

    rings: List["LinearRing"] = betterproto.message_field(1)
    """
    An array of LinearRings where the first item is the exterior ring and subsequent items are interior rings.
    """

    is_rectangle: bool = betterproto.bool_field(2)
    """
    An extension hint that this polygon is a rectangle. When true this implies several things:
     * exactly 1 linear ring with 5 points (starting corner, 3 other corners and start again)
     * each point has the same altitude corresponding with the plane of the rectangle
     * each point has the same height (either all present and equal, or all not present)
    """


@dataclass(eq=False, repr=False)
class GeoEllipse(betterproto.Message):
    """
    An ellipse shaped geo-entity.
     For a circle, the major and minor axis would be the same values.
     This shape is NOT Geo-JSON compatible.
    """

    semi_major_axis_m: Optional[float] = betterproto.message_field(
        2, wraps=betterproto.TYPE_DOUBLE
    )
    """
    Defines the distance from the center point of the ellipse to the furthest distance on the perimeter in meters.
    """

    semi_minor_axis_m: Optional[float] = betterproto.message_field(
        3, wraps=betterproto.TYPE_DOUBLE
    )
    """
    Defines the distance from the center point of the ellipse to the shortest distance on the perimeter in meters.
    """

    orientation_d: Optional[float] = betterproto.message_field(
        4, wraps=betterproto.TYPE_DOUBLE
    )
    """
    The orientation of the semi-major relative to true north in degrees from clockwise: 0-180 due to symmetry across the semi-minor axis.
    """

    height_m: Optional[float] = betterproto.message_field(
        5, wraps=betterproto.TYPE_DOUBLE
    )
    """
    Optional height above entity position to extrude in meters. A non-zero value creates an elliptic cylinder
    """


@dataclass(eq=False, repr=False)
class GeoEllipsoid(betterproto.Message):
    """
    An ellipsoid shaped geo-entity.
     Principal axis lengths are defined in entity body space
     This shape is NOT Geo-JSON compatible.
    """

    forward_axis_m: Optional[float] = betterproto.message_field(
        1, wraps=betterproto.TYPE_DOUBLE
    )
    """
    Defines the distance from the center point to the surface along the forward axis
    """

    side_axis_m: Optional[float] = betterproto.message_field(
        2, wraps=betterproto.TYPE_DOUBLE
    )
    """
    Defines the distance from the center point to the surface along the side axis
    """

    up_axis_m: Optional[float] = betterproto.message_field(
        3, wraps=betterproto.TYPE_DOUBLE
    )
    """
    Defines the distance from the center point to the surface along the up axis
    """


@dataclass(eq=False, repr=False)
class LinearRing(betterproto.Message):
    """A closed ring of points. The first and last point must be the same."""

    positions: List["GeoPolygonPosition"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class GeoPolygonPosition(betterproto.Message):
    """A position in a GeoPolygon with an optional extruded height."""

    position: "Position" = betterproto.message_field(1)
    """base position. if no altitude set, its on the ground."""

    height_m: Optional[float] = betterproto.message_field(
        2, wraps=betterproto.TYPE_FLOAT
    )
    """
    optional height above base position to extrude in meters.
     for a given polygon, all points should have a height or none of them.
     strictly GeoJSON compatible polygons will not have this set.
    """


@dataclass(eq=False, repr=False)
class GroupDetails(betterproto.Message):
    """Details related to grouping for this entity"""

    echelon: "Echelon" = betterproto.message_field(3, group="group_type")


@dataclass(eq=False, repr=False)
class Echelon(betterproto.Message):
    """
    Describes a Echelon group type.  Comprised of entities which are members of the
     same unit or echelon. Ex: A group of tanks within a armored company or that same company
     as a member of a battalion.
    """

    army_echelon: "ArmyEchelon" = betterproto.enum_field(1, group="echelon_type")


@dataclass(eq=False, repr=False)
class ComponentMessage(betterproto.Message):
    """A message describing the component's health status."""

    status: "HealthStatus" = betterproto.enum_field(1)
    """The status associated with this message."""

    message: str = betterproto.string_field(2)
    """The human-readable content of the message."""


@dataclass(eq=False, repr=False)
class ComponentHealth(betterproto.Message):
    """Health of an individual component."""

    id: str = betterproto.string_field(1)
    """Consistent internal ID for this component."""

    name: str = betterproto.string_field(2)
    """Display name for this component."""

    health: "HealthStatus" = betterproto.enum_field(3)
    """Health for this component."""

    messages: List["ComponentMessage"] = betterproto.message_field(4)
    """
    Human-readable describing the component state. These messages should be understandable by end users.
    """

    update_time: datetime = betterproto.message_field(5)
    """
    The last update time for this specific component.
     If this timestamp is unset, the data is assumed to be most recent
    """


@dataclass(eq=False, repr=False)
class Health(betterproto.Message):
    """General health of the entity as reported by the entity."""

    connection_status: "ConnectionStatus" = betterproto.enum_field(1)
    """
    Status indicating whether the entity is able to communicate with Entity Manager.
    """

    health_status: "HealthStatus" = betterproto.enum_field(2)
    """
    Top-level health status; typically a roll-up of individual component healths.
    """

    components: List["ComponentHealth"] = betterproto.message_field(3)
    """Health of individual components running on this Entity."""

    update_time: datetime = betterproto.message_field(4)
    """
    The update time for the top-level health information.
     If this timestamp is unset, the data is assumed to be most recent
    """

    active_alerts: List["Alert"] = betterproto.message_field(5)
    """
    Active alerts indicate a critical change in system state sent by the asset
     that must be made known to an operator or consumer of the common operating picture.
     Alerts are different from ComponentHealth messages--an active alert does not necessarily
     indicate a component is in an unhealthy state. For example, an asset may trigger
     an active alert based on fuel levels running low. Alerts should be removed from this list when their conditions
     are cleared. In other words, only active alerts should be reported here.
    """


@dataclass(eq=False, repr=False)
class Alert(betterproto.Message):
    """
    An alert informs operators of critical events related to system performance and mission
     execution. An alert is produced as a result of one or more alert conditions.
    """

    alert_code: str = betterproto.string_field(1)
    """
    Short, machine-readable code that describes this alert. This code is intended to provide systems off-asset
     with a lookup key to retrieve more detailed information about the alert.
    """

    description: str = betterproto.string_field(2)
    """
    Human-readable description of this alert. The description is intended for display in the UI for human
     understanding and should not be used for machine processing. If the description is fixed and the vehicle controller
     provides no dynamic substitutions, then prefer lookup based on alert_code.
    """

    level: "AlertLevel" = betterproto.enum_field(3)
    """Alert level (Warning, Caution, or Advisory)."""

    activated_time: datetime = betterproto.message_field(4)
    """Time at which this alert was activated."""

    active_conditions: List["AlertCondition"] = betterproto.message_field(5)
    """Set of conditions which have activated this alert."""


@dataclass(eq=False, repr=False)
class AlertCondition(betterproto.Message):
    """A condition which may trigger an alert."""

    condition_code: str = betterproto.string_field(1)
    """
    Short, machine-readable code that describes this condition. This code is intended to provide systems off-asset
     with a lookup key to retrieve more detailed information about the condition.
    """

    description: str = betterproto.string_field(2)
    """
    Human-readable description of this condition. The description is intended for display in the UI for human
     understanding and should not be used for machine processing. If the description is fixed and the vehicle controller
     provides no dynamic substitutions, then prefer lookup based on condition_code.
    """


@dataclass(eq=False, repr=False)
class UInt32Range(betterproto.Message):
    lower_bound: int = betterproto.uint32_field(1)
    upper_bound: int = betterproto.uint32_field(2)


@dataclass(eq=False, repr=False)
class FloatRange(betterproto.Message):
    lower_bound: float = betterproto.float_field(1)
    upper_bound: float = betterproto.float_field(2)


@dataclass(eq=False, repr=False)
class MilView(betterproto.Message):
    """Provides the disposition, environment, and nationality of an Entity."""

    disposition: "__ontology_v1__.Disposition" = betterproto.enum_field(1)
    environment: "__ontology_v1__.Environment" = betterproto.enum_field(2)
    nationality: "__ontology_v1__.Nationality" = betterproto.enum_field(3)


@dataclass(eq=False, repr=False)
class Ontology(betterproto.Message):
    """Ontology of the entity."""

    platform_type: str = betterproto.string_field(3)
    """
    A string that describes the entity's high-level type with natural language.
    """

    specific_type: str = betterproto.string_field(4)
    """A string that describes the entity's exact model or type."""

    template: "Template" = betterproto.enum_field(2)
    """
    The template used when creating this entity. Specifies minimum required components.
    """


@dataclass(eq=False, repr=False)
class Orbit(betterproto.Message):
    orbit_mean_elements: "__type__.OrbitMeanElements" = betterproto.message_field(1)
    """
    Orbit Mean Elements data, analogous to the Orbit Mean Elements Message in CCSDS 502.0-B-3
    """


@dataclass(eq=False, repr=False)
class Payloads(betterproto.Message):
    """List of payloads available for an entity."""

    payload_configurations: List["Payload"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class Payload(betterproto.Message):
    """Individual payload configuration."""

    config: "PayloadConfiguration" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class PayloadConfiguration(betterproto.Message):
    capability_id: str = betterproto.string_field(1)
    """
    Identifying ID for the capability.
     This ID may be used multiple times to represent payloads that are the same capability but have different operational states
    """

    quantity: int = betterproto.uint32_field(4)
    """The number of payloads currently available in the configuration."""

    effective_environment: List["__ontology_v1__.Environment"] = betterproto.enum_field(
        5
    )
    """The target environments the configuration is effective against."""

    payload_operational_state: "PayloadOperationalState" = betterproto.enum_field(6)
    """The operational state of this payload."""

    payload_description: str = betterproto.string_field(7)
    """A human readable description of the payload"""


@dataclass(eq=False, repr=False)
class PowerState(betterproto.Message):
    """Represents the state of power sources connected to this entity."""

    source_id_to_state: Dict[str, "PowerSource"] = betterproto.map_field(
        5, betterproto.TYPE_STRING, betterproto.TYPE_MESSAGE
    )
    """
    This is a map where the key is a unique id of the power source and the value is additional information about the
     power source.
    """


@dataclass(eq=False, repr=False)
class PowerSource(betterproto.Message):
    """
    Represents the state of a single power source that is connected to this entity.
    """

    power_status: "PowerStatus" = betterproto.enum_field(1)
    """Status of the power source."""

    power_type: "PowerType" = betterproto.enum_field(2)
    """Used to determine the type of power source."""

    power_level: "PowerLevel" = betterproto.message_field(3)
    """
    Power level of the system. If absent, the power level is assumed to be unknown.
    """

    messages: List[str] = betterproto.string_field(4)
    """
    Set of human-readable messages with status of the power system. Typically this would be used in an error state
     to provide additional error information. This can also be used for informational messages.
    """

    offloadable: Optional[bool] = betterproto.message_field(
        5, wraps=betterproto.TYPE_BOOL
    )
    """
    Whether the power source is offloadable. If the value is missing (as opposed to false) then the entity does not
     report whether the power source is offloadable.
    """


@dataclass(eq=False, repr=False)
class PowerLevel(betterproto.Message):
    """Represents the power level of a system."""

    capacity: float = betterproto.float_field(1)
    """Total power capacity of the system."""

    remaining: float = betterproto.float_field(2)
    """Remaining power capacity of the system."""

    percent_remaining: float = betterproto.float_field(3)
    """Percent of power remaining."""

    voltage: Optional[float] = betterproto.message_field(
        4, wraps=betterproto.TYPE_DOUBLE
    )
    """
    Voltage of the power source subsystem, as reported by the power source. If the source does not report this value
     this field will be null.
    """

    current_amps: Optional[float] = betterproto.message_field(
        5, wraps=betterproto.TYPE_DOUBLE
    )
    """
    Current in amps of the power source subsystem, as reported by the power source. If the source does not
     report this value this field will be null.
    """

    run_time_to_empty_mins: Optional[float] = betterproto.message_field(
        6, wraps=betterproto.TYPE_DOUBLE
    )
    """
    Estimated minutes until empty. Calculated with consumption at the moment, as reported by the power source. If the source does not
     report this value this field will be null.
    """

    consumption_rate_l_per_s: Optional[float] = betterproto.message_field(
        7, wraps=betterproto.TYPE_DOUBLE
    )
    """Fuel consumption rate in liters per second."""


@dataclass(eq=False, repr=False)
class Signal(betterproto.Message):
    """A component that describes an entity's signal characteristics."""

    frequency_center: "Frequency" = betterproto.message_field(
        1, group="frequency_measurement"
    )
    frequency_range: "FrequencyRange" = betterproto.message_field(
        2, group="frequency_measurement"
    )
    bandwidth_hz: Optional[float] = betterproto.message_field(
        3, wraps=betterproto.TYPE_DOUBLE
    )
    """Indicates the bandwidth of a signal (Hz)."""

    signal_to_noise_ratio: Optional[float] = betterproto.message_field(
        4, wraps=betterproto.TYPE_DOUBLE
    )
    """Indicates the signal to noise (SNR) of this signal."""

    line_of_bearing: "LineOfBearing" = betterproto.message_field(5, group="report")
    fixed: "Fixed" = betterproto.message_field(6, group="report")
    emitter_notations: List["EmitterNotation"] = betterproto.message_field(7)
    """Emitter notations associated with this entity."""

    pulse_width_s: Optional[float] = betterproto.message_field(
        8, wraps=betterproto.TYPE_DOUBLE
    )
    """length in time of a single pulse"""

    pulse_repetition_interval: "PulseRepetitionInterval" = betterproto.message_field(9)
    """length in time between the start of two pulses"""

    scan_characteristics: "ScanCharacteristics" = betterproto.message_field(11)
    """describes how a signal is observing the environment"""


@dataclass(eq=False, repr=False)
class EmitterNotation(betterproto.Message):
    """A representation of a single emitter notation."""

    emitter_notation: str = betterproto.string_field(1)
    confidence: Optional[float] = betterproto.message_field(
        2, wraps=betterproto.TYPE_DOUBLE
    )
    """
    confidence as a percentage that the emitter notation in this component is accurate
    """


@dataclass(eq=False, repr=False)
class Measurement(betterproto.Message):
    """A component that describes some measured value with error."""

    value: Optional[float] = betterproto.message_field(1, wraps=betterproto.TYPE_DOUBLE)
    """The value of the measurement."""

    sigma: Optional[float] = betterproto.message_field(2, wraps=betterproto.TYPE_DOUBLE)
    """Estimated one standard deviation in same unit as the value."""


@dataclass(eq=False, repr=False)
class Frequency(betterproto.Message):
    """A component for describing frequency."""

    frequency_hz: "Measurement" = betterproto.message_field(1)
    """Indicates a frequency of a signal (Hz) with its standard deviation."""


@dataclass(eq=False, repr=False)
class FrequencyRange(betterproto.Message):
    """A component to represent a frequency range."""

    minimum_frequency_hz: "Frequency" = betterproto.message_field(1)
    """Indicates the lowest measured frequency of a signal (Hz)."""

    maximum_frequency_hz: "Frequency" = betterproto.message_field(2)
    """Indicates the maximum measured frequency of a signal (Hz)."""


@dataclass(eq=False, repr=False)
class LineOfBearing(betterproto.Message):
    """A line of bearing of a signal."""

    angle_of_arrival: "AngleOfArrival" = betterproto.message_field(3)
    """The direction pointing from this entity to the detection"""

    range_estimate_m: "Measurement" = betterproto.message_field(
        4, group="detection_range"
    )
    """The estimated distance of the detection"""

    max_range_m: "Measurement" = betterproto.message_field(5, group="detection_range")
    """The maximum distance of the detection"""


@dataclass(eq=False, repr=False)
class AngleOfArrival(betterproto.Message):
    """The direction from which the signal is received"""

    relative_pose: "__type__.Pose" = betterproto.message_field(1)
    """
    Origin (LLA) and attitude (relative to ENU) of a ray pointing towards the detection. The attitude represents a
     forward-left-up (FLU) frame where the x-axis (1, 0, 0) is pointing towards the target.
    """

    bearing_elevation_covariance_rad2: "__type__.TMat2" = betterproto.message_field(2)
    """
    Bearing/elevation covariance matrix where bearing is defined in radians CCW+ about the z-axis from the x-axis of FLU frame
     and elevation is positive down from the FL/XY plane.
     mxx = bearing variance in rad^2
     mxy = bearing/elevation covariance in rad^2
     myy = elevation variance in rad^2
    """


@dataclass(eq=False, repr=False)
class Fixed(betterproto.Message):
    """
    A fix of a signal. No extra fields but it is expected that location should be populated when using this report.
    """

    pass


@dataclass(eq=False, repr=False)
class PulseRepetitionInterval(betterproto.Message):
    """A component that describe the length in time between two pulses"""

    pulse_repetition_interval_s: "Measurement" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class ScanCharacteristics(betterproto.Message):
    """A component that describes the scanning characteristics of a signal"""

    scan_type: "ScanType" = betterproto.enum_field(1)
    scan_period_s: Optional[float] = betterproto.message_field(
        2, wraps=betterproto.TYPE_DOUBLE
    )


@dataclass(eq=False, repr=False)
class Sensors(betterproto.Message):
    """List of sensors available for an entity."""

    sensors: List["Sensor"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class Sensor(betterproto.Message):
    """Individual sensor configuration."""

    sensor_id: str = betterproto.string_field(1)
    """
    This generally is used to indicate a specific type at a more detailed granularity. E.g. COMInt or LWIR
    """

    operational_state: "OperationalState" = betterproto.enum_field(3)
    sensor_type: "SensorType" = betterproto.enum_field(5)
    """The type of sensor"""

    sensor_description: str = betterproto.string_field(6)
    """A human readable description of the sensor"""

    rf_configuraton: "RfConfiguration" = betterproto.message_field(7)
    """RF configuration details of the sensor"""

    last_detection_timestamp: datetime = betterproto.message_field(8)
    """Time of the latest detection from the sensor"""

    fields_of_view: List["FieldOfView"] = betterproto.message_field(9)
    """Multiple fields of view for a single sensor component"""


@dataclass(eq=False, repr=False)
class FieldOfView(betterproto.Message):
    """Sensor Field Of View closely resembling fov.proto SensorFieldOfView."""

    fov_id: int = betterproto.int32_field(1)
    """
    The Id for one instance of a FieldOfView, persisted across multiple updates to provide continuity during
     smoothing. This is relevant for sensors where the dwell schedule is on the order of
     milliseconds, making multiple FOVs a requirement for proper display of search beams.
    """

    mount_id: str = betterproto.string_field(2)
    """The Id of the mount the sensor is on."""

    projected_frustum: "ProjectedFrustum" = betterproto.message_field(3)
    """The field of view the sensor projected onto the ground."""

    projected_center_ray: "Position" = betterproto.message_field(4)
    """Center ray of the frustum projected onto the ground."""

    center_ray_pose: "Pose" = betterproto.message_field(5)
    """
    The origin and direction of the center ray for this sensor relative to the ENU frame. A ray which is aligned with
     the positive X axis in the sensor frame will be transformed into the ray along the sensor direction in the ENU
     frame when transformed by the quaternion contained in this pose.
    """

    horizontal_fov: float = betterproto.float_field(6)
    """Horizontal field of view in radians."""

    vertical_fov: float = betterproto.float_field(7)
    """Vertical field of view in radians."""

    range: Optional[float] = betterproto.message_field(8, wraps=betterproto.TYPE_FLOAT)
    """Sensor range in meters."""

    mode: "SensorMode" = betterproto.enum_field(9)
    """
    The mode that this sensor is currently in, used to display for context in the UI. Some sensors can emit multiple
     sensor field of views with different modes, for example a radar can simultaneously search broadly and perform
     tighter bounded tracking.
    """


@dataclass(eq=False, repr=False)
class ProjectedFrustum(betterproto.Message):
    """
    Represents a frustum in which which all four corner points project onto the ground. All points in this message
     are optional, if the projection to the ground fails then they will not be populated.
    """

    upper_left: "Position" = betterproto.message_field(1)
    """Upper left point of the frustum."""

    upper_right: "Position" = betterproto.message_field(2)
    """Upper right point of the frustum."""

    bottom_right: "Position" = betterproto.message_field(3)
    """Bottom right point of the frustum."""

    bottom_left: "Position" = betterproto.message_field(4)
    """Bottom left point of the frustum."""


@dataclass(eq=False, repr=False)
class RfConfiguration(betterproto.Message):
    """Represents RF configurations supported on this sensor."""

    frequency_range_hz: List["FrequencyRange"] = betterproto.message_field(3)
    """Frequency ranges that are available for this sensor."""

    bandwidth_range_hz: List["BandwidthRange"] = betterproto.message_field(4)
    """Bandwidth ranges that are available for this sensor."""


@dataclass(eq=False, repr=False)
class BandwidthRange(betterproto.Message):
    """A component that describes the min and max bandwidths of a sensor"""

    minimum_bandwidth: "Bandwidth" = betterproto.message_field(1)
    maximum_bandwidth: "Bandwidth" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class Bandwidth(betterproto.Message):
    """Describes the bandwidth of a signal"""

    bandwidth_hz: Optional[float] = betterproto.message_field(
        1, wraps=betterproto.TYPE_DOUBLE
    )


@dataclass(eq=False, repr=False)
class Relationships(betterproto.Message):
    """
    The relationships between this entity and other entities in the common operational picture.
    """

    relationships: List["Relationship"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class Relationship(betterproto.Message):
    """
    The relationship component indicates a relationship to another entity.
    """

    related_entity_id: str = betterproto.string_field(1)
    """The entity ID to which this entity is related."""

    relationship_id: str = betterproto.string_field(2)
    """
    A unique identifier for this relationship. Allows removing or updating relationships.
    """

    relationship_type: "RelationshipType" = betterproto.message_field(3)
    """The relationship type"""


@dataclass(eq=False, repr=False)
class RelationshipType(betterproto.Message):
    """Determines the type of relationship between this entity and another."""

    tracked_by: "TrackedBy" = betterproto.message_field(2, group="type")
    group_child: "GroupChild" = betterproto.message_field(4, group="type")
    group_parent: "GroupParent" = betterproto.message_field(5, group="type")
    merged_from: "MergedFrom" = betterproto.message_field(6, group="type")
    active_target: "ActiveTarget" = betterproto.message_field(7, group="type")


@dataclass(eq=False, repr=False)
class TrackedBy(betterproto.Message):
    """
    Describes the relationship between the entity being tracked ("tracked entity") and the entity that is
     performing the tracking ("tracking entity").
    """

    actively_tracking_sensors: "Sensors" = betterproto.message_field(1)
    """
    Sensor details of the tracking entity's sensors that were active and tracking the tracked entity. This may be
     a subset of the total sensors available on the tracking entity.
    """

    last_measurement_timestamp: datetime = betterproto.message_field(2)
    """
    Latest time that any sensor in actively_tracking_sensors detected the tracked entity.
    """


@dataclass(eq=False, repr=False)
class GroupChild(betterproto.Message):
    """
    A GroupChild relationship is a uni-directional relationship indicating that (1) this entity
     represents an Entity Group and (2) the related entity is a child member of this group. The presence of this
     relationship alone determines that the type of group is an Entity Group.
    """

    pass


@dataclass(eq=False, repr=False)
class GroupParent(betterproto.Message):
    """
    A GroupParent relationship is a uni-directional relationship indicating that this entity is a member of
     the Entity Group represented by the related entity. The presence of this relationship alone determines that
     the type of group that this entity is a member of is an Entity Group.
    """

    pass


@dataclass(eq=False, repr=False)
class MergedFrom(betterproto.Message):
    """
    A MergedFrom relationship is a uni-directional relationship indicating that this entity is a merged entity whose
     data has at least partially been merged from the related entity.
    """

    pass


@dataclass(eq=False, repr=False)
class ActiveTarget(betterproto.Message):
    """
    A target relationship is the inverse of TrackedBy; a one-way relation
     from sensor to target, indicating track(s) currently prioritized by a robot.
    """

    pass


@dataclass(eq=False, repr=False)
class RouteDetails(betterproto.Message):
    destination_name: str = betterproto.string_field(1)
    """Free form text giving the name of the entity's destination"""

    estimated_arrival_time: datetime = betterproto.message_field(2)
    """Estimated time of arrival at destination"""


@dataclass(eq=False, repr=False)
class Schedules(betterproto.Message):
    """Schedules associated with this entity"""

    schedules: List["Schedule"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class Schedule(betterproto.Message):
    """A Schedule associated with this entity"""

    windows: List["CronWindow"] = betterproto.message_field(1)
    """expression that represents this schedule's "ON" state"""

    schedule_id: str = betterproto.string_field(2)
    """A unique identifier for this schedule."""

    schedule_type: "ScheduleType" = betterproto.enum_field(3)
    """The schedule type"""


@dataclass(eq=False, repr=False)
class CronWindow(betterproto.Message):
    cron_expression: str = betterproto.string_field(1)
    """
    in UTC, describes when and at what cadence this window starts, in the quartz flavor of cron
    
     examples:
        This schedule is begins at 7:00:00am UTC everyday between Monday and Friday
            0 0 7 ? * MON-FRI *
        This schedule begins every 5 minutes starting at 12:00:00pm UTC until 8:00:00pm UTC everyday
            0 0/5 12-20 * * ? *
        This schedule begins at 12:00:00pm UTC on March 2nd 2023
            0 0 12 2 3 ? 2023
    """

    duration_millis: int = betterproto.uint64_field(2)
    """describes the duration"""


@dataclass(eq=False, repr=False)
class Supplies(betterproto.Message):
    """
    Represents the state of supplies associated with an entity (available but not in condition to use immediately)
    """

    fuel: List["Fuel"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class Fuel(betterproto.Message):
    """
    Fuel describes an entity's repository of fuels stores including current amount, operational requirements, and maximum authorized capacity
    """

    fuel_id: str = betterproto.string_field(1)
    """unique fuel identifier"""

    name: str = betterproto.string_field(2)
    """long form name of the fuel source."""

    reported_date: datetime = betterproto.message_field(3)
    """timestamp the information was reported"""

    amount_gallons: int = betterproto.uint32_field(4)
    """amount of gallons on hand"""

    max_authorized_capacity_gallons: int = betterproto.uint32_field(5)
    """how much the asset is allowed to have available (in gallons)"""

    operational_requirement_gallons: int = betterproto.uint32_field(6)
    """minimum required for operations (in gallons)"""

    data_classification: "Classification" = betterproto.message_field(7)
    """
    fuel in a single asset may have different levels of classification
     use case: fuel for a SECRET asset while diesel fuel may be UNCLASSIFIED
    """

    data_source: str = betterproto.string_field(8)
    """source of information"""


@dataclass(eq=False, repr=False)
class TargetPriority(betterproto.Message):
    """The target prioritization associated with an entity."""

    high_value_target: "HighValueTarget" = betterproto.message_field(1)
    """
    Describes the target priority in relation to high value target lists.
    """

    threat: "Threat" = betterproto.message_field(2)
    """Describes whether the entity should be treated as a threat"""


@dataclass(eq=False, repr=False)
class HighValueTarget(betterproto.Message):
    """Describes whether something is a high value target or not."""

    is_high_value_target: bool = betterproto.bool_field(1)
    """
    Indicates whether the target matches any description from a high value target list.
    """

    target_priority: int = betterproto.uint32_field(2)
    """
    The priority associated with the target. If the target's description appears on multiple high value target lists,
     the priority will be a reflection of the highest priority of all of those list's target description.
    
     A lower value indicates the target is of a higher priority, with 1 being the highest possible priority. A value of
     0 indicates there is no priority associated with this target.
    """

    target_matches: List["HighValueTargetMatch"] = betterproto.message_field(3)
    """
    All of the high value target descriptions that the target matches against.
    """

    is_high_payoff_target: bool = betterproto.bool_field(4)
    """
    Indicates whether the target is a 'High Payoff Target'. Targets can be one or both of high value and high payoff.
    """


@dataclass(eq=False, repr=False)
class HighValueTargetMatch(betterproto.Message):
    high_value_target_list_id: str = betterproto.string_field(1)
    """
    The ID of the high value target list that matches the target description.
    """

    high_value_target_description_id: str = betterproto.string_field(2)
    """
    The ID of the specific high value target description within a high value target list that was matched against.
     The ID is considered to be a globally unique identifier across all high value target IDs.
    """


@dataclass(eq=False, repr=False)
class Threat(betterproto.Message):
    """Describes whether an entity is a threat or not."""

    is_threat: bool = betterproto.bool_field(1)
    """Indicates that the entity has been determined to be a threat."""


@dataclass(eq=False, repr=False)
class TransponderCodes(betterproto.Message):
    """
    A message describing any transponder codes associated with Mode 1, 2, 3, 4, 5, S interrogations.
    """

    mode1: int = betterproto.uint32_field(1)
    """The mode 1 code assigned to military assets."""

    mode2: int = betterproto.uint32_field(2)
    """The Mode 2 code assigned to military assets."""

    mode3: int = betterproto.uint32_field(3)
    """The Mode 3 code assigned by ATC to the asset."""

    mode4_interrogation_response: "InterrogationResponse" = betterproto.enum_field(4)
    """The validity of the response from the Mode 4 interrogation."""

    mode5: "Mode5" = betterproto.message_field(5)
    """The Mode 5 transponder codes."""

    mode_s: "ModeS" = betterproto.message_field(6)
    """The Mode S transponder codes."""


@dataclass(eq=False, repr=False)
class Mode5(betterproto.Message):
    """Describes the Mode 5 transponder interrogation status and codes."""

    mode5_interrogation_response: "InterrogationResponse" = betterproto.enum_field(1)
    """The validity of the response from the Mode 5 interrogation."""

    mode5: int = betterproto.uint32_field(2)
    """The Mode 5 code assigned to military assets."""

    mode5_platform_id: int = betterproto.uint32_field(3)
    """The Mode 5 platform identification code."""


@dataclass(eq=False, repr=False)
class ModeS(betterproto.Message):
    """Describes the Mode S codes."""

    id: str = betterproto.string_field(1)
    """Mode S identifier which comprises of 8 alphanumeric characters."""

    address: int = betterproto.uint32_field(2)
    """
    The Mode S ICAO aircraft address. Expected values are between 1 and 16777214 decimal. The Mode S address is
     considered unique.
    """


@dataclass(eq=False, repr=False)
class Entity(betterproto.Message):
    """
    The entity object represents a single known object within the Lattice operational environment. It contains
     all data associated with the entity, such as its name, ID, and other relevant components.
    """

    entity_id: str = betterproto.string_field(1)
    """
    A Globally Unique Identifier (GUID) for your entity. If this field is empty, the Entity Manager API
     automatically generates an ID when it creates the entity.
    """

    description: str = betterproto.string_field(2)
    """
    A human-readable entity description that's helpful for debugging purposes and human
     traceability. If this field is empty, the Entity Manager API generates one for you.
    """

    is_live: bool = betterproto.bool_field(3)
    """
    Indicates the entity is active and should have a lifecycle state of CREATE or UPDATE.
     Set this field to true when publishing an entity.
    """

    created_time: datetime = betterproto.message_field(4)
    """
    The time when the entity was first known to the entity producer. If this field is empty, the Entity Manager API uses the
     current timestamp of when the entity is first received.
     For example, when a drone is first powered on, it might report its startup time as the created time.
     The timestamp doesn't change for the lifetime of an entity.
    """

    expiry_time: datetime = betterproto.message_field(5)
    """
    Future time that expires an entity and updates the is_live flag.
     For entities that are constantly updating, the expiry time also updates.
     In some cases, this may differ from is_live.
     Example: Entities with tasks exported to an external system must remain
     active even after they expire.
     This field is required when publishing a prepopulated entity.
     The expiry time must be in the future, but less than 30 days from the current time.
    """

    status: "Status" = betterproto.message_field(19)
    """Human-readable descriptions of what the entity is currently doing."""

    location: "Location" = betterproto.message_field(6)
    """
    Geospatial data related to the entity, including its position, kinematics, and orientation.
    """

    location_uncertainty: "LocationUncertainty" = betterproto.message_field(15)
    """Indicates uncertainty of the entity's position and kinematics."""

    geo_shape: "GeoShape" = betterproto.message_field(23)
    """
    Geospatial representation of the entity, including entities that cover an area rather than a fixed point.
    """

    geo_details: "GeoDetails" = betterproto.message_field(24)
    """
    Additional details on what the geospatial area or point represents, along with visual display details.
    """

    aliases: "Aliases" = betterproto.message_field(7)
    """
    Entity name displayed in the Lattice UI side panel. Also includes identifiers that other systems can use to reference the same entity.
    """

    tracked: "Tracked" = betterproto.message_field(8)
    """
    If this entity is tracked by another entity, this component contains data related to how it's being tracked.
    """

    correlation: "Correlation" = betterproto.message_field(47)
    """
    If this entity has been correlated or decorrelated to another one, this component contains information on the correlation or decorrelation.
    """

    mil_view: "MilView" = betterproto.message_field(10)
    """View of the entity."""

    ontology: "Ontology" = betterproto.message_field(11)
    """
    Ontology defines an entity's categorization in Lattice, and improves data retrieval and integration. Builds a standardized representation of the entity.
    """

    sensors: "Sensors" = betterproto.message_field(20)
    """Details an entity's available sensors."""

    payloads: "Payloads" = betterproto.message_field(21)
    """Details an entity's available payloads."""

    power_state: "PowerState" = betterproto.message_field(30)
    """Details the entity's power source."""

    provenance: "Provenance" = betterproto.message_field(12)
    """The primary data source provenance for this entity."""

    overrides: "Overrides" = betterproto.message_field(13)
    """Provenance of override data."""

    indicators: "Indicators" = betterproto.message_field(14)
    """
    Describes an entity's specific characteristics and the operations that can be performed on the entity.
     For example, "simulated" informs the operator that the entity is from a simulation, and "deletable"
     informs the operator (and system) that the delete operation is valid against the entity.
    """

    target_priority: "TargetPriority" = betterproto.message_field(22)
    """
    The prioritization associated with an entity, such as if it's a threat or a high-value target.
    """

    signal: "Signal" = betterproto.message_field(25)
    """
    Describes an entity's signal characteristics, primarily used when an entity is a signal of interest.
    """

    transponder_codes: "TransponderCodes" = betterproto.message_field(26)
    """
    A message describing any transponder codes associated with Mode 1, 2, 3, 4, 5, S interrogations. These are related to ADS-B modes.
    """

    data_classification: "Classification" = betterproto.message_field(29)
    """
    Describes an entity's security classification levels at an overall classification level and on a per
     field level.
    """

    task_catalog: "__tasks_v2__.TaskCatalog" = betterproto.message_field(31)
    """A catalog of tasks that can be performed by an entity."""

    relationships: "Relationships" = betterproto.message_field(33)
    """
    The relationships between this entity and other entities in the common operational picture (COP).
    """

    visual_details: "VisualDetails" = betterproto.message_field(34)
    """
    Visual details associated with the display of an entity in the client.
    """

    dimensions: "Dimensions" = betterproto.message_field(36)
    """Physical dimensions of the entity."""

    route_details: "RouteDetails" = betterproto.message_field(37)
    """Additional information about an entity's route."""

    schedules: "Schedules" = betterproto.message_field(38)
    """Schedules associated with this entity."""

    health: "Health" = betterproto.message_field(39)
    """Health metrics or connection status reported by the entity."""

    group_details: "GroupDetails" = betterproto.message_field(40)
    """Details for the group associated with this entity."""

    supplies: "Supplies" = betterproto.message_field(42)
    """Contains relevant supply information for the entity, such as fuel."""

    orbit: "Orbit" = betterproto.message_field(46)
    """Orbit information for space objects."""


@dataclass(eq=False, repr=False)
class Status(betterproto.Message):
    """Contains status of entities."""

    platform_activity: str = betterproto.string_field(1)
    """
    A string that describes the activity that the entity is performing.
     Examples include "RECONNAISSANCE", "INTERDICTION", "RETURN TO BASE (RTB)", "PREPARING FOR LAUNCH".
    """

    role: str = betterproto.string_field(2)
    """
    A human-readable string that describes the role the entity is currently performing. E.g. "Team Member", "Commander".
    """


@dataclass(eq=False, repr=False)
class Aliases(betterproto.Message):
    """Available for any Entities with alternate ids in other systems."""

    alternate_ids: List["AlternateId"] = betterproto.message_field(1)
    name: str = betterproto.string_field(2)
    """The best available version of the entity's display name."""


@dataclass(eq=False, repr=False)
class Tracked(betterproto.Message):
    """Available for Entities that are tracked."""

    track_quality_wrapper: Optional[int] = betterproto.message_field(
        2, wraps=betterproto.TYPE_INT32
    )
    """Quality score, 0-15, nil if none"""

    sensor_hits: Optional[int] = betterproto.message_field(
        3, wraps=betterproto.TYPE_INT32
    )
    """Sensor hits aggregation on the tracked entity."""

    number_of_objects: "UInt32Range" = betterproto.message_field(4)
    """
    Estimated number of objects or units that are represented by this entity. Known as Strength in certain contexts (Link16)
     if UpperBound == LowerBound; (strength = LowerBound)
     If both UpperBound and LowerBound are defined; strength is between LowerBound and UpperBound (represented as string "Strength: 4-5")
     If UpperBound is defined only (LowerBound unset), Strength ≤ UpperBound
     If LowerBound is defined only (UpperBound unset), LowerBound ≤ Strength
     0 indicates unset.
    """

    radar_cross_section: Optional[float] = betterproto.message_field(
        6, wraps=betterproto.TYPE_DOUBLE
    )
    """
    The radar cross section (RCS) is a measure of how detectable an object is by radar. A large RCS indicates an object is more easily
     detected. The unit is “decibels per square meter,” or dBsm
    """

    last_measurement_time: datetime = betterproto.message_field(7)
    """Timestamp of the latest tracking measurement for this entity."""

    line_of_bearing: "LineOfBearing" = betterproto.message_field(9)
    """
    The relative position of a track with respect to the entity that is tracking it. Used for tracks that do not yet have a 3D position.
     For this entity (A), being tracked by some entity (B), this LineOfBearing would express a ray from B to A.
    """


@dataclass(eq=False, repr=False)
class Provenance(betterproto.Message):
    """Data provenance."""

    integration_name: str = betterproto.string_field(5)
    """Name of the integration that produced this entity"""

    data_type: str = betterproto.string_field(6)
    """Source data type of this entity. Examples: ADSB, Link16, etc."""

    source_id: str = betterproto.string_field(3)
    """An ID that allows an element from a source to be uniquely identified"""

    source_update_time: datetime = betterproto.message_field(2)
    """
    The time, according to the source system, that the data in the entity was last modified. Generally, this should
     be the time that the source-reported time of validity of the data in the entity. This field must be
     updated with every change to the entity or else Entity Manager will discard the update.
    """

    source_description: str = betterproto.string_field(4)
    """
    Description of the modification source. In the case of a user this is the email address.
    """


@dataclass(eq=False, repr=False)
class Indicators(betterproto.Message):
    """Indicators to describe entity to consumers."""

    simulated: Optional[bool] = betterproto.message_field(
        1, wraps=betterproto.TYPE_BOOL
    )
    exercise: Optional[bool] = betterproto.message_field(2, wraps=betterproto.TYPE_BOOL)
    emergency: Optional[bool] = betterproto.message_field(
        3, wraps=betterproto.TYPE_BOOL
    )
    c2: Optional[bool] = betterproto.message_field(4, wraps=betterproto.TYPE_BOOL)
    egressable: Optional[bool] = betterproto.message_field(
        6, wraps=betterproto.TYPE_BOOL
    )
    """
    Indicates the Entity should be egressed to external sources.
     Integrations choose how the egressing happens (e.g. if an Entity needs fuzzing).
    """

    starred: Optional[bool] = betterproto.message_field(7, wraps=betterproto.TYPE_BOOL)
    """
    A signal of arbitrary importance such that the entity should be globally marked for all users
    """


@dataclass(eq=False, repr=False)
class Overrides(betterproto.Message):
    """Metadata about entity overrides present."""

    override: List["Override"] = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class Override(betterproto.Message):
    """Details about an override. Last write wins."""

    request_id: str = betterproto.string_field(1)
    """override request id for an override request"""

    field_path: str = betterproto.string_field(2)
    """
    proto field path which is the string representation of a field.
     example: correlated.primary_entity_id would be primary_entity_id in correlated component
    """

    masked_field_value: "Entity" = betterproto.message_field(3)
    """
    new field value corresponding to field path. In the shape of an empty entity with only the changed value.
     example: entity: { mil_view: { disposition: Disposition_DISPOSITION_HOSTILE } }
    """

    status: "OverrideStatus" = betterproto.enum_field(4)
    """status of the override"""

    provenance: "Provenance" = betterproto.message_field(5)
    type: "OverrideType" = betterproto.enum_field(6)
    """
    The type of the override, defined by the stage of the entity lifecycle that the entity was in when the override
     was requested.
    """

    request_timestamp: datetime = betterproto.message_field(7)
    """
    Timestamp of the override request. The timestamp is generated by the Entity Manager instance that receives the request.
    """


@dataclass(eq=False, repr=False)
class AlternateId(betterproto.Message):
    """An alternate id for an Entity."""

    id: str = betterproto.string_field(2)
    type: "AltIdType" = betterproto.enum_field(3)


@dataclass(eq=False, repr=False)
class VisualDetails(betterproto.Message):
    """
    Visual details associated with the display of an entity in the client.
    """

    range_rings: "RangeRings" = betterproto.message_field(1)
    """The range rings to display around an entity."""


@dataclass(eq=False, repr=False)
class RangeRings(betterproto.Message):
    """
    Range rings allow visual assessment of map distance at varying zoom levels.
    """

    min_distance_m: Optional[float] = betterproto.message_field(
        1, wraps=betterproto.TYPE_DOUBLE
    )
    """The minimum range ring distance, specified in meters."""

    max_distance_m: Optional[float] = betterproto.message_field(
        2, wraps=betterproto.TYPE_DOUBLE
    )
    """The maximum range ring distance, specified in meters."""

    ring_count: int = betterproto.uint32_field(3)
    """The count of range rings."""

    ring_line_color: "__type__.Color" = betterproto.message_field(4)
    """The color of range rings, specified in hex string."""


@dataclass(eq=False, repr=False)
class Correlation(betterproto.Message):
    """
    Available for Entities that are a correlated (N to 1) set of entities. This will be present on
     each entity in the set.
    """

    primary: "PrimaryCorrelation" = betterproto.message_field(1, group="correlation")
    """
    This entity is the primary of a correlation meaning that it serves as the representative
     entity of the correlation set.
    """

    secondary: "SecondaryCorrelation" = betterproto.message_field(
        2, group="correlation"
    )
    """
    This entity is a secondary of a correlation meaning that it will be represented by the
     primary of the correlation set.
    """

    membership: "CorrelationMembership" = betterproto.message_field(4)
    """If present, this entity is a part of a correlation set."""

    decorrelation: "Decorrelation" = betterproto.message_field(3)
    """
    If present, this entity was explicitly decorrelated from one or more entities.
     An entity can be both correlated and decorrelated as long as they are disjoint sets.
     An example would be if a user in the UI decides that two tracks are not actually the
     same despite an automatic correlator having correlated them. The user would then
     decorrelate the two tracks and this decorrelation would be preserved preventing the
     correlator from re-correlating them at a later time.
    """


@dataclass(eq=False, repr=False)
class PrimaryCorrelation(betterproto.Message):
    secondary_entity_ids: List[str] = betterproto.string_field(1)
    """The secondary entity IDs part of this correlation."""


@dataclass(eq=False, repr=False)
class SecondaryCorrelation(betterproto.Message):
    primary_entity_id: str = betterproto.string_field(1)
    """The primary of this correlation."""

    metadata: "CorrelationMetadata" = betterproto.message_field(2)
    """Metadata about the correlation."""


@dataclass(eq=False, repr=False)
class CorrelationMembership(betterproto.Message):
    correlation_set_id: str = betterproto.string_field(1)
    """The ID of the correlation set this entity belongs to."""

    primary: "PrimaryMembership" = betterproto.message_field(2, group="membership")
    """
    This entity is the primary of a correlation set meaning that it serves as the representative
     entity of the correlation set.
    """

    non_primary: "NonPrimaryMembership" = betterproto.message_field(
        3, group="membership"
    )
    """
    This entity is not the primary of the correlation set. Note that there may not
     be a primary at all.
    """

    metadata: "CorrelationMetadata" = betterproto.message_field(4)
    """Additional metadata on this correlation."""


@dataclass(eq=False, repr=False)
class PrimaryMembership(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class NonPrimaryMembership(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class Decorrelation(betterproto.Message):
    all: "DecorrelatedAll" = betterproto.message_field(1)
    """
    This will be specified if this entity was decorrelated against all other entities.
    """

    decorrelated_entities: List["DecorrelatedSingle"] = betterproto.message_field(2)
    """
    A list of decorrelated entities that have been explicitly decorrelated against this entity
     which prevents lower precedence correlations from overriding it in the future.
     For example, if an operator in the UI decorrelated tracks A and B, any automated
     correlators would be unable to correlate them since manual decorrelations have
     higher precedence than automatic ones. Precedence is determined by both correlation
     type and replication mode.
    """


@dataclass(eq=False, repr=False)
class DecorrelatedAll(betterproto.Message):
    metadata: "CorrelationMetadata" = betterproto.message_field(1)
    """Metadata about the decorrelation."""


@dataclass(eq=False, repr=False)
class DecorrelatedSingle(betterproto.Message):
    entity_id: str = betterproto.string_field(1)
    """The entity that was decorrelated against."""

    metadata: "CorrelationMetadata" = betterproto.message_field(2)
    """Metadata about the decorrelation."""


@dataclass(eq=False, repr=False)
class CorrelationMetadata(betterproto.Message):
    provenance: "Provenance" = betterproto.message_field(1)
    """Who or what added this entity to the (de)correlation."""

    replication_mode: "CorrelationReplicationMode" = betterproto.enum_field(2)
    """
    Indicates how the correlation will be distributed. Because a correlation is composed of
     multiple secondaries, each of which may have been correlated with different replication
     modes, the distribution of the correlation is composed of distributions of the individual
     entities within the correlation set.
     For example, if there are two secondary entities A and B correlated against a primary C,
     with A having been correlated globally and B having been correlated locally, then the
     correlation set that is distributed globally than what is known locally in the node.
    """

    type: "CorrelationType" = betterproto.enum_field(3)
    """What type of (de)correlation was this entity added with."""


@dataclass(eq=False, repr=False)
class Statement(betterproto.Message):
    """
    A Statement is the building block of the entity filter. The outermost statement is conceptually
     the root node of an "expression tree" which allows for the construction of complete boolean
     logic statements. Statements are formed by grouping sets of children statement(s) or predicate(s)
     according to the boolean operation which is to be applied.

     For example, the criteria "take an action if an entity is hostile and an air vehicle" can be
     represented as: Statement1: { AndOperation: { Predicate1, Predicate2 } }. Where Statement1
     is the root of the expression tree, with an AND operation that is applied to children
     predicates. The predicates themselves encode "entity is hostile" and "entity is air vehicle."
    """

    and_: "AndOperation" = betterproto.message_field(1, group="operation")
    or_: "OrOperation" = betterproto.message_field(2, group="operation")
    not_: "NotOperation" = betterproto.message_field(3, group="operation")
    list: "ListOperation" = betterproto.message_field(4, group="operation")
    predicate: "Predicate" = betterproto.message_field(5, group="operation")


@dataclass(eq=False, repr=False)
class AndOperation(betterproto.Message):
    """
    The AndOperation represents the boolean AND operation, which is to be applied to the list of
     children statement(s) or predicate(s).
    """

    predicate_set: "PredicateSet" = betterproto.message_field(1, group="children")
    statement_set: "StatementSet" = betterproto.message_field(2, group="children")


@dataclass(eq=False, repr=False)
class OrOperation(betterproto.Message):
    """
    The OrOperation represents the boolean OR operation, which is to be applied to the list of
     children statement(s) or predicate(s).
    """

    predicate_set: "PredicateSet" = betterproto.message_field(1, group="children")
    statement_set: "StatementSet" = betterproto.message_field(2, group="children")


@dataclass(eq=False, repr=False)
class NotOperation(betterproto.Message):
    """
    The NotOperation represents the boolean NOT operation, which can only be applied to a single
     child predicate or statement.
    """

    predicate: "Predicate" = betterproto.message_field(1, group="child")
    statement: "Statement" = betterproto.message_field(2, group="child")


@dataclass(eq=False, repr=False)
class ListOperation(betterproto.Message):
    """
    The ListOperation represents an operation against a proto list. If the list is of primitive proto
     type (e.g. int32), paths in all child predicates should be left empty. If the list is of message
     proto type (e.g. Sensor), paths in all child predicates should be relative to the list path.

     For example, the criteria "take an action if an entity has any sensor with sensor_id='sensor' and
     OperationalState=STATE_OFF" would be modeled as:
     Predicate1: { path: "sensor_id", comparator: EQUAL_TO, value: "sensor" }
     Predicate2: { path: "operational_state", comparator: EQUAL_TO, value: STATE_OFF }

     Statement2: { AndOperation: PredicateSet: { <Predicate1>, <Predicate2> } }
     ListOperation: { list_path: "sensors.sensors", list_comparator: ANY, statement: <Statement2> }
     Statement1: { ListOperation: <ListOperation> }

     Note that in the above, the child predicates of the list operation have paths relative to the
     list_path because the list is comprised of message not primitive types.
    """

    list_path: str = betterproto.string_field(1)
    """
    The list_path specifies the repeated field on an entity to which this operation applies.
    """

    list_comparator: "ListComparator" = betterproto.enum_field(2)
    """
    The list_comparator specifies how to compose the boolean results from the child statement
     for each member of the specified list.
    """

    statement: "Statement" = betterproto.message_field(3)
    """
    The statement is a new expression tree conceptually rooted at type of the list. It determines
     how each member of the list is evaluated.
    """


@dataclass(eq=False, repr=False)
class PredicateSet(betterproto.Message):
    """
    The PredicateSet represents a list of predicates or "leaf nodes" in the expression tree, which
     can be directly evaluated to a boolean TRUE/FALSE result.
    """

    predicates: List["Predicate"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class StatementSet(betterproto.Message):
    """
    The StatementSet represents a list of statements or "tree nodes," each of which follow the same
     behavior as the Statement proto message.
    """

    statements: List["Statement"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class Predicate(betterproto.Message):
    """
    The Predicate fully encodes the information required to make an evaluation of an entity field
     against a given static value, resulting in a boolean TRUE/FALSE result. The structure of a
     predicate will always follow: "{entity-value} {comparator} {fixed-value}" where the entity value
     is determined by the field path.

     For example, a predicate would read as: "{entity.location.velocity_enu} {LESS_THAN} {500kph}"
    """

    field_path: str = betterproto.string_field(1)
    """
    The field_path determines which field on an entity is being referenced in this predicate. For
     example: correlated.primary_entity_id would be primary_entity_id in correlated component.
    """

    value: "Value" = betterproto.message_field(2)
    """
    The value determines the fixed value against which the entity field is to be compared.
     In the case of COMPARATOR_MATCH_ALL, the value contents do not matter as long as the Value is a supported
     type.
    """

    comparator: "Comparator" = betterproto.enum_field(3)
    """
    The comparator determines the manner in which the entity field and static value are compared.
     Comparators may only be applied to certain values. For example, the WITHIN comparator cannot
     be used for a boolean value comparison.
    """


@dataclass(eq=False, repr=False)
class Value(betterproto.Message):
    """
    The Value represents the information against which an entity field is evaluated. It is one of
     a fixed set of types, each of which correspond to specific comparators. See "ComparatorType"
     for the full list of Value <-> Comparator mappings.
    """

    boolean_type: "BooleanType" = betterproto.message_field(1, group="type")
    numeric_type: "NumericType" = betterproto.message_field(2, group="type")
    string_type: "StringType" = betterproto.message_field(3, group="type")
    enum_type: "EnumType" = betterproto.message_field(4, group="type")
    timestamp_type: "TimestampType" = betterproto.message_field(5, group="type")
    bounded_shape_type: "BoundedShapeType" = betterproto.message_field(6, group="type")
    position_type: "PositionType" = betterproto.message_field(7, group="type")
    heading_type: "HeadingType" = betterproto.message_field(8, group="type")
    list_type: "ListType" = betterproto.message_field(9, group="type")
    range_type: "RangeType" = betterproto.message_field(10, group="type")


@dataclass(eq=False, repr=False)
class BooleanType(betterproto.Message):
    """The BooleanType represents a static boolean value."""

    value: bool = betterproto.bool_field(1)


@dataclass(eq=False, repr=False)
class NumericType(betterproto.Message):
    """
    The NumericType represents static numeric values. It supports all numeric primitives supported
     by the proto3 language specification.
    """

    double_value: float = betterproto.double_field(1, group="value")
    float_value: float = betterproto.float_field(2, group="value")
    int32_value: int = betterproto.int32_field(3, group="value")
    int64_value: int = betterproto.int64_field(4, group="value")
    uint32_value: int = betterproto.uint32_field(5, group="value")
    uint64_value: int = betterproto.uint64_field(6, group="value")


@dataclass(eq=False, repr=False)
class StringType(betterproto.Message):
    """The StringType represents static string values."""

    value: str = betterproto.string_field(1)


@dataclass(eq=False, repr=False)
class EnumType(betterproto.Message):
    """
    The EnumType represents members of well-known anduril ontologies, such as "disposition." When
     such a value is specified, the evaluation library expects the integer representation of the enum
     value. For example, a disposition derived from ontology.v1 such as "DISPOSITION_HOSTILE" should be
     represented with the integer value 2.
    """

    value: int = betterproto.int32_field(1)


@dataclass(eq=False, repr=False)
class ListType(betterproto.Message):
    """A List of Values for use with the IN comparator."""

    values: List["Value"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class TimestampType(betterproto.Message):
    """The TimestampType represents a static timestamp value."""

    value: datetime = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class PositionType(betterproto.Message):
    """The PositionType represents any fixed LLA point in space."""

    value: "Position" = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class BoundedShapeType(betterproto.Message):
    """The BoundedShapeType represents any static fully-enclosed shape."""

    polygon_value: "GeoPolygon" = betterproto.message_field(1, group="value")


@dataclass(eq=False, repr=False)
class HeadingType(betterproto.Message):
    """
    The HeadingType represents the heading in degrees for an entity's
     attitudeEnu quaternion to be compared against. Defaults between a range of 0 to 360
    """

    value: int = betterproto.int32_field(1)


@dataclass(eq=False, repr=False)
class RangeType(betterproto.Message):
    """
    The RangeType represents a numeric range.
     Whether endpoints are included are based on the comparator used.
     Both endpoints must be of the same numeric type.
    """

    start: "NumericType" = betterproto.message_field(1)
    end: "NumericType" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class RateLimit(betterproto.Message):
    """rate-limiting / down-sampling parameters."""

    update_per_entity_limit_ms: int = betterproto.uint32_field(1)
    """
    Specifies a minimum duration in milliseconds after an update for a given entity before another one
     will be sent for the same entity.
     A value of 0 is treated as unset. If set, value must be >= 500.
     Example: if set to 1000, and 4 events occur (ms since start) at T0, T500, T900, T2100, then
     event from T0 will be sent at T0, T500 will be dropped, T900 will be sent at minimum of T1000,
     and T2100 will be sent on time (2100)
     This will only limit updates, other events will be sent immediately, with a delete clearing anything held
    """


@dataclass(eq=False, repr=False)
class PublishEntityRequest(betterproto.Message):
    entity: "Entity" = betterproto.message_field(1)
    """
    Create or update an entity.
     Required fields:
       * entity_id: Unique string identifier. Can be a Globally Unique Identifier (GUID).
       * expiry_time: Expiration time that must be greater than the current time and less than 30 days in the future. The Entities API will reject any entity update with an expiry_time in the past. When the expiry_time has passed, the Entities API will delete the entity from the COP and send a DELETE event.
       * is_live: Boolean that when true, creates or updates the entity. If false and the entity is still live, triggers a DELETE event.
       * provenance.integration_name: String that uniquely identifies the integration responsible for publishing the entity.
       * provenance.data_type.
       * provenance.source_update_time. This can be earlier than the RPC call if the data entered is older.
       * aliases.name: Human-readable string that represents the name of an entity.
       * ontology.template
     For additional required fields that are determined by template, see com.anduril.entitymanager.v1.Template.
     if an entity_id is provided, Entity Manager updates the entity. If no entity_id is provided, it creates an entity.
    """


@dataclass(eq=False, repr=False)
class PublishEntityResponse(betterproto.Message):
    pass


@dataclass(eq=False, repr=False)
class PublishEntitiesRequest(betterproto.Message):
    entity: "Entity" = betterproto.message_field(1)
    """
    Sends a stream of entity objects to create or update.
     Each entity requires the following fields:
       * entity_id: Unique string identifier. Can be a Globally Unique Identifier (GUID).
       * expiry_time: Expiration time that must be greater than the current time and less than 30 days in the future. The Entities API will reject any entity update with an expiry_time in the past. When the expiry_time has passed, the Entities API will delete the entity from the COP and send a DELETE event.
       * is_live: Boolean that when true, creates or updates the entity. If false and the entity is still live, triggers a DELETE event.
       * provenance.integration_name: String that uniquely identifies the integration responsible for publishing the entity.
       * provenance.data_type.
       * provenance.source_update_time. This can be earlier than the RPC call if the data entered is older.
       * aliases.name: Human-readable string that represents the name of an entity.
       * ontology.template
     For additional required fields that are determined by template, see com.anduril.entitymanager.v1.Template.
     If an entity_id is provided, the entity updates. If no entity_id is provided, the entity is created.
    """


@dataclass(eq=False, repr=False)
class PublishEntitiesResponse(betterproto.Message):
    """
    After the stream closes, the server returns an empty message indicating success. The server will silently
     drop invalid entities from the client stream. The client must reopen the stream if it's canceled due to
     an End of File (EOF) or timeout.
    """

    pass


@dataclass(eq=False, repr=False)
class GetEntityRequest(betterproto.Message):
    entity_id: str = betterproto.string_field(1)
    """The GUID of this entity to query."""


@dataclass(eq=False, repr=False)
class GetEntityResponse(betterproto.Message):
    entity: "Entity" = betterproto.message_field(1)
    """An Entity object that corresponds with the requested entityId."""


@dataclass(eq=False, repr=False)
class OverrideEntityRequest(betterproto.Message):
    entity: "Entity" = betterproto.message_field(1)
    """
    The entity containing the overridden fields. The service will extract the overridable fields from the entity
     object and ignore any other fields.
    """

    field_path: List[str] = betterproto.string_field(2)
    """
    The field paths that will be extracted from the Entity and saved as an override. Only fields marked overridable can
     be overridden.
    """

    provenance: "Provenance" = betterproto.message_field(3)
    """Additional information about the source of the override."""


@dataclass(eq=False, repr=False)
class OverrideEntityResponse(betterproto.Message):
    status: "OverrideStatus" = betterproto.enum_field(1)
    """The status of the override request."""


@dataclass(eq=False, repr=False)
class RemoveEntityOverrideRequest(betterproto.Message):
    entity_id: str = betterproto.string_field(1)
    """The entity ID that the override will be removed from."""

    field_path: List[str] = betterproto.string_field(2)
    """
    The field paths to remove from the override store for the provided entityId.
    """


@dataclass(eq=False, repr=False)
class RemoveEntityOverrideResponse(betterproto.Message):
    """void response but with placeholder for future optional fields."""

    pass


@dataclass(eq=False, repr=False)
class StreamEntityComponentsRequest(betterproto.Message):
    components_to_include: List[str] = betterproto.string_field(1)
    """
    lower_snake_case component names to include in response events, e.g. location. Only included components will
     populate.
    """

    include_all_components: bool = betterproto.bool_field(2)
    """
    Subscribe to all components. This should only be used in cases where you want all components.
     Setting both components_to_include and include_all_components is invalid and will be rejected.
    """

    filter: "Statement" = betterproto.message_field(3)
    """
    The root node of a statement filter "tree".
     If provided, only entities matching the filter criteria will be streamed. The filter is applied dynamically so if a
     new entity matches, it will be included, and if an entity updates to no longer match, it will be excluded.
    """

    rate_limit: "RateLimit" = betterproto.message_field(4)
    """
    Optional rate-limiting / down-sampling parameters, see RateLimit message for details.
    """

    heartbeat_period_millis: int = betterproto.uint32_field(5)
    """
    The period (in milliseconds) at which a Heartbeat message will be sent on the
     message stream. If this field is set to 0 then no Heartbeat messages are sent.
    """

    preexisting_only: bool = betterproto.bool_field(6)
    """
    Subscribe to a finite stream of preexisting events which closes when there are no additional pre-existing events to
     process. Respects the filter specified on the StreamEntityComponentsRequest.
    """


@dataclass(eq=False, repr=False)
class StreamEntityComponentsResponse(betterproto.Message):
    """
    response stream will be fed all matching pre-existing live entities as CREATED, plus any new events ongoing.
    """

    entity_event: "EntityEvent" = betterproto.message_field(1)
    heartbeat: "Heartbeat" = betterproto.message_field(2)


@dataclass(eq=False, repr=False)
class EntityEvent(betterproto.Message):
    """Event representing some type of entity change."""

    event_type: "EventType" = betterproto.enum_field(1)
    time: datetime = betterproto.message_field(2)
    entity: "Entity" = betterproto.message_field(3)


@dataclass(eq=False, repr=False)
class Heartbeat(betterproto.Message):
    """
    A message that is periodically sent on the stream for keep-alive behaviour.
    """

    timestamp: datetime = betterproto.message_field(1)
    """The timestamp at which the heartbeat message was sent."""


@dataclass(eq=False, repr=False)
class DynamicStatement(betterproto.Message):
    """
    A DynamicStatement is the building block of a "runtime aware" entity filter - that is, any filter
     which needs to perform operations against a series of entities that will need to be evaluated against
     on demand. The DynamicStatement allows you to perform a set intersection operation across a static
     set of entities dictated by a filter, and a dynamic set of entities dictated by a selector statement.

     For example, the expression "find me all hostile entities that reside within any assumed
     friendly geoentity" would be represented as the following dynamic statement:

      DynamicStatement
        filter
          predicate
            field_path: mil_view.disposition
            comparator: EQUALITY
            value: 2 // Hostile
        selector
          andOperation
            predicate1
              field_path: mil_view.disposition
              comparator: EQUALITY
              value: 4 // Assumed Friendly
            predicate2
              field_path: ontology.template
              comparator: EQUALITY
              value: 4 // Template Geo
        comparator
          IntersectionComparator
            WithinComparison
    """

    filter: "Statement" = betterproto.message_field(1)
    """
    The filter statement is used to determine which entities can be compared to the dynamic series
     of entities aggregated by the selector statement.
    """

    selector: "Statement" = betterproto.message_field(2)
    """
    The selector statement is used to determine which entities should be a part of dynamically
     changing set. The selector should be reevaluated as entites are created or deleted.
    """

    comparator: "IntersectionComparator" = betterproto.message_field(3)
    """
    The comparator specifies how the set intersection operation will be performed.
    """


@dataclass(eq=False, repr=False)
class IntersectionComparator(betterproto.Message):
    """
    The IntersectionComparator determines what entities and what fields to respect within a set during
     a set intersection operation.
    """

    within_comparison: "WithinComparison" = betterproto.message_field(
        1, group="comparison"
    )


@dataclass(eq=False, repr=False)
class WithinComparison(betterproto.Message):
    """
    The WithinComparison implicitly will understand how to determine which entitites reside
     within other geo-shaped entities. This comparison is being left empty, but as a proto, to
     support future expansions of the within comparison (eg; within range of a static distance).
    """

    pass


@dataclass(eq=False, repr=False)
class Media(betterproto.Message):
    """Media associated with an entity."""

    media: List["MediaItem"] = betterproto.message_field(1)


@dataclass(eq=False, repr=False)
class MediaItem(betterproto.Message):
    url: str = betterproto.string_field(1)
    """
    To Be Deprecated, use relative_path.
     The url where the media related to an entity can be accessed
    """

    type: "MediaType" = betterproto.enum_field(2)
    relative_path: str = betterproto.string_field(3)
    """
    The relative path where the media related to an entity can be accessed when used to query against a blobs service
     node.
    """


@dataclass(eq=False, repr=False)
class OverrideNotificationPayload(betterproto.Message):
    """A notification to indicate when a field is overridden on an entity."""

    entity: "Entity" = betterproto.message_field(1)
    """
    The entity containing the values to override and the entityID being overriden.
     Used by the client to determine the value a field is overridden to (e.g. hostile).
    """

    field_path: str = betterproto.string_field(2)
    """
    The field path determining the path on an entity to override. Used by the client
     to determine whether an override request was for a particular field (e.g. disposition).
    """

    provenance: "Provenance" = betterproto.message_field(3)
    """
    The provenance of the override request. This should always match the OverrideEntityRequest
     provenance field.
    """


class EntityManagerApiStub(betterproto.ServiceStub):
    async def publish_entity(
        self,
        publish_entity_request: "PublishEntityRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "PublishEntityResponse":
        return await self._unary_unary(
            "/anduril.entitymanager.v1.EntityManagerAPI/PublishEntity",
            publish_entity_request,
            PublishEntityResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def publish_entities(
        self,
        publish_entities_request_iterator: Union[
            AsyncIterable[PublishEntitiesRequest], Iterable[PublishEntitiesRequest]
        ],
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "PublishEntitiesResponse":
        return await self._stream_unary(
            "/anduril.entitymanager.v1.EntityManagerAPI/PublishEntities",
            publish_entities_request_iterator,
            PublishEntitiesRequest,
            PublishEntitiesResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def get_entity(
        self,
        get_entity_request: "GetEntityRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "GetEntityResponse":
        return await self._unary_unary(
            "/anduril.entitymanager.v1.EntityManagerAPI/GetEntity",
            get_entity_request,
            GetEntityResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def override_entity(
        self,
        override_entity_request: "OverrideEntityRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "OverrideEntityResponse":
        return await self._unary_unary(
            "/anduril.entitymanager.v1.EntityManagerAPI/OverrideEntity",
            override_entity_request,
            OverrideEntityResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def remove_entity_override(
        self,
        remove_entity_override_request: "RemoveEntityOverrideRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> "RemoveEntityOverrideResponse":
        return await self._unary_unary(
            "/anduril.entitymanager.v1.EntityManagerAPI/RemoveEntityOverride",
            remove_entity_override_request,
            RemoveEntityOverrideResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        )

    async def stream_entity_components(
        self,
        stream_entity_components_request: "StreamEntityComponentsRequest",
        *,
        timeout: Optional[float] = None,
        deadline: Optional["Deadline"] = None,
        metadata: Optional["MetadataLike"] = None
    ) -> AsyncIterator[StreamEntityComponentsResponse]:
        async for response in self._unary_stream(
            "/anduril.entitymanager.v1.EntityManagerAPI/StreamEntityComponents",
            stream_entity_components_request,
            StreamEntityComponentsResponse,
            timeout=timeout,
            deadline=deadline,
            metadata=metadata,
        ):
            yield response


class EntityManagerApiBase(ServiceBase):

    async def publish_entity(
        self, publish_entity_request: "PublishEntityRequest"
    ) -> "PublishEntityResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def publish_entities(
        self, publish_entities_request_iterator: AsyncIterator[PublishEntitiesRequest]
    ) -> "PublishEntitiesResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def get_entity(
        self, get_entity_request: "GetEntityRequest"
    ) -> "GetEntityResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def override_entity(
        self, override_entity_request: "OverrideEntityRequest"
    ) -> "OverrideEntityResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def remove_entity_override(
        self, remove_entity_override_request: "RemoveEntityOverrideRequest"
    ) -> "RemoveEntityOverrideResponse":
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)

    async def stream_entity_components(
        self, stream_entity_components_request: "StreamEntityComponentsRequest"
    ) -> AsyncIterator[StreamEntityComponentsResponse]:
        raise grpclib.GRPCError(grpclib.const.Status.UNIMPLEMENTED)
        yield StreamEntityComponentsResponse()

    async def __rpc_publish_entity(
        self,
        stream: "grpclib.server.Stream[PublishEntityRequest, PublishEntityResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.publish_entity(request)
        await stream.send_message(response)

    async def __rpc_publish_entities(
        self,
        stream: "grpclib.server.Stream[PublishEntitiesRequest, PublishEntitiesResponse]",
    ) -> None:
        request = stream.__aiter__()
        response = await self.publish_entities(request)
        await stream.send_message(response)

    async def __rpc_get_entity(
        self, stream: "grpclib.server.Stream[GetEntityRequest, GetEntityResponse]"
    ) -> None:
        request = await stream.recv_message()
        response = await self.get_entity(request)
        await stream.send_message(response)

    async def __rpc_override_entity(
        self,
        stream: "grpclib.server.Stream[OverrideEntityRequest, OverrideEntityResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.override_entity(request)
        await stream.send_message(response)

    async def __rpc_remove_entity_override(
        self,
        stream: "grpclib.server.Stream[RemoveEntityOverrideRequest, RemoveEntityOverrideResponse]",
    ) -> None:
        request = await stream.recv_message()
        response = await self.remove_entity_override(request)
        await stream.send_message(response)

    async def __rpc_stream_entity_components(
        self,
        stream: "grpclib.server.Stream[StreamEntityComponentsRequest, StreamEntityComponentsResponse]",
    ) -> None:
        request = await stream.recv_message()
        await self._call_rpc_handler_server_stream(
            self.stream_entity_components,
            stream,
            request,
        )

    def __mapping__(self) -> Dict[str, grpclib.const.Handler]:
        return {
            "/anduril.entitymanager.v1.EntityManagerAPI/PublishEntity": grpclib.const.Handler(
                self.__rpc_publish_entity,
                grpclib.const.Cardinality.UNARY_UNARY,
                PublishEntityRequest,
                PublishEntityResponse,
            ),
            "/anduril.entitymanager.v1.EntityManagerAPI/PublishEntities": grpclib.const.Handler(
                self.__rpc_publish_entities,
                grpclib.const.Cardinality.STREAM_UNARY,
                PublishEntitiesRequest,
                PublishEntitiesResponse,
            ),
            "/anduril.entitymanager.v1.EntityManagerAPI/GetEntity": grpclib.const.Handler(
                self.__rpc_get_entity,
                grpclib.const.Cardinality.UNARY_UNARY,
                GetEntityRequest,
                GetEntityResponse,
            ),
            "/anduril.entitymanager.v1.EntityManagerAPI/OverrideEntity": grpclib.const.Handler(
                self.__rpc_override_entity,
                grpclib.const.Cardinality.UNARY_UNARY,
                OverrideEntityRequest,
                OverrideEntityResponse,
            ),
            "/anduril.entitymanager.v1.EntityManagerAPI/RemoveEntityOverride": grpclib.const.Handler(
                self.__rpc_remove_entity_override,
                grpclib.const.Cardinality.UNARY_UNARY,
                RemoveEntityOverrideRequest,
                RemoveEntityOverrideResponse,
            ),
            "/anduril.entitymanager.v1.EntityManagerAPI/StreamEntityComponents": grpclib.const.Handler(
                self.__rpc_stream_entity_components,
                grpclib.const.Cardinality.UNARY_STREAM,
                StreamEntityComponentsRequest,
                StreamEntityComponentsResponse,
            ),
        }
