# Chkware

![Chkware | Test management for api era](https://raw.githubusercontent.com/chkware/cli/main/docs/github-readme-01.png)

[![PyPI version](https://badge.fury.io/py/chk.svg)](https://badge.fury.io/py/chk)
[![Python 3.8](https://img.shields.io/badge/python-3.10-red.svg)](https://www.python.org/downloads/release/python-3102/)
[![Twitter](https://img.shields.io/twitter/url/https/twitter.com/chkware.svg?style=social&label=Follow%20%40chkware)](https://twitter.com/chkware)
> Test management for API era.

### Introduction

API tests management is not easy to develop, and maintain. It requires multitude of knowledge of programming libraries, business scenarios, infrastructure details, etc - unless you use ***chkware***.

***chkware*** (pronounced as */check:ware/*) helps you write accurate, robust, and expressive feature tests for your API in less time.
 
Read [more value propositions](https://chkware.github.io/introduction) here. Find [changelog](docs/CHANGELOG.md) here.

### Setup

With [**Python 3.10**](https://www.python.org/downloads/) and [**Pipx**](https://pypa.github.io/pipx/installation/#install-pipx) preinstalled, run following in your terminal to get ***chkware*** installed.

```bash
$ pipx install chk
```

Jump to the [setup guide](https://chkware.github.io/setup) for different ways to install ***chkware***.

### Usage

[Get started](https://chkware.github.io/quick-start) quickly here.

### Ask anything

Please use tag `chkware-cli` with the question on [stackoverflow.com](https://stackoverflow.com/questions/tagged/chkware-cli) to ask or discuss anything. Follow the tag if you want to help others with your knowledge.

### Contribute

Read [contribution guide](docs/CONTRIBUTING.md) and [code of conduct](docs/CODE_OF_CONDUCT.md) to start contributions.

---
Licensed under [MPL v2.0](/LICENSE) | Follow [@chkware](https://twitter.com/chkware) on Twitter | [`chk` project](https://pypi.org/project/chk/) on PyPi
