ALLCools: ALL methyl-Cytosine tools
============================

ALLCools is a software package for single-cell DNA methylome data analysis. It contains functions for cellular and genomic analysis.

## Documentation Organization

1. For installation, please read **GET STARTED** [here](start/installation.md);
2. The ALLCools workflow encompasses the following two sections:
   1. **CELLULAR ANALYSIS**: This [section](cell_level/basic/intro_basic_clustering.md) goes over basic clustering steps, differential methylated genes (DMG) analysis, data integration, and doublets identification;
   2. **GENOMIC ANALYSIS**: This [section](cluster_level/intro.md) covers differential methylated region (DMR) calling, genome annotation, DNA motif analysis, correlation analysis, and enhancer prediction;
3. To generate analysis files from your own data, please read the **COMMAND LINE TOOLS** [here](command_line/allcools.ipynb);
4. For references to function used in this package, please read the **API** [here](https://lhqing.github.io/ALLCools/api/ALLCools/index.html).

```{figure} ./img/doc_organize.png
---
height: 180px
name: doc-organize-fig
---
ALLCools documentation organization.
```

## Authors

- Hanqing Liu, developer, initial conception
- Jingtian Zhou, developer, 5kb clustering algorithms
- Wei Tian
- Jiaying Xu

## Support

```{figure} ./img/open_issue.png
---
height: 150px
name: open-issue-fig
figclass: margin
---
Click on this to create a page specific issue.
```

- The source code is on [github](https://github.com/lhqing/ALLCools);
- For releases and changelog, please check out the [github releases page](https://github.com/lhqing/ALLCools/releases);
- For bugs and feature requests, please use the [issue tracker](https://github.com/lhqing/ALLCools/issues).
- For page-specific issues, please use the "open issue" button on the top-right toggle.

## Citing ALLCools

If ALLCools has been significant in your research, and you would like to acknowledge the project in your academic publication, we suggest citing our paper {cite:p}`Liu2021`. For any specific methods and algorithms, also consider citing the original author's paper included in the Citation and Reference page [here](project_info/citation.md). 
