"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.EvaluateExpression = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const iam = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const sfn = require("@aws-cdk/aws-stepfunctions");
/**
 * A Step Functions Task to evaluate an expression.
 *
 * OUTPUT: the output of this task is the evaluated expression.
 *
 * @stability stable
 */
class EvaluateExpression extends sfn.TaskStateBase {
    /**
     * @stability stable
     */
    constructor(scope, id, props) {
        var _b;
        super(scope, id, props);
        this.props = props;
        this.evalFn = createEvalFn((_b = this.props.runtime) !== null && _b !== void 0 ? _b : lambda.Runtime.NODEJS_14_X, this);
        this.taskPolicies = [
            new iam.PolicyStatement({
                resources: [this.evalFn.functionArn],
                actions: ['lambda:InvokeFunction'],
            }),
        ];
    }
    /**
     * @internal
     */
    _renderTask() {
        const matches = this.props.expression.match(/\$[.\[][.a-zA-Z[\]0-9-_]+/g);
        let expressionAttributeValues = {};
        if (matches) {
            expressionAttributeValues = matches.reduce((acc, m) => ({
                ...acc,
                [m]: sfn.JsonPath.stringAt(m),
            }), {});
        }
        const parameters = {
            expression: this.props.expression,
            expressionAttributeValues,
        };
        return {
            Resource: this.evalFn.functionArn,
            Parameters: sfn.FieldUtils.renderObject(parameters),
        };
    }
}
exports.EvaluateExpression = EvaluateExpression;
_a = JSII_RTTI_SYMBOL_1;
EvaluateExpression[_a] = { fqn: "@aws-cdk/aws-stepfunctions-tasks.EvaluateExpression", version: "1.108.1" };
function createEvalFn(runtime, scope) {
    const lambdaPurpose = 'Eval';
    const nodeJsGuids = {
        [lambda.Runtime.NODEJS_14_X.name]: 'da2d1181-604e-4a45-8694-1a6abd7fe42d',
        [lambda.Runtime.NODEJS_12_X.name]: '2b81e383-aad2-44db-8aaf-b4809ae0e3b4',
        [lambda.Runtime.NODEJS_10_X.name]: 'a0d2ce44-871b-4e74-87a1-f5e63d7c3bdc',
    };
    switch (runtime) {
        case lambda.Runtime.NODEJS_14_X:
        case lambda.Runtime.NODEJS_12_X:
        case lambda.Runtime.NODEJS_10_X:
            const uuid = nodeJsGuids[runtime.name];
            if (uuid) {
                return new lambda.SingletonFunction(scope, 'EvalFunction', {
                    runtime,
                    uuid,
                    handler: 'index.handler',
                    lambdaPurpose,
                    code: lambda.Code.fromAsset(path.join(__dirname, 'eval-nodejs-handler')),
                });
            }
            break;
    }
    throw new Error(`The runtime ${runtime.name} is currently not supported.`);
}
//# sourceMappingURL=data:application/json;base64,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