# coding: utf-8

"""
    Groupe PSA Connected Car - WEB API B2C

    *PSA B2C Connected Car API*  # Introduction This is the description of the *Groupe PSA Connected Car V2 API*. The speccification is  is based on **OpenAPI Specification version 3** and can be displayed via [ReDoc](https://github.com/Rebilly/ReDoc)a or [Swagger](http://swagger.io).   This API allows applications to fetch data from the connected Vehicles data platform. # Authentication PSA Connected Car APIs uses the [OAuth 2.0](https://tools.ietf.org/html/rfc6749) protocol for authentication and Authorization. any application require a valid [Access Token](https://tools.ietf.org/html/rfc6749#section-1.4) to access to user data. # Errors   Error codes returned by all REST APIs comply with the standard. Nevertheless, PSA Services (callers) need to have more complete data structures (even when the answer is not Http-OK) to better detail the type of error by providing application code, message and a debugging code(for investigation purposes). The http code of the response is managed by the protocol itself (in the header).      **Errors are  returned as a generic error response:**    * ```xError``` object model.       # noqa: E501

    OpenAPI spec version: 4.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class Trip(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'created_at': 'datetime',
        'links': 'TripLinks',
        'avg_consumption': 'list[TripAvgConsumption]',
        'distance': 'float',
        'done': 'bool',
        'duration': 'str',
        'faults': 'list[str]',
        'id': 'str',
        'odometer': 'float',
        'start_position': 'Position',
        'started_at': 'datetime',
        'stop_position': 'Position',
        'stopped_at': 'datetime',
        'zero_emission_ratio': 'float'
    }

    attribute_map = {
        'created_at': 'createdAt',
        'links': '_links',
        'avg_consumption': 'avgConsumption',
        'distance': 'distance',
        'done': 'done',
        'duration': 'duration',
        'faults': 'faults',
        'id': 'id',
        'odometer': 'odometer',
        'start_position': 'startPosition',
        'started_at': 'startedAt',
        'stop_position': 'stopPosition',
        'stopped_at': 'stoppedAt',
        'zero_emission_ratio': 'zeroEmissionRatio'
    }

    def __init__(self, created_at=None, links=None, avg_consumption=None, distance=None, done=None, duration=None, faults=None, id=None, odometer=None, start_position=None, started_at=None, stop_position=None, stopped_at=None, zero_emission_ratio=None):  # noqa: E501
        """Trip - a model defined in Swagger"""  # noqa: E501

        self._created_at = None
        self._links = None
        self._avg_consumption = None
        self._distance = None
        self._done = None
        self._duration = None
        self._faults = None
        self._id = None
        self._odometer = None
        self._start_position = None
        self._started_at = None
        self._stop_position = None
        self._stopped_at = None
        self._zero_emission_ratio = None
        self.discriminator = None

        if created_at is not None:
            self.created_at = created_at
        if links is not None:
            self.links = links
        if avg_consumption is not None:
            self.avg_consumption = avg_consumption
        if distance is not None:
            self.distance = distance
        if done is not None:
            self.done = done
        if duration is not None:
            self.duration = duration
        if faults is not None:
            self.faults = faults
        if id is not None:
            self.id = id
        if odometer is not None:
            self.odometer = odometer
        if start_position is not None:
            self.start_position = start_position
        if started_at is not None:
            self.started_at = started_at
        if stop_position is not None:
            self.stop_position = stop_position
        if stopped_at is not None:
            self.stopped_at = stopped_at
        if zero_emission_ratio is not None:
            self.zero_emission_ratio = zero_emission_ratio

    @property
    def created_at(self):
        """Gets the created_at of this Trip.  # noqa: E501

        Date when the resource has been created.  # noqa: E501

        :return: The created_at of this Trip.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this Trip.

        Date when the resource has been created.  # noqa: E501

        :param created_at: The created_at of this Trip.  # noqa: E501
        :type: datetime
        """

        self._created_at = created_at

    @property
    def links(self):
        """Gets the links of this Trip.  # noqa: E501


        :return: The links of this Trip.  # noqa: E501
        :rtype: TripLinks
        """
        return self._links

    @links.setter
    def links(self, links):
        """Sets the links of this Trip.


        :param links: The links of this Trip.  # noqa: E501
        :type: TripLinks
        """

        self._links = links

    @property
    def avg_consumption(self):
        """Gets the avg_consumption of this Trip.  # noqa: E501


        :return: The avg_consumption of this Trip.  # noqa: E501
        :rtype: list[TripAvgConsumption]
        """
        return self._avg_consumption

    @avg_consumption.setter
    def avg_consumption(self, avg_consumption):
        """Sets the avg_consumption of this Trip.


        :param avg_consumption: The avg_consumption of this Trip.  # noqa: E501
        :type: list[TripAvgConsumption]
        """

        self._avg_consumption = avg_consumption

    @property
    def distance(self):
        """Gets the distance of this Trip.  # noqa: E501

        Distance in Km of the trip  # noqa: E501

        :return: The distance of this Trip.  # noqa: E501
        :rtype: float
        """
        return self._distance

    @distance.setter
    def distance(self, distance):
        """Sets the distance of this Trip.

        Distance in Km of the trip  # noqa: E501

        :param distance: The distance of this Trip.  # noqa: E501
        :type: float
        """

        self._distance = distance

    @property
    def done(self):
        """Gets the done of this Trip.  # noqa: E501

        Determines whether this trip is finished or not.  # noqa: E501

        :return: The done of this Trip.  # noqa: E501
        :rtype: bool
        """
        return self._done

    @done.setter
    def done(self, done):
        """Sets the done of this Trip.

        Determines whether this trip is finished or not.  # noqa: E501

        :param done: The done of this Trip.  # noqa: E501
        :type: bool
        """

        self._done = done

    @property
    def duration(self):
        """Gets the duration of this Trip.  # noqa: E501

        Duration of the trip  # noqa: E501

        :return: The duration of this Trip.  # noqa: E501
        :rtype: str
        """
        return self._duration

    @duration.setter
    def duration(self, duration):
        """Sets the duration of this Trip.

        Duration of the trip  # noqa: E501

        :param duration: The duration of this Trip.  # noqa: E501
        :type: str
        """

        self._duration = duration

    @property
    def faults(self):
        """Gets the faults of this Trip.  # noqa: E501

        The faults of this finished or in progress trip. This means that we lacked data from the vehicle to complete the trip description during one of its step (starting, progressing, or finishing).  # noqa: E501

        :return: The faults of this Trip.  # noqa: E501
        :rtype: list[str]
        """
        return self._faults

    @faults.setter
    def faults(self, faults):
        """Sets the faults of this Trip.

        The faults of this finished or in progress trip. This means that we lacked data from the vehicle to complete the trip description during one of its step (starting, progressing, or finishing).  # noqa: E501

        :param faults: The faults of this Trip.  # noqa: E501
        :type: list[str]
        """
        allowed_values = ["Unstarted", "DataLacking", "Unfinished"]  # noqa: E501
        if not set(faults).issubset(set(allowed_values)):
            raise ValueError(
                "Invalid values for `faults` [{0}], must be a subset of [{1}]"  # noqa: E501
                .format(", ".join(map(str, set(faults) - set(allowed_values))),  # noqa: E501
                        ", ".join(map(str, allowed_values)))
            )

        self._faults = faults

    @property
    def id(self):
        """Gets the id of this Trip.  # noqa: E501

        Identifier of a trip  # noqa: E501

        :return: The id of this Trip.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Trip.

        Identifier of a trip  # noqa: E501

        :param id: The id of this Trip.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def odometer(self):
        """Gets the odometer of this Trip.  # noqa: E501

        The mileage of the vehicle at the end of a trip  # noqa: E501

        :return: The odometer of this Trip.  # noqa: E501
        :rtype: float
        """
        return self._odometer

    @odometer.setter
    def odometer(self, odometer):
        """Sets the odometer of this Trip.

        The mileage of the vehicle at the end of a trip  # noqa: E501

        :param odometer: The odometer of this Trip.  # noqa: E501
        :type: float
        """

        self._odometer = odometer

    @property
    def start_position(self):
        """Gets the start_position of this Trip.  # noqa: E501


        :return: The start_position of this Trip.  # noqa: E501
        :rtype: Position
        """
        return self._start_position

    @start_position.setter
    def start_position(self, start_position):
        """Sets the start_position of this Trip.


        :param start_position: The start_position of this Trip.  # noqa: E501
        :type: Position
        """

        self._start_position = start_position

    @property
    def started_at(self):
        """Gets the started_at of this Trip.  # noqa: E501

        Date & Time when the trip started  # noqa: E501

        :return: The started_at of this Trip.  # noqa: E501
        :rtype: datetime
        """
        return self._started_at

    @started_at.setter
    def started_at(self, started_at):
        """Sets the started_at of this Trip.

        Date & Time when the trip started  # noqa: E501

        :param started_at: The started_at of this Trip.  # noqa: E501
        :type: datetime
        """

        self._started_at = started_at

    @property
    def stop_position(self):
        """Gets the stop_position of this Trip.  # noqa: E501


        :return: The stop_position of this Trip.  # noqa: E501
        :rtype: Position
        """
        return self._stop_position

    @stop_position.setter
    def stop_position(self, stop_position):
        """Sets the stop_position of this Trip.


        :param stop_position: The stop_position of this Trip.  # noqa: E501
        :type: Position
        """

        self._stop_position = stop_position

    @property
    def stopped_at(self):
        """Gets the stopped_at of this Trip.  # noqa: E501

        Date & Time when the trip stopped  # noqa: E501

        :return: The stopped_at of this Trip.  # noqa: E501
        :rtype: datetime
        """
        return self._stopped_at

    @stopped_at.setter
    def stopped_at(self, stopped_at):
        """Sets the stopped_at of this Trip.

        Date & Time when the trip stopped  # noqa: E501

        :param stopped_at: The stopped_at of this Trip.  # noqa: E501
        :type: datetime
        """

        self._stopped_at = stopped_at

    @property
    def zero_emission_ratio(self):
        """Gets the zero_emission_ratio of this Trip.  # noqa: E501

        Part of trip distance with zero gaz emission of the trip expressed in percent (0-100%).  # noqa: E501

        :return: The zero_emission_ratio of this Trip.  # noqa: E501
        :rtype: float
        """
        return self._zero_emission_ratio

    @zero_emission_ratio.setter
    def zero_emission_ratio(self, zero_emission_ratio):
        """Sets the zero_emission_ratio of this Trip.

        Part of trip distance with zero gaz emission of the trip expressed in percent (0-100%).  # noqa: E501

        :param zero_emission_ratio: The zero_emission_ratio of this Trip.  # noqa: E501
        :type: float
        """

        self._zero_emission_ratio = zero_emission_ratio

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Trip, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Trip):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
