# coding: utf-8

"""
    Groupe PSA Connected Car - WEB API B2C

    *PSA B2C Connected Car API*  # Introduction This is the description of the *Groupe PSA Connected Car V2 API*. The speccification is  is based on **OpenAPI Specification version 3** and can be displayed via [ReDoc](https://github.com/Rebilly/ReDoc)a or [Swagger](http://swagger.io).   This API allows applications to fetch data from the connected Vehicles data platform. # Authentication PSA Connected Car APIs uses the [OAuth 2.0](https://tools.ietf.org/html/rfc6749) protocol for authentication and Authorization. any application require a valid [Access Token](https://tools.ietf.org/html/rfc6749#section-1.4) to access to user data. # Errors   Error codes returned by all REST APIs comply with the standard. Nevertheless, PSA Services (callers) need to have more complete data structures (even when the answer is not Http-OK) to better detail the type of error by providing application code, message and a debugging code(for investigation purposes). The http code of the response is managed by the protocol itself (in the header).      **Errors are  returned as a generic error response:**    * ```xError``` object model.       # noqa: E501

    OpenAPI spec version: 4.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class Program(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'occurence': 'ProgramOccurence',
        'recurrence': 'str',
        'start': 'str'
    }

    attribute_map = {
        'occurence': 'occurence',
        'recurrence': 'recurrence',
        'start': 'start'
    }

    def __init__(self, occurence=None, recurrence='Daily', start=None):  # noqa: E501
        """Program - a model defined in Swagger"""  # noqa: E501

        self._occurence = None
        self._recurrence = None
        self._start = None
        self.discriminator = None

        self.occurence = occurence
        self.recurrence = recurrence
        self.start = start

    @property
    def occurence(self):
        """Gets the occurence of this Program.  # noqa: E501


        :return: The occurence of this Program.  # noqa: E501
        :rtype: ProgramOccurence
        """
        return self._occurence

    @occurence.setter
    def occurence(self, occurence):
        """Sets the occurence of this Program.


        :param occurence: The occurence of this Program.  # noqa: E501
        :type: ProgramOccurence
        """
        if occurence is None:
            raise ValueError("Invalid value for `occurence`, must not be `None`")  # noqa: E501

        self._occurence = occurence

    @property
    def recurrence(self):
        """Gets the recurrence of this Program.  # noqa: E501

         Determines the recurrence of the program.  * None: means no recurrence.  * Daily: repeated over the week.  * Weekly: repeated over the weeks of the year from w1 to w52 specified in an array unitary or grouped by ranges (w1, w2,w34-w46, w52).   # noqa: E501

        :return: The recurrence of this Program.  # noqa: E501
        :rtype: str
        """
        return self._recurrence

    @recurrence.setter
    def recurrence(self, recurrence):
        """Sets the recurrence of this Program.

         Determines the recurrence of the program.  * None: means no recurrence.  * Daily: repeated over the week.  * Weekly: repeated over the weeks of the year from w1 to w52 specified in an array unitary or grouped by ranges (w1, w2,w34-w46, w52).   # noqa: E501

        :param recurrence: The recurrence of this Program.  # noqa: E501
        :type: str
        """
        if recurrence is None:
            raise ValueError("Invalid value for `recurrence`, must not be `None`")  # noqa: E501
        allowed_values = ["None", "Daily", "Weekly"]  # noqa: E501
        if recurrence not in allowed_values:
            raise ValueError(
                "Invalid value for `recurrence` ({0}), must be one of {1}"  # noqa: E501
                .format(recurrence, allowed_values)
            )

        self._recurrence = recurrence

    @property
    def start(self):
        """Gets the start of this Program.  # noqa: E501

        The program start time formatted using the duration format based on [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601#Time_intervals) with the schema: P[n]Y[n]M[n]DT[n]H[n]M[n]S  _example_:   * PT14H30M :  14H30min   # noqa: E501

        :return: The start of this Program.  # noqa: E501
        :rtype: str
        """
        return self._start

    @start.setter
    def start(self, start):
        """Sets the start of this Program.

        The program start time formatted using the duration format based on [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601#Time_intervals) with the schema: P[n]Y[n]M[n]DT[n]H[n]M[n]S  _example_:   * PT14H30M :  14H30min   # noqa: E501

        :param start: The start of this Program.  # noqa: E501
        :type: str
        """
        if start is None:
            raise ValueError("Invalid value for `start`, must not be `None`")  # noqa: E501

        self._start = start

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Program, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Program):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
