# coding: utf-8

"""
    Groupe PSA Connected Car - WEB API B2C

    *PSA B2C Connected Car API*  # Introduction This is the description of the *Groupe PSA Connected Car V2 API*. The speccification is  is based on **OpenAPI Specification version 3** and can be displayed via [ReDoc](https://github.com/Rebilly/ReDoc)a or [Swagger](http://swagger.io).   This API allows applications to fetch data from the connected Vehicles data platform. # Authentication PSA Connected Car APIs uses the [OAuth 2.0](https://tools.ietf.org/html/rfc6749) protocol for authentication and Authorization. any application require a valid [Access Token](https://tools.ietf.org/html/rfc6749#section-1.4) to access to user data. # Errors   Error codes returned by all REST APIs comply with the standard. Nevertheless, PSA Services (callers) need to have more complete data structures (even when the answer is not Http-OK) to better detail the type of error by providing application code, message and a debugging code(for investigation purposes). The http code of the response is managed by the protocol itself (in the header).      **Errors are  returned as a generic error response:**    * ```xError``` object model.       # noqa: E501

    OpenAPI spec version: 4.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from psa_car_controller.psa.connected_car_api.api_client import ApiClient


class VehiclesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_monitordd(self, id, mid, **kwargs):  # noqa: E501
        """Delete a Monitor. OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Stop (disable) an existing Monitor.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_monitordd(id, mid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param str mid: id of the alert. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_monitordd_with_http_info(id, mid, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_monitordd_with_http_info(id, mid, **kwargs)  # noqa: E501
            return data

    def delete_monitordd_with_http_info(self, id, mid, **kwargs):  # noqa: E501
        """Delete a Monitor. OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Stop (disable) an existing Monitor.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_monitordd_with_http_info(id, mid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param str mid: id of the alert. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'mid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_monitordd" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_monitordd`")  # noqa: E501
        # verify the required parameter 'mid' is set
        if ('mid' not in params or
                params['mid'] is None):
            raise ValueError("Missing the required parameter `mid` when calling `delete_monitordd`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'mid' in params:
            path_params['mid'] = params['mid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = ['Vehicle_auth', 'client_id', 'realm']  # noqa: E501

        return self.api_client.call_api(
            '/user/vehicles/{id}/monitors/{mid}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_car_last_position(self, id, **kwargs):  # noqa: E501
        """Last position identified  # noqa: E501

        Returns the latest GPS Position of the Vehicle.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_car_last_position(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :return: Position
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_car_last_position_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_car_last_position_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_car_last_position_with_http_info(self, id, **kwargs):  # noqa: E501
        """Last position identified  # noqa: E501

        Returns the latest GPS Position of the Vehicle.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_car_last_position_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :return: Position
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_car_last_position" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_car_last_position`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/vnd.geo+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Vehicle_auth', 'client_id', 'realm']  # noqa: E501

        return self.api_client.call_api(
            '/user/vehicles/{id}/lastPosition', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Position',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_telemetry(self, id, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Returns the latest Telemetry messages that occurred during a selective timestamp-ranges and bounded by an index range.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_telemetry(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param list[str] type: Results will only contain Telemetry messages of this kind. You can add more than one message type.
        :param str index_range: Results indexes will be included in this range (see **indexRange** model).      default: 0-    example: 0-, 0-5
        :param int page_size: The maximum number of results (for a collection results response) to return per page. When not set, at most 60 results will be returned.  
        :param str page_token: Start-Page marker, the token for continuing a previous list request on the next page. It is built and used **only** by the server.
        :param str locale: Locale is used for rendering text, correctly displaying regional monetary values, time and date formats. Respect REGEX \\w(-\\w)?
        :param list[str] extension: Additional data set that will be included in embedded field    * _Disclaimer_:  **Enabling ```maintenance``` extension will automatically disable ```Kinetic``` telemetry message**
        :return: Telemetry
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_telemetry_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_telemetry_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_telemetry_with_http_info(self, id, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Returns the latest Telemetry messages that occurred during a selective timestamp-ranges and bounded by an index range.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_telemetry_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param list[str] type: Results will only contain Telemetry messages of this kind. You can add more than one message type.
        :param str index_range: Results indexes will be included in this range (see **indexRange** model).      default: 0-    example: 0-, 0-5
        :param int page_size: The maximum number of results (for a collection results response) to return per page. When not set, at most 60 results will be returned.  
        :param str page_token: Start-Page marker, the token for continuing a previous list request on the next page. It is built and used **only** by the server.
        :param str locale: Locale is used for rendering text, correctly displaying regional monetary values, time and date formats. Respect REGEX \\w(-\\w)?
        :param list[str] extension: Additional data set that will be included in embedded field    * _Disclaimer_:  **Enabling ```maintenance``` extension will automatically disable ```Kinetic``` telemetry message**
        :return: Telemetry
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'type', 'index_range', 'page_size', 'page_token', 'locale', 'extension']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_telemetry" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_telemetry`")  # noqa: E501

        if 'index_range' in params and not re.search(r'\\d+-\\d*', params['index_range']):  # noqa: E501
            raise ValueError("Invalid value for parameter `index_range` when calling `get_telemetry`, must conform to the pattern `/\\d+-\\d*/`")  # noqa: E501
        if 'page_size' in params and params['page_size'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_telemetry`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'type' in params:
            query_params.append(('type', params['type']))  # noqa: E501
            collection_formats['type'] = 'multi'  # noqa: E501
        if 'index_range' in params:
            query_params.append(('indexRange', params['index_range']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'locale' in params:
            query_params.append(('locale', params['locale']))  # noqa: E501
        if 'extension' in params:
            query_params.append(('extension', params['extension']))  # noqa: E501
            collection_formats['extension'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/hal+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Vehicle_auth', 'client_id', 'realm']  # noqa: E501

        return self.api_client.call_api(
            '/user/vehicles/{id}/telemetry', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Telemetry',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_vehicle_alerts(self, id, **kwargs):  # noqa: E501
        """get_vehicle_alerts  # noqa: E501

        Returns the latest alert messages for a Vehicle.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_vehicle_alerts(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param list[TimeRange] timestamps: Array of **\"timestamp\"** ranges. Results will contain results whose timestamps are included in those date-time ranges (see **timestamp** data  model).**\"timestamp\"** items should be expressed as in '[RFC3339](https://www.ietf.org/rfc/rfc3339.txt)'.
        :param str index_range: Results indexes will be included in this range (see **indexRange** model).      default: 0-    example: 0-, 0-5
        :param int page_size: The maximum number of results (for a collection results response) to return per page. When not set, at most 60 results will be returned.  
        :param str page_token: Start-Page marker, the token for continuing a previous list request on the next page. It is built and used **only** by the server.
        :param str locale: Locale is used for rendering text, correctly displaying regional monetary values, time and date formats. Respect REGEX \\w(-\\w)?
        :param str locale2: Locale is used for rendering text, correctly displaying regional monetary values, time and date formats.
        :return: Alerts
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_vehicle_alerts_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_vehicle_alerts_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_vehicle_alerts_with_http_info(self, id, **kwargs):  # noqa: E501
        """get_vehicle_alerts  # noqa: E501

        Returns the latest alert messages for a Vehicle.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_vehicle_alerts_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param list[TimeRange] timestamps: Array of **\"timestamp\"** ranges. Results will contain results whose timestamps are included in those date-time ranges (see **timestamp** data  model).**\"timestamp\"** items should be expressed as in '[RFC3339](https://www.ietf.org/rfc/rfc3339.txt)'.
        :param str index_range: Results indexes will be included in this range (see **indexRange** model).      default: 0-    example: 0-, 0-5
        :param int page_size: The maximum number of results (for a collection results response) to return per page. When not set, at most 60 results will be returned.  
        :param str page_token: Start-Page marker, the token for continuing a previous list request on the next page. It is built and used **only** by the server.
        :param str locale: Locale is used for rendering text, correctly displaying regional monetary values, time and date formats. Respect REGEX \\w(-\\w)?
        :param str locale2: Locale is used for rendering text, correctly displaying regional monetary values, time and date formats.
        :return: Alerts
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'timestamps', 'index_range', 'page_size', 'page_token', 'locale', 'locale2']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vehicle_alerts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_vehicle_alerts`")  # noqa: E501

        if 'index_range' in params and not re.search(r'\\d+-\\d*', params['index_range']):  # noqa: E501
            raise ValueError("Invalid value for parameter `index_range` when calling `get_vehicle_alerts`, must conform to the pattern `/\\d+-\\d*/`")  # noqa: E501
        if 'page_size' in params and params['page_size'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_vehicle_alerts`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'timestamps' in params:
            query_params.append(('timestamps', params['timestamps']))  # noqa: E501
            collection_formats['timestamps'] = 'multi'  # noqa: E501
        if 'index_range' in params:
            query_params.append(('indexRange', params['index_range']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501
        if 'locale' in params:
            query_params.append(('locale', params['locale']))  # noqa: E501
        if 'locale2' in params:
            query_params.append(('locale', params['locale2']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/hal+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Vehicle_auth', 'client_id', 'realm']  # noqa: E501

        return self.api_client.call_api(
            '/user/vehicles/{id}/alerts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Alerts',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_vehicle_alerts_by_id(self, id, aid, **kwargs):  # noqa: E501
        """get_vehicle_alerts_by_id  # noqa: E501

        Returns information about a specific alert messages for a Vehicle.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_vehicle_alerts_by_id(id, aid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param str aid: id of the alert. (required)
        :param str locale: Locale is used for rendering text, correctly displaying regional monetary values, time and date formats. Respect REGEX \\w(-\\w)?
        :return: Alert
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_vehicle_alerts_by_id_with_http_info(id, aid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_vehicle_alerts_by_id_with_http_info(id, aid, **kwargs)  # noqa: E501
            return data

    def get_vehicle_alerts_by_id_with_http_info(self, id, aid, **kwargs):  # noqa: E501
        """get_vehicle_alerts_by_id  # noqa: E501

        Returns information about a specific alert messages for a Vehicle.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_vehicle_alerts_by_id_with_http_info(id, aid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param str aid: id of the alert. (required)
        :param str locale: Locale is used for rendering text, correctly displaying regional monetary values, time and date formats. Respect REGEX \\w(-\\w)?
        :return: Alert
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'aid', 'locale']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vehicle_alerts_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_vehicle_alerts_by_id`")  # noqa: E501
        # verify the required parameter 'aid' is set
        if ('aid' not in params or
                params['aid'] is None):
            raise ValueError("Missing the required parameter `aid` when calling `get_vehicle_alerts_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'aid' in params:
            path_params['aid'] = params['aid']  # noqa: E501

        query_params = []
        if 'locale' in params:
            query_params.append(('locale', params['locale']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/hal+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Vehicle_auth', 'client_id', 'realm']  # noqa: E501

        return self.api_client.call_api(
            '/user/vehicles/{id}/alerts/{aid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Alert',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_vehicle_byid(self, id, **kwargs):  # noqa: E501
        """Details of vehicule  # noqa: E501

        Returns detailed information about a Vehicle.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_vehicle_byid(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :return: Vehicle
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_vehicle_byid_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_vehicle_byid_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_vehicle_byid_with_http_info(self, id, **kwargs):  # noqa: E501
        """Details of vehicule  # noqa: E501

        Returns detailed information about a Vehicle.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_vehicle_byid_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :return: Vehicle
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vehicle_byid" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_vehicle_byid`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/hal+json '])  # noqa: E501

        # Authentication setting
        auth_settings = ['Vehicle_auth', 'client_id', 'realm']  # noqa: E501

        return self.api_client.call_api(
            '/user/vehicles/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Vehicle',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_vehicle_collision(self, id, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Returns the set of Collisions that occurred for a given vehicle (id) during the timestamp ranges and bounded by an index range.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_vehicle_collision(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param list[TimeRange] timestamps: Array of **\"timestamp\"** ranges. Results will contain results whose timestamps are included in those date-time ranges (see **timestamp** data  model).**\"timestamp\"** items should be expressed as in '[RFC3339](https://www.ietf.org/rfc/rfc3339.txt)'.
        :param str index_range: Results indexes will be included in this range (see **indexRange** model).      default: 0-    example: 0-, 0-5
        :param int page_size: The maximum number of results (for a collection results response) to return per page. When not set, at most 60 results will be returned.  
        :param str page_token: Start-Page marker, the token for continuing a previous list request on the next page. It is built and used **only** by the server.
        :return: Collisions
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_vehicle_collision_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_vehicle_collision_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_vehicle_collision_with_http_info(self, id, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Returns the set of Collisions that occurred for a given vehicle (id) during the timestamp ranges and bounded by an index range.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_vehicle_collision_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param list[TimeRange] timestamps: Array of **\"timestamp\"** ranges. Results will contain results whose timestamps are included in those date-time ranges (see **timestamp** data  model).**\"timestamp\"** items should be expressed as in '[RFC3339](https://www.ietf.org/rfc/rfc3339.txt)'.
        :param str index_range: Results indexes will be included in this range (see **indexRange** model).      default: 0-    example: 0-, 0-5
        :param int page_size: The maximum number of results (for a collection results response) to return per page. When not set, at most 60 results will be returned.  
        :param str page_token: Start-Page marker, the token for continuing a previous list request on the next page. It is built and used **only** by the server.
        :return: Collisions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'timestamps', 'index_range', 'page_size', 'page_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vehicle_collision" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_vehicle_collision`")  # noqa: E501

        if 'index_range' in params and not re.search(r'\\d+-\\d*', params['index_range']):  # noqa: E501
            raise ValueError("Invalid value for parameter `index_range` when calling `get_vehicle_collision`, must conform to the pattern `/\\d+-\\d*/`")  # noqa: E501
        if 'page_size' in params and params['page_size'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_vehicle_collision`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'timestamps' in params:
            query_params.append(('timestamps', params['timestamps']))  # noqa: E501
            collection_formats['timestamps'] = 'multi'  # noqa: E501
        if 'index_range' in params:
            query_params.append(('indexRange', params['index_range']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/hal+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Vehicle_auth', 'client_id', 'realm']  # noqa: E501

        return self.api_client.call_api(
            '/user/vehicles/{id}/collisions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Collisions',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_vehicle_collision_by_id(self, id, cid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Returns the Collision that matches the vehicle id and the Collision cid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_vehicle_collision_by_id(id, cid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param str cid: Results will only contain the Collision related to this Collision *id*. (required)
        :return: Collision
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_vehicle_collision_by_id_with_http_info(id, cid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_vehicle_collision_by_id_with_http_info(id, cid, **kwargs)  # noqa: E501
            return data

    def get_vehicle_collision_by_id_with_http_info(self, id, cid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Returns the Collision that matches the vehicle id and the Collision cid.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_vehicle_collision_by_id_with_http_info(id, cid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param str cid: Results will only contain the Collision related to this Collision *id*. (required)
        :return: Collision
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'cid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vehicle_collision_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_vehicle_collision_by_id`")  # noqa: E501
        # verify the required parameter 'cid' is set
        if ('cid' not in params or
                params['cid'] is None):
            raise ValueError("Missing the required parameter `cid` when calling `get_vehicle_collision_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'cid' in params:
            path_params['cid'] = params['cid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/hal+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Vehicle_auth', 'client_id', 'realm']  # noqa: E501

        return self.api_client.call_api(
            '/user/vehicles/{id}/collisions/{cid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Collision',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_vehicle_maintenance(self, id, **kwargs):  # noqa: E501
        """get_vehicle_maintenance  # noqa: E501

        Returns the latest Maintenance information for a Vehicle.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_vehicle_maintenance(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :return: Maintenance
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_vehicle_maintenance_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_vehicle_maintenance_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_vehicle_maintenance_with_http_info(self, id, **kwargs):  # noqa: E501
        """get_vehicle_maintenance  # noqa: E501

        Returns the latest Maintenance information for a Vehicle.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_vehicle_maintenance_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :return: Maintenance
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vehicle_maintenance" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_vehicle_maintenance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/hal+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Vehicle_auth', 'client_id', 'realm']  # noqa: E501

        return self.api_client.call_api(
            '/user/vehicles/{id}/maintenance', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Maintenance',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_vehicle_monitors(self, id, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Returns the list of subscribed Monitors for a Vehicle.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_vehicle_monitors(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param str index_range: Results indexes will be included in this range (see **indexRange** model).      default: 0-    example: 0-, 0-5
        :param int page_size: The maximum number of results (for a collection results response) to return per page. When not set, at most 60 results will be returned.  
        :param str page_token: Start-Page marker, the token for continuing a previous list request on the next page. It is built and used **only** by the server.
        :return: Monitors
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_vehicle_monitors_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_vehicle_monitors_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_vehicle_monitors_with_http_info(self, id, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Returns the list of subscribed Monitors for a Vehicle.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_vehicle_monitors_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param str index_range: Results indexes will be included in this range (see **indexRange** model).      default: 0-    example: 0-, 0-5
        :param int page_size: The maximum number of results (for a collection results response) to return per page. When not set, at most 60 results will be returned.  
        :param str page_token: Start-Page marker, the token for continuing a previous list request on the next page. It is built and used **only** by the server.
        :return: Monitors
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'index_range', 'page_size', 'page_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vehicle_monitors" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_vehicle_monitors`")  # noqa: E501

        if 'index_range' in params and not re.search(r'\\d+-\\d*', params['index_range']):  # noqa: E501
            raise ValueError("Invalid value for parameter `index_range` when calling `get_vehicle_monitors`, must conform to the pattern `/\\d+-\\d*/`")  # noqa: E501
        if 'page_size' in params and params['page_size'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_vehicle_monitors`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'index_range' in params:
            query_params.append(('indexRange', params['index_range']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/hal+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Vehicle_auth', 'client_id', 'realm']  # noqa: E501

        return self.api_client.call_api(
            '/user/vehicles/{id}/monitors', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Monitors',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_vehicle_monitors_by_id(self, id, mid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Returns information about a specific Monitor for a Vehicle.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_vehicle_monitors_by_id(id, mid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param str mid: id of the alert. (required)
        :return: MonitorParameter
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_vehicle_monitors_by_id_with_http_info(id, mid, **kwargs)  # noqa: E501
        else:
            (data) = self.get_vehicle_monitors_by_id_with_http_info(id, mid, **kwargs)  # noqa: E501
            return data

    def get_vehicle_monitors_by_id_with_http_info(self, id, mid, **kwargs):  # noqa: E501
        """OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Returns information about a specific Monitor for a Vehicle.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_vehicle_monitors_by_id_with_http_info(id, mid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param str mid: id of the alert. (required)
        :return: MonitorParameter
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'mid']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vehicle_monitors_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_vehicle_monitors_by_id`")  # noqa: E501
        # verify the required parameter 'mid' is set
        if ('mid' not in params or
                params['mid'] is None):
            raise ValueError("Missing the required parameter `mid` when calling `get_vehicle_monitors_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'mid' in params:
            path_params['mid'] = params['mid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/hal+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Vehicle_auth', 'client_id', 'realm']  # noqa: E501

        return self.api_client.call_api(
            '/user/vehicles/{id}/monitors/{mid}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MonitorParameter',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_vehicle_status(self, id, **kwargs):  # noqa: E501
        """Vehicle status.  # noqa: E501

        Returns the latest vehicle status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_vehicle_status(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param list[str] extension: Additional data set that will be included in embedded field    * _Disclaimer_:  **Enabling ```odometer``` extension will automatically disable ```kinetic``` telemetry message**
        :return: Status
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_vehicle_status_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_vehicle_status_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def get_vehicle_status_with_http_info(self, id, **kwargs):  # noqa: E501
        """Vehicle status.  # noqa: E501

        Returns the latest vehicle status.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_vehicle_status_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param list[str] extension: Additional data set that will be included in embedded field    * _Disclaimer_:  **Enabling ```odometer``` extension will automatically disable ```kinetic``` telemetry message**
        :return: Status
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'extension']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vehicle_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_vehicle_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'extension' in params:
            query_params.append(('extension', params['extension']))  # noqa: E501
            collection_formats['extension'] = 'multi'  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/hal+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Vehicle_auth', 'client_id', 'realm']  # noqa: E501

        return self.api_client.call_api(
            '/user/vehicles/{id}/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Status',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_vehicles_by_device(self, **kwargs):  # noqa: E501
        """List of vehicules  # noqa: E501

        Returns the Vehicles associated with the User.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_vehicles_by_device(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str index_range: Results indexes will be included in this range (see **indexRange** model).      default: 0-    example: 0-, 0-5
        :param int page_size: The maximum number of results (for a collection results response) to return per page. When not set, at most 60 results will be returned.  
        :param str locale: Locale is used for rendering text, correctly displaying regional monetary values, time and date formats. Respect REGEX \\w(-\\w)?
        :param str page_token: Start-Page marker, the token for continuing a previous list request on the next page. It is built and used **only** by the server.
        :return: Vehicles
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_vehicles_by_device_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.get_vehicles_by_device_with_http_info(**kwargs)  # noqa: E501
            return data

    def get_vehicles_by_device_with_http_info(self, **kwargs):  # noqa: E501
        """List of vehicules  # noqa: E501

        Returns the Vehicles associated with the User.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_vehicles_by_device_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str index_range: Results indexes will be included in this range (see **indexRange** model).      default: 0-    example: 0-, 0-5
        :param int page_size: The maximum number of results (for a collection results response) to return per page. When not set, at most 60 results will be returned.  
        :param str locale: Locale is used for rendering text, correctly displaying regional monetary values, time and date formats. Respect REGEX \\w(-\\w)?
        :param str page_token: Start-Page marker, the token for continuing a previous list request on the next page. It is built and used **only** by the server.
        :return: Vehicles
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['index_range', 'page_size', 'locale', 'page_token']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_vehicles_by_device" % key
                )
            params[key] = val
        del params['kwargs']

        if 'index_range' in params and not re.search(r'\\d+-\\d*', params['index_range']):  # noqa: E501
            raise ValueError("Invalid value for parameter `index_range` when calling `get_vehicles_by_device`, must conform to the pattern `/\\d+-\\d*/`")  # noqa: E501
        if 'page_size' in params and params['page_size'] < 1:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_vehicles_by_device`, must be a value greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'index_range' in params:
            query_params.append(('indexRange', params['index_range']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('pageSize', params['page_size']))  # noqa: E501
        if 'locale' in params:
            query_params.append(('locale', params['locale']))  # noqa: E501
        if 'page_token' in params:
            query_params.append(('pageToken', params['page_token']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/hal+json '])  # noqa: E501

        # Authentication setting
        auth_settings = ['Vehicle_auth', 'client_id', 'realm']  # noqa: E501

        return self.api_client.call_api(
            '/user/vehicles', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Vehicles',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_fleet_vehicle_monitor_status(self, id, mid, **kwargs):  # noqa: E501
        """Set a new monitor status. OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Set monitor status.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_fleet_vehicle_monitor_status(id, mid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param str mid: id of the alert. (required)
        :param MonitorStatusSetter body:
        :return: MonitorRef
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_fleet_vehicle_monitor_status_with_http_info(id, mid, **kwargs)  # noqa: E501
        else:
            (data) = self.set_fleet_vehicle_monitor_status_with_http_info(id, mid, **kwargs)  # noqa: E501
            return data

    def set_fleet_vehicle_monitor_status_with_http_info(self, id, mid, **kwargs):  # noqa: E501
        """Set a new monitor status. OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Set monitor status.    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_fleet_vehicle_monitor_status_with_http_info(id, mid, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param str mid: id of the alert. (required)
        :param MonitorStatusSetter body:
        :return: MonitorRef
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'mid', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_fleet_vehicle_monitor_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `set_fleet_vehicle_monitor_status`")  # noqa: E501
        # verify the required parameter 'mid' is set
        if ('mid' not in params or
                params['mid'] is None):
            raise ValueError("Missing the required parameter `mid` when calling `set_fleet_vehicle_monitor_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501
        if 'mid' in params:
            path_params['mid'] = params['mid']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/user/vehicles/{id}/monitors/{mid}/status', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MonitorRef',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_vehicle_monitor(self, id, **kwargs):  # noqa: E501
        """Create a new Monitor. OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        >Create a Monitor for a Vehicle. This is a kind of vehicle monitor that generates an event following the transition state of one of the (monitored) data  of the vehicles. As for example the fuel level, the moving out of a defined geographical area.   >When the the trigger occurs, the built event expressed as a JSON object will be sent over the callback.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_vehicle_monitor(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param MonitorParameter body:
        :return: MonitorParameter
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.set_vehicle_monitor_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.set_vehicle_monitor_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def set_vehicle_monitor_with_http_info(self, id, **kwargs):  # noqa: E501
        """Create a new Monitor. OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        >Create a Monitor for a Vehicle. This is a kind of vehicle monitor that generates an event following the transition state of one of the (monitored) data  of the vehicles. As for example the fuel level, the moving out of a defined geographical area.   >When the the trigger occurs, the built event expressed as a JSON object will be sent over the callback.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_vehicle_monitor_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param MonitorParameter body:
        :return: MonitorParameter
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_vehicle_monitor" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `set_vehicle_monitor`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/hal+json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['Vehicle_auth', 'client_id', 'realm']  # noqa: E501

        return self.api_client.call_api(
            '/user/vehicles/{id}/monitors', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MonitorParameter',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_fleet_vehicle_monitor(self, mid, id, **kwargs):  # noqa: E501
        """Update and existing Monitor. OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Update an existing ```Monitor``` that has been posted (and accepted previously) for this vehicle. The monitor object (body) provided should be complete because the aggregation is not supported for the update of the ```monitor```. you can retrieve this object using the ```GET /monitor/{mid}``` API then modify it and finally publish it (via this ```PUT API```)    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_fleet_vehicle_monitor(mid, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str mid: id of the alert. (required)
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param MonitorParameter body:
        :return: MonitorRef
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_fleet_vehicle_monitor_with_http_info(mid, id, **kwargs)  # noqa: E501
        else:
            (data) = self.update_fleet_vehicle_monitor_with_http_info(mid, id, **kwargs)  # noqa: E501
            return data

    def update_fleet_vehicle_monitor_with_http_info(self, mid, id, **kwargs):  # noqa: E501
        """Update and existing Monitor. OUT OF 1ST RELEASE (R-LEV 1.1) SCOPE  # noqa: E501

        Update an existing ```Monitor``` that has been posted (and accepted previously) for this vehicle. The monitor object (body) provided should be complete because the aggregation is not supported for the update of the ```monitor```. you can retrieve this object using the ```GET /monitor/{mid}``` API then modify it and finally publish it (via this ```PUT API```)    # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_fleet_vehicle_monitor_with_http_info(mid, id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str mid: id of the alert. (required)
        :param str id: Results will only be related to this Vehicle *id*. (required)
        :param MonitorParameter body:
        :return: MonitorRef
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['mid', 'id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_fleet_vehicle_monitor" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'mid' is set
        if ('mid' not in params or
                params['mid'] is None):
            raise ValueError("Missing the required parameter `mid` when calling `update_fleet_vehicle_monitor`")  # noqa: E501
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `update_fleet_vehicle_monitor`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'mid' in params:
            path_params['mid'] = params['mid']  # noqa: E501
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/user/vehicles/{id}/monitors/{mid}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='MonitorRef',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
