"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Unit = exports.Statistic = void 0;
/**
 * Statistic to use over the aggregation period.
 *
 * @stability stable
 */
var Statistic;
(function (Statistic) {
    Statistic["SAMPLE_COUNT"] = "SampleCount";
    Statistic["AVERAGE"] = "Average";
    Statistic["SUM"] = "Sum";
    Statistic["MINIMUM"] = "Minimum";
    Statistic["MAXIMUM"] = "Maximum";
})(Statistic = exports.Statistic || (exports.Statistic = {}));
/**
 * Unit for metric.
 *
 * @stability stable
 */
var Unit;
(function (Unit) {
    Unit["SECONDS"] = "Seconds";
    Unit["MICROSECONDS"] = "Microseconds";
    Unit["MILLISECONDS"] = "Milliseconds";
    Unit["BYTES"] = "Bytes";
    Unit["KILOBYTES"] = "Kilobytes";
    Unit["MEGABYTES"] = "Megabytes";
    Unit["GIGABYTES"] = "Gigabytes";
    Unit["TERABYTES"] = "Terabytes";
    Unit["BITS"] = "Bits";
    Unit["KILOBITS"] = "Kilobits";
    Unit["MEGABITS"] = "Megabits";
    Unit["GIGABITS"] = "Gigabits";
    Unit["TERABITS"] = "Terabits";
    Unit["PERCENT"] = "Percent";
    Unit["COUNT"] = "Count";
    Unit["BYTES_PER_SECOND"] = "Bytes/Second";
    Unit["KILOBYTES_PER_SECOND"] = "Kilobytes/Second";
    Unit["MEGABYTES_PER_SECOND"] = "Megabytes/Second";
    Unit["GIGABYTES_PER_SECOND"] = "Gigabytes/Second";
    Unit["TERABYTES_PER_SECOND"] = "Terabytes/Second";
    Unit["BITS_PER_SECOND"] = "Bits/Second";
    Unit["KILOBITS_PER_SECOND"] = "Kilobits/Second";
    Unit["MEGABITS_PER_SECOND"] = "Megabits/Second";
    Unit["GIGABITS_PER_SECOND"] = "Gigabits/Second";
    Unit["TERABITS_PER_SECOND"] = "Terabits/Second";
    Unit["COUNT_PER_SECOND"] = "Count/Second";
    Unit["NONE"] = "None";
})(Unit = exports.Unit || (exports.Unit = {}));
//# sourceMappingURL=data:application/json;base64,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