import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::Lambda::Alias`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html
 * @external
 */
export interface CfnAliasProps {
    /**
     * `AWS::Lambda::Alias.FunctionName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-functionname
     * @external
     */
    readonly functionName: string;
    /**
     * `AWS::Lambda::Alias.FunctionVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-functionversion
     * @external
     */
    readonly functionVersion: string;
    /**
     * `AWS::Lambda::Alias.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::Lambda::Alias.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::Lambda::Alias.ProvisionedConcurrencyConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-provisionedconcurrencyconfig
     * @external
     */
    readonly provisionedConcurrencyConfig?: CfnAlias.ProvisionedConcurrencyConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::Alias.RoutingConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-routingconfig
     * @external
     */
    readonly routingConfig?: CfnAlias.AliasRoutingConfigurationProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Lambda::Alias`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html
 * @external
 * @cloudformationResource AWS::Lambda::Alias
 */
export declare class CfnAlias extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Lambda::Alias";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnAlias;
    /**
     * `AWS::Lambda::Alias.FunctionName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-functionname
     * @external
     */
    functionName: string;
    /**
     * `AWS::Lambda::Alias.FunctionVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-functionversion
     * @external
     */
    functionVersion: string;
    /**
     * `AWS::Lambda::Alias.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-name
     * @external
     */
    name: string;
    /**
     * `AWS::Lambda::Alias.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::Lambda::Alias.ProvisionedConcurrencyConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-provisionedconcurrencyconfig
     * @external
     */
    provisionedConcurrencyConfig: CfnAlias.ProvisionedConcurrencyConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Lambda::Alias.RoutingConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html#cfn-lambda-alias-routingconfig
     * @external
     */
    routingConfig: CfnAlias.AliasRoutingConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Lambda::Alias`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAliasProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Lambda::Alias`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html
 * @external
 * @cloudformationResource AWS::Lambda::Alias
 */
export declare namespace CfnAlias {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-alias-aliasroutingconfiguration.html
     * @external
     */
    interface AliasRoutingConfigurationProperty {
        /**
         * `CfnAlias.AliasRoutingConfigurationProperty.AdditionalVersionWeights`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-alias-aliasroutingconfiguration.html#cfn-lambda-alias-aliasroutingconfiguration-additionalversionweights
         * @external
         */
        readonly additionalVersionWeights: Array<CfnAlias.VersionWeightProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Lambda::Alias`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html
 * @external
 * @cloudformationResource AWS::Lambda::Alias
 */
export declare namespace CfnAlias {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-alias-provisionedconcurrencyconfiguration.html
     * @external
     */
    interface ProvisionedConcurrencyConfigurationProperty {
        /**
         * `CfnAlias.ProvisionedConcurrencyConfigurationProperty.ProvisionedConcurrentExecutions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-alias-provisionedconcurrencyconfiguration.html#cfn-lambda-alias-provisionedconcurrencyconfiguration-provisionedconcurrentexecutions
         * @external
         */
        readonly provisionedConcurrentExecutions: number;
    }
}
/**
 * A CloudFormation `AWS::Lambda::Alias`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-alias.html
 * @external
 * @cloudformationResource AWS::Lambda::Alias
 */
export declare namespace CfnAlias {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-alias-versionweight.html
     * @external
     */
    interface VersionWeightProperty {
        /**
         * `CfnAlias.VersionWeightProperty.FunctionVersion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-alias-versionweight.html#cfn-lambda-alias-versionweight-functionversion
         * @external
         */
        readonly functionVersion: string;
        /**
         * `CfnAlias.VersionWeightProperty.FunctionWeight`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-alias-versionweight.html#cfn-lambda-alias-versionweight-functionweight
         * @external
         */
        readonly functionWeight: number;
    }
}
/**
 * Properties for defining a `AWS::Lambda::EventInvokeConfig`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html
 * @external
 */
export interface CfnEventInvokeConfigProps {
    /**
     * `AWS::Lambda::EventInvokeConfig.FunctionName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-functionname
     * @external
     */
    readonly functionName: string;
    /**
     * `AWS::Lambda::EventInvokeConfig.Qualifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-qualifier
     * @external
     */
    readonly qualifier: string;
    /**
     * `AWS::Lambda::EventInvokeConfig.DestinationConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-destinationconfig
     * @external
     */
    readonly destinationConfig?: CfnEventInvokeConfig.DestinationConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::EventInvokeConfig.MaximumEventAgeInSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-maximumeventageinseconds
     * @external
     */
    readonly maximumEventAgeInSeconds?: number;
    /**
     * `AWS::Lambda::EventInvokeConfig.MaximumRetryAttempts`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-maximumretryattempts
     * @external
     */
    readonly maximumRetryAttempts?: number;
}
/**
 * A CloudFormation `AWS::Lambda::EventInvokeConfig`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html
 * @external
 * @cloudformationResource AWS::Lambda::EventInvokeConfig
 */
export declare class CfnEventInvokeConfig extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Lambda::EventInvokeConfig";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnEventInvokeConfig;
    /**
     * `AWS::Lambda::EventInvokeConfig.FunctionName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-functionname
     * @external
     */
    functionName: string;
    /**
     * `AWS::Lambda::EventInvokeConfig.Qualifier`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-qualifier
     * @external
     */
    qualifier: string;
    /**
     * `AWS::Lambda::EventInvokeConfig.DestinationConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-destinationconfig
     * @external
     */
    destinationConfig: CfnEventInvokeConfig.DestinationConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Lambda::EventInvokeConfig.MaximumEventAgeInSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-maximumeventageinseconds
     * @external
     */
    maximumEventAgeInSeconds: number | undefined;
    /**
     * `AWS::Lambda::EventInvokeConfig.MaximumRetryAttempts`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html#cfn-lambda-eventinvokeconfig-maximumretryattempts
     * @external
     */
    maximumRetryAttempts: number | undefined;
    /**
     * Create a new `AWS::Lambda::EventInvokeConfig`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEventInvokeConfigProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Lambda::EventInvokeConfig`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html
 * @external
 * @cloudformationResource AWS::Lambda::EventInvokeConfig
 */
export declare namespace CfnEventInvokeConfig {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventinvokeconfig-destinationconfig.html
     * @external
     */
    interface DestinationConfigProperty {
        /**
         * `CfnEventInvokeConfig.DestinationConfigProperty.OnFailure`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventinvokeconfig-destinationconfig.html#cfn-lambda-eventinvokeconfig-destinationconfig-onfailure
         * @external
         */
        readonly onFailure?: CfnEventInvokeConfig.OnFailureProperty | cdk.IResolvable;
        /**
         * `CfnEventInvokeConfig.DestinationConfigProperty.OnSuccess`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventinvokeconfig-destinationconfig.html#cfn-lambda-eventinvokeconfig-destinationconfig-onsuccess
         * @external
         */
        readonly onSuccess?: CfnEventInvokeConfig.OnSuccessProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Lambda::EventInvokeConfig`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html
 * @external
 * @cloudformationResource AWS::Lambda::EventInvokeConfig
 */
export declare namespace CfnEventInvokeConfig {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventinvokeconfig-destinationconfig-onfailure.html
     * @external
     */
    interface OnFailureProperty {
        /**
         * `CfnEventInvokeConfig.OnFailureProperty.Destination`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventinvokeconfig-destinationconfig-onfailure.html#cfn-lambda-eventinvokeconfig-destinationconfig-onfailure-destination
         * @external
         */
        readonly destination: string;
    }
}
/**
 * A CloudFormation `AWS::Lambda::EventInvokeConfig`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventinvokeconfig.html
 * @external
 * @cloudformationResource AWS::Lambda::EventInvokeConfig
 */
export declare namespace CfnEventInvokeConfig {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventinvokeconfig-destinationconfig-onsuccess.html
     * @external
     */
    interface OnSuccessProperty {
        /**
         * `CfnEventInvokeConfig.OnSuccessProperty.Destination`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventinvokeconfig-destinationconfig-onsuccess.html#cfn-lambda-eventinvokeconfig-destinationconfig-onsuccess-destination
         * @external
         */
        readonly destination: string;
    }
}
/**
 * Properties for defining a `AWS::Lambda::EventSourceMapping`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html
 * @external
 */
export interface CfnEventSourceMappingProps {
    /**
     * `AWS::Lambda::EventSourceMapping.EventSourceArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-eventsourcearn
     * @external
     */
    readonly eventSourceArn: string;
    /**
     * `AWS::Lambda::EventSourceMapping.FunctionName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-functionname
     * @external
     */
    readonly functionName: string;
    /**
     * `AWS::Lambda::EventSourceMapping.BatchSize`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-batchsize
     * @external
     */
    readonly batchSize?: number;
    /**
     * `AWS::Lambda::EventSourceMapping.BisectBatchOnFunctionError`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-bisectbatchonfunctionerror
     * @external
     */
    readonly bisectBatchOnFunctionError?: boolean | cdk.IResolvable;
    /**
     * `AWS::Lambda::EventSourceMapping.DestinationConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-destinationconfig
     * @external
     */
    readonly destinationConfig?: CfnEventSourceMapping.DestinationConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::EventSourceMapping.Enabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-enabled
     * @external
     */
    readonly enabled?: boolean | cdk.IResolvable;
    /**
     * `AWS::Lambda::EventSourceMapping.MaximumBatchingWindowInSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-maximumbatchingwindowinseconds
     * @external
     */
    readonly maximumBatchingWindowInSeconds?: number;
    /**
     * `AWS::Lambda::EventSourceMapping.MaximumRecordAgeInSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-maximumrecordageinseconds
     * @external
     */
    readonly maximumRecordAgeInSeconds?: number;
    /**
     * `AWS::Lambda::EventSourceMapping.MaximumRetryAttempts`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-maximumretryattempts
     * @external
     */
    readonly maximumRetryAttempts?: number;
    /**
     * `AWS::Lambda::EventSourceMapping.ParallelizationFactor`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-parallelizationfactor
     * @external
     */
    readonly parallelizationFactor?: number;
    /**
     * `AWS::Lambda::EventSourceMapping.PartialBatchResponse`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-partialbatchresponse
     * @external
     */
    readonly partialBatchResponse?: boolean | cdk.IResolvable;
    /**
     * `AWS::Lambda::EventSourceMapping.Queues`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-queues
     * @external
     */
    readonly queues?: string[];
    /**
     * `AWS::Lambda::EventSourceMapping.SourceAccessConfigurations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-sourceaccessconfigurations
     * @external
     */
    readonly sourceAccessConfigurations?: Array<CfnEventSourceMapping.SourceAccessConfigurationProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Lambda::EventSourceMapping.StartingPosition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-startingposition
     * @external
     */
    readonly startingPosition?: string;
    /**
     * `AWS::Lambda::EventSourceMapping.Topics`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-topics
     * @external
     */
    readonly topics?: string[];
    /**
     * `AWS::Lambda::EventSourceMapping.TumblingWindowInSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-tumblingwindowinseconds
     * @external
     */
    readonly tumblingWindowInSeconds?: number;
}
/**
 * A CloudFormation `AWS::Lambda::EventSourceMapping`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html
 * @external
 * @cloudformationResource AWS::Lambda::EventSourceMapping
 */
export declare class CfnEventSourceMapping extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Lambda::EventSourceMapping";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnEventSourceMapping;
    /**
     * @external
     * @cloudformationAttribute Id
     */
    readonly attrId: string;
    /**
     * `AWS::Lambda::EventSourceMapping.EventSourceArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-eventsourcearn
     * @external
     */
    eventSourceArn: string;
    /**
     * `AWS::Lambda::EventSourceMapping.FunctionName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-functionname
     * @external
     */
    functionName: string;
    /**
     * `AWS::Lambda::EventSourceMapping.BatchSize`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-batchsize
     * @external
     */
    batchSize: number | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.BisectBatchOnFunctionError`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-bisectbatchonfunctionerror
     * @external
     */
    bisectBatchOnFunctionError: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.DestinationConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-destinationconfig
     * @external
     */
    destinationConfig: CfnEventSourceMapping.DestinationConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.Enabled`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-enabled
     * @external
     */
    enabled: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.MaximumBatchingWindowInSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-maximumbatchingwindowinseconds
     * @external
     */
    maximumBatchingWindowInSeconds: number | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.MaximumRecordAgeInSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-maximumrecordageinseconds
     * @external
     */
    maximumRecordAgeInSeconds: number | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.MaximumRetryAttempts`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-maximumretryattempts
     * @external
     */
    maximumRetryAttempts: number | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.ParallelizationFactor`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-parallelizationfactor
     * @external
     */
    parallelizationFactor: number | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.PartialBatchResponse`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-partialbatchresponse
     * @external
     */
    partialBatchResponse: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.Queues`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-queues
     * @external
     */
    queues: string[] | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.SourceAccessConfigurations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-sourceaccessconfigurations
     * @external
     */
    sourceAccessConfigurations: Array<CfnEventSourceMapping.SourceAccessConfigurationProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.StartingPosition`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-startingposition
     * @external
     */
    startingPosition: string | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.Topics`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-topics
     * @external
     */
    topics: string[] | undefined;
    /**
     * `AWS::Lambda::EventSourceMapping.TumblingWindowInSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html#cfn-lambda-eventsourcemapping-tumblingwindowinseconds
     * @external
     */
    tumblingWindowInSeconds: number | undefined;
    /**
     * Create a new `AWS::Lambda::EventSourceMapping`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEventSourceMappingProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Lambda::EventSourceMapping`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html
 * @external
 * @cloudformationResource AWS::Lambda::EventSourceMapping
 */
export declare namespace CfnEventSourceMapping {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventsourcemapping-destinationconfig.html
     * @external
     */
    interface DestinationConfigProperty {
        /**
         * `CfnEventSourceMapping.DestinationConfigProperty.OnFailure`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventsourcemapping-destinationconfig.html#cfn-lambda-eventsourcemapping-destinationconfig-onfailure
         * @external
         */
        readonly onFailure?: CfnEventSourceMapping.OnFailureProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Lambda::EventSourceMapping`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html
 * @external
 * @cloudformationResource AWS::Lambda::EventSourceMapping
 */
export declare namespace CfnEventSourceMapping {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventsourcemapping-onfailure.html
     * @external
     */
    interface OnFailureProperty {
        /**
         * `CfnEventSourceMapping.OnFailureProperty.Destination`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventsourcemapping-onfailure.html#cfn-lambda-eventsourcemapping-onfailure-destination
         * @external
         */
        readonly destination?: string;
    }
}
/**
 * A CloudFormation `AWS::Lambda::EventSourceMapping`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-eventsourcemapping.html
 * @external
 * @cloudformationResource AWS::Lambda::EventSourceMapping
 */
export declare namespace CfnEventSourceMapping {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventsourcemapping-sourceaccessconfiguration.html
     * @external
     */
    interface SourceAccessConfigurationProperty {
        /**
         * `CfnEventSourceMapping.SourceAccessConfigurationProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventsourcemapping-sourceaccessconfiguration.html#cfn-lambda-eventsourcemapping-sourceaccessconfiguration-type
         * @external
         */
        readonly type?: string;
        /**
         * `CfnEventSourceMapping.SourceAccessConfigurationProperty.URI`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-eventsourcemapping-sourceaccessconfiguration.html#cfn-lambda-eventsourcemapping-sourceaccessconfiguration-uri
         * @external
         */
        readonly uri?: string;
    }
}
/**
 * Properties for defining a `AWS::Lambda::Function`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html
 * @external
 */
export interface CfnFunctionProps {
    /**
     * `AWS::Lambda::Function.Code`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-code
     * @external
     */
    readonly code: CfnFunction.CodeProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::Function.Handler`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-handler
     * @external
     */
    readonly handler: string;
    /**
     * `AWS::Lambda::Function.Role`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-role
     * @external
     */
    readonly role: string;
    /**
     * `AWS::Lambda::Function.Runtime`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-runtime
     * @external
     */
    readonly runtime: string;
    /**
     * `AWS::Lambda::Function.DeadLetterConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-deadletterconfig
     * @external
     */
    readonly deadLetterConfig?: CfnFunction.DeadLetterConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::Function.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::Lambda::Function.Environment`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-environment
     * @external
     */
    readonly environment?: CfnFunction.EnvironmentProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::Function.FileSystemConfigs`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-filesystemconfigs
     * @external
     */
    readonly fileSystemConfigs?: Array<CfnFunction.FileSystemConfigProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Lambda::Function.FunctionName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-functionname
     * @external
     */
    readonly functionName?: string;
    /**
     * `AWS::Lambda::Function.ImageConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-imageconfig
     * @external
     */
    readonly imageConfig?: CfnFunction.ImageConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::Function.KmsKeyArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-kmskeyarn
     * @external
     */
    readonly kmsKeyArn?: string;
    /**
     * `AWS::Lambda::Function.Layers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-layers
     * @external
     */
    readonly layers?: string[];
    /**
     * `AWS::Lambda::Function.MemorySize`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-memorysize
     * @external
     */
    readonly memorySize?: number;
    /**
     * `AWS::Lambda::Function.PackageType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-packagetype
     * @external
     */
    readonly packageType?: string;
    /**
     * `AWS::Lambda::Function.ReservedConcurrentExecutions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-reservedconcurrentexecutions
     * @external
     */
    readonly reservedConcurrentExecutions?: number;
    /**
     * `AWS::Lambda::Function.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::Lambda::Function.Timeout`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-timeout
     * @external
     */
    readonly timeout?: number;
    /**
     * `AWS::Lambda::Function.TracingConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-tracingconfig
     * @external
     */
    readonly tracingConfig?: CfnFunction.TracingConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::Function.VpcConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-vpcconfig
     * @external
     */
    readonly vpcConfig?: CfnFunction.VpcConfigProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Lambda::Function`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html
 * @external
 * @cloudformationResource AWS::Lambda::Function
 */
export declare class CfnFunction extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Lambda::Function";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnFunction;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * `AWS::Lambda::Function.Code`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-code
     * @external
     */
    code: CfnFunction.CodeProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::Function.Handler`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-handler
     * @external
     */
    handler: string;
    /**
     * `AWS::Lambda::Function.Role`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-role
     * @external
     */
    role: string;
    /**
     * `AWS::Lambda::Function.Runtime`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-runtime
     * @external
     */
    runtime: string;
    /**
     * `AWS::Lambda::Function.DeadLetterConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-deadletterconfig
     * @external
     */
    deadLetterConfig: CfnFunction.DeadLetterConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Lambda::Function.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::Lambda::Function.Environment`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-environment
     * @external
     */
    environment: CfnFunction.EnvironmentProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Lambda::Function.FileSystemConfigs`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-filesystemconfigs
     * @external
     */
    fileSystemConfigs: Array<CfnFunction.FileSystemConfigProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Lambda::Function.FunctionName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-functionname
     * @external
     */
    functionName: string | undefined;
    /**
     * `AWS::Lambda::Function.ImageConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-imageconfig
     * @external
     */
    imageConfig: CfnFunction.ImageConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Lambda::Function.KmsKeyArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-kmskeyarn
     * @external
     */
    kmsKeyArn: string | undefined;
    /**
     * `AWS::Lambda::Function.Layers`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-layers
     * @external
     */
    layers: string[] | undefined;
    /**
     * `AWS::Lambda::Function.MemorySize`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-memorysize
     * @external
     */
    memorySize: number | undefined;
    /**
     * `AWS::Lambda::Function.PackageType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-packagetype
     * @external
     */
    packageType: string | undefined;
    /**
     * `AWS::Lambda::Function.ReservedConcurrentExecutions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-reservedconcurrentexecutions
     * @external
     */
    reservedConcurrentExecutions: number | undefined;
    /**
     * `AWS::Lambda::Function.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::Lambda::Function.Timeout`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-timeout
     * @external
     */
    timeout: number | undefined;
    /**
     * `AWS::Lambda::Function.TracingConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-tracingconfig
     * @external
     */
    tracingConfig: CfnFunction.TracingConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Lambda::Function.VpcConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html#cfn-lambda-function-vpcconfig
     * @external
     */
    vpcConfig: CfnFunction.VpcConfigProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Lambda::Function`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFunctionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Lambda::Function`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html
 * @external
 * @cloudformationResource AWS::Lambda::Function
 */
export declare namespace CfnFunction {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-code.html
     * @external
     */
    interface CodeProperty {
        /**
         * `CfnFunction.CodeProperty.S3Bucket`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-code.html#cfn-lambda-function-code-s3bucket
         * @external
         */
        readonly s3Bucket?: string;
        /**
         * `CfnFunction.CodeProperty.S3Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-code.html#cfn-lambda-function-code-s3key
         * @external
         */
        readonly s3Key?: string;
        /**
         * `CfnFunction.CodeProperty.S3ObjectVersion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-code.html#cfn-lambda-function-code-s3objectversion
         * @external
         */
        readonly s3ObjectVersion?: string;
        /**
         * `CfnFunction.CodeProperty.ZipFile`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-code.html#cfn-lambda-function-code-zipfile
         * @external
         */
        readonly zipFile?: string;
        /**
         * `CfnFunction.CodeProperty.ImageUri`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-code.html#cfn-lambda-function-code-imageuri
         * @external
         */
        readonly imageUri?: string;
    }
}
/**
 * A CloudFormation `AWS::Lambda::Function`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html
 * @external
 * @cloudformationResource AWS::Lambda::Function
 */
export declare namespace CfnFunction {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-deadletterconfig.html
     * @external
     */
    interface DeadLetterConfigProperty {
        /**
         * `CfnFunction.DeadLetterConfigProperty.TargetArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-deadletterconfig.html#cfn-lambda-function-deadletterconfig-targetarn
         * @external
         */
        readonly targetArn?: string;
    }
}
/**
 * A CloudFormation `AWS::Lambda::Function`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html
 * @external
 * @cloudformationResource AWS::Lambda::Function
 */
export declare namespace CfnFunction {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-environment.html
     * @external
     */
    interface EnvironmentProperty {
        /**
         * `CfnFunction.EnvironmentProperty.Variables`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-environment.html#cfn-lambda-function-environment-variables
         * @external
         */
        readonly variables?: {
            [key: string]: (string);
        } | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::Lambda::Function`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html
 * @external
 * @cloudformationResource AWS::Lambda::Function
 */
export declare namespace CfnFunction {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-filesystemconfig.html
     * @external
     */
    interface FileSystemConfigProperty {
        /**
         * `CfnFunction.FileSystemConfigProperty.Arn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-filesystemconfig.html#cfn-lambda-function-filesystemconfig-arn
         * @external
         */
        readonly arn: string;
        /**
         * `CfnFunction.FileSystemConfigProperty.LocalMountPath`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-filesystemconfig.html#cfn-lambda-function-filesystemconfig-localmountpath
         * @external
         */
        readonly localMountPath: string;
    }
}
/**
 * A CloudFormation `AWS::Lambda::Function`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html
 * @external
 * @cloudformationResource AWS::Lambda::Function
 */
export declare namespace CfnFunction {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-imageconfig.html
     * @external
     */
    interface ImageConfigProperty {
        /**
         * `CfnFunction.ImageConfigProperty.Command`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-imageconfig.html#cfn-lambda-function-imageconfig-command
         * @external
         */
        readonly command?: string[];
        /**
         * `CfnFunction.ImageConfigProperty.EntryPoint`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-imageconfig.html#cfn-lambda-function-imageconfig-entrypoint
         * @external
         */
        readonly entryPoint?: string[];
        /**
         * `CfnFunction.ImageConfigProperty.WorkingDirectory`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-imageconfig.html#cfn-lambda-function-imageconfig-workingdirectory
         * @external
         */
        readonly workingDirectory?: string;
    }
}
/**
 * A CloudFormation `AWS::Lambda::Function`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html
 * @external
 * @cloudformationResource AWS::Lambda::Function
 */
export declare namespace CfnFunction {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-tracingconfig.html
     * @external
     */
    interface TracingConfigProperty {
        /**
         * `CfnFunction.TracingConfigProperty.Mode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-tracingconfig.html#cfn-lambda-function-tracingconfig-mode
         * @external
         */
        readonly mode?: string;
    }
}
/**
 * A CloudFormation `AWS::Lambda::Function`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-function.html
 * @external
 * @cloudformationResource AWS::Lambda::Function
 */
export declare namespace CfnFunction {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html
     * @external
     */
    interface VpcConfigProperty {
        /**
         * `CfnFunction.VpcConfigProperty.SecurityGroupIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html#cfn-lambda-function-vpcconfig-securitygroupids
         * @external
         */
        readonly securityGroupIds: string[];
        /**
         * `CfnFunction.VpcConfigProperty.SubnetIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-function-vpcconfig.html#cfn-lambda-function-vpcconfig-subnetids
         * @external
         */
        readonly subnetIds: string[];
    }
}
/**
 * Properties for defining a `AWS::Lambda::LayerVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html
 * @external
 */
export interface CfnLayerVersionProps {
    /**
     * `AWS::Lambda::LayerVersion.Content`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html#cfn-lambda-layerversion-content
     * @external
     */
    readonly content: CfnLayerVersion.ContentProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::LayerVersion.CompatibleRuntimes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html#cfn-lambda-layerversion-compatibleruntimes
     * @external
     */
    readonly compatibleRuntimes?: string[];
    /**
     * `AWS::Lambda::LayerVersion.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html#cfn-lambda-layerversion-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::Lambda::LayerVersion.LayerName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html#cfn-lambda-layerversion-layername
     * @external
     */
    readonly layerName?: string;
    /**
     * `AWS::Lambda::LayerVersion.LicenseInfo`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html#cfn-lambda-layerversion-licenseinfo
     * @external
     */
    readonly licenseInfo?: string;
}
/**
 * A CloudFormation `AWS::Lambda::LayerVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html
 * @external
 * @cloudformationResource AWS::Lambda::LayerVersion
 */
export declare class CfnLayerVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Lambda::LayerVersion";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnLayerVersion;
    /**
     * `AWS::Lambda::LayerVersion.Content`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html#cfn-lambda-layerversion-content
     * @external
     */
    content: CfnLayerVersion.ContentProperty | cdk.IResolvable;
    /**
     * `AWS::Lambda::LayerVersion.CompatibleRuntimes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html#cfn-lambda-layerversion-compatibleruntimes
     * @external
     */
    compatibleRuntimes: string[] | undefined;
    /**
     * `AWS::Lambda::LayerVersion.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html#cfn-lambda-layerversion-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::Lambda::LayerVersion.LayerName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html#cfn-lambda-layerversion-layername
     * @external
     */
    layerName: string | undefined;
    /**
     * `AWS::Lambda::LayerVersion.LicenseInfo`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html#cfn-lambda-layerversion-licenseinfo
     * @external
     */
    licenseInfo: string | undefined;
    /**
     * Create a new `AWS::Lambda::LayerVersion`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLayerVersionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Lambda::LayerVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversion.html
 * @external
 * @cloudformationResource AWS::Lambda::LayerVersion
 */
export declare namespace CfnLayerVersion {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-layerversion-content.html
     * @external
     */
    interface ContentProperty {
        /**
         * `CfnLayerVersion.ContentProperty.S3Bucket`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-layerversion-content.html#cfn-lambda-layerversion-content-s3bucket
         * @external
         */
        readonly s3Bucket: string;
        /**
         * `CfnLayerVersion.ContentProperty.S3Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-layerversion-content.html#cfn-lambda-layerversion-content-s3key
         * @external
         */
        readonly s3Key: string;
        /**
         * `CfnLayerVersion.ContentProperty.S3ObjectVersion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-layerversion-content.html#cfn-lambda-layerversion-content-s3objectversion
         * @external
         */
        readonly s3ObjectVersion?: string;
    }
}
/**
 * Properties for defining a `AWS::Lambda::LayerVersionPermission`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversionpermission.html
 * @external
 */
export interface CfnLayerVersionPermissionProps {
    /**
     * `AWS::Lambda::LayerVersionPermission.Action`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversionpermission.html#cfn-lambda-layerversionpermission-action
     * @external
     */
    readonly action: string;
    /**
     * `AWS::Lambda::LayerVersionPermission.LayerVersionArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversionpermission.html#cfn-lambda-layerversionpermission-layerversionarn
     * @external
     */
    readonly layerVersionArn: string;
    /**
     * `AWS::Lambda::LayerVersionPermission.Principal`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversionpermission.html#cfn-lambda-layerversionpermission-principal
     * @external
     */
    readonly principal: string;
    /**
     * `AWS::Lambda::LayerVersionPermission.OrganizationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversionpermission.html#cfn-lambda-layerversionpermission-organizationid
     * @external
     */
    readonly organizationId?: string;
}
/**
 * A CloudFormation `AWS::Lambda::LayerVersionPermission`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversionpermission.html
 * @external
 * @cloudformationResource AWS::Lambda::LayerVersionPermission
 */
export declare class CfnLayerVersionPermission extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Lambda::LayerVersionPermission";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnLayerVersionPermission;
    /**
     * `AWS::Lambda::LayerVersionPermission.Action`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversionpermission.html#cfn-lambda-layerversionpermission-action
     * @external
     */
    action: string;
    /**
     * `AWS::Lambda::LayerVersionPermission.LayerVersionArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversionpermission.html#cfn-lambda-layerversionpermission-layerversionarn
     * @external
     */
    layerVersionArn: string;
    /**
     * `AWS::Lambda::LayerVersionPermission.Principal`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversionpermission.html#cfn-lambda-layerversionpermission-principal
     * @external
     */
    principal: string;
    /**
     * `AWS::Lambda::LayerVersionPermission.OrganizationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-layerversionpermission.html#cfn-lambda-layerversionpermission-organizationid
     * @external
     */
    organizationId: string | undefined;
    /**
     * Create a new `AWS::Lambda::LayerVersionPermission`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLayerVersionPermissionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Lambda::Permission`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html
 * @external
 */
export interface CfnPermissionProps {
    /**
     * `AWS::Lambda::Permission.Action`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-action
     * @external
     */
    readonly action: string;
    /**
     * `AWS::Lambda::Permission.FunctionName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-functionname
     * @external
     */
    readonly functionName: string;
    /**
     * `AWS::Lambda::Permission.Principal`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-principal
     * @external
     */
    readonly principal: string;
    /**
     * `AWS::Lambda::Permission.EventSourceToken`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-eventsourcetoken
     * @external
     */
    readonly eventSourceToken?: string;
    /**
     * `AWS::Lambda::Permission.SourceAccount`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-sourceaccount
     * @external
     */
    readonly sourceAccount?: string;
    /**
     * `AWS::Lambda::Permission.SourceArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-sourcearn
     * @external
     */
    readonly sourceArn?: string;
}
/**
 * A CloudFormation `AWS::Lambda::Permission`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html
 * @external
 * @cloudformationResource AWS::Lambda::Permission
 */
export declare class CfnPermission extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Lambda::Permission";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnPermission;
    /**
     * `AWS::Lambda::Permission.Action`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-action
     * @external
     */
    action: string;
    /**
     * `AWS::Lambda::Permission.FunctionName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-functionname
     * @external
     */
    functionName: string;
    /**
     * `AWS::Lambda::Permission.Principal`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-principal
     * @external
     */
    principal: string;
    /**
     * `AWS::Lambda::Permission.EventSourceToken`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-eventsourcetoken
     * @external
     */
    eventSourceToken: string | undefined;
    /**
     * `AWS::Lambda::Permission.SourceAccount`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-sourceaccount
     * @external
     */
    sourceAccount: string | undefined;
    /**
     * `AWS::Lambda::Permission.SourceArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-permission.html#cfn-lambda-permission-sourcearn
     * @external
     */
    sourceArn: string | undefined;
    /**
     * Create a new `AWS::Lambda::Permission`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnPermissionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::Lambda::Version`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html
 * @external
 */
export interface CfnVersionProps {
    /**
     * `AWS::Lambda::Version.FunctionName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-functionname
     * @external
     */
    readonly functionName: string;
    /**
     * `AWS::Lambda::Version.CodeSha256`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-codesha256
     * @external
     */
    readonly codeSha256?: string;
    /**
     * `AWS::Lambda::Version.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::Lambda::Version.ProvisionedConcurrencyConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-provisionedconcurrencyconfig
     * @external
     */
    readonly provisionedConcurrencyConfig?: CfnVersion.ProvisionedConcurrencyConfigurationProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Lambda::Version`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html
 * @external
 * @cloudformationResource AWS::Lambda::Version
 */
export declare class CfnVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Lambda::Version";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnVersion;
    /**
     * @external
     * @cloudformationAttribute Version
     */
    readonly attrVersion: string;
    /**
     * `AWS::Lambda::Version.FunctionName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-functionname
     * @external
     */
    functionName: string;
    /**
     * `AWS::Lambda::Version.CodeSha256`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-codesha256
     * @external
     */
    codeSha256: string | undefined;
    /**
     * `AWS::Lambda::Version.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::Lambda::Version.ProvisionedConcurrencyConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html#cfn-lambda-version-provisionedconcurrencyconfig
     * @external
     */
    provisionedConcurrencyConfig: CfnVersion.ProvisionedConcurrencyConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Lambda::Version`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnVersionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Lambda::Version`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-lambda-version.html
 * @external
 * @cloudformationResource AWS::Lambda::Version
 */
export declare namespace CfnVersion {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-version-provisionedconcurrencyconfiguration.html
     * @external
     */
    interface ProvisionedConcurrencyConfigurationProperty {
        /**
         * `CfnVersion.ProvisionedConcurrencyConfigurationProperty.ProvisionedConcurrentExecutions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-lambda-version-provisionedconcurrencyconfiguration.html#cfn-lambda-version-provisionedconcurrencyconfiguration-provisionedconcurrentexecutions
         * @external
         */
        readonly provisionedConcurrentExecutions: number;
    }
}
