# django_cadence

A reusable Django app that provides scheduling of asynchronous tasks (optionally as asynchronous tasks via Dramatiq or Celery)

![Latest GitHub Release](https://img.shields.io/github/v/release/LucidDan/django-cadence?sort=semver&style=plastic)
![Latest Pypi Release](https://img.shields.io/pypi/v/django-cadence.svg?style=plastic)
![License](https://img.shields.io/github/license/LucidDan/django-cadence?style=plastic)
![Build](https://img.shields.io/travis/:LucidDan/django-cadence?style=plastic)

![Photo of a calendar on a wall](https://unsplash.com/photos/PypjzKTUqLo "Photo by Roman Bozhko")

## Introduction

This is a simple package, so far at least, that provides some scheduling capabilities in Django.
It can do this standalone, or in cooperation with [Dramatiq] or [Celery].


## Links and References

* [Releases - PyPI](https://pypi.org/django-cadence)
* [Releases - GitHub](https://github.com/LucidDan/django-cadence/releases)
* [GitHub Issues]
* [Source](https://github.com/LucidDan/django-cadence/)
* [ChangeLog](CHANGELOG.md)
* [License](LICENSE.md)
* [Contributing](CONTRIBUTING.md)

## What's New

Current version: 0.1.2

Testing travis deployment, and updating documentation.

See the [changelog](CHANGELOG.md) for more information on recent changes.

## Supported Releases

See [SECURITY.md] for releases which are currently supported for security updates.

In general, the current major release is supported for all bug and security fixes, and the previous major release is supported for security fixes only.

## Dependencies

Required:
 * [Python]() v3.6.x - v3.8.x
 * [Django]() v2.2.x - v3.0.x
 * [APScheduler]() v3.6.x
 
Recommended:
 * [Dramatiq]() v1.8.x - v1.9.x
  (or)
 * [Celery]() v4.4.x


## Installing

Use pip or another pip-based tool in combination with PyPI to install this package.


## Getting Support

First, unless it is extremely urgent, please check the FAQ, Known Issues section, and general documentation before looking for help.

There are a few avenues available for support. In general, if you're really confident you've found a bug, log an issue directly via GitHub.

* [Log an issue via GitHub][GitHub Issues]


## FAQ

This section contains some frequent questions and answers, be aware that if you did not read this section and ask one of these questions on the forum or chat server, you might get redirected back to read this with varying levels of politeness or irritation. ;-)

### When will the mod be updated for Django version X, Python version Y, etc?

When it is done. Pull requests are welcome.


## Known Issues

This section attempts to sum up known issues in a easier-to-consume way. For the most up-to-date information on this, it might be worth checking [GitHub Issues]

* There are currently no known issues.


## Contributing

See [CONTRIBUTING.md] for information on how you can help contribute to this project.


## Special Thanks

Here is a non-exhaustive list of sources, people, etc that deserve some thanks for bringing this project into existence:

* []()



[GitHub Issues]: https://github.com/LucidDan/django-cadence/issues
[Dramatiq]: https://dramatiq.io/
[Celery]: https://docs.celeryproject.org/

