# Licensed to the Apache Software Foundation (ASF) under one
# or more contributor license agreements.  See the NOTICE file
# distributed with this work for additional information
# regarding copyright ownership.  The ASF licenses this file
# to you under the Apache License, Version 2.0 (the
# "License"); you may not use this file except in compliance
# with the License.  You may obtain a copy of the License at
#
#   http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing,
# software distributed under the License is distributed on an
# "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
# KIND, either express or implied.  See the License for the
# specific language governing permissions and limitations
# under the License.
def get_provider_info():
    return {
        'package-name': 'apache-airflow-providers-docker',
        'name': 'Docker',
        'description': '`Docker <https://docs.docker.com/install/>`__\n',
        'versions': ['1.0.0'],
        'integrations': [
            {
                'integration-name': 'Docker',
                'external-doc-url': 'https://docs.docker.com/',
                'tags': ['software'],
            },
            {
                'integration-name': 'Docker Swarm',
                'external-doc-url': 'https://docs.docker.com/engine/swarm/',
                'tags': ['software'],
            },
        ],
        'operators': [
            {'integration-name': 'Docker', 'python-modules': ['airflow.providers.docker.operators.docker']},
            {
                'integration-name': 'Docker Swarm',
                'python-modules': ['airflow.providers.docker.operators.docker_swarm'],
            },
        ],
        'hooks': [
            {'integration-name': 'Docker', 'python-modules': ['airflow.providers.docker.hooks.docker']}
        ],
        'hook-class-names': ['airflow.providers.docker.hooks.docker.DockerHook'],
    }
