from .account import Account
from .instance import BlockchainInstance
from graphenecommon.genesisbalance import (
    GenesisBalance as GrapheneGenesisBalance,
    GenesisBalances as GrapheneGenesisBalances,
)

from peerplaysbase.account import Address, PublicKey
from peerplaysbase import operations


@BlockchainInstance.inject
class GenesisBalance(GrapheneGenesisBalance):
    """ Read data about a Committee Member in the chain

        :param str member: Name of the Committee Member
        :param peerplays blockchain_instance: PeerPlays() instance to use when
            accesing a RPC
        :param bool lazy: Use lazy loading

    """

    type_id = 15

    def define_classes(self):
        self.account_class = Account
        self.operations = operations
        self.address_class = Address
        self.publickey_class = PublicKey


@BlockchainInstance.inject
class GenesisBalances(GrapheneGenesisBalances):
    """ List genesis balances that can be claimed from the
        keys in the wallet
    """

    def define_classes(self):
        self.genesisbalance_class = GenesisBalance
        self.publickey_class = PublicKey
        self.address_class = Address
