import setuptools

USERNAME = 'beasteers'
NAME = 'oidcat'

import os
import imp
version = imp.load_source(
    '{}.__version__'.format(NAME),
    os.path.join(os.path.dirname(__file__), NAME, '__version__.py'))
version = version.__version__

setuptools.setup(
    name=NAME,
    version=version,
    description='easy oidc client & server',
    long_description=open('README.md').read().strip(),
    long_description_content_type='text/markdown',
    author='Bea Steers',
    author_email='bea.steers@gmail.com',
    # url='https://github.com/{}/{}'.format(USERNAME, NAME),
    packages=setuptools.find_packages(),
    entry_points={'console_scripts': ['oidcat-admin=oidcat.cli.keycloak:main']},
    install_requires=['requests'],
    extras_require={
        'server': ['flask', 'flask_oidc', 'sqlitedict'],
        'cli': ['tabulate', 'fire'],
    },
    license='MIT License',
    keywords='')
