"""make_nullablee

Revision ID: 52b809a34371
Revises: 339927587383
Create Date: 2025-05-31 18:34:58.962966

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql

# revision identifiers, used by Alembic.
revision: str = "52b809a34371"
down_revision: Union[str, None] = "339927587383"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column(
        "investment_runs",
        "initial_portfolio",
        existing_type=mysql.JSON(),
        nullable=True,
    )
    op.create_foreign_key(
        None,
        "portfolios",
        "investment_runs",
        ["investment_run_id"],
        ["id"],
        ondelete="CASCADE",
    )
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint(None, "portfolios", type_="foreignkey")
    op.alter_column(
        "investment_runs",
        "initial_portfolio",
        existing_type=mysql.JSON(),
        nullable=False,
    )
    # ### end Alembic commands ###
