"""add_investment_run_id


Revision ID: 339927587383
Revises: 5681095bfc27
Create Date: 2025-05-31 18:06:13.741056

"""

from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql

# revision identifiers, used by Alembic.
revision: str = "339927587383"
down_revision: Union[str, None] = "5681095bfc27"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "operations", sa.Column("investment_run_id", sa.BigInteger(), nullable=False)
    )
    op.create_foreign_key(
        None,
        "operations",
        "investment_runs",
        ["investment_run_id"],
        ["id"],
        ondelete="CASCADE",
    )
    op.drop_column("operations", "env")
    op.add_column(
        "portfolio_history",
        sa.Column("investment_run_id", sa.BigInteger(), nullable=False),
    )
    op.create_foreign_key(
        None,
        "portfolio_history",
        "investment_runs",
        ["investment_run_id"],
        ["id"],
        ondelete="CASCADE",
    )
    op.drop_column("portfolio_history", "env")
    op.add_column(
        "portfolios", sa.Column("investment_run_id", sa.BigInteger(), nullable=False)
    )
    op.drop_constraint("uq_portfolio_composite", "portfolios", type_="unique")
    op.create_unique_constraint(
        "uq_portfolio_composite", "portfolios", ["stock", "investment_run_id"]
    )
    op.create_foreign_key(
        None,
        "portfolios",
        "investment_runs",
        ["investment_run_id"],
        ["id"],
        ondelete="CASCADE",
    )
    op.drop_column("portfolios", "env")
    op.add_column(
        "transactions", sa.Column("investment_run_id", sa.BigInteger(), nullable=False)
    )
    op.create_foreign_key(
        None,
        "transactions",
        "investment_runs",
        ["investment_run_id"],
        ["id"],
        ondelete="CASCADE",
    )
    op.drop_column("transactions", "env")
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column(
        "transactions", sa.Column("env", mysql.VARCHAR(length=50), nullable=False)
    )
    op.drop_constraint(None, "transactions", type_="foreignkey")
    op.drop_column("transactions", "investment_run_id")
    op.add_column(
        "portfolios", sa.Column("env", mysql.VARCHAR(length=50), nullable=False)
    )
    op.drop_constraint(None, "portfolios", type_="foreignkey")
    op.drop_constraint("uq_portfolio_composite", "portfolios", type_="unique")
    op.create_unique_constraint(
        "uq_portfolio_composite", "portfolios", ["stock", "env"]
    )
    op.drop_column("portfolios", "investment_run_id")
    op.add_column(
        "portfolio_history", sa.Column("env", mysql.VARCHAR(length=50), nullable=False)
    )
    op.drop_constraint(None, "portfolio_history", type_="foreignkey")
    op.drop_column("portfolio_history", "investment_run_id")
    op.add_column(
        "operations", sa.Column("env", mysql.VARCHAR(length=50), nullable=False)
    )
    op.drop_constraint(None, "operations", type_="foreignkey")
    op.drop_column("operations", "investment_run_id")
    # ### end Alembic commands ###
