"""create_investment_run_and_portfolio_history

Revision ID: 5681095bfc27
Revises: c175e4a36d68
Create Date: 2025-05-31 12:56:05.041307

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '5681095bfc27'
down_revision: Union[str, None] = 'c175e4a36d68'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('portfolio_history',
    sa.Column('id', sa.BigInteger(), autoincrement=True, nullable=False),
    sa.Column('created_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('env', sa.String(length=50), nullable=False),
    sa.Column('portfolio', sa.JSON(), nullable=False),
    sa.Column('total_value', sa.Double(), nullable=False),
    sa.Column('total_cash', sa.Double(), nullable=False),
    sa.Column('total_cash_eur', sa.Double(), nullable=False),
    sa.Column('total_cash_usd', sa.Double(), nullable=False),
    sa.Column('total_portfolio_value', sa.Double(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_portfolio_history_id'), 'portfolio_history', ['id'], unique=False)
    op.create_table('investment_runs',
    sa.Column('id', sa.BigInteger(), autoincrement=True, nullable=False),
    sa.Column('created_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('env', sa.String(length=50), nullable=False),
    sa.Column('start_date', sa.Date(), nullable=False),
    sa.Column('end_date', sa.Date(), nullable=True),
    sa.Column('dataset_id', sa.BigInteger(), nullable=False),
    sa.Column('initial_investment', sa.Double(), nullable=False),
    sa.Column('portfolio_max_size', sa.Integer(), nullable=False),
    sa.Column('buffer_days_rebuy', sa.Integer(), nullable=False),
    sa.Column('initial_portfolio', sa.JSON(), nullable=False),
    sa.ForeignKeyConstraint(['dataset_id'], ['datasets.id'], ),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_investment_runs_id'), 'investment_runs', ['id'], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_investment_runs_id'), table_name='investment_runs')
    op.drop_table('investment_runs')
    op.drop_index(op.f('ix_portfolio_history_id'), table_name='portfolio_history')
    op.drop_table('portfolio_history')
    # ### end Alembic commands ###
