"""generalise_stock_to_group

Revision ID: c175e4a36d68
Revises: 6b6f2d38e9bc
Create Date: 2025-05-31 11:11:42.103206

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql

# revision identifiers, used by Alembic.
revision: str = 'c175e4a36d68'
down_revision: Union[str, None] = '6b6f2d38e9bc'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('datasets', sa.Column('number_of_groups', sa.Integer(), nullable=False))
    op.add_column('datasets', sa.Column('list_of_groups', sa.JSON(), nullable=False))
    op.drop_column('datasets', 'number_of_stocks')
    op.drop_column('datasets', 'list_of_companies')
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.add_column('datasets', sa.Column('list_of_companies', mysql.JSON(), nullable=False))
    op.add_column('datasets', sa.Column('number_of_stocks', mysql.INTEGER(), autoincrement=False, nullable=False))
    op.drop_column('datasets', 'list_of_groups')
    op.drop_column('datasets', 'number_of_groups')
    # ### end Alembic commands ###
