"""double_instead_of_float

Revision ID: 6b6f2d38e9bc
Revises: 25c227c684f8
Create Date: 2025-05-27 20:47:45.303669

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql

# revision identifiers, used by Alembic.
revision: str = '6b6f2d38e9bc'
down_revision: Union[str, None] = '25c227c684f8'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column('operations', 'price_in',
               existing_type=mysql.FLOAT(),
               type_=sa.Double(),
               existing_nullable=False)
    op.alter_column('operations', 'price_out',
               existing_type=mysql.FLOAT(),
               type_=sa.Double(),
               existing_nullable=False)
    op.alter_column('operations', 'pl',
               existing_type=mysql.FLOAT(),
               type_=sa.Double(),
               existing_nullable=False)
    op.alter_column('operations', 'cash',
               existing_type=mysql.FLOAT(),
               type_=sa.Double(),
               existing_nullable=False)
    op.alter_column('operations', 'portfolio_value',
               existing_type=mysql.FLOAT(),
               type_=sa.Double(),
               existing_nullable=False)
    op.alter_column('operations', 'total_value',
               existing_type=mysql.FLOAT(),
               type_=sa.Double(),
               existing_nullable=False)
    op.alter_column('operations', 'roi',
               existing_type=mysql.FLOAT(),
               type_=sa.Double(),
               existing_nullable=False)
    op.alter_column('operations', 'cumulated_roi',
               existing_type=mysql.FLOAT(),
               type_=sa.Double(),
               existing_nullable=False)
    op.alter_column('operations', 'cagr',
               existing_type=mysql.FLOAT(),
               type_=sa.Double(),
               existing_nullable=False)
    op.alter_column('portfolios', 'price_in',
               existing_type=mysql.FLOAT(),
               type_=sa.Double(),
               existing_nullable=False)
    op.alter_column('portfolios', 'value',
               existing_type=mysql.FLOAT(),
               type_=sa.Double(),
               existing_nullable=False)
    op.alter_column('transactions', 'price',
               existing_type=mysql.FLOAT(),
               type_=sa.Double(),
               existing_nullable=False)
    op.alter_column('transactions', 'value',
               existing_type=mysql.FLOAT(),
               type_=sa.Double(),
               existing_nullable=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column('transactions', 'value',
               existing_type=sa.Double(),
               type_=mysql.FLOAT(),
               existing_nullable=False)
    op.alter_column('transactions', 'price',
               existing_type=sa.Double(),
               type_=mysql.FLOAT(),
               existing_nullable=False)
    op.alter_column('portfolios', 'value',
               existing_type=sa.Double(),
               type_=mysql.FLOAT(),
               existing_nullable=False)
    op.alter_column('portfolios', 'price_in',
               existing_type=sa.Double(),
               type_=mysql.FLOAT(),
               existing_nullable=False)
    op.alter_column('operations', 'cagr',
               existing_type=sa.Double(),
               type_=mysql.FLOAT(),
               existing_nullable=False)
    op.alter_column('operations', 'cumulated_roi',
               existing_type=sa.Double(),
               type_=mysql.FLOAT(),
               existing_nullable=False)
    op.alter_column('operations', 'roi',
               existing_type=sa.Double(),
               type_=mysql.FLOAT(),
               existing_nullable=False)
    op.alter_column('operations', 'total_value',
               existing_type=sa.Double(),
               type_=mysql.FLOAT(),
               existing_nullable=False)
    op.alter_column('operations', 'portfolio_value',
               existing_type=sa.Double(),
               type_=mysql.FLOAT(),
               existing_nullable=False)
    op.alter_column('operations', 'cash',
               existing_type=sa.Double(),
               type_=mysql.FLOAT(),
               existing_nullable=False)
    op.alter_column('operations', 'pl',
               existing_type=sa.Double(),
               type_=mysql.FLOAT(),
               existing_nullable=False)
    op.alter_column('operations', 'price_out',
               existing_type=sa.Double(),
               type_=mysql.FLOAT(),
               existing_nullable=False)
    op.alter_column('operations', 'price_in',
               existing_type=sa.Double(),
               type_=mysql.FLOAT(),
               existing_nullable=False)
    # ### end Alembic commands ###
