"""fix_nb_character_on_portfolio


Revision ID: 40cbfc215f7c
Revises: b96396dcfaff
Create Date: 2025-05-27 13:37:18.291145

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa
from sqlalchemy.dialects import mysql

# revision identifiers, used by Alembic.
revision: str = '40cbfc215f7c'
down_revision: Union[str, None] = 'b96396dcfaff'
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.alter_column('portfolios', 'why_buy',
               existing_type=mysql.VARCHAR(length=50),
               type_=sa.String(length=255),
               existing_nullable=True)
    op.create_unique_constraint('uq_portfolio_composite', 'portfolios', ['stock', 'env'])
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_constraint('uq_portfolio_composite', 'portfolios', type_='unique')
    op.alter_column('portfolios', 'why_buy',
               existing_type=sa.String(length=255),
               type_=mysql.VARCHAR(length=50),
               existing_nullable=True)
    # ### end Alembic commands ###
