"""initial setup

Revision ID: 7390745388e4
Revises: 
Create Date: 2025-04-06 17:38:29.297967

"""
from typing import Sequence, Union

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = '7390745388e4'
down_revision: Union[str, None] = None
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.create_table('datas',
    sa.Column('id', sa.BigInteger(), autoincrement=True, nullable=False),
    sa.Column('created_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('date', sa.DateTime(), nullable=True),
    sa.Column('open', sa.Float(), nullable=True),
    sa.Column('high', sa.Float(), nullable=True),
    sa.Column('low', sa.Float(), nullable=True),
    sa.Column('close', sa.Float(), nullable=True),
    sa.Column('adjclose', sa.Float(), nullable=True),
    sa.Column('volume', sa.BigInteger(), nullable=True),
    sa.Column('stock', sa.String(length=50), nullable=True),
    sa.Column('isin', sa.String(length=50), nullable=True),
    sa.Column('security', sa.String(length=50), nullable=True),
    sa.Column('sector', sa.String(length=255), nullable=True),
    sa.Column('subindustry', sa.String(length=255), nullable=True),
    sa.Column('location', sa.String(length=255), nullable=True),
    sa.Column('vix_close', sa.Float(), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_datas_date'), 'datas', ['date'], unique=False)
    op.create_index(op.f('ix_datas_id'), 'datas', ['id'], unique=False)
    op.create_index(op.f('ix_datas_stock'), 'datas', ['stock'], unique=False)
    op.create_table('datasets',
    sa.Column('id', sa.BigInteger(), autoincrement=True, nullable=False),
    sa.Column('created_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('name', sa.String(length=50), nullable=False),
    sa.Column('path', sa.String(length=255), nullable=True),
    sa.Column('type', sa.String(length=50), nullable=False),
    sa.Column('size', sa.Integer(), nullable=False),
    sa.Column('train_size', sa.Integer(), nullable=False),
    sa.Column('val_size', sa.Integer(), nullable=True),
    sa.Column('test_size', sa.Integer(), nullable=False),
    sa.Column('number_of_stocks', sa.Integer(), nullable=False),
    sa.Column('list_of_companies', sa.JSON(), nullable=False),
    sa.Column('corr_threshold', sa.Float(), nullable=False),
    sa.Column('max_features', sa.Integer(), nullable=False),
    sa.Column('percentile', sa.Float(), nullable=False),
    sa.Column('start_date', sa.DateTime(), nullable=False),
    sa.Column('end_date', sa.DateTime(), nullable=False),
    sa.Column('train_start_date', sa.DateTime(), nullable=False),
    sa.Column('train_end_date', sa.DateTime(), nullable=False),
    sa.Column('val_start_date', sa.DateTime(), nullable=True),
    sa.Column('val_end_date', sa.DateTime(), nullable=True),
    sa.Column('test_start_date', sa.DateTime(), nullable=False),
    sa.Column('test_end_date', sa.DateTime(), nullable=False),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('name', name='uq_datasets_composite')
    )
    op.create_index(op.f('ix_datasets_id'), 'datasets', ['id'], unique=False)
    op.create_table('features',
    sa.Column('id', sa.BigInteger(), autoincrement=True, nullable=False),
    sa.Column('created_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('name', sa.String(length=50), nullable=False),
    sa.Column('type', sa.String(length=50), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('name')
    )
    op.create_index(op.f('ix_features_id'), 'features', ['id'], unique=False)
    op.create_table('models',
    sa.Column('id', sa.BigInteger(), autoincrement=True, nullable=False),
    sa.Column('created_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('name', sa.String(length=50), nullable=False),
    sa.Column('type', sa.String(length=50), nullable=False),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('name', 'type', name='uq_model_composite')
    )
    op.create_index(op.f('ix_models_id'), 'models', ['id'], unique=False)
    op.create_table('operations',
    sa.Column('id', sa.BigInteger(), autoincrement=True, nullable=False),
    sa.Column('created_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('stock', sa.String(length=50), nullable=False),
    sa.Column('price_in', sa.Float(), nullable=False),
    sa.Column('date_in', sa.Date(), nullable=False),
    sa.Column('why_buy', sa.String(length=50), nullable=True),
    sa.Column('price_out', sa.Float(), nullable=False),
    sa.Column('date_out', sa.Date(), nullable=False),
    sa.Column('why_sell', sa.String(length=50), nullable=True),
    sa.Column('pl', sa.Float(), nullable=False),
    sa.Column('cash', sa.Float(), nullable=False),
    sa.Column('portfolio_value', sa.Float(), nullable=False),
    sa.Column('total_value', sa.Float(), nullable=False),
    sa.Column('roi', sa.Float(), nullable=False),
    sa.Column('cumulated_roi', sa.Float(), nullable=False),
    sa.Column('cagr', sa.Float(), nullable=False),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_operations_id'), 'operations', ['id'], unique=False)
    op.create_table('portfolios',
    sa.Column('id', sa.BigInteger(), autoincrement=True, nullable=False),
    sa.Column('created_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('stock', sa.String(length=50), nullable=False),
    sa.Column('position', sa.Integer(), nullable=False),
    sa.Column('price_in', sa.Float(), nullable=False),
    sa.Column('value', sa.Float(), nullable=False),
    sa.Column('date_in', sa.Date(), nullable=False),
    sa.Column('why_buy', sa.String(length=50), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_portfolios_id'), 'portfolios', ['id'], unique=False)
    op.create_table('targets',
    sa.Column('id', sa.BigInteger(), autoincrement=True, nullable=False),
    sa.Column('created_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('name', sa.String(length=50), nullable=False),
    sa.Column('type', sa.String(length=50), nullable=False),
    sa.Column('description', sa.String(length=255), nullable=True),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('name', 'type', name='uq_target_composite')
    )
    op.create_index(op.f('ix_targets_id'), 'targets', ['id'], unique=False)
    op.create_table('transactions',
    sa.Column('id', sa.BigInteger(), autoincrement=True, nullable=False),
    sa.Column('created_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('buy_sell', sa.String(length=50), nullable=False),
    sa.Column('stock', sa.String(length=50), nullable=False),
    sa.Column('price', sa.Float(), nullable=False),
    sa.Column('position', sa.Integer(), nullable=False),
    sa.Column('value', sa.Float(), nullable=False),
    sa.Column('date', sa.Date(), nullable=False),
    sa.Column('why', sa.String(length=50), nullable=True),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_transactions_id'), 'transactions', ['id'], unique=False)
    op.create_table('dataset_target_association',
    sa.Column('dataset_id', sa.BigInteger(), nullable=False),
    sa.Column('target_id', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['dataset_id'], ['datasets.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['target_id'], ['targets.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('dataset_id', 'target_id')
    )
    op.create_table('feature_selections',
    sa.Column('id', sa.BigInteger(), autoincrement=True, nullable=False),
    sa.Column('created_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('training_time', sa.Integer(), nullable=True),
    sa.Column('best_features_path', sa.String(length=255), nullable=True),
    sa.Column('dataset_id', sa.BigInteger(), nullable=False),
    sa.Column('target_id', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['dataset_id'], ['datasets.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['target_id'], ['targets.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('dataset_id', 'target_id', name='uq_feature_selection_composite')
    )
    op.create_index(op.f('ix_feature_selections_id'), 'feature_selections', ['id'], unique=False)
    op.create_table('model_selections',
    sa.Column('id', sa.BigInteger(), autoincrement=True, nullable=False),
    sa.Column('created_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('best_model_params', sa.JSON(), nullable=True),
    sa.Column('best_model_path', sa.String(length=255), nullable=True),
    sa.Column('best_model_id', sa.BigInteger(), nullable=True),
    sa.Column('target_id', sa.BigInteger(), nullable=False),
    sa.Column('dataset_id', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['best_model_id'], ['models.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['dataset_id'], ['datasets.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['target_id'], ['targets.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('target_id', 'dataset_id', name='uq_model_selection_composite')
    )
    op.create_index(op.f('ix_model_selections_id'), 'model_selections', ['id'], unique=False)
    op.create_table('feature_selection_association',
    sa.Column('feature_selection_id', sa.BigInteger(), nullable=False),
    sa.Column('feature_id', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['feature_id'], ['features.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['feature_selection_id'], ['feature_selections.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('feature_selection_id', 'feature_id')
    )
    op.create_table('feature_selection_ranks',
    sa.Column('id', sa.BigInteger(), autoincrement=True, nullable=False),
    sa.Column('created_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('score', sa.Float(), nullable=True),
    sa.Column('pvalue', sa.Float(), nullable=True),
    sa.Column('support', sa.Integer(), nullable=True),
    sa.Column('rank', sa.Integer(), nullable=True),
    sa.Column('method', sa.String(length=50), nullable=True),
    sa.Column('training_time', sa.Integer(), nullable=True),
    sa.Column('feature_id', sa.BigInteger(), nullable=True),
    sa.Column('feature_selection_id', sa.BigInteger(), nullable=True),
    sa.ForeignKeyConstraint(['feature_id'], ['features.id'], ondelete='CASCADE'),
    sa.ForeignKeyConstraint(['feature_selection_id'], ['feature_selections.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('feature_id', 'feature_selection_id', 'method', name='uq_feature_selection_rank_composite')
    )
    op.create_index(op.f('ix_feature_selection_ranks_id'), 'feature_selection_ranks', ['id'], unique=False)
    op.create_table('model_trainings',
    sa.Column('id', sa.BigInteger(), autoincrement=True, nullable=False),
    sa.Column('created_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('best_params', sa.JSON(), nullable=True),
    sa.Column('model_path', sa.String(length=255), nullable=True),
    sa.Column('training_time', sa.Integer(), nullable=True),
    sa.Column('model_id', sa.BigInteger(), nullable=False),
    sa.Column('model_selection_id', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['model_id'], ['models.id'], ),
    sa.ForeignKeyConstraint(['model_selection_id'], ['model_selections.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id'),
    sa.UniqueConstraint('model_id', 'model_selection_id', name='uq_model_training_composite')
    )
    op.create_index(op.f('ix_model_trainings_id'), 'model_trainings', ['id'], unique=False)
    op.create_table('scores',
    sa.Column('id', sa.BigInteger(), autoincrement=True, nullable=False),
    sa.Column('created_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('updated_at', sa.TIMESTAMP(timezone=True), server_default=sa.text('now()'), nullable=False),
    sa.Column('type', sa.String(length=50), nullable=False),
    sa.Column('training_time', sa.Integer(), nullable=True),
    sa.Column('eval_data_std', sa.Float(), nullable=True),
    sa.Column('rmse', sa.Float(), nullable=True),
    sa.Column('rmse_std_ratio', sa.Float(), nullable=True),
    sa.Column('mae', sa.Float(), nullable=True),
    sa.Column('mape', sa.Float(), nullable=True),
    sa.Column('mam', sa.Float(), nullable=True),
    sa.Column('mad', sa.Float(), nullable=True),
    sa.Column('mae_mam_ratio', sa.Float(), nullable=True),
    sa.Column('mae_mad_ratio', sa.Float(), nullable=True),
    sa.Column('r2', sa.Float(), nullable=True),
    sa.Column('logloss', sa.Float(), nullable=True),
    sa.Column('accuracy', sa.Float(), nullable=True),
    sa.Column('precision', sa.Float(), nullable=True),
    sa.Column('recall', sa.Float(), nullable=True),
    sa.Column('f1', sa.Float(), nullable=True),
    sa.Column('roc_auc', sa.Float(), nullable=True),
    sa.Column('threshold', sa.Float(), nullable=True),
    sa.Column('precision_at_threshold', sa.Float(), nullable=True),
    sa.Column('recall_at_threshold', sa.Float(), nullable=True),
    sa.Column('model_training_id', sa.BigInteger(), nullable=False),
    sa.ForeignKeyConstraint(['model_training_id'], ['model_trainings.id'], ondelete='CASCADE'),
    sa.PrimaryKeyConstraint('id')
    )
    op.create_index(op.f('ix_scores_id'), 'scores', ['id'], unique=False)
    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    op.drop_index(op.f('ix_scores_id'), table_name='scores')
    op.drop_table('scores')
    op.drop_index(op.f('ix_model_trainings_id'), table_name='model_trainings')
    op.drop_table('model_trainings')
    op.drop_index(op.f('ix_feature_selection_ranks_id'), table_name='feature_selection_ranks')
    op.drop_table('feature_selection_ranks')
    op.drop_table('feature_selection_association')
    op.drop_index(op.f('ix_model_selections_id'), table_name='model_selections')
    op.drop_table('model_selections')
    op.drop_index(op.f('ix_feature_selections_id'), table_name='feature_selections')
    op.drop_table('feature_selections')
    op.drop_table('dataset_target_association')
    op.drop_index(op.f('ix_transactions_id'), table_name='transactions')
    op.drop_table('transactions')
    op.drop_index(op.f('ix_targets_id'), table_name='targets')
    op.drop_table('targets')
    op.drop_index(op.f('ix_portfolios_id'), table_name='portfolios')
    op.drop_table('portfolios')
    op.drop_index(op.f('ix_operations_id'), table_name='operations')
    op.drop_table('operations')
    op.drop_index(op.f('ix_models_id'), table_name='models')
    op.drop_table('models')
    op.drop_index(op.f('ix_features_id'), table_name='features')
    op.drop_table('features')
    op.drop_index(op.f('ix_datasets_id'), table_name='datasets')
    op.drop_table('datasets')
    op.drop_index(op.f('ix_datas_stock'), table_name='datas')
    op.drop_index(op.f('ix_datas_id'), table_name='datas')
    op.drop_index(op.f('ix_datas_date'), table_name='datas')
    op.drop_table('datas')
    # ### end Alembic commands ###
