# Создатель презентаций NanoFootball.com

Формирует из `dict` объекта упражнения, тренировки или события презентацию PowerPoint, которую получит пользователь. Требует около трех секунд на одно упражнение. Таким образом создание презентации из шести упражнений займет 10-20 секунд.

# Установка

## Для Линукс систем

    pip install nf_presentation

## Для Виндоус систем

На данный момент pipwin перестал работать, так что установка кринжеватая. Но быстрая:

Сначала установим библиотеку `cairocffi`, которую нужно скачать вручную с http://www.lfd.uci.edu/~gohlke/pythonlibs/#cairocffi

Выбрать под свою версию питона, например `cairocffi‑1.3.0‑cp310‑cp310‑win_amd64.whl` (для систем х64 и питона 3.10(это можно узнать по записи `cp310`)) 

    pip install cairocffi‑1.3.0‑cp310‑cp310‑win_amd64.whl //или другой ваш файл
    pip install nf_presentation

Проверить, что все установилось можно так:

    python 

    >> import nf_presentation

Если все прошло гладко, значит ты молодец, установка прошла успешно. В противном случае вылезет такая ошибка

    OSError: no library called "cairo-2" was found
    no library called "cairo" was found
    no library called "libcairo-2" was found
    cannot load library 'libcairo.so.2': error 0x7e
    cannot load library 'libcairo.2.dylib': error 0x7e
    cannot load library 'libcairo-2.dll': error 0x7e

Значит `cairocffi` все еще неправильно установлена, попробуй удалить ее `pip uninstall cairocffi` и попробуй еще раз. И да прибудет с тобой сила

# Использование

Базовый код выглядит так:

    import nf_presentation

    # для тренировки
    pptx_bytes= nf_presentation.from_training(input_data=training_data_dict)
    # для события
    pptx_bytes= nf_presentation.from_event(input_data=event_data_dict)
    # или для одного упражнения
    pptx_bytes= nf_presentation.from_single_exercise(
        input_data=exercise_data_dict,
        render_options={
            'scheme_1':True,
            'scheme_2':False,
            'video_1':True,
            'video_2':False,
            'animation_1':True
            })

    response=HttpResponse(pptx_bytes, content-type='application/vnd.ms-powerpoint'
    resonse['Content-Disposition']='attachement;filename="out.pptx"'
    return response

`pptx_bytes` это массив байтов, которые уже можно передать пользователям NanoFootball

## Запись в файл или поток

Для работы локально иногда может потребовать записать данные файл, для этого достаточно добавить аргумент `output_file`.

    import nf_presentation
    
    nf_presentation.from_training(input_data=training_data_dict, output_file='out.pptx')

Теперь `create_pptx()` вернет None

## Тестовые данные

В пакет встроенны тестовые данные, и работоспособность пакета можно указав `input_data='test'`

    import nf_presentation

    pptx_bytes= nf_presentation.from_training(input_data='test')
    # или для одного упражнения
    pptx_bytes= nf_presentation.from_singe_exercise(input_data='test')

Для вывода во временный файл достаточно назначить аргумент `output_file` вывода во временный файл можно использовать поток, как в примере выше

    import nf_presentation

    nf_presentation.from_singe_exercise(output_file='from_test_data.pptx')

# Тестирование

В корневой скачанной папке запустить `python -m unittest`

# Проблемы

1. Больше всего времени уходит на создание схемы. А все потому что он выкачивает из интернета ссылки на файлы, если бы я знал, где локально хранятся файлы, это можно было бы в разы ускорить
2. Описание пока вообще не рендерится
3. Упражнения которые приходят из событий по структуре отличаются от упражнений в списке упражнений


## TODO

1. [x] починил схему в упражнении http://nanofootball.com/exercises/exercise?id=9793&nfb=1&type=nfb_folders
   1. [ ] отловил похожие ошибки с полигонами
      1. [x] 2675
      2. [ ] 
   2. [ ] Побавить замены в схемах по regex,
      1. [ ] для ворот, а может быть для всех картинок вообще добавить preserverAspectRatio
      2. [ ] для fill
2. [ ] Скачивание должно стоять и внутри упражнения тоже
4. [ ] Использование анимаций в from_event()
   1. [ ] Можно ли получить исходный формат exercise_info как в nanofootball.com/exercises
16. [ ] Цели в левой таблице-> текст по центру колонки
17. [ ] Слайды создаются из двустороннего шаблона
18. [ ] Цвета
19. [ ] Cоздать презентацию для каждого упражнения, дабы отловить возможные ошибки
20. [ ] Показывать ошибку, если файл не найдеy в assets, и картинка по умолчанию)

## Текущие проблемы

Некоторые схемы получаются искаженными, даже в упражнении из тестовых данных. Там одни из ворот почему-то вытянуты по диагонали. Слава богу, в похожей схеме из другого упражнения все нормально. Так что сравнив схемы там и там, можно решить проблему

В данный момент изображения создаются из других изображений(ворот, игроков и прочее). И эти ворота игроки скачиваются из интернета. Было бы неплохо, если бы можно было искать эти файлы локально, на сервере. Это помогло бы ускорить процесс. 

### Битый SVG

В аттрибуте shchemeData упражения хранится svg фай схемы. Можно было бы легко пользоваться этими свг, и переделать их в пнг. Но есть проблема. Эти SVG битые. 

Аттрибуты записаны некорректно. То есть с точки зрения браузера они написаны верно, а с точки зрения форматирования svg - нет. Дело в том, что для браузера не существует различий между прописными с строчными буквами, например viewBox и viewbox для браузера выглядят одинаково, но для любой программы читающей изображения(в том числе cairoSVG) viewbox без большой буквы будет считаться ошибкой и пропущен обработчиком.

Поэтому важно поправить данные полях схем, перед передачей в субпрограмму, которая из этой свг сделает PNG
> При обработке SVG данных из schemeData упражнения будут сделаны такие замены
> 1. viewbox -> viewBox
> 2. markerwidth -> markerWidth
> 3. refx -> refX
> 4. к некоторым внешним svg приписывается параметр preserveAspectRatio, чтобы они правильно отображались
> 5. строки типа style='...; fill="$0000000a1"' cairo не читает, цвет и прорачность выносится за тег style, можно использовать формат записи такой style="... fill: rgba(255, 255, 0, 0.1)", его каиро понимает
> 4. ...
> 
> Все такие замены набиваются руками и лежат в nf_presentation.settings.svg_replacements
> так же можно воспользоваться фукцией nf_presentation.settings.add_svg_replacement(old,fix), чтобы добавить новую подстановку. Потому что в дальнейшем список таких замен будет только расширяться, и если картинка на выходе не совсем походит на ту, что на сайте, скорее всего нужно поправить какой-то битый аттрибут.



### Зависимости SVG

В каждой картинке схемы из базы данных хранится ссылки на другие файлы, к счастью CairoSVG может использовать веб ссылки для картинок, чтобы создать потом png файл

> При обрботке svg схемы все ссылки /static/schemeDrawer/img/... будут заменяться на http://nanofootball.com/static/schemeDrawer/img/...
> 
> Подразумевается что все картинки доступны по адресу http://nanofootball.com/static/schemeDrawer/img/...

### Зависимости перекодировщика SVG -> PNG 

Модуль cairosvg, который собсно и перегружает картинки имеет в зависимостях cairocffi, которые на виндоус надо устанавливать отдельно, а в линуксе пока вообще хз что. Кажется это довольно грузная зависимость для сервера NF

> В данный момент подразумевается, что при установке пакета nf-presentation устанавливается CairoSVG, которая в свою очередь автоматически установит cairocffi на линкус систему. Подразумевается, что наш НФ сервер работает на линуксе