# -*- coding: utf-8 -*-
# Copyright 2022 Kristo Mela
# This source code is licensed under the MIT license. See LICENSE in the repository root directory.
# Author(s): Kristo Mela

# Materials [MPa] [kg/mm^3], SFS EN 1993-1-1, table 3.1, EN 10025-2
# Thickness <= 40 mm
mat = {"S235": {"f_y": 235.0, "f_u": 360.0, "E": 210000.0, "v": 0.3, "rho": 7850e-9},
       "S275": {"f_y": 275.0, "f_u": 430.0, "E": 210000.0, "v": 0.3, "rho": 7850e-9},
       "S355": {"f_y": 355.0, "f_u": 510.0, "E": 210000.0, "v": 0.3, "rho": 7850e-9},
       "S420": {"f_y": 420.0, "f_u": 500.0, "E": 210000.0, "v": 0.3, "rho": 7850e-9},
       "S355MC": {"f_y": 355.0, "f_u": 430.0, "E": 210000.0, "v": 0.3, "rho": 7850e-9},
       "S500MC": {"f_y": 500.0, "f_u": 550.0, "E": 210000.0, "v": 0.3, "rho": 7850e-9},
       "S700MC": {"f_y": 700.0, "f_u": 750.0, "E": 210000.0, "v": 0.3, "rho": 7850e-9},
       "S355ML": {"f_y": 355.0, "f_u": 470.0, "E": 210000.0, "v": 0.3, "rho": 7850e-9},
       "S500ML": {"f_y": 500.0, "f_u": 570.0, "E": 210000.0, "v": 0.3, "rho": 7850e-9},
       "S700E/F": {"f_y": 700.0, "f_u": 780.0, "E": 210000.0, "v": 0.3, "rho": 7850e-9},
       }


# sizes [mm]
profile = {"IPE 80": {"h": 80.0, "b": 46.0, "t_w": 3.8, "t_f": 5.2, "r": 5.0},
           "IPE 100": {"h": 100.0, "b": 55.0, "t_w": 4.1, "t_f": 5.7, "r": 7.0},
           "IPE 120": {"h": 120.0, "b": 64.0, "t_w": 4.4, "t_f": 6.3, "r": 7.0},
           "IPE 140": {"h": 140.0, "b": 73.0, "t_w": 4.7, "t_f": 6.9, "r": 7.0},
           "IPE 160": {"h": 160.0, "b": 82.0, "t_w": 5.0, "t_f": 7.4, "r": 9.0},
           "IPE 180": {"h": 180.0, "b": 91.0, "t_w": 5.3, "t_f": 8.0, "r": 9.0},
           "IPE 200": {"h": 200.0, "b": 100.0, "t_w": 5.6, "t_f": 8.5, "r": 12.0},
           "IPE 220": {"h": 220.0, "b": 110.0, "t_w": 5.9, "t_f": 9.2, "r": 12.0},
           "IPE 240": {"h": 240.0, "b": 120.0, "t_w": 6.2, "t_f": 9.8, "r": 15.0},
           "IPE 270": {"h": 270.0, "b": 135.0, "t_w": 6.6, "t_f": 10.2, "r": 15.0},
           "IPE 300": {"h": 300.0, "b": 150.0, "t_w": 7.1, "t_f": 10.7, "r": 15.0},
           "IPE 330": {"h": 330.0, "b": 160.0, "t_w": 7.5, "t_f": 11.5, "r": 18.0},
           "IPE 360": {"h": 360.0, "b": 170.0, "t_w": 8.0, "t_f": 12.7, "r": 18.0},
           "IPE 400": {"h": 400.0, "b": 180.0, "t_w": 8.6, "t_f": 13.5, "r": 21.0},
           "IPE 450": {"h": 450.0, "b": 190.0, "t_w": 9.4, "t_f": 14.6, "r": 21.0},
           "IPE 500": {"h": 500.0, "b": 200.0, "t_w": 10.2, "t_f": 16.0, "r": 21.0},
           "IPE 550": {"h": 550.0, "b": 210.0, "t_w": 11.1, "t_f": 17.2, "r": 24.0},
           "IPE 600": {"h": 600.0, "b": 220.0, "t_w": 12.0, "t_f": 19.0, "r": 24.0},
           "IPE 750": {"h": 750.0, "b": 264.0, "t_w": 12.0, "t_f": 15.5, "r": 17.0},
           "HE 100 AA": {"h": 91.0, "b": 100.0, "t_w": 4.2, "t_f": 5.5, "r": 12.0},
           "HE 100 A": {"h": 96.0, "b": 100.0, "t_w": 5.0, "t_f": 8.0, "r": 12.0},
           "HE 100 B": {"h": 100.0, "b": 100.0, "t_w": 6.0, "t_f": 10.0, "r": 12.0},
           "HE 100 C": {"h": 110.0, "b": 103.0, "t_w": 9.0, "t_f": 15.0, "r": 12.0},
           "HE 100 M": {"h": 120.0, "b": 106.0, "t_w": 12.0, "t_f": 20.0, "r": 12.0},
           "HE 120 AA": {"h": 109.0, "b": 120.0, "t_w": 4.2, "t_f": 5.5, "r": 12.0},
           "HE 120 A": {"h": 114.0, "b": 120.0, "t_w": 5.0, "t_f": 8.0, "r": 12.0},
           "HE 120 B": {"h": 120.0, "b": 120.0, "t_w": 6.5, "t_f": 11.0, "r": 12.0},
           "HE 120 C": {"h": 130.0, "b": 123.0, "t_w": 9.5, "t_f": 16.0, "r": 12.0},
           "HE 120 M": {"h": 140.0, "b": 126.0, "t_w": 12.5, "t_f": 21.0, "r": 12.0},
           "HE 140 AA": {"h": 128.0, "b": 140.0, "t_w": 4.3, "t_f": 6.0, "r": 12.0},
           "HE 140 A": {"h": 133.0, "b": 140.0, "t_w": 5.5, "t_f": 8.5, "r": 12.0},
           "HE 140 B": {"h": 140.0, "b": 140.0, "t_w": 7.0, "t_f": 12.0, "r": 12.0},
           "HE 140 C": {"h": 150.0, "b": 143.0, "t_w": 10.0, "t_f": 17.0, "r": 12.0},
           "HE 140 M": {"h": 160.0, "b": 146.0, "t_w": 13.0, "t_f": 22.0, "r": 12.0},
           "HE 160 AA": {"h": 148.0, "b": 160.0, "t_w": 4.5, "t_f": 7.0, "r": 15.0},
           "HE 160 A": {"h": 152.0, "b": 160.0, "t_w": 6.0, "t_f": 9.0, "r": 15.0},
           "HE 160 B": {"h": 160.0, "b": 160.0, "t_w": 8.0, "t_f": 13.0, "r": 15.0},
           "HE 160 C": {"h": 170.0, "b": 163.0, "t_w": 11.0, "t_f": 18.0, "r": 15.0},
           "HE 160 M": {"h": 180.0, "b": 166.0, "t_w": 14.0, "t_f": 23.0, "r": 15.0},
           "HE 180 AA": {"h": 167.0, "b": 180.0, "t_w": 5.0, "t_f": 7.5, "r": 15.0},
           "HE 180 A": {"h": 171.0, "b": 180.0, "t_w": 6.0, "t_f": 9.5, "r": 15.0},
           "HE 180 B": {"h": 180.0, "b": 180.0, "t_w": 8.5, "t_f": 14.0, "r": 15.0},
           "HE 180 C": {"h": 190.0, "b": 183.0, "t_w": 11.5, "t_f": 19.0, "r": 15.0},
           "HE 180 M": {"h": 200.0, "b": 186.0, "t_w": 14.5, "t_f": 24.0, "r": 15.0},
           "HE 200 AA": {"h": 186.0, "b": 200.0, "t_w": 5.5, "t_f": 8.0, "r": 18.0},
           "HE 200 A": {"h": 190.0, "b": 200.0, "t_w": 6.5, "t_f": 10.0, "r": 18.0},
           "HE 200 B": {"h": 200.0, "b": 200.0, "t_w": 9.0, "t_f": 15.0, "r": 18.0},
           "HE 200 C": {"h": 210.0, "b": 203.0, "t_w": 12.0, "t_f": 20.0, "r": 18.0},
           "HE 200 M": {"h": 220.0, "b": 206.0, "t_w": 15.0, "t_f": 25.0, "r": 18.0},
           "HE 220 AA": {"h": 205.0, "b": 220.0, "t_w": 6.0, "t_f": 8.5, "r": 18.0},
           "HE 220 A": {"h": 210.0, "b": 220.0, "t_w": 7.0, "t_f": 11.0, "r": 18.0},
           "HE 220 B": {"h": 220.0, "b": 220.0, "t_w": 9.5, "t_f": 16.0, "r": 18.0},
           "HE 220 C": {"h": 230.0, "b": 223.0, "t_w": 12.5, "t_f": 21.0, "r": 18.0},
           "HE 220 M": {"h": 240.0, "b": 226.0, "t_w": 15.5, "t_f": 26.0, "r": 18.0},
           "HE 240 AA": {"h": 224.0, "b": 240.0, "t_w": 6.5, "t_f": 9.0, "r": 21.0},
           "HE 240 A": {"h": 230.0, "b": 240.0, "t_w": 7.5, "t_f": 12.0, "r": 21.0},
           "HE 240 B": {"h": 240.0, "b": 240.0, "t_w": 10.0, "t_f": 17.0, "r": 21.0},
           "HE 240 C": {"h": 255.0, "b": 244.0, "t_w": 14.0, "t_f": 24.5, "r": 21.0},
           "HE 240 M": {"h": 270.0, "b": 248.0, "t_w": 18.0, "t_f": 32.0, "r": 21.0},
           "HE 260 AA": {"h": 244.0, "b": 260.0, "t_w": 6.5, "t_f": 9.5, "r": 24.0},
           "HE 260 A": {"h": 250.0, "b": 260.0, "t_w": 7.5, "t_f": 12.5, "r": 24.0},
           "HE 260 B": {"h": 260.0, "b": 260.0, "t_w": 10.0, "t_f": 17.5, "r": 24.0},
           "HE 260 C": {"h": 275.0, "b": 264.0, "t_w": 14.0, "t_f": 25.0, "r": 24.0},
           "HE 260 M": {"h": 290.0, "b": 268.0, "t_w": 18.0, "t_f": 32.5, "r": 24.0},
           "HE 280 AA": {"h": 264.0, "b": 280.0, "t_w": 7.0, "t_f": 10.0, "r": 24.0},
           "HE 280 A": {"h": 270.0, "b": 280.0, "t_w": 8.0, "t_f": 13.0, "r": 24.0},
           "HE 280 B": {"h": 280.0, "b": 280.0, "t_w": 10.5, "t_f": 18.0, "r": 24.0},
           "HE 280 C": {"h": 295.0, "b": 284.0, "t_w": 14.5, "t_f": 25.5, "r": 24.0},
           "HE 280 M": {"h": 310.0, "b": 288.0, "t_w": 18.5, "t_f": 33.0, "r": 24.0},
           "HE 300 AA": {"h": 283.0, "b": 300.0, "t_w": 7.5, "t_f": 10.5, "r": 27.0},
           "HE 300 A": {"h": 290.0, "b": 300.0, "t_w": 8.5, "t_f": 14.0, "r": 27.0},
           "HE 300 B": {"h": 300.0, "b": 300.0, "t_w": 11.0, "t_f": 19.0, "r": 27.0},
           "HE 300 C": {"h": 320.0, "b": 305.0, "t_w": 16.0, "t_f": 29.0, "r": 27.0},
           "HE 300 M": {"h": 340.0, "b": 310.0, "t_w": 21.0, "t_f": 39.0, "r": 27.0},
           "HE 320 AA": {"h": 301.0, "b": 300.0, "t_w": 8.0, "t_f": 11.0, "r": 27.0},
           "HE 320 A": {"h": 310.0, "b": 300.0, "t_w": 9.0, "t_f": 15.5, "r": 27.0},
           "HE 320 B": {"h": 320.0, "b": 300.0, "t_w": 11.5, "t_f": 20.5, "r": 27.0},
           "HE 320 C": {"h": 340.0, "b": 305.0, "t_w": 16.0, "t_f": 30.5, "r": 27.0},
           "HE 320 M": {"h": 359.0, "b": 309.0, "t_w": 21.0, "t_f": 40.0, "r": 27.0},
           "HE 340 AA": {"h": 320.0, "b": 300.0, "t_w": 8.5, "t_f": 11.5, "r": 27.0},
           "HE 340 A": {"h": 330.0, "b": 300.0, "t_w": 9.5, "t_f": 16.5, "r": 27.0},
           "HE 340 B": {"h": 340.0, "b": 300.0, "t_w": 12.0, "t_f": 21.5, "r": 27.0},
           "HE 340 M": {"h": 377.0, "b": 309.0, "t_w": 21.0, "t_f": 40.0, "r": 27.0},
           "HE 360 AA": {"h": 339.0, "b": 300.0, "t_w": 9.0, "t_f": 12.0, "r": 27.0},
           "HE 360 A": {"h": 350.0, "b": 300.0, "t_w": 10.0, "t_f": 17.5, "r": 27.0},
           "HE 360 B": {"h": 360.0, "b": 300.0, "t_w": 12.5, "t_f": 22.5, "r": 27.0},
           "HE 360 M": {"h": 395.0, "b": 308.0, "t_w": 21.0, "t_f": 40.0, "r": 27.0},
           "HE 400 AA": {"h": 378.0, "b": 300.0, "t_w": 9.5, "t_f": 13.0, "r": 27.0},
           "HE 400 A": {"h": 390.0, "b": 300.0, "t_w": 11.0, "t_f": 19.0, "r": 27.0},
           "HE 400 B": {"h": 400.0, "b": 300.0, "t_w": 13.5, "t_f": 24.0, "r": 27.0},
           "HE 400 M": {"h": 432.0, "b": 307.0, "t_w": 21.0, "t_f": 40.0, "r": 27.0},
           "HE 450 AA": {"h": 425.0, "b": 300.0, "t_w": 10.0, "t_f": 13.5, "r": 27.0},
           "HE 450 A": {"h": 440.0, "b": 300.0, "t_w": 11.5, "t_f": 21.0, "r": 27.0},
           "HE 450 B": {"h": 450.0, "b": 300.0, "t_w": 14.0, "t_f": 26.0, "r": 27.0},
           "HE 450 M": {"h": 478.0, "b": 307.0, "t_w": 21.0, "t_f": 40.0, "r": 27.0},
           "HE 500 AA": {"h": 472.0, "b": 300.0, "t_w": 10.5, "t_f": 14.0, "r": 27.0},
           "HE 500 A": {"h": 490.0, "b": 300.0, "t_w": 12.0, "t_f": 23.0, "r": 27.0},
           "HE 500 B": {"h": 500.0, "b": 300.0, "t_w": 14.5, "t_f": 28.0, "r": 27.0},
           "HE 500 M": {"h": 524.0, "b": 306.0, "t_w": 21.0, "t_f": 40.0, "r": 27.0},
           "HE 550 AA": {"h": 522.0, "b": 300.0, "t_w": 11.5, "t_f": 15.0, "r": 27.0},
           "HE 550 A": {"h": 540.0, "b": 300.0, "t_w": 12.5, "t_f": 24.0, "r": 27.0},
           "HE 550 B": {"h": 550.0, "b": 300.0, "t_w": 15.0, "t_f": 29.0, "r": 27.0},
           "HE 550 M": {"h": 572.0, "b": 306.0, "t_w": 21.0, "t_f": 40.0, "r": 27.0},
           "HE 600 AA": {"h": 571.0, "b": 300.0, "t_w": 12.0, "t_f": 15.5, "r": 27.0},
           "HE 600 A": {"h": 590.0, "b": 300.0, "t_w": 13.0, "t_f": 25.0, "r": 27.0},
           "HE 600 B": {"h": 600.0, "b": 300.0, "t_w": 15.5, "t_f": 30.0, "r": 27.0},
           "HE 600 M": {"h": 620.0, "b": 305.0, "t_w": 21.0, "t_f": 40.0, "r": 27.0},
           "HE 650 AA": {"h": 620.0, "b": 300.0, "t_w": 12.5, "t_f": 16.0, "r": 27.0},
           "HE 650 A": {"h": 640.0, "b": 300.0, "t_w": 13.5, "t_f": 26.0, "r": 27.0},
           "HE 650 B": {"h": 650.0, "b": 300.0, "t_w": 16.0, "t_f": 31.0, "r": 27.0},
           "HE 650 M": {"h": 668.0, "b": 305.0, "t_w": 21.0, "t_f": 40.0, "r": 27.0},
           "HE 700 AA": {"h": 670.0, "b": 300.0, "t_w": 13.0, "t_f": 17.0, "r": 27.0},
           "HE 700 A": {"h": 690.0, "b": 300.0, "t_w": 14.5, "t_f": 27.0, "r": 27.0},
           "HE 700 B": {"h": 700.0, "b": 300.0, "t_w": 17.0, "t_f": 32.0, "r": 27.0},
           "HE 700 M": {"h": 716.0, "b": 304.0, "t_w": 21.0, "t_f": 40.0, "r": 27.0},
           "HE 800 AA": {"h": 770.0, "b": 300.0, "t_w": 14.0, "t_f": 18.0, "r": 30.0},
           "HE 800 A": {"h": 790.0, "b": 300.0, "t_w": 15.0, "t_f": 28.0, "r": 30.0},
           "HE 800 B": {"h": 800.0, "b": 300.0, "t_w": 17.5, "t_f": 33.0, "r": 30.0},
           "HE 800 M": {"h": 814.0, "b": 303.0, "t_w": 21.0, "t_f": 40.0, "r": 30.0},
           "HE 900 AA": {"h": 870.0, "b": 300.0, "t_w": 15.0, "t_f": 20.0, "r": 30.0},
           "HE 900 A": {"h": 890.0, "b": 300.0, "t_w": 16.0, "t_f": 30.0, "r": 30.0},
           "HE 900 B": {"h": 900.0, "b": 300.0, "t_w": 18.5, "t_f": 35.0, "r": 30.0},
           "HE 900 M": {"h": 910.0, "b": 302.0, "t_w": 21.0, "t_f": 40.0, "r": 30.0},
           "HE 1000 AA": {"h": 970.0, "b": 300.0, "t_w": 16.0, "t_f": 21.0, "r": 30.0},
           "HE 1000 A": {"h": 990.0, "b": 300.0, "t_w": 16.5, "t_f": 31.0, "r": 30.0},
           "HE 1000 B": {"h": 1000.0, "b": 300.0, "t_w": 19.0, "t_f": 36.0, "r": 30.0},
           "HE 1000 M": {"h": 1008.0, "b": 302.0, "t_w": 21.0, "t_f": 40.0, "r": 30.0}
           }


ipe_profiles = {"IPE 80": {"h": 80.0, "b": 46.0, "t_w": 3.8, "t_f": 5.2, "r": 5.0},
               "IPE 100": {"h": 100.0, "b": 55.0, "t_w": 4.1, "t_f": 5.7, "r": 7.0},
               "IPE 120": {"h": 120.0, "b": 64.0, "t_w": 4.4, "t_f": 6.3, "r": 7.0},
               "IPE 140": {"h": 140.0, "b": 73.0, "t_w": 4.7, "t_f": 6.9, "r": 7.0},
               "IPE 160": {"h": 160.0, "b": 82.0, "t_w": 5.0, "t_f": 7.4, "r": 9.0},
               "IPE 180": {"h": 180.0, "b": 91.0, "t_w": 5.3, "t_f": 8.0, "r": 9.0},
               "IPE 200": {"h": 200.0, "b": 100.0, "t_w": 5.6, "t_f": 8.5, "r": 12.0},
               "IPE 220": {"h": 220.0, "b": 110.0, "t_w": 5.9, "t_f": 9.2, "r": 12.0},
               "IPE 240": {"h": 240.0, "b": 120.0, "t_w": 6.2, "t_f": 9.8, "r": 15.0},
               "IPE 270": {"h": 270.0, "b": 135.0, "t_w": 6.6, "t_f": 10.2, "r": 15.0},
               "IPE 300": {"h": 300.0, "b": 150.0, "t_w": 7.1, "t_f": 10.7, "r": 15.0},
               "IPE 330": {"h": 330.0, "b": 160.0, "t_w": 7.5, "t_f": 11.5, "r": 18.0},
               "IPE 360": {"h": 360.0, "b": 170.0, "t_w": 8.0, "t_f": 12.7, "r": 18.0},
               "IPE 400": {"h": 400.0, "b": 180.0, "t_w": 8.6, "t_f": 13.5, "r": 21.0},
               "IPE 450": {"h": 450.0, "b": 190.0, "t_w": 9.4, "t_f": 14.6, "r": 21.0},
               "IPE 500": {"h": 500.0, "b": 200.0, "t_w": 10.2, "t_f": 16.0, "r": 21.0},
               "IPE 550": {"h": 550.0, "b": 210.0, "t_w": 11.1, "t_f": 17.2, "r": 24.0},
               "IPE 600": {"h": 600.0, "b": 220.0, "t_w": 12.0, "t_f": 19.0, "r": 24.0},
               "IPE 750": {"h": 750.0, "b": 264.0, "t_w": 12.0, "t_f": 15.5, "r": 17.0}}

hea_profiles = {"HE 100 A": {"h": 96.0, "b": 100.0, "t_w": 5.0, "t_f": 8.0, "r": 12.0},
                "HE 120 A": {"h": 114.0, "b": 120.0, "t_w": 5.0, "t_f": 8.0, "r": 12.0},
                "HE 140 A": {"h": 133.0, "b": 140.0, "t_w": 5.5, "t_f": 8.5, "r": 12.0},
                "HE 160 A": {"h": 152.0, "b": 160.0, "t_w": 6.0, "t_f": 9.0, "r": 15.0},
                "HE 180 A": {"h": 171.0, "b": 180.0, "t_w": 6.0, "t_f": 9.5, "r": 15.0},
                "HE 200 A": {"h": 190.0, "b": 200.0, "t_w": 6.5, "t_f": 10.0, "r": 18.0},
                "HE 220 A": {"h": 210.0, "b": 220.0, "t_w": 7.0, "t_f": 11.0, "r": 18.0},
                "HE 240 A": {"h": 230.0, "b": 240.0, "t_w": 7.5, "t_f": 12.0, "r": 21.0},
                "HE 260 A": {"h": 250.0, "b": 260.0, "t_w": 7.5, "t_f": 12.5, "r": 24.0},
                "HE 280 A": {"h": 270.0, "b": 280.0, "t_w": 8.0, "t_f": 13.0, "r": 24.0},
                "HE 300 A": {"h": 290.0, "b": 300.0, "t_w": 8.5, "t_f": 14.0, "r": 27.0},
                "HE 320 A": {"h": 310.0, "b": 300.0, "t_w": 9.0, "t_f": 15.5, "r": 27.0},
                "HE 340 A": {"h": 330.0, "b": 300.0, "t_w": 9.5, "t_f": 16.5, "r": 27.0},
                "HE 360 A": {"h": 350.0, "b": 300.0, "t_w": 10.0, "t_f": 17.5, "r": 27.0},
                "HE 400 A": {"h": 390.0, "b": 300.0, "t_w": 11.0, "t_f": 19.0, "r": 27.0},
                "HE 450 A": {"h": 440.0, "b": 300.0, "t_w": 11.5, "t_f": 21.0, "r": 27.0},
                "HE 500 A": {"h": 490.0, "b": 300.0, "t_w": 12.0, "t_f": 23.0, "r": 27.0},
                "HE 550 A": {"h": 540.0, "b": 300.0, "t_w": 12.5, "t_f": 24.0, "r": 27.0},
                "HE 600 A": {"h": 590.0, "b": 300.0, "t_w": 13.0, "t_f": 25.0, "r": 27.0},
                "HE 650 A": {"h": 640.0, "b": 300.0, "t_w": 13.5, "t_f": 26.0, "r": 27.0},
                "HE 700 A": {"h": 690.0, "b": 300.0, "t_w": 14.5, "t_f": 27.0, "r": 27.0},
                "HE 800 A": {"h": 790.0, "b": 300.0, "t_w": 15.0, "t_f": 28.0, "r": 30.0},
                "HE 900 A": {"h": 890.0, "b": 300.0, "t_w": 16.0, "t_f": 30.0, "r": 30.0},
                "HE 1000 A": {"h": 990.0, "b": 300.0, "t_w": 16.5, "t_f": 31.0, "r": 30.0}}

heb_profiles = {"HE 100 B": {"h": 100.0, "b": 100.0, "t_w": 6.0, "t_f": 10.0, "r": 12.0},            
                "HE 120 B": {"h": 120.0, "b": 120.0, "t_w": 6.5, "t_f": 11.0, "r": 12.0},                
                "HE 140 B": {"h": 140.0, "b": 140.0, "t_w": 7.0, "t_f": 12.0, "r": 12.0},                
                "HE 160 B": {"h": 160.0, "b": 160.0, "t_w": 8.0, "t_f": 13.0, "r": 15.0},                
                "HE 180 B": {"h": 180.0, "b": 180.0, "t_w": 8.5, "t_f": 14.0, "r": 15.0},                
                "HE 200 B": {"h": 200.0, "b": 200.0, "t_w": 9.0, "t_f": 15.0, "r": 18.0},                
                "HE 220 B": {"h": 220.0, "b": 220.0, "t_w": 9.5, "t_f": 16.0, "r": 18.0},                
                "HE 240 B": {"h": 240.0, "b": 240.0, "t_w": 10.0, "t_f": 17.0, "r": 21.0},                
                "HE 260 B": {"h": 260.0, "b": 260.0, "t_w": 10.0, "t_f": 17.5, "r": 24.0},                
                "HE 280 B": {"h": 280.0, "b": 280.0, "t_w": 10.5, "t_f": 18.0, "r": 24.0},                
                "HE 300 B": {"h": 300.0, "b": 300.0, "t_w": 11.0, "t_f": 19.0, "r": 27.0},                
                "HE 320 B": {"h": 320.0, "b": 300.0, "t_w": 11.5, "t_f": 20.5, "r": 27.0},                
                "HE 340 B": {"h": 340.0, "b": 300.0, "t_w": 12.0, "t_f": 21.5, "r": 27.0},                
                "HE 360 B": {"h": 360.0, "b": 300.0, "t_w": 12.5, "t_f": 22.5, "r": 27.0},                
                "HE 400 B": {"h": 400.0, "b": 300.0, "t_w": 13.5, "t_f": 24.0, "r": 27.0},                
                "HE 450 B": {"h": 450.0, "b": 300.0, "t_w": 14.0, "t_f": 26.0, "r": 27.0},                
                "HE 500 B": {"h": 500.0, "b": 300.0, "t_w": 14.5, "t_f": 28.0, "r": 27.0},                
                "HE 550 B": {"h": 550.0, "b": 300.0, "t_w": 15.0, "t_f": 29.0, "r": 27.0},                
                "HE 600 B": {"h": 600.0, "b": 300.0, "t_w": 15.5, "t_f": 30.0, "r": 27.0},                
                "HE 650 B": {"h": 650.0, "b": 300.0, "t_w": 16.0, "t_f": 31.0, "r": 27.0},                
                "HE 700 B": {"h": 700.0, "b": 300.0, "t_w": 17.0, "t_f": 32.0, "r": 27.0},                
                "HE 800 B": {"h": 800.0, "b": 300.0, "t_w": 17.5, "t_f": 33.0, "r": 30.0},                
                "HE 900 B": {"h": 900.0, "b": 300.0, "t_w": 18.5, "t_f": 35.0, "r": 30.0},                
                "HE 1000 B": {"h": 1000.0, "b": 300.0, "t_w": 19.0, "t_f": 36.0, "r": 30.0}}

h_profiles = {"HE 100 AA": {"h": 91.0, "b": 100.0, "t_w": 4.2, "t_f": 5.5, "r": 12.0},
               "HE 100 A": {"h": 96.0, "b": 100.0, "t_w": 5.0, "t_f": 8.0, "r": 12.0},
               "HE 100 B": {"h": 100.0, "b": 100.0, "t_w": 6.0, "t_f": 10.0, "r": 12.0},
               "HE 100 C": {"h": 110.0, "b": 103.0, "t_w": 9.0, "t_f": 15.0, "r": 12.0},
               "HE 100 M": {"h": 120.0, "b": 106.0, "t_w": 12.0, "t_f": 20.0, "r": 12.0},
               "HE 120 AA": {"h": 109.0, "b": 120.0, "t_w": 4.2, "t_f": 5.5, "r": 12.0},
               "HE 120 A": {"h": 114.0, "b": 120.0, "t_w": 5.0, "t_f": 8.0, "r": 12.0},
               "HE 120 B": {"h": 120.0, "b": 120.0, "t_w": 6.5, "t_f": 11.0, "r": 12.0},
               "HE 120 C": {"h": 130.0, "b": 123.0, "t_w": 9.5, "t_f": 16.0, "r": 12.0},
               "HE 120 M": {"h": 140.0, "b": 126.0, "t_w": 12.5, "t_f": 21.0, "r": 12.0},
               "HE 140 AA": {"h": 128.0, "b": 140.0, "t_w": 4.3, "t_f": 6.0, "r": 12.0},
               "HE 140 A": {"h": 133.0, "b": 140.0, "t_w": 5.5, "t_f": 8.5, "r": 12.0},
               "HE 140 B": {"h": 140.0, "b": 140.0, "t_w": 7.0, "t_f": 12.0, "r": 12.0},
               "HE 140 C": {"h": 150.0, "b": 143.0, "t_w": 10.0, "t_f": 17.0, "r": 12.0},
               "HE 140 M": {"h": 160.0, "b": 146.0, "t_w": 13.0, "t_f": 22.0, "r": 12.0},
               "HE 160 AA": {"h": 148.0, "b": 160.0, "t_w": 4.5, "t_f": 7.0, "r": 15.0},
               "HE 160 A": {"h": 152.0, "b": 160.0, "t_w": 6.0, "t_f": 9.0, "r": 15.0},
               "HE 160 B": {"h": 160.0, "b": 160.0, "t_w": 8.0, "t_f": 13.0, "r": 15.0},
               "HE 160 C": {"h": 170.0, "b": 163.0, "t_w": 11.0, "t_f": 18.0, "r": 15.0},
               "HE 160 M": {"h": 180.0, "b": 166.0, "t_w": 14.0, "t_f": 23.0, "r": 15.0},
               "HE 180 AA": {"h": 167.0, "b": 180.0, "t_w": 5.0, "t_f": 7.5, "r": 15.0},
               "HE 180 A": {"h": 171.0, "b": 180.0, "t_w": 6.0, "t_f": 9.5, "r": 15.0},
               "HE 180 B": {"h": 180.0, "b": 180.0, "t_w": 8.5, "t_f": 14.0, "r": 15.0},
               "HE 180 C": {"h": 190.0, "b": 183.0, "t_w": 11.5, "t_f": 19.0, "r": 15.0},
               "HE 180 M": {"h": 200.0, "b": 186.0, "t_w": 14.5, "t_f": 24.0, "r": 15.0},
               "HE 200 AA": {"h": 186.0, "b": 200.0, "t_w": 5.5, "t_f": 8.0, "r": 18.0},
               "HE 200 A": {"h": 190.0, "b": 200.0, "t_w": 6.5, "t_f": 10.0, "r": 18.0},
               "HE 200 B": {"h": 200.0, "b": 200.0, "t_w": 9.0, "t_f": 15.0, "r": 18.0},
               "HE 200 C": {"h": 210.0, "b": 203.0, "t_w": 12.0, "t_f": 20.0, "r": 18.0},
               "HE 200 M": {"h": 220.0, "b": 206.0, "t_w": 15.0, "t_f": 25.0, "r": 18.0},
               "HE 220 AA": {"h": 205.0, "b": 220.0, "t_w": 6.0, "t_f": 8.5, "r": 18.0},
               "HE 220 A": {"h": 210.0, "b": 220.0, "t_w": 7.0, "t_f": 11.0, "r": 18.0},
               "HE 220 B": {"h": 220.0, "b": 220.0, "t_w": 9.5, "t_f": 16.0, "r": 18.0},
               "HE 220 C": {"h": 230.0, "b": 223.0, "t_w": 12.5, "t_f": 21.0, "r": 18.0},
               "HE 220 M": {"h": 240.0, "b": 226.0, "t_w": 15.5, "t_f": 26.0, "r": 18.0},
               "HE 240 AA": {"h": 224.0, "b": 240.0, "t_w": 6.5, "t_f": 9.0, "r": 21.0},
               "HE 240 A": {"h": 230.0, "b": 240.0, "t_w": 7.5, "t_f": 12.0, "r": 21.0},
               "HE 240 B": {"h": 240.0, "b": 240.0, "t_w": 10.0, "t_f": 17.0, "r": 21.0},
               "HE 240 C": {"h": 255.0, "b": 244.0, "t_w": 14.0, "t_f": 24.5, "r": 21.0},
               "HE 240 M": {"h": 270.0, "b": 248.0, "t_w": 18.0, "t_f": 32.0, "r": 21.0},
               "HE 260 AA": {"h": 244.0, "b": 260.0, "t_w": 6.5, "t_f": 9.5, "r": 24.0},
               "HE 260 A": {"h": 250.0, "b": 260.0, "t_w": 7.5, "t_f": 12.5, "r": 24.0},
               "HE 260 B": {"h": 260.0, "b": 260.0, "t_w": 10.0, "t_f": 17.5, "r": 24.0},
               "HE 260 C": {"h": 275.0, "b": 264.0, "t_w": 14.0, "t_f": 25.0, "r": 24.0},
               "HE 260 M": {"h": 290.0, "b": 268.0, "t_w": 18.0, "t_f": 32.5, "r": 24.0},
               "HE 280 AA": {"h": 264.0, "b": 280.0, "t_w": 7.0, "t_f": 10.0, "r": 24.0},
               "HE 280 A": {"h": 270.0, "b": 280.0, "t_w": 8.0, "t_f": 13.0, "r": 24.0},
               "HE 280 B": {"h": 280.0, "b": 280.0, "t_w": 10.5, "t_f": 18.0, "r": 24.0},
               "HE 280 C": {"h": 295.0, "b": 284.0, "t_w": 14.5, "t_f": 25.5, "r": 24.0},
               "HE 280 M": {"h": 310.0, "b": 288.0, "t_w": 18.5, "t_f": 33.0, "r": 24.0},
               "HE 300 AA": {"h": 283.0, "b": 300.0, "t_w": 7.5, "t_f": 10.5, "r": 27.0},
               "HE 300 A": {"h": 290.0, "b": 300.0, "t_w": 8.5, "t_f": 14.0, "r": 27.0},
               "HE 300 B": {"h": 300.0, "b": 300.0, "t_w": 11.0, "t_f": 19.0, "r": 27.0},
               "HE 300 C": {"h": 320.0, "b": 305.0, "t_w": 16.0, "t_f": 29.0, "r": 27.0},
               "HE 300 M": {"h": 340.0, "b": 310.0, "t_w": 21.0, "t_f": 39.0, "r": 27.0},
               "HE 320 AA": {"h": 301.0, "b": 300.0, "t_w": 8.0, "t_f": 11.0, "r": 27.0},
               "HE 320 A": {"h": 310.0, "b": 300.0, "t_w": 9.0, "t_f": 15.5, "r": 27.0},
               "HE 320 B": {"h": 320.0, "b": 300.0, "t_w": 11.5, "t_f": 20.5, "r": 27.0},
               "HE 320 C": {"h": 340.0, "b": 305.0, "t_w": 16.0, "t_f": 30.5, "r": 27.0},
               "HE 320 M": {"h": 359.0, "b": 309.0, "t_w": 21.0, "t_f": 40.0, "r": 27.0},
               "HE 340 AA": {"h": 320.0, "b": 300.0, "t_w": 8.5, "t_f": 11.5, "r": 27.0},
               "HE 340 A": {"h": 330.0, "b": 300.0, "t_w": 9.5, "t_f": 16.5, "r": 27.0},
               "HE 340 B": {"h": 340.0, "b": 300.0, "t_w": 12.0, "t_f": 21.5, "r": 27.0},
               "HE 340 M": {"h": 377.0, "b": 309.0, "t_w": 21.0, "t_f": 40.0, "r": 27.0},
               "HE 360 AA": {"h": 339.0, "b": 300.0, "t_w": 9.0, "t_f": 12.0, "r": 27.0},
               "HE 360 A": {"h": 350.0, "b": 300.0, "t_w": 10.0, "t_f": 17.5, "r": 27.0},
               "HE 360 B": {"h": 360.0, "b": 300.0, "t_w": 12.5, "t_f": 22.5, "r": 27.0},
               "HE 360 M": {"h": 395.0, "b": 308.0, "t_w": 21.0, "t_f": 40.0, "r": 27.0},
               "HE 400 AA": {"h": 378.0, "b": 300.0, "t_w": 9.5, "t_f": 13.0, "r": 27.0},
               "HE 400 A": {"h": 390.0, "b": 300.0, "t_w": 11.0, "t_f": 19.0, "r": 27.0},
               "HE 400 B": {"h": 400.0, "b": 300.0, "t_w": 13.5, "t_f": 24.0, "r": 27.0},
               "HE 400 M": {"h": 432.0, "b": 307.0, "t_w": 21.0, "t_f": 40.0, "r": 27.0},
               "HE 450 AA": {"h": 425.0, "b": 300.0, "t_w": 10.0, "t_f": 13.5, "r": 27.0},
               "HE 450 A": {"h": 440.0, "b": 300.0, "t_w": 11.5, "t_f": 21.0, "r": 27.0},
               "HE 450 B": {"h": 450.0, "b": 300.0, "t_w": 14.0, "t_f": 26.0, "r": 27.0},
               "HE 450 M": {"h": 478.0, "b": 307.0, "t_w": 21.0, "t_f": 40.0, "r": 27.0},
               "HE 500 AA": {"h": 472.0, "b": 300.0, "t_w": 10.5, "t_f": 14.0, "r": 27.0},
               "HE 500 A": {"h": 490.0, "b": 300.0, "t_w": 12.0, "t_f": 23.0, "r": 27.0},
               "HE 500 B": {"h": 500.0, "b": 300.0, "t_w": 14.5, "t_f": 28.0, "r": 27.0},
               "HE 500 M": {"h": 524.0, "b": 306.0, "t_w": 21.0, "t_f": 40.0, "r": 27.0},
               "HE 550 AA": {"h": 522.0, "b": 300.0, "t_w": 11.5, "t_f": 15.0, "r": 27.0},
               "HE 550 A": {"h": 540.0, "b": 300.0, "t_w": 12.5, "t_f": 24.0, "r": 27.0},
               "HE 550 B": {"h": 550.0, "b": 300.0, "t_w": 15.0, "t_f": 29.0, "r": 27.0},
               "HE 550 M": {"h": 572.0, "b": 306.0, "t_w": 21.0, "t_f": 40.0, "r": 27.0},
               "HE 600 AA": {"h": 571.0, "b": 300.0, "t_w": 12.0, "t_f": 15.5, "r": 27.0},
               "HE 600 A": {"h": 590.0, "b": 300.0, "t_w": 13.0, "t_f": 25.0, "r": 27.0},
               "HE 600 B": {"h": 600.0, "b": 300.0, "t_w": 15.5, "t_f": 30.0, "r": 27.0},
               "HE 600 M": {"h": 620.0, "b": 305.0, "t_w": 21.0, "t_f": 40.0, "r": 27.0},
               "HE 650 AA": {"h": 620.0, "b": 300.0, "t_w": 12.5, "t_f": 16.0, "r": 27.0},
               "HE 650 A": {"h": 640.0, "b": 300.0, "t_w": 13.5, "t_f": 26.0, "r": 27.0},
               "HE 650 B": {"h": 650.0, "b": 300.0, "t_w": 16.0, "t_f": 31.0, "r": 27.0},
               "HE 650 M": {"h": 668.0, "b": 305.0, "t_w": 21.0, "t_f": 40.0, "r": 27.0},
               "HE 700 AA": {"h": 670.0, "b": 300.0, "t_w": 13.0, "t_f": 17.0, "r": 27.0},
               "HE 700 A": {"h": 690.0, "b": 300.0, "t_w": 14.5, "t_f": 27.0, "r": 27.0},
               "HE 700 B": {"h": 700.0, "b": 300.0, "t_w": 17.0, "t_f": 32.0, "r": 27.0},
               "HE 700 M": {"h": 716.0, "b": 304.0, "t_w": 21.0, "t_f": 40.0, "r": 27.0},
               "HE 800 AA": {"h": 770.0, "b": 300.0, "t_w": 14.0, "t_f": 18.0, "r": 30.0},
               "HE 800 A": {"h": 790.0, "b": 300.0, "t_w": 15.0, "t_f": 28.0, "r": 30.0},
               "HE 800 B": {"h": 800.0, "b": 300.0, "t_w": 17.5, "t_f": 33.0, "r": 30.0},
               "HE 800 M": {"h": 814.0, "b": 303.0, "t_w": 21.0, "t_f": 40.0, "r": 30.0},
               "HE 900 AA": {"h": 870.0, "b": 300.0, "t_w": 15.0, "t_f": 20.0, "r": 30.0},
               "HE 900 A": {"h": 890.0, "b": 300.0, "t_w": 16.0, "t_f": 30.0, "r": 30.0},
               "HE 900 B": {"h": 900.0, "b": 300.0, "t_w": 18.5, "t_f": 35.0, "r": 30.0},
               "HE 900 M": {"h": 910.0, "b": 302.0, "t_w": 21.0, "t_f": 40.0, "r": 30.0},
               "HE 1000 AA": {"h": 970.0, "b": 300.0, "t_w": 16.0, "t_f": 21.0, "r": 30.0},
               "HE 1000 A": {"h": 990.0, "b": 300.0, "t_w": 16.5, "t_f": 31.0, "r": 30.0},
               "HE 1000 B": {"h": 1000.0, "b": 300.0, "t_w": 19.0, "t_f": 36.0, "r": 30.0},
               "HE 1000 M": {"h": 1008.0, "b": 302.0, "t_w": 21.0, "t_f": 40.0, "r": 30.0}}



# shs_profiles = {'SHS 25X25X2.0': {'h': 25.0, 'b': 25.0, 't': 2.0, 'r': 4.0},
#                  'SHS 25X25X2.5': {'h': 25.0, 'b': 25.0, 't': 2.5, 'r': 5.0},
#                  'SHS 25X25X3.0': {'h': 25.0, 'b': 25.0, 't': 3.0, 'r': 6.0},
#                  'SHS 30X30X2.0': {'h': 30.0, 'b': 30.0, 't': 2.0, 'r': 4.0},
#                  'SHS 30X30X2.5': {'h': 30.0, 'b': 30.0, 't': 2.5, 'r': 5.0},
#                  'SHS 30X30X3.0': {'h': 30.0, 'b': 30.0, 't': 3.0, 'r': 6.0},
#                  'SHS 40X40X2.0': {'h': 40.0, 'b': 40.0, 't': 2.0, 'r': 4.0},
#                  'SHS 40X40X2.5': {'h': 40.0, 'b': 40.0, 't': 2.5, 'r': 5.0},
#                  'SHS 40X40X3.0': {'h': 40.0, 'b': 40.0, 't': 3.0, 'r': 6.0},
#                  'SHS 40X40X4.0': {'h': 40.0, 'b': 40.0, 't': 4.0, 'r': 8.0},
#                  'SHS 50X50X2.0': {'h': 50.0, 'b': 50.0, 't': 2.0, 'r': 4.0},
#                  'SHS 50X50X2.5': {'h': 50.0, 'b': 50.0, 't': 2.5, 'r': 5.0},
#                  'SHS 50X50X3.0': {'h': 50.0, 'b': 50.0, 't': 3.0, 'r': 6.0},
#                  'SHS 50X50X4.0': {'h': 50.0, 'b': 50.0, 't': 4.0, 'r': 8.0},
#                  'SHS 50X50X5.0': {'h': 50.0, 'b': 50.0, 't': 5.0, 'r': 10.0},
#                  'SHS 60X60X2.0': {'h': 60.0, 'b': 60.0, 't': 2.0, 'r': 4.0},
#                  'SHS 60X60X2.5': {'h': 60.0, 'b': 60.0, 't': 2.5, 'r': 5.0},
#                  'SHS 60X60X3.0': {'h': 60.0, 'b': 60.0, 't': 3.0, 'r': 6.0},
#                  'SHS 60X60X4.0': {'h': 60.0, 'b': 60.0, 't': 4.0, 'r': 8.0},
#                  'SHS 60X60X5.0': {'h': 60.0, 'b': 60.0, 't': 5.0, 'r': 10.0},
#                  'SHS 70X70X2.5': {'h': 70.0, 'b': 70.0, 't': 2.5, 'r': 5.0},
#                  'SHS 70X70X3.0': {'h': 70.0, 'b': 70.0, 't': 3.0, 'r': 6.0},
#                  'SHS 70X70X4.0': {'h': 70.0, 'b': 70.0, 't': 4.0, 'r': 8.0},
#                  'SHS 70X70X5.0': {'h': 70.0, 'b': 70.0, 't': 5.0, 'r': 10.0},
#                  'SHS 80X80X2.5': {'h': 80.0, 'b': 80.0, 't': 2.5, 'r': 5.0},
#                  'SHS 80X80X3.0': {'h': 80.0, 'b': 80.0, 't': 3.0, 'r': 6.0},
#                  'SHS 80X80X4.0': {'h': 80.0, 'b': 80.0, 't': 4.0, 'r': 8.0},
#                  'SHS 80X80X5.0': {'h': 80.0, 'b': 80.0, 't': 5.0, 'r': 10.0},
#                  'SHS 80X80X6.0': {'h': 80.0, 'b': 80.0, 't': 6.0, 'r': 12.0},
#                  'SHS 90X90X2.5': {'h': 90.0, 'b': 90.0, 't': 2.5, 'r': 5.0},
#                  'SHS 90X90X3.0': {'h': 90.0, 'b': 90.0, 't': 3.0, 'r': 6.0},
#                  'SHS 90X90X4.0': {'h': 90.0, 'b': 90.0, 't': 4.0, 'r': 8.0},
#                  'SHS 90X90X5.0': {'h': 90.0, 'b': 90.0, 't': 5.0, 'r': 10.0},
#                  'SHS 90X90X6.0': {'h': 90.0, 'b': 90.0, 't': 6.0, 'r': 12.0},
#                  'SHS 100X100X2.5': {'h': 100.0, 'b': 100.0, 't': 2.5, 'r': 5.0},
#                  'SHS 100X100X3.0': {'h': 100.0, 'b': 100.0, 't': 3.0, 'r': 6.0},
#                  'SHS 100X100X4.0': {'h': 100.0, 'b': 100.0, 't': 4.0, 'r': 8.0},
#                  'SHS 100X100X5.0': {'h': 100.0, 'b': 100.0, 't': 5.0, 'r': 10.0},
#                  'SHS 100X100X6.0': {'h': 100.0, 'b': 100.0, 't': 6.0, 'r': 12.0},
#                  'SHS 100X100X7.1': {'h': 100.0, 'b': 100.0, 't': 7.1, 'r': 17.75},
#                  'SHS 100X100X8.0': {'h': 100.0, 'b': 100.0, 't': 8.0, 'r': 20.0},
#                  'SHS 100X100X10.0': {'h': 100.0, 'b': 100.0, 't': 10.0, 'r': 25.0},
#                  'SHS 110X110X2.5': {'h': 110.0, 'b': 110.0, 't': 2.5, 'r': 5.0},
#                  'SHS 110X110X3.0': {'h': 110.0, 'b': 110.0, 't': 3.0, 'r': 6.0},
#                  'SHS 110X110X4.0': {'h': 110.0, 'b': 110.0, 't': 4.0, 'r': 8.0},
#                  'SHS 110X110X5.0': {'h': 110.0, 'b': 110.0, 't': 5.0, 'r': 10.0},
#                  'SHS 110X110X6.0': {'h': 110.0, 'b': 110.0, 't': 6.0, 'r': 12.0},
#                  'SHS 120X120X3.0': {'h': 120.0, 'b': 120.0, 't': 3.0, 'r': 6.0},
#                  'SHS 120X120X4.0': {'h': 120.0, 'b': 120.0, 't': 4.0, 'r': 8.0},
#                  'SHS 120X120X5.0': {'h': 120.0, 'b': 120.0, 't': 5.0, 'r': 10.0},
#                  'SHS 120X120X5.6': {'h': 120.0, 'b': 120.0, 't': 5.6, 'r': 11.2},
#                  'SHS 120X120X6.0': {'h': 120.0, 'b': 120.0, 't': 6.0, 'r': 12.0},
#                  'SHS 120X120X7.1': {'h': 120.0, 'b': 120.0, 't': 7.1, 'r': 17.75},
#                  'SHS 120X120X8.0': {'h': 120.0, 'b': 120.0, 't': 8.0, 'r': 20.0},
#                  'SHS 120X120X8.8': {'h': 120.0, 'b': 120.0, 't': 8.8, 'r': 22.0},
#                  'SHS 120X120X10.0': {'h': 120.0, 'b': 120.0, 't': 10.0, 'r': 25.0},
#                  'SHS 140X140X4.0': {'h': 140.0, 'b': 140.0, 't': 4.0, 'r': 8.0},
#                  'SHS 140X140X5.0': {'h': 140.0, 'b': 140.0, 't': 5.0, 'r': 10.0},
#                  'SHS 140X140X5.6': {'h': 140.0, 'b': 140.0, 't': 5.6, 'r': 11.2},
#                  'SHS 140X140X6.0': {'h': 140.0, 'b': 140.0, 't': 6.0, 'r': 12.0},
#                  'SHS 140X140X7.1': {'h': 140.0, 'b': 140.0, 't': 7.1, 'r': 17.75},
#                  'SHS 140X140X8.0': {'h': 140.0, 'b': 140.0, 't': 8.0, 'r': 20.0},
#                  'SHS 140X140X8.8': {'h': 140.0, 'b': 140.0, 't': 8.8, 'r': 22.0},
#                  'SHS 140X140X10.0': {'h': 140.0, 'b': 140.0, 't': 10.0, 'r': 25.0},
#                  'SHS 150X150X4.0': {'h': 150.0, 'b': 150.0, 't': 4.0, 'r': 8.0},
#                  'SHS 150X150X5.0': {'h': 150.0, 'b': 150.0, 't': 5.0, 'r': 10.0},
#                  'SHS 150X150X6.0': {'h': 150.0, 'b': 150.0, 't': 6.0, 'r': 12.0},
#                  'SHS 150X150X7.1': {'h': 150.0, 'b': 150.0, 't': 7.1, 'r': 17.75},
#                  'SHS 150X150X8.0': {'h': 150.0, 'b': 150.0, 't': 8.0, 'r': 20.0},
#                  'SHS 150X150X8.8': {'h': 150.0, 'b': 150.0, 't': 8.8, 'r': 22.0},
#                  'SHS 150X150X10.0': {'h': 150.0, 'b': 150.0, 't': 10.0, 'r': 25.0},
#                  'SHS 150X150X12.5': {'h': 150.0, 'b': 150.0, 't': 12.5, 'r': 37.5},
#                  'SHS 160X160X4.0': {'h': 160.0, 'b': 160.0, 't': 4.0, 'r': 8.0},
#                  'SHS 160X160X5.0': {'h': 160.0, 'b': 160.0, 't': 5.0, 'r': 10.0},
#                  'SHS 160X160X6.0': {'h': 160.0, 'b': 160.0, 't': 6.0, 'r': 12.0},
#                  'SHS 160X160X7.1': {'h': 160.0, 'b': 160.0, 't': 7.1, 'r': 17.75},
#                  'SHS 160X160X8.0': {'h': 160.0, 'b': 160.0, 't': 8.0, 'r': 20.0},
#                  'SHS 160X160X8.8': {'h': 160.0, 'b': 160.0, 't': 8.8, 'r': 22.0},
#                  'SHS 160X160X10.0': {'h': 160.0, 'b': 160.0, 't': 10.0, 'r': 25.0},
#                  'SHS 160X160X12.0': {'h': 160.0, 'b': 160.0, 't': 12.0, 'r': 36.0},
#                  'SHS 160X160X12.5': {'h': 160.0, 'b': 160.0, 't': 12.5, 'r': 37.5},
#                  'SHS 180X180X5.0': {'h': 180.0, 'b': 180.0, 't': 5.0, 'r': 10.0},
#                  'SHS 180X180X6.0': {'h': 180.0, 'b': 180.0, 't': 6.0, 'r': 12.0},
#                  'SHS 180X180X7.1': {'h': 180.0, 'b': 180.0, 't': 7.1, 'r': 17.75},
#                  'SHS 180X180X8.0': {'h': 180.0, 'b': 180.0, 't': 8.0, 'r': 20.0},
#                  'SHS 180X180X8.8': {'h': 180.0, 'b': 180.0, 't': 8.8, 'r': 22.0},
#                  'SHS 180X180X10.0': {'h': 180.0, 'b': 180.0, 't': 10.0, 'r': 25.0},
#                  'SHS 180X180X12.5': {'h': 180.0, 'b': 180.0, 't': 12.5, 'r': 37.5},
#                  'SHS 200X200X5.0': {'h': 200.0, 'b': 200.0, 't': 5.0, 'r': 10.0},
#                  'SHS 200X200X6.0': {'h': 200.0, 'b': 200.0, 't': 6.0, 'r': 12.0},
#                  'SHS 200X200X7.1': {'h': 200.0, 'b': 200.0, 't': 7.1, 'r': 17.75},
#                  'SHS 200X200X8.0': {'h': 200.0, 'b': 200.0, 't': 8.0, 'r': 20.0},
#                  'SHS 200X200X8.8': {'h': 200.0, 'b': 200.0, 't': 8.8, 'r': 22.0},
#                  'SHS 200X200X10.0': {'h': 200.0, 'b': 200.0, 't': 10.0, 'r': 25.0},
#                  'SHS 200X200X12.5': {'h': 200.0, 'b': 200.0, 't': 12.5, 'r': 37.5},
#                  'SHS 220X220X6.0': {'h': 220.0, 'b': 220.0, 't': 6.0, 'r': 12.0},
#                  'SHS 220X220X7.1': {'h': 220.0, 'b': 220.0, 't': 7.1, 'r': 17.75},
#                  'SHS 220X220X8.0': {'h': 220.0, 'b': 220.0, 't': 8.0, 'r': 20.0},
#                  'SHS 220X220X8.8': {'h': 220.0, 'b': 220.0, 't': 8.8, 'r': 22.0},
#                  'SHS 220X220X10.0': {'h': 220.0, 'b': 220.0, 't': 10.0, 'r': 25.0},
#                  'SHS 220X220X12.5': {'h': 220.0, 'b': 220.0, 't': 12.5, 'r': 37.5},
#                  'SHS 250X250X6.0': {'h': 250.0, 'b': 250.0, 't': 6.0, 'r': 12.0},
#                  'SHS 250X250X7.1': {'h': 250.0, 'b': 250.0, 't': 7.1, 'r': 17.75},
#                  'SHS 250X250X8.0': {'h': 250.0, 'b': 250.0, 't': 8.0, 'r': 20.0},
#                  'SHS 250X250X8.8': {'h': 250.0, 'b': 250.0, 't': 8.8, 'r': 22.0},
#                  'SHS 250X250X10.0': {'h': 250.0, 'b': 250.0, 't': 10.0, 'r': 25.0},
#                  'SHS 250X250X12.5': {'h': 250.0, 'b': 250.0, 't': 12.5, 'r': 37.5},
#                  'SHS 260X260X6.0': {'h': 260.0, 'b': 260.0, 't': 6.0, 'r': 12.0},
#                  'SHS 260X260X7.1': {'h': 260.0, 'b': 260.0, 't': 7.1, 'r': 17.75},
#                  'SHS 260X260X8.0': {'h': 260.0, 'b': 260.0, 't': 8.0, 'r': 20.0},
#                  'SHS 260X260X8.8': {'h': 260.0, 'b': 260.0, 't': 8.8, 'r': 22.0},
#                  'SHS 260X260X10.0': {'h': 260.0, 'b': 260.0, 't': 10.0, 'r': 25.0},
#                  'SHS 260X260X11.0': {'h': 260.0, 'b': 260.0, 't': 11.0, 'r': 33.0},
#                  'SHS 260X260X12.5': {'h': 260.0, 'b': 260.0, 't': 12.5, 'r': 37.5},
#                  'SHS 300X300X6.0': {'h': 300.0, 'b': 300.0, 't': 6.0, 'r': 12.0},
#                  'SHS 300X300X7.1': {'h': 300.0, 'b': 300.0, 't': 7.1, 'r': 17.75},
#                  'SHS 300X300X8.0': {'h': 300.0, 'b': 300.0, 't': 8.0, 'r': 20.0},
#                  'SHS 300X300X8.8': {'h': 300.0, 'b': 300.0, 't': 8.8, 'r': 22.0},
#                  'SHS 300X300X10.0': {'h': 300.0, 'b': 300.0, 't': 10.0, 'r': 25.0},
#                  'SHS 300X300X12.5': {'h': 300.0, 'b': 300.0, 't': 12.5, 'r': 37.5}}

# Järjestetty pinta-alan mukaan, SSAB:n valikoiman luokkien 1 ja 2 profiilit
shs_profiles = {'SHS 25X25X2.0': {'h': 25.0, 'b': 25.0, 't': 2.0, 'r': 4.0},
                'SHS 25X25X2.5': {'h': 25.0, 'b': 25.0, 't': 2.5, 'r': 5.0},
                'SHS 30X30X2.0': {'h': 30.0, 'b': 30.0, 't': 2.0, 'r': 4.0},
                'SHS 25X25X3.0': {'h': 25.0, 'b': 25.0, 't': 3.0, 'r': 6.0},
                'SHS 30X30X2.5': {'h': 30.0, 'b': 30.0, 't': 2.5, 'r': 5.0},
                'SHS 40X40X2.0': {'h': 40.0, 'b': 40.0, 't': 2.0, 'r': 4.0},
                'SHS 30X30X3.0': {'h': 30.0, 'b': 30.0, 't': 3.0, 'r': 6.0},
                'SHS 40X40X2.5': {'h': 40.0, 'b': 40.0, 't': 2.5, 'r': 5.0},
                'SHS 50X50X2.0': {'h': 50.0, 'b': 50.0, 't': 2.0, 'r': 4.0},
                'SHS 40X40X3.0': {'h': 40.0, 'b': 40.0, 't': 3.0, 'r': 6.0},
                'SHS 60X60X2.0': {'h': 60.0, 'b': 60.0, 't': 2.0, 'r': 4.0},
                'SHS 50X50X2.5': {'h': 50.0, 'b': 50.0, 't': 2.5, 'r': 5.0},
                'SHS 40X40X4.0': {'h': 40.0, 'b': 40.0, 't': 4.0, 'r': 8.0},
                'SHS 50X50X3.0': {'h': 50.0, 'b': 50.0, 't': 3.0, 'r': 6.0},
                'SHS 60X60X2.5': {'h': 60.0, 'b': 60.0, 't': 2.5, 'r': 5.0},
                'SHS 70X70X2.5': {'h': 70.0, 'b': 70.0, 't': 2.5, 'r': 5.0},
                'SHS 60X60X3.0': {'h': 60.0, 'b': 60.0, 't': 3.0, 'r': 6.0},
                'SHS 50X50X4.0': {'h': 50.0, 'b': 50.0, 't': 4.0, 'r': 8.0},
                'SHS 70X70X3.0': {'h': 70.0, 'b': 70.0, 't': 3.0, 'r': 6.0},
                'SHS 50X50X5.0': {'h': 50.0, 'b': 50.0, 't': 5.0, 'r': 10.0},
                'SHS 60X60X4.0': {'h': 60.0, 'b': 60.0, 't': 4.0, 'r': 8.0},
                'SHS 80X80X3.0': {'h': 80.0, 'b': 80.0, 't': 3.0, 'r': 6.0},
                'SHS 70X70X4.0': {'h': 70.0, 'b': 70.0, 't': 4.0, 'r': 8.0},
                'SHS 90X90X3.0': {'h': 90.0, 'b': 90.0, 't': 3.0, 'r': 6.0},
                'SHS 60X60X5.0': {'h': 60.0, 'b': 60.0, 't': 5.0, 'r': 10.0},
                'SHS 80X80X4.0': {'h': 80.0, 'b': 80.0, 't': 4.0, 'r': 8.0},
                'SHS 70X70X5.0': {'h': 70.0, 'b': 70.0, 't': 5.0, 'r': 10.0},
                'SHS 90X90X4.0': {'h': 90.0, 'b': 90.0, 't': 4.0, 'r': 8.0},
                'SHS 80X80X5.0': {'h': 80.0, 'b': 80.0, 't': 5.0, 'r': 10.0},
                'SHS 100X100X4.0': {'h': 100.0, 'b': 100.0, 't': 4.0, 'r': 8.0},
                'SHS 90X90X5.0': {'h': 90.0, 'b': 90.0, 't': 5.0, 'r': 10.0},
                'SHS 110X110X4.0': {'h': 110.0, 'b': 110.0, 't': 4.0, 'r': 8.0},
                'SHS 80X80X6.0': {'h': 80.0, 'b': 80.0, 't': 6.0, 'r': 12.0},
                'SHS 120X120X4.0': {'h': 120.0, 'b': 120.0, 't': 4.0, 'r': 8.0},
                'SHS 100X100X5.0': {'h': 100.0, 'b': 100.0, 't': 5.0, 'r': 10.0},
                'SHS 90X90X6.0': {'h': 90.0, 'b': 90.0, 't': 6.0, 'r': 12.0},
                'SHS 110X110X5.0': {'h': 110.0, 'b': 110.0, 't': 5.0, 'r': 10.0},
                'SHS 100X100X6.0': {'h': 100.0, 'b': 100.0, 't': 6.0, 'r': 12.0},
                'SHS 120X120X5.0': {'h': 120.0, 'b': 120.0, 't': 5.0, 'r': 10.0},
                'SHS 110X110X6.0': {'h': 110.0, 'b': 110.0, 't': 6.0, 'r': 12.0},
                'SHS 100X100X7.1': {'h': 100.0, 'b': 100.0, 't': 7.1, 'r': 17.75},
                'SHS 120X120X5.6': {'h': 120.0, 'b': 120.0, 't': 5.6, 'r': 11.2},
                'SHS 140X140X5.0': {'h': 140.0, 'b': 140.0, 't': 5.0, 'r': 10.0},
                'SHS 120X120X6.0': {'h': 120.0, 'b': 120.0, 't': 6.0, 'r': 12.0},
                'SHS 100X100X8.0': {'h': 100.0, 'b': 100.0, 't': 8.0, 'r': 20.0},
                'SHS 150X150X5.0': {'h': 150.0, 'b': 150.0, 't': 5.0, 'r': 10.0},
                'SHS 140X140X5.6': {'h': 140.0, 'b': 140.0, 't': 5.6, 'r': 11.2},
                'SHS 120X120X7.1': {'h': 120.0, 'b': 120.0, 't': 7.1, 'r': 17.75},
                'SHS 140X140X6.0': {'h': 140.0, 'b': 140.0, 't': 6.0, 'r': 12.0},
                'SHS 100X100X10.0': {'h': 100.0, 'b': 100.0, 't': 10.0, 'r': 25.0},
                'SHS 150X150X6.0': {'h': 150.0, 'b': 150.0, 't': 6.0, 'r': 12.0},
                'SHS 120X120X8.0': {'h': 120.0, 'b': 120.0, 't': 8.0, 'r': 20.0},
                'SHS 140X140X7.1': {'h': 140.0, 'b': 140.0, 't': 7.1, 'r': 17.75},
                'SHS 160X160X6.0': {'h': 160.0, 'b': 160.0, 't': 6.0, 'r': 12.0},
                'SHS 120X120X8.8': {'h': 120.0, 'b': 120.0, 't': 8.8, 'r': 22.0},
                'SHS 150X150X7.1': {'h': 150.0, 'b': 150.0, 't': 7.1, 'r': 17.75},
                'SHS 140X140X8.0': {'h': 140.0, 'b': 140.0, 't': 8.0, 'r': 20.0},
                'SHS 120X120X10.0': {'h': 120.0, 'b': 120.0, 't': 10.0, 'r': 25.0},
                'SHS 180X180X6.0': {'h': 180.0, 'b': 180.0, 't': 6.0, 'r': 12.0},
                'SHS 160X160X7.1': {'h': 160.0, 'b': 160.0, 't': 7.1, 'r': 17.75},
                'SHS 150X150X8.0': {'h': 150.0, 'b': 150.0, 't': 8.0, 'r': 20.0},
                'SHS 140X140X8.8': {'h': 140.0, 'b': 140.0, 't': 8.8, 'r': 22.0},
                'SHS 160X160X8.0': {'h': 160.0, 'b': 160.0, 't': 8.0, 'r': 20.0},
                'SHS 150X150X8.8': {'h': 150.0, 'b': 150.0, 't': 8.8, 'r': 22.0},
                'SHS 180X180X7.1': {'h': 180.0, 'b': 180.0, 't': 7.1, 'r': 17.75},
                'SHS 140X140X10.0': {'h': 140.0, 'b': 140.0, 't': 10.0, 'r': 25.0},
                'SHS 160X160X8.8': {'h': 160.0, 'b': 160.0, 't': 8.8, 'r': 22.0},
                'SHS 150X150X10.0': {'h': 150.0, 'b': 150.0, 't': 10.0, 'r': 25.0},
                'SHS 180X180X8.0': {'h': 180.0, 'b': 180.0, 't': 8.0, 'r': 20.0},
                'SHS 200X200X7.1': {'h': 200.0, 'b': 200.0, 't': 7.1, 'r': 17.75},
                'SHS 160X160X10.0': {'h': 160.0, 'b': 160.0, 't': 10.0, 'r': 25.0},
                'SHS 180X180X8.8': {'h': 180.0, 'b': 180.0, 't': 8.8, 'r': 22.0},
                'SHS 220X220X7.1': {'h': 220.0, 'b': 220.0, 't': 7.1, 'r': 17.75},
                'SHS 200X200X8.0': {'h': 200.0, 'b': 200.0, 't': 8.0, 'r': 20.0},
                'SHS 150X150X12.5': {'h': 150.0, 'b': 150.0, 't': 12.5, 'r': 37.5},
                'SHS 180X180X10.0': {'h': 180.0, 'b': 180.0, 't': 10.0, 'r': 25.0},
                'SHS 200X200X8.8': {'h': 200.0, 'b': 200.0, 't': 8.8, 'r': 22.0},
                'SHS 220X220X8.0': {'h': 220.0, 'b': 220.0, 't': 8.0, 'r': 20.0},
                'SHS 160X160X12.5': {'h': 160.0, 'b': 160.0, 't': 12.5, 'r': 37.5},
                'SHS 220X220X8.8': {'h': 220.0, 'b': 220.0, 't': 8.8, 'r': 22.0},
                'SHS 200X200X10.0': {'h': 200.0, 'b': 200.0, 't': 10.0, 'r': 25.0},
                'SHS 250X250X8.0': {'h': 250.0, 'b': 250.0, 't': 8.0, 'r': 20.0},
                'SHS 180X180X12.5': {'h': 180.0, 'b': 180.0, 't': 12.5, 'r': 37.5},
                'SHS 220X220X10.0': {'h': 220.0, 'b': 220.0, 't': 10.0, 'r': 25.0},
                'SHS 250X250X8.8': {'h': 250.0, 'b': 250.0, 't': 8.8, 'r': 22.0},
                'SHS 260X260X8.8': {'h': 260.0, 'b': 260.0, 't': 8.8, 'r': 22.0},
                'SHS 200X200X12.5': {'h': 200.0, 'b': 200.0, 't': 12.5, 'r': 37.5},
                'SHS 250X250X10.0': {'h': 250.0, 'b': 250.0, 't': 10.0, 'r': 25.0},
                'SHS 260X260X10.0': {'h': 260.0, 'b': 260.0, 't': 10.0, 'r': 25.0},
                'SHS 220X220X12.5': {'h': 220.0, 'b': 220.0, 't': 12.5, 'r': 37.5},
                'SHS 250X250X12.5': {'h': 250.0, 'b': 250.0, 't': 12.5, 'r': 37.5},
                'SHS 300X300X10.0': {'h': 300.0, 'b': 300.0, 't': 10.0, 'r': 25.0},
                'SHS 260X260X12.5': {'h': 260.0, 'b': 260.0, 't': 12.5, 'r': 37.5},
                'SHS 300X300X12.5': {'h': 300.0, 'b': 300.0, 't': 12.5, 'r': 37.5},
                }


rhs_profiles = {'RHS 40X40X2.0': {'h': 40.0, 'b': 40.0, 't': 2.0, 'r': 4.0},
                 'RHS 40X40X2.5': {'h': 40.0, 'b': 40.0, 't': 2.5, 'r': 5.0},
                 'RHS 40X40X3.0': {'h': 40.0, 'b': 40.0, 't': 3.0, 'r': 6.0},
                 'RHS 50X50X2.0': {'h': 50.0, 'b': 50.0, 't': 2.0, 'r': 4.0},
                 'RHS 50X50X2.5': {'h': 50.0, 'b': 50.0, 't': 2.5, 'r': 5.0},
                 'RHS 50X50X3.0': {'h': 50.0, 'b': 50.0, 't': 3.0, 'r': 6.0},
                 'RHS 50X50X4.0': {'h': 50.0, 'b': 50.0, 't': 4.0, 'r': 8.0},
                 'RHS 60X60X2.0': {'h': 60.0, 'b': 60.0, 't': 2.0, 'r': 4.0},
                 'RHS 60X60X2.5': {'h': 60.0, 'b': 60.0, 't': 2.5, 'r': 5.0},
                 'RHS 60X60X3.0': {'h': 60.0, 'b': 60.0, 't': 3.0, 'r': 6.0},
                 'RHS 60X60X4.0': {'h': 60.0, 'b': 60.0, 't': 4.0, 'r': 8.0},
                 'RHS 60X60X5.0': {'h': 60.0, 'b': 60.0, 't': 5.0, 'r': 10.0},
                 'RHS 70X70X2.0': {'h': 70.0, 'b': 70.0, 't': 2.0, 'r': 4.0},
                 'RHS 70X70X2.5': {'h': 70.0, 'b': 70.0, 't': 2.5, 'r': 5.0},
                 'RHS 70X70X3.0': {'h': 70.0, 'b': 70.0, 't': 3.0, 'r': 6.0},
                 'RHS 70X70X4.0': {'h': 70.0, 'b': 70.0, 't': 4.0, 'r': 8.0},
                 'RHS 70X70X5.0': {'h': 70.0, 'b': 70.0, 't': 5.0, 'r': 10.0},
                 'RHS 80X80X2.0': {'h': 80.0, 'b': 80.0, 't': 2.0, 'r': 4.0},
                 'RHS 80X80X2.5': {'h': 80.0, 'b': 80.0, 't': 2.5, 'r': 5.0},
                 'RHS 80X80X3.0': {'h': 80.0, 'b': 80.0, 't': 3.0, 'r': 6.0},
                 'RHS 80X80X4.0': {'h': 80.0, 'b': 80.0, 't': 4.0, 'r': 8.0},
                 'RHS 80X80X5.0': {'h': 80.0, 'b': 80.0, 't': 5.0, 'r': 10.0},
                 'RHS 90X90X2.5': {'h': 90.0, 'b': 90.0, 't': 2.5, 'r': 5.0},
                 'RHS 90X90X3.0': {'h': 90.0, 'b': 90.0, 't': 3.0, 'r': 6.0},
                 'RHS 90X90X4.0': {'h': 90.0, 'b': 90.0, 't': 4.0, 'r': 8.0},
                 'RHS 90X90X5.0': {'h': 90.0, 'b': 90.0, 't': 5.0, 'r': 10.0},
                 'RHS 100X100X2.5': {'h': 100.0, 'b': 100.0, 't': 2.5, 'r': 5.0},
                 'RHS 100X100X3.0': {'h': 100.0, 'b': 100.0, 't': 3.0, 'r': 6.0},
                 'RHS 100X100X4.0': {'h': 100.0, 'b': 100.0, 't': 4.0, 'r': 8.0},
                 'RHS 100X100X5.0': {'h': 100.0, 'b': 100.0, 't': 5.0, 'r': 10.0},
                 'RHS 100X100X6.0': {'h': 100.0, 'b': 100.0, 't': 6.0, 'r': 12.0},
                 'RHS 120X120X2.5': {'h': 120.0, 'b': 120.0, 't': 2.5, 'r': 5.0},
                 'RHS 120X120X3.0': {'h': 120.0, 'b': 120.0, 't': 3.0, 'r': 6.0},
                 'RHS 120X120X4.0': {'h': 120.0, 'b': 120.0, 't': 4.0, 'r': 8.0},
                 'RHS 120X120X5.0': {'h': 120.0, 'b': 120.0, 't': 5.0, 'r': 10.0},
                 'RHS 120X120X6.0': {'h': 120.0, 'b': 120.0, 't': 6.0, 'r': 12.0},
                 'RHS 120X120X7.1': {'h': 120.0, 'b': 120.0, 't': 7.1, 'r': 17.75},
                 'RHS 120X120X8.0': {'h': 120.0, 'b': 120.0, 't': 8.0, 'r': 20.0},
                 'RHS 120X120X8.8': {'h': 120.0, 'b': 120.0, 't': 8.8, 'r': 22.0},
                 'RHS 120X120X10.0': {'h': 120.0, 'b': 120.0, 't': 10.0, 'r': 25.0},
                 'RHS 140X140X2.5': {'h': 140.0, 'b': 140.0, 't': 2.5, 'r': 5.0},
                 'RHS 140X140X3.0': {'h': 140.0, 'b': 140.0, 't': 3.0, 'r': 6.0},
                 'RHS 140X140X4.0': {'h': 140.0, 'b': 140.0, 't': 4.0, 'r': 8.0},
                 'RHS 140X140X5.0': {'h': 140.0, 'b': 140.0, 't': 5.0, 'r': 10.0},
                 'RHS 140X140X6.0': {'h': 140.0, 'b': 140.0, 't': 6.0, 'r': 12.0},
                 'RHS 150X150X2.5': {'h': 150.0, 'b': 150.0, 't': 2.5, 'r': 5.0},
                 'RHS 150X150X3.0': {'h': 150.0, 'b': 150.0, 't': 3.0, 'r': 6.0},
                 'RHS 150X150X4.0': {'h': 150.0, 'b': 150.0, 't': 4.0, 'r': 8.0},
                 'RHS 150X150X5.0': {'h': 150.0, 'b': 150.0, 't': 5.0, 'r': 10.0},
                 'RHS 150X150X6.0': {'h': 150.0, 'b': 150.0, 't': 6.0, 'r': 12.0},
                 'RHS 150X150X7.1': {'h': 150.0, 'b': 150.0, 't': 7.1, 'r': 17.75},
                 'RHS 150X150X8.0': {'h': 150.0, 'b': 150.0, 't': 8.0, 'r': 20.0},
                 'RHS 150X150X8.8': {'h': 150.0, 'b': 150.0, 't': 8.8, 'r': 22.0},
                 'RHS 150X150X10.0': {'h': 150.0, 'b': 150.0, 't': 10.0, 'r': 25.0},
                 'RHS 160X160X4.0': {'h': 160.0, 'b': 160.0, 't': 4.0, 'r': 8.0},
                 'RHS 160X160X5.0': {'h': 160.0, 'b': 160.0, 't': 5.0, 'r': 10.0},
                 'RHS 160X160X6.0': {'h': 160.0, 'b': 160.0, 't': 6.0, 'r': 12.0},
                 'RHS 160X160X8.0': {'h': 160.0, 'b': 160.0, 't': 8.0, 'r': 20.0},
                 'RHS 160X160X3.0': {'h': 160.0, 'b': 160.0, 't': 3.0, 'r': 6.0},
                 'RHS 160X160X7.1': {'h': 160.0, 'b': 160.0, 't': 7.1, 'r': 17.75},
                 'RHS 160X160X8.8': {'h': 160.0, 'b': 160.0, 't': 8.8, 'r': 22.0},
                 'RHS 160X160X10.0': {'h': 160.0, 'b': 160.0, 't': 10.0, 'r': 25.0},
                 'RHS 180X180X4.0': {'h': 180.0, 'b': 180.0, 't': 4.0, 'r': 8.0},
                 'RHS 180X180X5.0': {'h': 180.0, 'b': 180.0, 't': 5.0, 'r': 10.0},
                 'RHS 180X180X5.6': {'h': 180.0, 'b': 180.0, 't': 5.6, 'r': 11.2},
                 'RHS 180X180X6.0': {'h': 180.0, 'b': 180.0, 't': 6.0, 'r': 12.0},
                 'RHS 180X180X7.1': {'h': 180.0, 'b': 180.0, 't': 7.1, 'r': 17.75},
                 'RHS 180X180X8.0': {'h': 180.0, 'b': 180.0, 't': 8.0, 'r': 20.0},
                 'RHS 180X180X8.8': {'h': 180.0, 'b': 180.0, 't': 8.8, 'r': 22.0},
                 'RHS 180X180X10.0': {'h': 180.0, 'b': 180.0, 't': 10.0, 'r': 25.0},
                 'RHS 180X180X12.5': {'h': 180.0, 'b': 180.0, 't': 12.5, 'r': 37.5},
                 'RHS 200X200X4.0': {'h': 200.0, 'b': 200.0, 't': 4.0, 'r': 8.0},
                 'RHS 200X200X5.0': {'h': 200.0, 'b': 200.0, 't': 5.0, 'r': 10.0},
                 'RHS 200X200X6.0': {'h': 200.0, 'b': 200.0, 't': 6.0, 'r': 12.0},
                 'RHS 200X200X7.1': {'h': 200.0, 'b': 200.0, 't': 7.1, 'r': 17.75},
                 'RHS 200X200X8.0': {'h': 200.0, 'b': 200.0, 't': 8.0, 'r': 20.0},
                 'RHS 200X200X8.8': {'h': 200.0, 'b': 200.0, 't': 8.8, 'r': 22.0},
                 'RHS 200X200X10.0': {'h': 200.0, 'b': 200.0, 't': 10.0, 'r': 25.0},
                 'RHS 200X200X12.5': {'h': 200.0, 'b': 200.0, 't': 12.5, 'r': 37.5},
                 'RHS 220X220X5.0': {'h': 220.0, 'b': 220.0, 't': 5.0, 'r': 10.0},
                 'RHS 220X220X6.0': {'h': 220.0, 'b': 220.0, 't': 6.0, 'r': 12.0},
                 'RHS 220X220X7.1': {'h': 220.0, 'b': 220.0, 't': 7.1, 'r': 17.75},
                 'RHS 220X220X8.0': {'h': 220.0, 'b': 220.0, 't': 8.0, 'r': 20.0},
                 'RHS 220X220X8.8': {'h': 220.0, 'b': 220.0, 't': 8.8, 'r': 22.0},
                 'RHS 220X220X10.0': {'h': 220.0, 'b': 220.0, 't': 10.0, 'r': 25.0},
                 'RHS 250X250X5.0': {'h': 250.0, 'b': 250.0, 't': 5.0, 'r': 10.0},
                 'RHS 250X250X6.0': {'h': 250.0, 'b': 250.0, 't': 6.0, 'r': 12.0},
                 'RHS 250X250X8.0': {'h': 250.0, 'b': 250.0, 't': 8.0, 'r': 20.0},
                 'RHS 250X250X10.0': {'h': 250.0, 'b': 250.0, 't': 10.0, 'r': 25.0},
                 'RHS 250X250X7.1': {'h': 250.0, 'b': 250.0, 't': 7.1, 'r': 17.75},
                 'RHS 250X250X8.8': {'h': 250.0, 'b': 250.0, 't': 8.8, 'r': 22.0},
                 'RHS 250X250X12.5': {'h': 250.0, 'b': 250.0, 't': 12.5, 'r': 37.5},
                 'RHS 260X260X6.0': {'h': 260.0, 'b': 260.0, 't': 6.0, 'r': 12.0},
                 'RHS 260X260X7.1': {'h': 260.0, 'b': 260.0, 't': 7.1, 'r': 17.75},
                 'RHS 260X260X8.0': {'h': 260.0, 'b': 260.0, 't': 8.0, 'r': 20.0},
                 'RHS 260X260X8.8': {'h': 260.0, 'b': 260.0, 't': 8.8, 'r': 22.0},
                 'RHS 260X260X10.0': {'h': 260.0, 'b': 260.0, 't': 10.0, 'r': 25.0},
                 'RHS 260X260X12.5': {'h': 260.0, 'b': 260.0, 't': 12.5, 'r': 37.5},
                 'RHS 300X300X5.0': {'h': 300.0, 'b': 300.0, 't': 5.0, 'r': 10.0},
                 'RHS 300X300X6.0': {'h': 300.0, 'b': 300.0, 't': 6.0, 'r': 12.0},
                 'RHS 300X300X7.1': {'h': 300.0, 'b': 300.0, 't': 7.1, 'r': 17.75},
                 'RHS 300X300X8.0': {'h': 300.0, 'b': 300.0, 't': 8.0, 'r': 20.0},
                 'RHS 300X300X8.8': {'h': 300.0, 'b': 300.0, 't': 8.8, 'r': 22.0},
                 'RHS 300X300X10.0': {'h': 300.0, 'b': 300.0, 't': 10.0, 'r': 25.0},
                 'RHS 300X300X12.5': {'h': 300.0, 'b': 300.0, 't': 12.5, 'r': 37.5},
                 'RHS 400X400X6.0': {'h': 400.0, 'b': 400.0, 't': 6.0, 'r': 12.0},
                 'RHS 400X400X7.1': {'h': 400.0, 'b': 400.0, 't': 7.1, 'r': 17.75},
                 'RHS 400X400X8.0': {'h': 400.0, 'b': 400.0, 't': 8.0, 'r': 20.0},
                 'RHS 400X400X8.8': {'h': 400.0, 'b': 400.0, 't': 8.8, 'r': 22.0},
                 'RHS 400X400X10.0': {'h': 400.0, 'b': 400.0, 't': 10.0, 'r': 25.0},
                 'RHS 400X400X12.5': {'h': 400.0, 'b': 400.0, 't': 12.5, 'r': 37.5}}



chs_profiles = {'CHS 26.9X2.0': {'d': 26.9, 't': 2.0},
                 'CHS 26.9X2.5': {'d': 26.9, 't': 2.5},
                 'CHS 26.9X2.6': {'d': 26.9, 't': 2.6},
                 'CHS 33.7X2.0': {'d': 33.7, 't': 2.0},
                 'CHS 33.7X2.5': {'d': 33.7, 't': 2.5},
                 'CHS 33.7X2.6': {'d': 33.7, 't': 2.6},
                 'CHS 33.7X3.0': {'d': 33.7, 't': 3.0},
                 'CHS 33.7X3.2': {'d': 33.7, 't': 3.2},
                 'CHS 42.4X2.0': {'d': 42.4, 't': 2.0},
                 'CHS 42.4X2.5': {'d': 42.4, 't': 2.5},
                 'CHS 42.4X2.6': {'d': 42.4, 't': 2.6},
                 'CHS 42.4X2.9': {'d': 42.4, 't': 2.9},
                 'CHS 42.4X3.0': {'d': 42.4, 't': 3.0},
                 'CHS 42.4X3.2': {'d': 42.4, 't': 3.2},
                 'CHS 42.4X4.0': {'d': 42.4, 't': 4.0},
                 'CHS 48.3X2.0': {'d': 48.3, 't': 2.0},
                 'CHS 48.3X2.5': {'d': 48.3, 't': 2.5},
                 'CHS 48.3X2.6': {'d': 48.3, 't': 2.6},
                 'CHS 48.3X3.0': {'d': 48.3, 't': 3.0},
                 'CHS 48.3X3.2': {'d': 48.3, 't': 3.2},
                 'CHS 48.3X4.0': {'d': 48.3, 't': 4.0},
                 'CHS 60.3X2.0': {'d': 60.3, 't': 2.0},
                 'CHS 60.3X2.5': {'d': 60.3, 't': 2.5},
                 'CHS 60.3X2.9': {'d': 60.3, 't': 2.9},
                 'CHS 60.3X3.0': {'d': 60.3, 't': 3.0},
                 'CHS 60.3X3.2': {'d': 60.3, 't': 3.2},
                 'CHS 60.3X4.0': {'d': 60.3, 't': 4.0},
                 'CHS 60.3X5.0': {'d': 60.3, 't': 5.0},
                 'CHS 76.1X2.0': {'d': 76.1, 't': 2.0},
                 'CHS 76.1X2.5': {'d': 76.1, 't': 2.5},
                 'CHS 76.1X2.9': {'d': 76.1, 't': 2.9},
                 'CHS 76.1X3.0': {'d': 76.1, 't': 3.0},
                 'CHS 76.1X4.0': {'d': 76.1, 't': 4.0},
                 'CHS 76.1X5.0': {'d': 76.1, 't': 5.0},
                 'CHS 76.1X6.3': {'d': 76.1, 't': 6.3},
                 'CHS 88.9X2.5': {'d': 88.9, 't': 2.5},
                 'CHS 88.9X3.0': {'d': 88.9, 't': 3.0},
                 'CHS 88.9X3.2': {'d': 88.9, 't': 3.2},
                 'CHS 88.9X4.0': {'d': 88.9, 't': 4.0},
                 'CHS 88.9X5.0': {'d': 88.9, 't': 5.0},
                 'CHS 88.9X6.0': {'d': 88.9, 't': 6.0},
                 'CHS 88.9X6.3': {'d': 88.9, 't': 6.3},
                 'CHS 101.6X2.5': {'d': 101.6, 't': 2.5},
                 'CHS 101.6X3.0': {'d': 101.6, 't': 3.0},
                 'CHS 101.6X3.6': {'d': 101.6, 't': 3.6},
                 'CHS 101.6X4.0': {'d': 101.6, 't': 4.0},
                 'CHS 101.6X5.0': {'d': 101.6, 't': 5.0},
                 'CHS 101.6X6.0': {'d': 101.6, 't': 6.0},
                 'CHS 101.6X6.3': {'d': 101.6, 't': 6.3},
                 'CHS 108.0X2.5': {'d': 108.0, 't': 2.5},
                 'CHS 108.0X3.0': {'d': 108.0, 't': 3.0},
                 'CHS 108.0X3.6': {'d': 108.0, 't': 3.6},
                 'CHS 108.0X4.0': {'d': 108.0, 't': 4.0},
                 'CHS 108.0X5.0': {'d': 108.0, 't': 5.0},
                 'CHS 108.0X6.0': {'d': 108.0, 't': 6.0},
                 'CHS 108.0X6.3': {'d': 108.0, 't': 6.3},
                 'CHS 114.3X2.5': {'d': 114.3, 't': 2.5},
                 'CHS 114.3X3.0': {'d': 114.3, 't': 3.0},
                 'CHS 114.3X3.6': {'d': 114.3, 't': 3.6},
                 'CHS 114.3X4.0': {'d': 114.3, 't': 4.0},
                 'CHS 114.3X5.0': {'d': 114.3, 't': 5.0},
                 'CHS 114.3X6.0': {'d': 114.3, 't': 6.0},
                 'CHS 114.3X6.3': {'d': 114.3, 't': 6.3},
                 'CHS 127.0X2.5': {'d': 127.0, 't': 2.5},
                 'CHS 127.0X3.0': {'d': 127.0, 't': 3.0},
                 'CHS 127.0X4.0': {'d': 127.0, 't': 4.0},
                 'CHS 127.0X5.0': {'d': 127.0, 't': 5.0},
                 'CHS 127.0X6.0': {'d': 127.0, 't': 6.0},
                 'CHS 127.0X6.3': {'d': 127.0, 't': 6.3},
                 'CHS 133.0X2.5': {'d': 133.0, 't': 2.5},
                 'CHS 133.0X3.0': {'d': 133.0, 't': 3.0},
                 'CHS 133.0X4.0': {'d': 133.0, 't': 4.0},
                 'CHS 133.0X5.0': {'d': 133.0, 't': 5.0},
                 'CHS 133.0X6.0': {'d': 133.0, 't': 6.0},
                 'CHS 133.0X6.3': {'d': 133.0, 't': 6.3},
                 'CHS 139.7X3.0': {'d': 139.7, 't': 3.0},
                 'CHS 139.7X4.0': {'d': 139.7, 't': 4.0},
                 'CHS 139.7X5.0': {'d': 139.7, 't': 5.0},
                 'CHS 139.7X6.0': {'d': 139.7, 't': 6.0},
                 'CHS 139.7X6.3': {'d': 139.7, 't': 6.3},
                 'CHS 139.7X8.0': {'d': 139.7, 't': 8.0},
                 'CHS 139.7X10.0': {'d': 139.7, 't': 10.0},
                 'CHS 152.4X3.0': {'d': 152.4, 't': 3.0},
                 'CHS 152.4X4.0': {'d': 152.4, 't': 4.0},
                 'CHS 152.4X5.0': {'d': 152.4, 't': 5.0},
                 'CHS 152.4X6.0': {'d': 152.4, 't': 6.0},
                 'CHS 152.4X6.3': {'d': 152.4, 't': 6.3},
                 'CHS 159.0X3.0': {'d': 159.0, 't': 3.0},
                 'CHS 159.0X4.0': {'d': 159.0, 't': 4.0},
                 'CHS 159.0X5.0': {'d': 159.0, 't': 5.0},
                 'CHS 159.0X6.0': {'d': 159.0, 't': 6.0},
                 'CHS 159.0X6.3': {'d': 159.0, 't': 6.3},
                 'CHS 168.3X3.0': {'d': 168.3, 't': 3.0},
                 'CHS 168.3X3.2': {'d': 168.3, 't': 3.2},
                 'CHS 168.3X4.0': {'d': 168.3, 't': 4.0},
                 'CHS 168.3X4.5': {'d': 168.3, 't': 4.5},
                 'CHS 168.3X5.0': {'d': 168.3, 't': 5.0},
                 'CHS 168.3X6.0': {'d': 168.3, 't': 6.0},
                 'CHS 168.3X6.3': {'d': 168.3, 't': 6.3},
                 'CHS 168.3X8.0': {'d': 168.3, 't': 8.0},
                 'CHS 168.3X10.0': {'d': 168.3, 't': 10.0},
                 'CHS 193.7X4.0': {'d': 193.7, 't': 4.0},
                 'CHS 193.7X5.0': {'d': 193.7, 't': 5.0},
                 'CHS 193.7X6.0': {'d': 193.7, 't': 6.0},
                 'CHS 193.7X6.3': {'d': 193.7, 't': 6.3},
                 'CHS 193.7X8.0': {'d': 193.7, 't': 8.0},
                 'CHS 193.7X10.0': {'d': 193.7, 't': 10.0},
                 'CHS 193.7X12.5': {'d': 193.7, 't': 12.5},
                 'CHS 219.1X4.0': {'d': 219.1, 't': 4.0},
                 'CHS 219.1X4.5': {'d': 219.1, 't': 4.5},
                 'CHS 219.1X5.0': {'d': 219.1, 't': 5.0},
                 'CHS 219.1X6.0': {'d': 219.1, 't': 6.0},
                 'CHS 219.1X6.3': {'d': 219.1, 't': 6.3},
                 'CHS 219.1X8.0': {'d': 219.1, 't': 8.0},
                 'CHS 219.1X10.0': {'d': 219.1, 't': 10.0},
                 'CHS 219.1X12.5': {'d': 219.1, 't': 12.5},
                 'CHS 244.5X6.0': {'d': 244.5, 't': 6.0},
                 'CHS 244.5X8.0': {'d': 244.5, 't': 8.0},
                 'CHS 244.5X10.0': {'d': 244.5, 't': 10.0},
                 'CHS 244.5X12.5': {'d': 244.5, 't': 12.5},
                 'CHS 273.0X4.0': {'d': 273.0, 't': 4.0},
                 'CHS 273.0X5.0': {'d': 273.0, 't': 5.0},
                 'CHS 273.0X6.0': {'d': 273.0, 't': 6.0},
                 'CHS 273.0X6.3': {'d': 273.0, 't': 6.3},
                 'CHS 273.0X8.0': {'d': 273.0, 't': 8.0},
                 'CHS 273.0X10.0': {'d': 273.0, 't': 10.0},
                 'CHS 273.0X12.5': {'d': 273.0, 't': 12.5},
                 'CHS 323.9X4.0': {'d': 323.9, 't': 4.0},
                 'CHS 323.9X5.0': {'d': 323.9, 't': 5.0},
                 'CHS 323.9X6.0': {'d': 323.9, 't': 6.0},
                 'CHS 323.9X6.3': {'d': 323.9, 't': 6.3},
                 'CHS 323.9X8.0': {'d': 323.9, 't': 8.0},
                 'CHS 323.9X10.0': {'d': 323.9, 't': 10.0},
                 'CHS 323.9X12.5': {'d': 323.9, 't': 12.5}}

def make_ipe(key):
    """ Makes an IPE section out of the 'key' used """
    from metku.sections.steel.ISection import IPE
    import re
    
    # Find height of the profile from 'key'
    h = int(re.findall('\d+',key)[0])
    
    return IPE(h,catalogue=True)

def make_hea(key):
    """ Makes an HEA section out of the 'key' used """
    from metku.sections.steel.ISection import HEA
    import re
    
    # Find height of the profile from 'key'
    h = int(re.findall('\d+',key)[0])
            
    return HEA(h,catalogue=True)

def make_heb(key):
    """ Makes an HEB section out of the 'key' used """
    from metku.sections.steel.ISection import HEB
    import re
    
    # Find height of the profile from 'key'
    h = int(re.findall('\d+',key)[0])
            
    return HEB(h,catalogue=True)


def make_rhs(key):
    """ Makes an RHS section out of the 'key' used """
    from metku.sections.steel.RHS import RHS
    import re
    
    # Find height of the profile from 'key'
    p = [float(a) for a in re.findall('(\d+\.?\d)+',key)]
    
    return RHS(p[0],p[1],p[2])    

def make_section(key):
    """ Makes a steel section out of key """
    import re
            
    prof_name = re.findall('(\S+)',key)
    
    #print(prof_name)
    
    if prof_name[0] == "IPE":
        p = make_ipe(prof_name[1])
    elif prof_name[0] == "RHS":
        p = make_rhs(prof_name[1])
    elif prof_name[0] == "HE":
        if prof_name[2] == "A":
            p = make_hea(prof_name[1])
        elif prof_name[2] == "B":
            p = make_heb(prof_name[1])
        else:
            raise ValueError("Only HEA and HEB supported of H sections.")
    else:
        raise ValueError(f'Unknown profile name {key}.')
    
    return p
    

def print_shs():
    
    from RHS import SHS

    n = 0    
    for key, value in shs_profiles.items():
        if value['t'] > 2.5 and value['b'] < 180:
            n += 1
            s = SHS(value['b'],value['t'])        
            print(str(n) + ' & ' + key + ' & '  + '{0:5.3f} & {1:5.3f} \\\\'.format(s.A*1e-2,s.Iy*1e-4))
    
    print(n)
    

"""
# Creates dict from dimensions txt -file
def R(t):
    if t <= 6:
        return 2*t
    elif 6 < t <= 10:
        return 2.5*t
    else:
        return 3*t

# NOTE! Check row indices, they are not the same for chs and shs!
chs_profiles = {} 
with open('CHS_dimensions.txt', 'r') as f:
    for row in f:
        row = row.split(' ')
        B = row[0]
        H = row[0]
        T = row[1]
        #r = R(float(T))
        profile = 'CHS ' + H + 'X' + T
        print(profile)
        values = {'d': float(H), 't': float(T)}
        chs_profiles[profile] = values
"""
       