# coding: utf-8

"""
    Stitch Connect

    https://www.stitchdata.com/docs/developers/stitch-connect/api  # noqa: E501

    The version of the OpenAPI document: 0.3
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from stitch_connect_client.configuration import Configuration


class HookNotification(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "id": "int",
        "client_id": "int",
        "created_at": "datetime",
        "modified_at": "datetime",
        "disabled_at": "datetime",
        "type": "str",
        "version": "int",
        "config": "HookNotificationConfig",
    }

    attribute_map = {
        "id": "id",
        "client_id": "client_id",
        "created_at": "created_at",
        "modified_at": "modified_at",
        "disabled_at": "disabled_at",
        "type": "type",
        "version": "version",
        "config": "config",
    }

    def __init__(
        self,
        id=None,
        client_id=None,
        created_at=None,
        modified_at=None,
        disabled_at=None,
        type=None,
        version=None,
        config=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """HookNotification - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._client_id = None
        self._created_at = None
        self._modified_at = None
        self._disabled_at = None
        self._type = None
        self._version = None
        self._config = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if client_id is not None:
            self.client_id = client_id
        if created_at is not None:
            self.created_at = created_at
        if modified_at is not None:
            self.modified_at = modified_at
        if disabled_at is not None:
            self.disabled_at = disabled_at
        if type is not None:
            self.type = type
        if version is not None:
            self.version = version
        if config is not None:
            self.config = config

    @property
    def id(self):
        """Gets the id of this HookNotification.  # noqa: E501

        The notification ID.  # noqa: E501

        :return: The id of this HookNotification.  # noqa: E501
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this HookNotification.

        The notification ID.  # noqa: E501

        :param id: The id of this HookNotification.  # noqa: E501
        :type: int
        """

        self._id = id

    @property
    def client_id(self):
        """Gets the client_id of this HookNotification.  # noqa: E501

        The ID of the Stitch client account.  # noqa: E501

        :return: The client_id of this HookNotification.  # noqa: E501
        :rtype: int
        """
        return self._client_id

    @client_id.setter
    def client_id(self, client_id):
        """Sets the client_id of this HookNotification.

        The ID of the Stitch client account.  # noqa: E501

        :param client_id: The client_id of this HookNotification.  # noqa: E501
        :type: int
        """

        self._client_id = client_id

    @property
    def created_at(self):
        """Gets the created_at of this HookNotification.  # noqa: E501

        The time at which the notification was created.  # noqa: E501

        :return: The created_at of this HookNotification.  # noqa: E501
        :rtype: datetime
        """
        return self._created_at

    @created_at.setter
    def created_at(self, created_at):
        """Sets the created_at of this HookNotification.

        The time at which the notification was created.  # noqa: E501

        :param created_at: The created_at of this HookNotification.  # noqa: E501
        :type: datetime
        """

        self._created_at = created_at

    @property
    def modified_at(self):
        """Gets the modified_at of this HookNotification.  # noqa: E501

        The time at which the notification was last modified.  # noqa: E501

        :return: The modified_at of this HookNotification.  # noqa: E501
        :rtype: datetime
        """
        return self._modified_at

    @modified_at.setter
    def modified_at(self, modified_at):
        """Sets the modified_at of this HookNotification.

        The time at which the notification was last modified.  # noqa: E501

        :param modified_at: The modified_at of this HookNotification.  # noqa: E501
        :type: datetime
        """

        self._modified_at = modified_at

    @property
    def disabled_at(self):
        """Gets the disabled_at of this HookNotification.  # noqa: E501

        The time at which the notification was disabled. This will be null unless the notification has been disabled.   # noqa: E501

        :return: The disabled_at of this HookNotification.  # noqa: E501
        :rtype: datetime
        """
        return self._disabled_at

    @disabled_at.setter
    def disabled_at(self, disabled_at):
        """Sets the disabled_at of this HookNotification.

        The time at which the notification was disabled. This will be null unless the notification has been disabled.   # noqa: E501

        :param disabled_at: The disabled_at of this HookNotification.  # noqa: E501
        :type: datetime
        """

        self._disabled_at = disabled_at

    @property
    def type(self):
        """Gets the type of this HookNotification.  # noqa: E501

        The type of the notification. Possible values are: post_load   # noqa: E501

        :return: The type of this HookNotification.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this HookNotification.

        The type of the notification. Possible values are: post_load   # noqa: E501

        :param type: The type of this HookNotification.  # noqa: E501
        :type: str
        """
        allowed_values = ["post_load"]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and type not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `type` ({0}), must be one of {1}".format(  # noqa: E501
                    type, allowed_values
                )
            )

        self._type = type

    @property
    def version(self):
        """Gets the version of this HookNotification.  # noqa: E501

        The version of the hook service the notification is using.  # noqa: E501

        :return: The version of this HookNotification.  # noqa: E501
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """Sets the version of this HookNotification.

        The version of the hook service the notification is using.  # noqa: E501

        :param version: The version of this HookNotification.  # noqa: E501
        :type: int
        """

        self._version = version

    @property
    def config(self):
        """Gets the config of this HookNotification.  # noqa: E501


        :return: The config of this HookNotification.  # noqa: E501
        :rtype: HookNotificationConfig
        """
        return self._config

    @config.setter
    def config(self, config):
        """Sets the config of this HookNotification.


        :param config: The config of this HookNotification.  # noqa: E501
        :type: HookNotificationConfig
        """

        self._config = config

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, HookNotification):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, HookNotification):
            return True

        return self.to_dict() != other.to_dict()
