# coding: utf-8

"""
    Stitch Connect

    https://www.stitchdata.com/docs/developers/stitch-connect/api  # noqa: E501

    The version of the OpenAPI document: 0.3
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from stitch_connect_client.configuration import Configuration


class ConnectionDetails(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        "access": "bool",
        "default_scheduling_interval": "int",
        "pricing_tier": "str",
        "default_start_date": "str",
        "pipeline_state": "str",
        "protocol": "str",
    }

    attribute_map = {
        "access": "access",
        "default_scheduling_interval": "default_scheduling_interval",
        "pricing_tier": "pricing_tier",
        "default_start_date": "default_start_date",
        "pipeline_state": "pipeline_state",
        "protocol": "protocol",
    }

    def __init__(
        self,
        access=None,
        default_scheduling_interval=None,
        pricing_tier=None,
        default_start_date=None,
        pipeline_state=None,
        protocol=None,
        local_vars_configuration=None,
    ):  # noqa: E501
        """ConnectionDetails - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._access = None
        self._default_scheduling_interval = None
        self._pricing_tier = None
        self._default_start_date = None
        self._pipeline_state = None
        self._protocol = None
        self.discriminator = None

        if access is not None:
            self.access = access
        if default_scheduling_interval is not None:
            self.default_scheduling_interval = default_scheduling_interval
        if pricing_tier is not None:
            self.pricing_tier = pricing_tier
        if default_start_date is not None:
            self.default_start_date = default_start_date
        if pipeline_state is not None:
            self.pipeline_state = pipeline_state
        if protocol is not None:
            self.protocol = protocol

    @property
    def access(self):
        """Gets the access of this ConnectionDetails.  # noqa: E501

        Indicates whether the Stitch client who made the request has access to the connection. This value is based on the connection’s pricing_tier and pipeline_state. If the Stitch client is using a plan that doesn’t meet the pricing_tier requirement, the access value will be false. For example: If pricing_tier: enterprise,the Stitch client must be on an Enterprise plan to access the source. All connections with a pipeline_state value of deprecated will also have an access value of false.   # noqa: E501

        :return: The access of this ConnectionDetails.  # noqa: E501
        :rtype: bool
        """
        return self._access

    @access.setter
    def access(self, access):
        """Sets the access of this ConnectionDetails.

        Indicates whether the Stitch client who made the request has access to the connection. This value is based on the connection’s pricing_tier and pipeline_state. If the Stitch client is using a plan that doesn’t meet the pricing_tier requirement, the access value will be false. For example: If pricing_tier: enterprise,the Stitch client must be on an Enterprise plan to access the source. All connections with a pipeline_state value of deprecated will also have an access value of false.   # noqa: E501

        :param access: The access of this ConnectionDetails.  # noqa: E501
        :type: bool
        """

        self._access = access

    @property
    def default_scheduling_interval(self):
        """Gets the default_scheduling_interval of this ConnectionDetails.  # noqa: E501

        Applicable only to source report cards. The default frequency_in_minutes value for the source.   # noqa: E501

        :return: The default_scheduling_interval of this ConnectionDetails.  # noqa: E501
        :rtype: int
        """
        return self._default_scheduling_interval

    @default_scheduling_interval.setter
    def default_scheduling_interval(self, default_scheduling_interval):
        """Sets the default_scheduling_interval of this ConnectionDetails.

        Applicable only to source report cards. The default frequency_in_minutes value for the source.   # noqa: E501

        :param default_scheduling_interval: The default_scheduling_interval of this ConnectionDetails.  # noqa: E501
        :type: int
        """

        self._default_scheduling_interval = default_scheduling_interval

    @property
    def pricing_tier(self):
        """Gets the pricing_tier of this ConnectionDetails.  # noqa: E501

        Indicates the type of Stitch plan required to use the connection. Possible values are: standard - Any Stitch plan can use the connection. premium - A Standard Stitch plan is required to use the connection. enterprise - An Enterprise Stitch plan is required to use the connection.   # noqa: E501

        :return: The pricing_tier of this ConnectionDetails.  # noqa: E501
        :rtype: str
        """
        return self._pricing_tier

    @pricing_tier.setter
    def pricing_tier(self, pricing_tier):
        """Sets the pricing_tier of this ConnectionDetails.

        Indicates the type of Stitch plan required to use the connection. Possible values are: standard - Any Stitch plan can use the connection. premium - A Standard Stitch plan is required to use the connection. enterprise - An Enterprise Stitch plan is required to use the connection.   # noqa: E501

        :param pricing_tier: The pricing_tier of this ConnectionDetails.  # noqa: E501
        :type: str
        """
        allowed_values = ["standard", "premium", "enterprise"]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and pricing_tier not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `pricing_tier` ({0}), must be one of {1}".format(  # noqa: E501
                    pricing_tier, allowed_values
                )
            )

        self._pricing_tier = pricing_tier

    @property
    def default_start_date(self):
        """Gets the default_start_date of this ConnectionDetails.  # noqa: E501

        Applicable only to source report cards. The default start_date value for the source.   # noqa: E501

        :return: The default_start_date of this ConnectionDetails.  # noqa: E501
        :rtype: str
        """
        return self._default_start_date

    @default_start_date.setter
    def default_start_date(self, default_start_date):
        """Sets the default_start_date of this ConnectionDetails.

        Applicable only to source report cards. The default start_date value for the source.   # noqa: E501

        :param default_start_date: The default_start_date of this ConnectionDetails.  # noqa: E501
        :type: str
        """

        self._default_start_date = default_start_date

    @property
    def pipeline_state(self):
        """Gets the pipeline_state of this ConnectionDetails.  # noqa: E501

        The connection type’s release status in Stitch. Possible values are: alpha - The connection is in development and is not available in Stitch. beta - The connection is in open or closed beta and is available in Stitch. released - The connection is in general release and available in Stitch. deprecated - The connection has been deprecated and is no longer available in Stitch.   # noqa: E501

        :return: The pipeline_state of this ConnectionDetails.  # noqa: E501
        :rtype: str
        """
        return self._pipeline_state

    @pipeline_state.setter
    def pipeline_state(self, pipeline_state):
        """Sets the pipeline_state of this ConnectionDetails.

        The connection type’s release status in Stitch. Possible values are: alpha - The connection is in development and is not available in Stitch. beta - The connection is in open or closed beta and is available in Stitch. released - The connection is in general release and available in Stitch. deprecated - The connection has been deprecated and is no longer available in Stitch.   # noqa: E501

        :param pipeline_state: The pipeline_state of this ConnectionDetails.  # noqa: E501
        :type: str
        """
        allowed_values = ["alpha", "beta", "released", "deprecated"]  # noqa: E501
        if (
            self.local_vars_configuration.client_side_validation
            and pipeline_state not in allowed_values
        ):  # noqa: E501
            raise ValueError(
                "Invalid value for `pipeline_state` ({0}), must be one of {1}".format(  # noqa: E501
                    pipeline_state, allowed_values
                )
            )

        self._pipeline_state = pipeline_state

    @property
    def protocol(self):
        """Gets the protocol of this ConnectionDetails.  # noqa: E501

        The type of the connection. For example: snowflake or platform.facebook   # noqa: E501

        :return: The protocol of this ConnectionDetails.  # noqa: E501
        :rtype: str
        """
        return self._protocol

    @protocol.setter
    def protocol(self, protocol):
        """Sets the protocol of this ConnectionDetails.

        The type of the connection. For example: snowflake or platform.facebook   # noqa: E501

        :param protocol: The protocol of this ConnectionDetails.  # noqa: E501
        :type: str
        """

        self._protocol = protocol

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(
                    map(lambda x: x.to_dict() if hasattr(x, "to_dict") else x, value)
                )
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(
                    map(
                        lambda item: (item[0], item[1].to_dict())
                        if hasattr(item[1], "to_dict")
                        else item,
                        value.items(),
                    )
                )
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ConnectionDetails):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ConnectionDetails):
            return True

        return self.to_dict() != other.to_dict()
