# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/05_utils.ipynb.

# %% auto 0
__all__ = ['load_yaml', 'RLHFConfig', 'create_reference_model', 'ModelConfig', 'TokenizerConfig', 'OptimizerConfig',
           'TrainerConfig', 'PPOConfig', 'InstructConfig']

# %% ../nbs/05_utils.ipynb 3
import yaml
from copy import deepcopy
from dataclasses import dataclass

# %% ../nbs/05_utils.ipynb 4
def load_yaml(config_path):
    with open(config_path, "r") as f:
        return yaml.safe_load(f)

# %% ../nbs/05_utils.ipynb 5
@dataclass
class RLHFConfig:
    # PPO config
    epsilon: float = 0.1
    # entropy coefficient
    ent_coef: float = 0.01
    vf_coef: float = 0.1

# %% ../nbs/05_utils.ipynb 7
def create_reference_model(model):
    ref_model = deepcopy(model).eval()
    return ref_model

# %% ../nbs/05_utils.ipynb 9
@dataclass
class ModelConfig:
    model_path: str

# %% ../nbs/05_utils.ipynb 10
@dataclass
class TokenizerConfig:
    tokenizer_path: str

# %% ../nbs/05_utils.ipynb 11
@dataclass
class OptimizerConfig:
    lr: float = 1.0e-4
    eps: float = 1.0e-8
    weight_decay: float = 1.0e-6

# %% ../nbs/05_utils.ipynb 12
@dataclass
class TrainerConfig:
    epochs: int = 20

# %% ../nbs/05_utils.ipynb 13
@dataclass
class PPOConfig:
    ent_coef: float = 0.01
    vf_coef: float = 0.5

# %% ../nbs/05_utils.ipynb 14
@dataclass
class InstructConfig:
    model: ModelConfig
    tokenizer: TokenizerConfig
