# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/01_dataset.ipynb.

# %% auto 0
__all__ = ['PairDataset', 'PromptDataset']

# %% ../nbs/01_dataset.ipynb 4
from typing import Callable, Tuple, Iterable

from torch.utils.data import Dataset
from tqdm import tqdm
from torchtyping import TensorType

# %% ../nbs/01_dataset.ipynb 6
class PairDataset(Dataset):
    """Pairwise dataset for train reward model."""
    def __init__(
        self,
        dataset: Iterable, # A dataset
        tokenizer: Callable, # The tokenizer of the reward model
        max_length: int = 1024 # Max context length of the reward model
    ):
        
        self.chosen = []
        self.rejected = []
        
        for data in tqdm(dataset):
            chosen, rejected = data["chosen"], data["rejected"]
            chosen_encoding = tokenizer(
                chosen,
                max_length=max_length, padding="max_length", truncation=True,
                return_tensors="pt"
            )
            rejected_encoding = tokenizer(
                rejected,
                max_length=max_length, padding="max_length", truncation=True,
                return_tensors="pt"
            )
            
            self.chosen.append({
                "input_ids": chosen_encoding["input_ids"],
                "attention_mask": chosen_encoding["attention_mask"]
            })
            self.rejected.append({
                "input_ids": rejected_encoding["input_ids"],
                "attention_mask": rejected_encoding["attention_mask"]
            })
    
    def __len__(self) -> int:
        return len(self.chosen)

    def __getitem__(self, idx: int) -> Tuple[
        TensorType["seq_len"], TensorType["seq_len"],
        TensorType["seq_len"], TensorType["seq_len"]
    ]:
        return self.chosen[idx]["input_ids"],\
               self.chosen[idx]["attention_mask"],\
               self.rejected[idx]["input_ids"],\
               self.rejected[idx]["attention_mask"]

# %% ../nbs/01_dataset.ipynb 9
class PromptDataset(Dataset):
    """Dataset for train RL-based language model."""
    def __init__(
        self,
        dataset: Iterable, # A dataset
        tokenizer: Callable, # The tokenizer of the language model
        max_length: int = 1024 # Max context length of the language model
    ):
        self.prompts = []
        
        for data in tqdm(dataset):
            prompt = data["prompt"]
            prompt_encoding = tokenizer(
                prompt,
                max_length=max_length, padding="max_length", truncation=True,
                return_tensors="pt"
            )
            
            self.prompts.append({
                "input_ids": prompt_encoding["input_ids"],
                "attention_mask": prompt_encoding["attention_mask"]
            })
            
    def __len__(self):
        return len(self.prompts)

    def __getitem__(self, idx: int) -> Tuple[TensorType["seq_len"], TensorType["seq_len"]]:
        return self.prompts[idx]["input_ids"],\
               self.prompts[idx]["attention_mask"]
