# SplitsTree:
# Id    Taxon    Delta Score     Q-residual
# 1    AA    0.27013    0.0406
# 2    AB    0.27921    0.041105
# 3    AC    0.328    0.030336
# 4    AD    0.26978    0.031421
# 5    AE    0.27118    0.033125
# 6    AF    0.28167    0.039248
# 7    AG    0.29062    0.049195
# 8    AH    0.28035    0.034266
# 9    AI    0.32486    0.045499
# 10    AJ    0.28668    0.046927
# 11    AK    0.35019    0.04426
# 12    AL    0.32484    0.030382
# 13    AM    0.33057    0.031204
# 14    AN    0.31396    0.027447
# 15    AO    0.30637    0.02703
# 16    AP    0.33246    0.027122
# 17    AQ    0.34761    0.038107
# 18    AR    0.32489    0.028659
# 19    AS    0.32531    0.033416
# 20    AT    0.37344    0.033957
# 21    AU    0.30578    0.04857
# 22    AV    0.30757    0.05168
# 23    AW    0.30244    0.040142
# 24    AX    0.30585    0.048
# 25    AY    0.29111    0.037047
# 26    AZ    0.36653    0.03058
# 27    BA    0.28366    0.04387
# 28    BB    0.3186    0.037878
# 29    BC    0.29954    0.037589
# 30    BD    0.329    0.037693
# 31    BE    0.33394    0.030684
# 32    BF    0.32399    0.037987
# 33    BG    0.32011    0.032013
# 34    BH    0.32112    0.036034
# 35    BI    0.34362    0.029561
# 36    BJ    0.38213    0.035062
# 37    BK    0.34991    0.035053
# 38    BL    0.34376    0.041067
# 39    BM    0.33014    0.031898
# 40    BN    0.34925    0.032781
# 41    BO    0.34732    0.032514
# 42    BP    0.33233    0.037045
# 43    BQ    0.34459    0.032023
# 44    BR    0.363    0.035953
# 45    BS    0.34162    0.029233
# 46    BT    0.34214    0.033308
# 47    BU    0.31115    0.029059
# 48    BV    0.36181    0.027127
# 49    BW    0.32007    0.028835
# 50    BX    0.31675    0.029023
# ===========================
#
# Delta score = 0.322
# Q-residual score = 0.03565

MATRIX = {}
MATRIX['AA'] = '2101011110000011010111011100111000011001001011111421221111101100000001111110000000000'
MATRIX['AB'] = '201111??0000001101211101110001?00011100100101101142021011010000000000131?10?000000000'
MATRIX['AC'] = '1001111010000011002000001100010000011000000111111220200110100010?00000311101000000000'
MATRIX['AD'] = '200101?01000001101011101110001100001100100101101142021011010000000000111?10?000000000'
MATRIX['AE'] = '2001011100000011110111011100111001011001001011011520220111100000000001210101000000000'
MATRIX['AF'] = '2001011110000011110111011200111001011011021011011520220111100000000001210101000000000'
MATRIX['AG'] = '2001010100000011110111011200111001011001121011011520220111100000000001210101000000000'
MATRIX['AH'] = '2001011110000011110111012100111000011101011011011520220111100000000001311010000000000'
MATRIX['AI'] = '2001011110000011102001111100011001010001011001011520221101100000000001311111000000000'
MATRIX['AJ'] = '200101?00000001?11?11101110011100?0100010?1011111?202201?1101000000001?1111?000000000'
MATRIX['AK'] = '0--0-00010000000-0-000000100001000111100000200011020200100100010?101103010?1000000010'
MATRIX['AL'] = '0000101010000000-0-000000100011000011000000000011020200100000010?10111311101000000010'
MATRIX['AM'] = '0000101010000000-0-000000100011000011000000000011020200100?00010?10?113?1101000000010'
MATRIX['AN'] = '10010010100000011020000221000111000110000001000111202001000000101101?1210101100000000'
MATRIX['AO'] = '100100101000000110000002200001110001100000010001112020010000001011011101?101100000000'
MATRIX['AP'] = '00?10010100000011020000?11000111000110000001000111202001000000101?0?01?10?0?000000000'
MATRIX['AQ'] = '2000000010100001101000001000000100011000000000011120100100000000100101310101000010011'
MATRIX['AR'] = '0001000010000011000200001100010000011001000111111221200100000010000001210101000000000'
MATRIX['AS'] = '0001000010000011010200001100010000011001000111111221200100000010000001210111000000000'
MATRIX['AT'] = '00111010100000010000000211000110000110000001000111212001??100010?00011211101000000010'
MATRIX['AU'] = '000000000010110100000002110000101101001012010001112?2001??000000000011011111011111110'
MATRIX['AV'] = '00000000001110011000000011001100110100100201000111212001???00000000111011111011011110'
MATRIX['AW'] = '0000000010?0000100000002110001101101001012010001112?2001??0000000?0011011111010011110'
MATRIX['AX'] = '000000000010100100000002110000101101001012010001112?2001??000000000011011111010110110'
MATRIX['AY'] = '000000001010010100000000110001101101001012010001112?2001??000000010111011111011??1110'
MATRIX['AZ'] = '200110101000000110200002110001100001100010011101112?2001?0001011100011211111000000000'
MATRIX['BA'] = '2011111110000011010111011100011000111001000011011320210100100010000001311101000000000'
MATRIX['BB'] = '20?1001?1000001102?2200211000110000110010001111113212101?000001000000131110?000000000'
MATRIX['BC'] = '001000000010001110?00000100001?11101001002010001112?2001?0000010100?0131?1110100100?0'
MATRIX['BD'] = '001000001000000110?00000100001?10?0100?001010001112?2001?0000010100?013101?10100000?0'
MATRIX['BE'] = '1001001010000011002000001100011001011001000111111321200100010010000?0121010?000000000'
MATRIX['BF'] = '1011101010000011002200001100011001111001000111111321200100110010000100301?01000000000'
MATRIX['BG'] = '100110101000001100200000110001?001011001000111?1132120?100?100100?0?013???0?000000000'
MATRIX['BH'] = '000000000000000110000000110000100101000001010001112?200100000010010101211111000000000'
MATRIX['BI'] = '0000001010000001102000001100011?0101100000010001112?200100?00010?10101211101000000000'
MATRIX['BJ'] = '000100101000000110200000110001010101100000011101112?200100000010?10101210111000000000'
MATRIX['BK'] = '000000101000000110200000110001010?01100000010001112?200100?00010110101311101000000000'
MATRIX['BL'] = '2001101010000011002200021100011000011001000011011321200100100010?10100311101000000000'
MATRIX['BM'] = '2001101010000011002000001100010000011000000111011?21200100100011?10001310101000000000'
MATRIX['BN'] = '2001101010000011002000001100010000011000000110011321200100?00011?10101310101000000000'
MATRIX['BO'] = '2001101010000011002000021100011000011000000111111121200100?00011?10101311101000000000'
MATRIX['BP'] = '20011010100000110?220002110001??000110010001100113212001001000110?0?013??101000000000'
MATRIX['BQ'] = '000110101000000110200002110101110001100000011101112120010000001?110101210101000000000'
MATRIX['BR'] = '2001101010000000-0-000001100010100011000000111011021200100?00011?10101311101000000000'
MATRIX['BS'] = '2001001010000001102000021101011100011000000111011121200100000011110101011101000000000'
MATRIX['BT'] = '200110101000000100200002110101110001100000011001112120010000001111010121?1?1000000000'
MATRIX['BU'] = '100100101000000110?000022000011?00011000000100011121100100?0001011011131?10?000000000'
MATRIX['BV'] = '2001100010000001102000021100011000011000000111011121200100000010?00001310?00000000000'
MATRIX['BW'] = '?0010010?000000110?00002201000100001100000010001102?100100000000100111310101000000010'
MATRIX['BX'] = '100100101000000110?000022010011000011000000100011121100100000010100111210101000000010'

for taxon in MATRIX:
    MATRIX[taxon] = [_ for _ in MATRIX[taxon]]


EXPECTED = {}
EXPECTED['AA'] = {'delta': 0.27013, 'q': 0.040600}
EXPECTED['AB'] = {'delta': 0.27921, 'q': 0.041105}
EXPECTED['AC'] = {'delta': 0.32800, 'q': 0.030336}
EXPECTED['AD'] = {'delta': 0.26978, 'q': 0.031421}
EXPECTED['AE'] = {'delta': 0.27118, 'q': 0.033125}
EXPECTED['AF'] = {'delta': 0.28167, 'q': 0.039248}
EXPECTED['AG'] = {'delta': 0.29062, 'q': 0.049195}
EXPECTED['AH'] = {'delta': 0.28035, 'q': 0.034266}
EXPECTED['AI'] = {'delta': 0.32486, 'q': 0.045499}
EXPECTED['AJ'] = {'delta': 0.28668, 'q': 0.046927}
EXPECTED['AK'] = {'delta': 0.35019, 'q': 0.044260}
EXPECTED['AL'] = {'delta': 0.32484, 'q': 0.030382}
EXPECTED['AM'] = {'delta': 0.33057, 'q': 0.031204}
EXPECTED['AN'] = {'delta': 0.31396, 'q': 0.027447}
EXPECTED['AO'] = {'delta': 0.30637, 'q': 0.027030}
EXPECTED['AP'] = {'delta': 0.33246, 'q': 0.027122}
EXPECTED['AQ'] = {'delta': 0.34761, 'q': 0.038107}
EXPECTED['AR'] = {'delta': 0.32489, 'q': 0.028659}
EXPECTED['AS'] = {'delta': 0.32531, 'q': 0.033416}
EXPECTED['AT'] = {'delta': 0.37344, 'q': 0.033957}
EXPECTED['AU'] = {'delta': 0.30578, 'q': 0.048570}
EXPECTED['AV'] = {'delta': 0.30757, 'q': 0.051680}
EXPECTED['AW'] = {'delta': 0.30244, 'q': 0.040142}
EXPECTED['AX'] = {'delta': 0.30585, 'q': 0.048000}
EXPECTED['AY'] = {'delta': 0.29111, 'q': 0.037047}
EXPECTED['AZ'] = {'delta': 0.36653, 'q': 0.030580}
EXPECTED['BA'] = {'delta': 0.28366, 'q': 0.043870}
EXPECTED['BB'] = {'delta': 0.31860, 'q': 0.037878}
EXPECTED['BC'] = {'delta': 0.29954, 'q': 0.037589}
EXPECTED['BD'] = {'delta': 0.32900, 'q': 0.037693}
EXPECTED['BE'] = {'delta': 0.33394, 'q': 0.030684}
EXPECTED['BF'] = {'delta': 0.32399, 'q': 0.037987}
EXPECTED['BG'] = {'delta': 0.32011, 'q': 0.032013}
EXPECTED['BH'] = {'delta': 0.32112, 'q': 0.036034}
EXPECTED['BI'] = {'delta': 0.34362, 'q': 0.029561}
EXPECTED['BJ'] = {'delta': 0.38213, 'q': 0.035062}
EXPECTED['BK'] = {'delta': 0.34991, 'q': 0.035053}
EXPECTED['BL'] = {'delta': 0.34376, 'q': 0.041067}
EXPECTED['BM'] = {'delta': 0.33014, 'q': 0.031898}
EXPECTED['BN'] = {'delta': 0.34925, 'q': 0.032781}
EXPECTED['BO'] = {'delta': 0.34732, 'q': 0.032514}
EXPECTED['BP'] = {'delta': 0.33233, 'q': 0.037045}
EXPECTED['BQ'] = {'delta': 0.34459, 'q': 0.032023}
EXPECTED['BR'] = {'delta': 0.36300, 'q': 0.035953}
EXPECTED['BS'] = {'delta': 0.34162, 'q': 0.029233}
EXPECTED['BT'] = {'delta': 0.34214, 'q': 0.033308}
EXPECTED['BU'] = {'delta': 0.31115, 'q': 0.029059}
EXPECTED['BV'] = {'delta': 0.36181, 'q': 0.027127}
EXPECTED['BW'] = {'delta': 0.32007, 'q': 0.028835}
EXPECTED['BX'] = {'delta': 0.31675, 'q': 0.029023}

