"""
Contains Preis class
and corresponding marshmallow schema for de-/serialization
"""

from decimal import Decimal
from typing import Optional

from ..enum.mengeneinheit import Mengeneinheit
from ..enum.preisstatus import Preisstatus
from ..enum.waehrungseinheit import Waehrungseinheit
from .com import COM

# pylint: disable=too-few-public-methods


class Preis(COM):
    """
    Abbildung eines Preises mit Wert, Einheit, Bezugswert und Status.

    .. raw:: html

        <object data="../_static/images/bo4e/com/Preis.svg" type="image/svg+xml"></object>

    .. HINT::
        `Preis JSON Schema <https://json-schema.app/view/%23?url=https://raw.githubusercontent.com/Hochfrequenz/BO4E-python/main/json_schemas/com/Preis.json>`_

    """

    #: Gibt die nominale Höhe des Preises an.
    wert: Optional[Decimal] = None
    #: Währungseinheit für den Preis, z.B. Euro oder Ct.
    einheit: Optional[Waehrungseinheit] = None
    #: Angabe, für welche Bezugsgröße der Preis gilt. Z.B. kWh.
    bezugswert: Optional[Mengeneinheit] = None

    #: Gibt den Status des veröffentlichten Preises an
    status: Optional[Preisstatus] = None
