# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['omnidep', 'omnidep.tst']

package_data = \
{'': ['*'],
 'omnidep.tst': ['test_cases/*',
                 'test_cases/case_insensitive_sorted/*',
                 'test_cases/case_sensitive_sorted/*',
                 'test_cases/unsorted/*']}

install_requires = \
['importlib-metadata>=1.1.0', 'tomli>=1.1.0']

extras_require = \
{':python_version < "3.10"': ['isort>=5.0.1']}

entry_points = \
{'console_scripts': ['omnidep = omnidep.main:script_entry_point']}

setup_kwargs = {
    'name': 'omnidep',
    'version': '0.3.0',
    'description': 'Linter to compare project dependencies against imports in source code',
    'long_description': '=======\nOmnidep\n=======\n\nA Python linter to compare a project\'s declared dependencies against the import\nstatements in its source code.\n\n.. image:: https://github.com/sjjessop/omnidep/workflows/tests/badge.svg?branch=develop\n   :alt: Test status\n   :target: https://github.com/sjjessop/omnidep/actions?query=workflow%3Atests+branch%3Adevelop\n\n.. image:: https://img.shields.io/badge/python-3.7%20%7C%203.8%20%7C%203.9%20%7C%203.10-blue.svg\n   :alt: Python versions 3.7 3.8 3.9 3.10\n   :target: https://www.python.org/downloads/\n\n.. image:: https://img.shields.io/badge/badges-3-green.svg\n   :alt: 3 badges\n   :target: https://shields.io/\n\nPurpose\n=======\n\nProvides warnings when a project imports packages that it doesn\'t declare a\ndependency on, plus some related linting of the project dependency data.\n\nCurrently only poetry projects are supported (configured in pyproject.toml).\n\nUsage\n-----\n\n.. code-block:: bash\n\n    omnidep pyproject.toml\n\nError codes explained\n---------------------\n\nX, Y, P, Q, R, represent the names of imports or dependencies, depending on the\nmessage.\n\nODEP001\n^^^^^^^\n\n| ``package \'X\' is imported but not listed in dependencies``\n| ``package \'X\' is imported but not listed in dev-dependencies``\n|\n\nX is the name you imported, which is not necessarily the same as the name of\nthe project used to install it (for example the project ``beautifulsoup4``\ninstalls the package ``bs4``). omnidep does its best to find what project your\ndesired package comes from, but if it fails, or if you don\'t have a suitable\ndependency, then this is the result.\n\nTo fix:\n\n* List the project name in your dependencies. If the package is used from test\n  code, then the dependency can be either dev or non-dev. If the package is\n  used from non-test code, then the dependency needs to be non-dev.\n* To ignore the import, add it to the list of ignored imports in your\n  ``[tool.omnidep]`` config, like ``ignore-imports = ["X"]``.\n* The package might come from a dependency of a dependency, and you might\n  prefer not to explicitly list it as a direct dependency too, so you can list\n  X as a child of some other dependency that you do list. You should only do\n  this when the indirect dependency is inherent to the direct dependency, for\n  example ``boto3`` provides ``botocore``. Otherwise there\'s a risk that the\n  indirect dependency will introduce breaking changes, which the direct\n  dependency doesn\'t care about and so accepts the new version, but which break\n  your particular usage of the indirect dependency. To do this, then\n  you can add ``child-packages = {something = ["X"]}`` to your\n  ``[tool.omnidep]`` config, meaning that the project named "something"\n  provides "X", and so a dependency on "something" is acceptable in place of a\n  dependency on "X".\n\nODEP002\n^^^^^^^\n\n``module \'X\' is imported but not installed``\n\nNot only is there no dependency found that provides X, but X isn\'t even\ncurrently installed. omnidep relies on locally installed metadata to help it\nfind what dependencies correspond to what imports.\n\nTo fix:\n\n* Install your project, bringing in its dependencies.\n* Add a dependency that provides X.\n* Ignore the import by listing it in your in your ``[tool.omnidep]`` config,\n  like ``ignore-imports = ["X"]``.\n\nODEP003\n^^^^^^^\n\n``Namespace package found: any of [\'P\', \'Q\', \'R\'] might provide \'X\'``\n\nIf projects P, Q, and R all provide code in the Python package X, then omnidep\ndoesn\'t know which one you need in order to satisfy a given import. If you\ndeclare dependencies on all of them (that is, all the ones you currently have\ninstalled), then omnidep is satisfied. If you depend on some but not others,\nthen you get this message.\n\nTo fix:\n\n* If you don\'t need the ones you don\'t declare dependencies on, and they are\n  installed accidentally, then uninstall them.\n* If appropriate, declare dependencies on all of P, Q, and R. However, this\n  might not be appropriate because P and Q might be genuine direct dependencies\n  of your code, whereas R was pulled in indirectly via something else. You\n  don\'t want to have to list indirect dependencies as direct dependencies.\n* Otherwise you have to resolve for yourself whether your dependencies are\n  adequate, then ignore the import with ``ignore-imports = ["X"]`` in your\n  ``[tool.omnidep]`` config.\n\n\nODEP004\n^^^^^^^\n\n``Namespace package found: any of [\'P\', \'Q\', \'R\'] might provide \'X\', and there are no dependencies on any of them``\n\nIf projects P, Q, and R all provide code in the Python package X, then omnidep\ndoesn\'t know which one you need in order to satisfy a given import. If you\ndeclare dependencies on all of them (that is, all the ones you currently have\ninstalled), then omnidep is satisfied. If you depend on none of them,\nthen you get this message.\n\nTo fix:\n\n* If appropriate, declare dependencies on all of P, Q, and R. However, this\n  might not be appropriate because P and Q might be genuine direct dependencies\n  of your code, whereas R was pulled in indirectly via something else. You\n  don\'t want to have to list indirect dependencies as direct dependencies.\n* Otherwise you have to resolve for yourself whether your dependencies are\n  adequate, then ignore the import with ``ignore-imports = ["X"]`` in your\n  ``[tool.omnidep]`` config.\n\n\nODEP005\n^^^^^^^\n\n``unused dependencies in project file: {\'X\', \'Y\'}``\n\nomnidep expects you not to list any dependencies that you don\'t import. This\nmight be completely legitimate, for example:\n\n* the dependency is a plugin to some framework and will be used via some means\n  other than an explicit ``import`` in your code;\n* you are controlling the version of an indirect dependency, to deal with\n  some problem caused by unexpected breaking changes.\n\nUnused dev-dependencies are always ignored, since they tend to include linters\nand suchlike.\n\nTo fix:\n\n* Remove the dependency.\n* List the dependency in your ``[tool.omnidep]`` config like\n  ``ignore-dependencies = ["X"]``.\n\nODEP006\n^^^^^^^\n\n| ``dependencies are not sorted: \'Y\' before \'X\'``\n| ``dev-dependencies are not sorted: \'Y\' before \'X\'``\n|\n\nIgnoring ``python``, which is allowed to come first, omnidep expects you to\nlist dependencies in case-insensitive alphabetical order within each section\n(dev and non-dev).\n\nTo fix: Either list your dependencies alphabetically, or set\n``ignore-dependencies-order = true`` or\n``ignore-dev-dependencies-order = true`` in your ``[tool.omnidep]`` config.\n\nODEP007\n^^^^^^^\n\n``dependency \'X\' is not the preferred name: consider \'Y\'``\n\nomnidep expects you to use either of two formats to name dependencies in your\nproject file: the "Normalized Name" as defined in\n`PEP 503 <https://peps.python.org/pep-0503/>`_ or the name the dependency uses\nfor itself in its metadata. Any name that normalizes to the same value will\nwork, but inconsistent naming tends to lead to confusion, or to failing to find\nmentions when you search for them.\n\nTo fix: Use the name omnidep suggests, or the normalized name.\n\nODEP008\n^^^^^^^\n\n``Module \'X\' not under package management but found on python path``\n\nomnidep cannot find any project that provides X, but it is available to import.\nThis can happen for example if you have set up the ``PYTHONPATH`` to find the\ncode, instead of installing it as a dependency.\n\nTo fix:\n\n* If this is an error, list a suitable dependency.\n* If you know what you\'re doing, and users of your project will know how to\n  supply the code that you\'re importing, then ignore the import with\n  ``ignore-imports = ["X"]`` in your ``[tool.omnidep]`` config.\n\nChangelog\n=========\n\n0.3.0\n-----\n\n* When testing that dependencies are sorted, do it case-insensitive.\n* Deal with some build issues.\n\n0.2.1\n-----\n\n* Refer to online docs insted of long message in terminal.\n* Publish to PyPI.\n\n0.2.0\n-----\n\n* Minor documentation improvements.\n* Lower bounds for dependencies importlib-metadata, isort, and tomli.\n* CI test of the lower-bound versions.\n',
    'author': 'Steve Jessop',
    'author_email': '68118527+sjjessop@users.noreply.github.com',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/sjjessop/omnidep',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'extras_require': extras_require,
    'entry_points': entry_points,
    'python_requires': '>=3.7.0,<4.0.0',
}


setup(**setup_kwargs)
