"""Type stub file for SmartKDB v5."""

from typing import Dict, List, Any, Optional, Literal
from enum import Enum

# Core Engine
class KTable:
    """Represents a database table."""
    def __init__(self, db: SmartKDB, name: str, pk: str = ..., indexes: Optional[List[str]] = ...) -> None: ...
    def insert(self, doc: Dict[str, Any], transaction_id: Optional[str] = ...) -> Dict[str, Any]: ...
    def get(self, id_val: str) -> Optional[Dict[str, Any]]: ...
    def update(self, id_val: str, updates: Dict[str, Any], transaction_id: Optional[str] = ...) -> Dict[str, Any]: ...
    def delete(self, id_val: str, transaction_id: Optional[str] = ...) -> None: ...
    def query(self) -> QueryBuilder: ...

class QueryBuilder:
    """Query builder for fluent query construction."""
    def __init__(self, table: KTable) -> None: ...
    def where(self, field: str, op: str, value: Any) -> QueryBuilder: ...
    def execute(self) -> List[Dict[str, Any]]: ...

class SmartKDB:
    """
    Main SmartKDB database class.
    
    Provides a cognitive, AI-native embedded database with ACID transactions,
    versioning, and distributed capabilities.
    """
    def __init__(self, path: str = ...) -> None: ...
    def create_table(self, name: str, pk: str = ..., indexes: Optional[List[str]] = ...) -> KTable: ...
    def get_table(self, name: str) -> KTable: ...
    def login(self, user: str, password: str) -> None: ...
    
    # Properties
    @property
    def tx_manager(self) -> TransactionManager: ...
    @property
    def version_manager(self) -> VersionManager: ...
    @property
    def node_manager(self) -> NodeManager: ...
    @property
    def brain(self) -> Brain: ...
    @property
    def auth(self) -> AuthManager: ...

class AuthManager:
    """Authentication and authorization manager."""
    def __init__(self, db: SmartKDB) -> None: ...
    def create_user(self, username: str, password: str, role: str) -> None: ...

# Transaction System
class TransactionState(Enum):
    ACTIVE: str
    COMMITTED: str
    ROLLED_BACK: str

class Transaction:
    """Represents a database transaction."""
    id: str
    state: TransactionState
    def add_operation(self, table: str, op_type: str, data: Any, original_data: Optional[Any] = ...) -> None: ...
    def create_savepoint(self, name: str) -> None: ...
    def rollback_to_savepoint(self, name: str) -> List[Dict[str, Any]]: ...

class TransactionManager:
    """Manages ACID transactions."""
    def begin(self) -> str: ...
    def commit(self, tx_id: str) -> bool: ...
    def rollback(self, tx_id: str) -> bool: ...
    def get_transaction(self, tx_id: str) -> Optional[Transaction]: ...

# Versioning
class VersionManager:
    """Manages data versioning and time-travel queries."""
    def __init__(self, db_path: str) -> None: ...
    def archive_record(self, table: str, record_id: str, data: Dict[str, Any], timestamp: Optional[float] = ...) -> None: ...
    def get_version_at(self, table: str, record_id: str, timestamp: float) -> Optional[Dict[str, Any]]: ...
    def get_history(self, table: str, record_id: str) -> List[Dict[str, Any]]: ...

# Distributed
class NodeManager:
    """Manages distributed cluster nodes."""
    def __init__(self, my_address: str, peers: Optional[List[str]] = ...) -> None: ...
    def join_cluster(self, seed_node: str) -> None: ...
    def broadcast_update(self, table: str, record_id: str, data: Dict[str, Any]) -> None: ...
    def get_cluster_status(self) -> Dict[str, Any]: ...

# AI Layer
class Brain:
    """AI Brain for query optimization and learning."""
    stats: Dict[str, Any]
    def log_query(self, table: str, query_type: str, duration: float) -> None: ...
    def suggest_indexes(self, table: str) -> List[str]: ...

class Trainer:
    """AI Trainer for dataset optimization."""
    def optimize_training(self, dataset_name: str) -> Dict[str, Any]: ...
    def suggest_cleaning(self, table_name: str) -> List[str]: ...
    def generate_report(self) -> str: ...

class LLMConnector:
    """Connector for Large Language Models."""
    def __init__(self, provider: Literal["openai", "local"] = ..., api_key: Optional[str] = ...) -> None: ...
    def query(self, prompt: str) -> str: ...

# Plugins
class PluginManager:
    """Manages database plugins."""
    def __init__(self, db: SmartKDB) -> None: ...
    def load_plugins(self) -> None: ...
    def get_plugin(self, name: str) -> Optional[Any]: ...
