class ComplyAdvantageError(Exception):
    """Wrapper for exceptions generated by the ComplyAdvantage API."""

    def __init__(self, message, resp={}):
        self.resp = resp
        try:
            error = resp["errors"][0]
        except KeyError:
            error = {}
        self.code = error.get("code", -1)
        self.msg = error.get("message", message)
        super(ComplyAdvantageError, self).__init__(self.msg)
