# DO NOT EDIT! This file is automatically generated
import marshmallow
import marshmallow_enum

from commercetools import helpers, types
from commercetools._schemas._common import (
    BaseResourceSchema,
    LocalizedStringField,
    ReferenceSchema,
    ResourceIdentifierSchema,
)
from commercetools._schemas._type import FieldContainerField

__all__ = [
    "CartAddCustomLineItemActionSchema",
    "CartAddDiscountCodeActionSchema",
    "CartAddItemShippingAddressActionSchema",
    "CartAddLineItemActionSchema",
    "CartAddPaymentActionSchema",
    "CartAddShoppingListActionSchema",
    "CartApplyDeltaToCustomLineItemShippingDetailsTargetsActionSchema",
    "CartApplyDeltaToLineItemShippingDetailsTargetsActionSchema",
    "CartChangeCustomLineItemMoneyActionSchema",
    "CartChangeCustomLineItemQuantityActionSchema",
    "CartChangeLineItemQuantityActionSchema",
    "CartChangeTaxCalculationModeActionSchema",
    "CartChangeTaxModeActionSchema",
    "CartChangeTaxRoundingModeActionSchema",
    "CartDraftSchema",
    "CartPagedQueryResponseSchema",
    "CartRecalculateActionSchema",
    "CartReferenceSchema",
    "CartRemoveCustomLineItemActionSchema",
    "CartRemoveDiscountCodeActionSchema",
    "CartRemoveItemShippingAddressActionSchema",
    "CartRemoveLineItemActionSchema",
    "CartRemovePaymentActionSchema",
    "CartResourceIdentifierSchema",
    "CartSchema",
    "CartSetAnonymousIdActionSchema",
    "CartSetBillingAddressActionSchema",
    "CartSetCartTotalTaxActionSchema",
    "CartSetCountryActionSchema",
    "CartSetCustomFieldActionSchema",
    "CartSetCustomLineItemCustomFieldActionSchema",
    "CartSetCustomLineItemCustomTypeActionSchema",
    "CartSetCustomLineItemShippingDetailsActionSchema",
    "CartSetCustomLineItemTaxAmountActionSchema",
    "CartSetCustomLineItemTaxRateActionSchema",
    "CartSetCustomShippingMethodActionSchema",
    "CartSetCustomTypeActionSchema",
    "CartSetCustomerEmailActionSchema",
    "CartSetCustomerGroupActionSchema",
    "CartSetCustomerIdActionSchema",
    "CartSetDeleteDaysAfterLastModificationActionSchema",
    "CartSetLineItemCustomFieldActionSchema",
    "CartSetLineItemCustomTypeActionSchema",
    "CartSetLineItemDistributionChannelActionSchema",
    "CartSetLineItemPriceActionSchema",
    "CartSetLineItemShippingDetailsActionSchema",
    "CartSetLineItemTaxAmountActionSchema",
    "CartSetLineItemTaxRateActionSchema",
    "CartSetLineItemTotalPriceActionSchema",
    "CartSetLocaleActionSchema",
    "CartSetShippingAddressActionSchema",
    "CartSetShippingMethodActionSchema",
    "CartSetShippingMethodTaxAmountActionSchema",
    "CartSetShippingMethodTaxRateActionSchema",
    "CartSetShippingRateInputActionSchema",
    "CartUpdateActionSchema",
    "CartUpdateItemShippingAddressActionSchema",
    "CartUpdateSchema",
    "ClassificationShippingRateInputDraftSchema",
    "ClassificationShippingRateInputSchema",
    "CustomLineItemDraftSchema",
    "CustomLineItemSchema",
    "DiscountCodeInfoSchema",
    "DiscountedLineItemPortionSchema",
    "DiscountedLineItemPriceForQuantitySchema",
    "DiscountedLineItemPriceSchema",
    "ExternalLineItemTotalPriceSchema",
    "ExternalTaxAmountDraftSchema",
    "ExternalTaxRateDraftSchema",
    "ItemShippingDetailsDraftSchema",
    "ItemShippingDetailsSchema",
    "ItemShippingTargetSchema",
    "LineItemDraftSchema",
    "LineItemSchema",
    "ReplicaCartDraftSchema",
    "ScoreShippingRateInputDraftSchema",
    "ScoreShippingRateInputSchema",
    "ShippingInfoSchema",
    "ShippingRateInputDraftSchema",
    "ShippingRateInputSchema",
    "TaxPortionDraftSchema",
    "TaxPortionSchema",
    "TaxedItemPriceSchema",
    "TaxedPriceDraftSchema",
    "TaxedPriceSchema",
]


class CartDraftSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.CartDraft`."""

    currency = marshmallow.fields.String()
    customer_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="customerId"
    )
    customer_email = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="customerEmail"
    )
    customer_group = helpers.LazyNestedField(
        nested="commercetools._schemas._customer_group.CustomerGroupResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="customerGroup",
    )
    anonymous_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="anonymousId"
    )
    store = helpers.LazyNestedField(
        nested="commercetools._schemas._store.StoreResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    country = marshmallow.fields.String(allow_none=True, missing=None)
    inventory_mode = marshmallow_enum.EnumField(
        types.InventoryMode, by_value=True, missing=None, data_key="inventoryMode"
    )
    tax_mode = marshmallow_enum.EnumField(
        types.TaxMode, by_value=True, missing=None, data_key="taxMode"
    )
    tax_rounding_mode = marshmallow_enum.EnumField(
        types.RoundingMode, by_value=True, missing=None, data_key="taxRoundingMode"
    )
    tax_calculation_mode = marshmallow_enum.EnumField(
        types.TaxCalculationMode,
        by_value=True,
        missing=None,
        data_key="taxCalculationMode",
    )
    line_items = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.LineItemDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        missing=None,
        data_key="lineItems",
    )
    custom_line_items = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.CustomLineItemDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        missing=None,
        data_key="customLineItems",
    )
    shipping_address = helpers.LazyNestedField(
        nested="commercetools._schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingAddress",
    )
    billing_address = helpers.LazyNestedField(
        nested="commercetools._schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="billingAddress",
    )
    shipping_method = helpers.LazyNestedField(
        nested="commercetools._schemas._shipping_method.ShippingMethodResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingMethod",
    )
    external_tax_rate_for_shipping_method = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ExternalTaxRateDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalTaxRateForShippingMethod",
    )
    custom = helpers.LazyNestedField(
        nested="commercetools._schemas._type.CustomFieldsDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    locale = marshmallow.fields.String(allow_none=True, missing=None)
    delete_days_after_last_modification = marshmallow.fields.Integer(
        allow_none=True, missing=None, data_key="deleteDaysAfterLastModification"
    )
    origin = marshmallow_enum.EnumField(types.CartOrigin, by_value=True, missing=None)
    shipping_rate_input = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "Classification": "commercetools._schemas._cart.ClassificationShippingRateInputDraftSchema",
            "Score": "commercetools._schemas._cart.ScoreShippingRateInputDraftSchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingRateInput",
    )
    item_shipping_addresses = helpers.LazyNestedField(
        nested="commercetools._schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        missing=None,
        data_key="itemShippingAddresses",
    )
    discount_codes = marshmallow.fields.List(
        marshmallow.fields.String(allow_none=True),
        missing=None,
        data_key="discountCodes",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.CartDraft(**data)


class CartPagedQueryResponseSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.CartPagedQueryResponse`."""

    limit = marshmallow.fields.Integer(allow_none=True)
    count = marshmallow.fields.Integer(allow_none=True)
    total = marshmallow.fields.Integer(allow_none=True, missing=None)
    offset = marshmallow.fields.Integer(allow_none=True)
    results = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.CartSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.CartPagedQueryResponse(**data)


class CartReferenceSchema(ReferenceSchema):
    """Marshmallow schema for :class:`commercetools.types.CartReference`."""

    obj = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.CartSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type_id"]
        return types.CartReference(**data)


class CartResourceIdentifierSchema(ResourceIdentifierSchema):
    """Marshmallow schema for :class:`commercetools.types.CartResourceIdentifier`."""

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type_id"]
        return types.CartResourceIdentifier(**data)


class CartSchema(BaseResourceSchema):
    """Marshmallow schema for :class:`commercetools.types.Cart`."""

    id = marshmallow.fields.String(allow_none=True)
    version = marshmallow.fields.Integer(allow_none=True)
    created_at = marshmallow.fields.DateTime(allow_none=True, data_key="createdAt")
    last_modified_at = marshmallow.fields.DateTime(
        allow_none=True, data_key="lastModifiedAt"
    )
    last_modified_by = helpers.LazyNestedField(
        nested="commercetools._schemas._common.LastModifiedBySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="lastModifiedBy",
    )
    created_by = helpers.LazyNestedField(
        nested="commercetools._schemas._common.CreatedBySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="createdBy",
    )
    customer_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="customerId"
    )
    customer_email = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="customerEmail"
    )
    anonymous_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="anonymousId"
    )
    store = helpers.LazyNestedField(
        nested="commercetools._schemas._store.StoreKeyReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    line_items = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.LineItemSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        data_key="lineItems",
    )
    custom_line_items = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.CustomLineItemSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        data_key="customLineItems",
    )
    total_price = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "centPrecision": "commercetools._schemas._common.CentPrecisionMoneySchema",
            "highPrecision": "commercetools._schemas._common.HighPrecisionMoneySchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="totalPrice",
    )
    taxed_price = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.TaxedPriceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="taxedPrice",
    )
    cart_state = marshmallow_enum.EnumField(
        types.CartState, by_value=True, data_key="cartState"
    )
    shipping_address = helpers.LazyNestedField(
        nested="commercetools._schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingAddress",
    )
    billing_address = helpers.LazyNestedField(
        nested="commercetools._schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="billingAddress",
    )
    inventory_mode = marshmallow_enum.EnumField(
        types.InventoryMode, by_value=True, missing=None, data_key="inventoryMode"
    )
    tax_mode = marshmallow_enum.EnumField(
        types.TaxMode, by_value=True, data_key="taxMode"
    )
    tax_rounding_mode = marshmallow_enum.EnumField(
        types.RoundingMode, by_value=True, data_key="taxRoundingMode"
    )
    tax_calculation_mode = marshmallow_enum.EnumField(
        types.TaxCalculationMode, by_value=True, data_key="taxCalculationMode"
    )
    customer_group = helpers.LazyNestedField(
        nested="commercetools._schemas._customer_group.CustomerGroupReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="customerGroup",
    )
    country = marshmallow.fields.String(missing=None)
    shipping_info = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ShippingInfoSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingInfo",
    )
    discount_codes = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.DiscountCodeInfoSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        missing=None,
        data_key="discountCodes",
    )
    custom = helpers.LazyNestedField(
        nested="commercetools._schemas._type.CustomFieldsSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    payment_info = helpers.LazyNestedField(
        nested="commercetools._schemas._order.PaymentInfoSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="paymentInfo",
    )
    locale = marshmallow.fields.String(allow_none=True, missing=None)
    delete_days_after_last_modification = marshmallow.fields.Integer(
        allow_none=True, missing=None, data_key="deleteDaysAfterLastModification"
    )
    refused_gifts = helpers.LazyNestedField(
        nested="commercetools._schemas._cart_discount.CartDiscountReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        data_key="refusedGifts",
    )
    origin = marshmallow_enum.EnumField(types.CartOrigin, by_value=True)
    shipping_rate_input = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "Classification": "commercetools._schemas._cart.ClassificationShippingRateInputSchema",
            "Score": "commercetools._schemas._cart.ScoreShippingRateInputSchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingRateInput",
    )
    item_shipping_addresses = helpers.LazyNestedField(
        nested="commercetools._schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        missing=None,
        data_key="itemShippingAddresses",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.Cart(**data)


class CartUpdateActionSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.CartUpdateAction`."""

    action = marshmallow.fields.String(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartUpdateAction(**data)


class CartUpdateSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.CartUpdate`."""

    version = marshmallow.fields.Integer(allow_none=True)
    actions = marshmallow.fields.List(
        helpers.Discriminator(
            discriminator_field=("action", "action"),
            discriminator_schemas={
                "addCustomLineItem": "commercetools._schemas._cart.CartAddCustomLineItemActionSchema",
                "addDiscountCode": "commercetools._schemas._cart.CartAddDiscountCodeActionSchema",
                "addItemShippingAddress": "commercetools._schemas._cart.CartAddItemShippingAddressActionSchema",
                "addLineItem": "commercetools._schemas._cart.CartAddLineItemActionSchema",
                "addPayment": "commercetools._schemas._cart.CartAddPaymentActionSchema",
                "addShoppingList": "commercetools._schemas._cart.CartAddShoppingListActionSchema",
                "applyDeltaToCustomLineItemShippingDetailsTargets": "commercetools._schemas._cart.CartApplyDeltaToCustomLineItemShippingDetailsTargetsActionSchema",
                "applyDeltaToLineItemShippingDetailsTargets": "commercetools._schemas._cart.CartApplyDeltaToLineItemShippingDetailsTargetsActionSchema",
                "changeCustomLineItemMoney": "commercetools._schemas._cart.CartChangeCustomLineItemMoneyActionSchema",
                "changeCustomLineItemQuantity": "commercetools._schemas._cart.CartChangeCustomLineItemQuantityActionSchema",
                "changeLineItemQuantity": "commercetools._schemas._cart.CartChangeLineItemQuantityActionSchema",
                "changeTaxCalculationMode": "commercetools._schemas._cart.CartChangeTaxCalculationModeActionSchema",
                "changeTaxMode": "commercetools._schemas._cart.CartChangeTaxModeActionSchema",
                "changeTaxRoundingMode": "commercetools._schemas._cart.CartChangeTaxRoundingModeActionSchema",
                "recalculate": "commercetools._schemas._cart.CartRecalculateActionSchema",
                "removeCustomLineItem": "commercetools._schemas._cart.CartRemoveCustomLineItemActionSchema",
                "removeDiscountCode": "commercetools._schemas._cart.CartRemoveDiscountCodeActionSchema",
                "removeItemShippingAddress": "commercetools._schemas._cart.CartRemoveItemShippingAddressActionSchema",
                "removeLineItem": "commercetools._schemas._cart.CartRemoveLineItemActionSchema",
                "removePayment": "commercetools._schemas._cart.CartRemovePaymentActionSchema",
                "setAnonymousId": "commercetools._schemas._cart.CartSetAnonymousIdActionSchema",
                "setBillingAddress": "commercetools._schemas._cart.CartSetBillingAddressActionSchema",
                "setCartTotalTax": "commercetools._schemas._cart.CartSetCartTotalTaxActionSchema",
                "setCountry": "commercetools._schemas._cart.CartSetCountryActionSchema",
                "setCustomField": "commercetools._schemas._cart.CartSetCustomFieldActionSchema",
                "setCustomLineItemCustomField": "commercetools._schemas._cart.CartSetCustomLineItemCustomFieldActionSchema",
                "setCustomLineItemCustomType": "commercetools._schemas._cart.CartSetCustomLineItemCustomTypeActionSchema",
                "setCustomLineItemShippingDetails": "commercetools._schemas._cart.CartSetCustomLineItemShippingDetailsActionSchema",
                "setCustomLineItemTaxAmount": "commercetools._schemas._cart.CartSetCustomLineItemTaxAmountActionSchema",
                "setCustomLineItemTaxRate": "commercetools._schemas._cart.CartSetCustomLineItemTaxRateActionSchema",
                "setCustomShippingMethod": "commercetools._schemas._cart.CartSetCustomShippingMethodActionSchema",
                "setCustomType": "commercetools._schemas._cart.CartSetCustomTypeActionSchema",
                "setCustomerEmail": "commercetools._schemas._cart.CartSetCustomerEmailActionSchema",
                "setCustomerGroup": "commercetools._schemas._cart.CartSetCustomerGroupActionSchema",
                "setCustomerId": "commercetools._schemas._cart.CartSetCustomerIdActionSchema",
                "setDeleteDaysAfterLastModification": "commercetools._schemas._cart.CartSetDeleteDaysAfterLastModificationActionSchema",
                "setLineItemCustomField": "commercetools._schemas._cart.CartSetLineItemCustomFieldActionSchema",
                "setLineItemCustomType": "commercetools._schemas._cart.CartSetLineItemCustomTypeActionSchema",
                "setLineItemDistributionChannel": "commercetools._schemas._cart.CartSetLineItemDistributionChannelActionSchema",
                "setLineItemPrice": "commercetools._schemas._cart.CartSetLineItemPriceActionSchema",
                "setLineItemShippingDetails": "commercetools._schemas._cart.CartSetLineItemShippingDetailsActionSchema",
                "setLineItemTaxAmount": "commercetools._schemas._cart.CartSetLineItemTaxAmountActionSchema",
                "setLineItemTaxRate": "commercetools._schemas._cart.CartSetLineItemTaxRateActionSchema",
                "setLineItemTotalPrice": "commercetools._schemas._cart.CartSetLineItemTotalPriceActionSchema",
                "setLocale": "commercetools._schemas._cart.CartSetLocaleActionSchema",
                "setShippingAddress": "commercetools._schemas._cart.CartSetShippingAddressActionSchema",
                "setShippingMethod": "commercetools._schemas._cart.CartSetShippingMethodActionSchema",
                "setShippingMethodTaxAmount": "commercetools._schemas._cart.CartSetShippingMethodTaxAmountActionSchema",
                "setShippingMethodTaxRate": "commercetools._schemas._cart.CartSetShippingMethodTaxRateActionSchema",
                "setShippingRateInput": "commercetools._schemas._cart.CartSetShippingRateInputActionSchema",
                "updateItemShippingAddress": "commercetools._schemas._cart.CartUpdateItemShippingAddressActionSchema",
            },
            unknown=marshmallow.EXCLUDE,
            allow_none=True,
        ),
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.CartUpdate(**data)


class CustomLineItemDraftSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.CustomLineItemDraft`."""

    name = LocalizedStringField(allow_none=True)
    quantity = marshmallow.fields.Integer(allow_none=True)
    money = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    slug = marshmallow.fields.String(allow_none=True)
    tax_category = helpers.LazyNestedField(
        nested="commercetools._schemas._tax_category.TaxCategoryResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="taxCategory",
    )
    external_tax_rate = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ExternalTaxRateDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalTaxRate",
    )
    custom = helpers.LazyNestedField(
        nested="commercetools._schemas._type.CustomFieldsSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    shipping_details = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ItemShippingDetailsDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingDetails",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.CustomLineItemDraft(**data)


class CustomLineItemSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.CustomLineItem`."""

    id = marshmallow.fields.String(allow_none=True)
    name = LocalizedStringField(allow_none=True)
    money = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "centPrecision": "commercetools._schemas._common.CentPrecisionMoneySchema",
            "highPrecision": "commercetools._schemas._common.HighPrecisionMoneySchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    taxed_price = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.TaxedItemPriceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="taxedPrice",
    )
    total_price = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "centPrecision": "commercetools._schemas._common.CentPrecisionMoneySchema",
            "highPrecision": "commercetools._schemas._common.HighPrecisionMoneySchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="totalPrice",
    )
    slug = marshmallow.fields.String(allow_none=True)
    quantity = marshmallow.fields.Integer(allow_none=True)
    state = helpers.LazyNestedField(
        nested="commercetools._schemas._order.ItemStateSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )
    tax_category = helpers.LazyNestedField(
        nested="commercetools._schemas._tax_category.TaxCategoryReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="taxCategory",
    )
    tax_rate = helpers.LazyNestedField(
        nested="commercetools._schemas._tax_category.TaxRateSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="taxRate",
    )
    discounted_price_per_quantity = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.DiscountedLineItemPriceForQuantitySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        data_key="discountedPricePerQuantity",
    )
    custom = helpers.LazyNestedField(
        nested="commercetools._schemas._type.CustomFieldsSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    shipping_details = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ItemShippingDetailsSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingDetails",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.CustomLineItem(**data)


class DiscountCodeInfoSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.DiscountCodeInfo`."""

    discount_code = helpers.LazyNestedField(
        nested="commercetools._schemas._discount_code.DiscountCodeReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="discountCode",
    )
    state = marshmallow_enum.EnumField(types.DiscountCodeState, by_value=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.DiscountCodeInfo(**data)


class DiscountedLineItemPortionSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.DiscountedLineItemPortion`."""

    discount = helpers.LazyNestedField(
        nested="commercetools._schemas._cart_discount.CartDiscountReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    discounted_amount = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "centPrecision": "commercetools._schemas._common.CentPrecisionMoneySchema",
            "highPrecision": "commercetools._schemas._common.HighPrecisionMoneySchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="discountedAmount",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.DiscountedLineItemPortion(**data)


class DiscountedLineItemPriceForQuantitySchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.DiscountedLineItemPriceForQuantity`."""

    quantity = marshmallow.fields.Integer(allow_none=True)
    discounted_price = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.DiscountedLineItemPriceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="discountedPrice",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.DiscountedLineItemPriceForQuantity(**data)


class DiscountedLineItemPriceSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.DiscountedLineItemPrice`."""

    value = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "centPrecision": "commercetools._schemas._common.CentPrecisionMoneySchema",
            "highPrecision": "commercetools._schemas._common.HighPrecisionMoneySchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    included_discounts = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.DiscountedLineItemPortionSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        data_key="includedDiscounts",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.DiscountedLineItemPrice(**data)


class ExternalLineItemTotalPriceSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.ExternalLineItemTotalPrice`."""

    price = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    total_price = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="totalPrice",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.ExternalLineItemTotalPrice(**data)


class ExternalTaxAmountDraftSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.ExternalTaxAmountDraft`."""

    total_gross = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="totalGross",
    )
    tax_rate = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ExternalTaxRateDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="taxRate",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.ExternalTaxAmountDraft(**data)


class ExternalTaxRateDraftSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.ExternalTaxRateDraft`."""

    name = marshmallow.fields.String(allow_none=True)
    amount = marshmallow.fields.Integer(allow_none=True, missing=None)
    country = marshmallow.fields.String(allow_none=True)
    state = marshmallow.fields.String(allow_none=True, missing=None)
    sub_rates = helpers.LazyNestedField(
        nested="commercetools._schemas._tax_category.SubRateSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        missing=None,
        data_key="subRates",
    )
    included_in_price = marshmallow.fields.Bool(
        allow_none=True, missing=None, data_key="includedInPrice"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.ExternalTaxRateDraft(**data)


class ItemShippingDetailsDraftSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.ItemShippingDetailsDraft`."""

    targets = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ItemShippingTargetSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.ItemShippingDetailsDraft(**data)


class ItemShippingDetailsSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.ItemShippingDetails`."""

    targets = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ItemShippingTargetSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )
    valid = marshmallow.fields.Bool(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.ItemShippingDetails(**data)


class ItemShippingTargetSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.ItemShippingTarget`."""

    address_key = marshmallow.fields.String(allow_none=True, data_key="addressKey")
    quantity = marshmallow.fields.Integer(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.ItemShippingTarget(**data)


class LineItemDraftSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.LineItemDraft`."""

    product_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="productId"
    )
    variant_id = marshmallow.fields.Integer(
        allow_none=True, missing=None, data_key="variantId"
    )
    sku = marshmallow.fields.String(allow_none=True, missing=None)
    quantity = marshmallow.fields.Integer(allow_none=True, missing=None)
    added_at = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="addedAt"
    )
    supply_channel = helpers.LazyNestedField(
        nested="commercetools._schemas._channel.ChannelResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="supplyChannel",
    )
    distribution_channel = helpers.LazyNestedField(
        nested="commercetools._schemas._channel.ChannelResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="distributionChannel",
    )
    external_tax_rate = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ExternalTaxRateDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalTaxRate",
    )
    custom = helpers.LazyNestedField(
        nested="commercetools._schemas._type.CustomFieldsDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    external_price = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalPrice",
    )
    external_total_price = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ExternalLineItemTotalPriceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalTotalPrice",
    )
    shipping_details = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ItemShippingDetailsDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingDetails",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.LineItemDraft(**data)


class LineItemSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.LineItem`."""

    id = marshmallow.fields.String(allow_none=True)
    product_id = marshmallow.fields.String(allow_none=True, data_key="productId")
    name = LocalizedStringField(allow_none=True)
    product_slug = LocalizedStringField(
        allow_none=True, missing=None, data_key="productSlug"
    )
    product_type = helpers.LazyNestedField(
        nested="commercetools._schemas._product_type.ProductTypeReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="productType",
    )
    variant = helpers.LazyNestedField(
        nested="commercetools._schemas._product.ProductVariantSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    price = helpers.LazyNestedField(
        nested="commercetools._schemas._common.PriceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    taxed_price = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.TaxedItemPriceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="taxedPrice",
    )
    total_price = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "centPrecision": "commercetools._schemas._common.CentPrecisionMoneySchema",
            "highPrecision": "commercetools._schemas._common.HighPrecisionMoneySchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="totalPrice",
    )
    quantity = marshmallow.fields.Integer(allow_none=True)
    added_at = marshmallow.fields.DateTime(
        allow_none=True, missing=None, data_key="addedAt"
    )
    state = helpers.LazyNestedField(
        nested="commercetools._schemas._order.ItemStateSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
    )
    tax_rate = helpers.LazyNestedField(
        nested="commercetools._schemas._tax_category.TaxRateSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="taxRate",
    )
    supply_channel = helpers.LazyNestedField(
        nested="commercetools._schemas._channel.ChannelReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="supplyChannel",
    )
    distribution_channel = helpers.LazyNestedField(
        nested="commercetools._schemas._channel.ChannelReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="distributionChannel",
    )
    discounted_price_per_quantity = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.DiscountedLineItemPriceForQuantitySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        data_key="discountedPricePerQuantity",
    )
    price_mode = marshmallow_enum.EnumField(
        types.LineItemPriceMode, by_value=True, data_key="priceMode"
    )
    line_item_mode = marshmallow_enum.EnumField(
        types.LineItemMode, by_value=True, data_key="lineItemMode"
    )
    custom = helpers.LazyNestedField(
        nested="commercetools._schemas._type.CustomFieldsSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    shipping_details = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ItemShippingDetailsSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingDetails",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.LineItem(**data)


class ReplicaCartDraftSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.ReplicaCartDraft`."""

    reference = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.CartReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.ReplicaCartDraft(**data)


class ShippingInfoSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.ShippingInfo`."""

    shipping_method_name = marshmallow.fields.String(
        allow_none=True, data_key="shippingMethodName"
    )
    price = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "centPrecision": "commercetools._schemas._common.CentPrecisionMoneySchema",
            "highPrecision": "commercetools._schemas._common.HighPrecisionMoneySchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    shipping_rate = helpers.LazyNestedField(
        nested="commercetools._schemas._shipping_method.ShippingRateSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="shippingRate",
    )
    taxed_price = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.TaxedItemPriceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="taxedPrice",
    )
    tax_rate = helpers.LazyNestedField(
        nested="commercetools._schemas._tax_category.TaxRateSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="taxRate",
    )
    tax_category = helpers.LazyNestedField(
        nested="commercetools._schemas._tax_category.TaxCategoryReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="taxCategory",
    )
    shipping_method = helpers.LazyNestedField(
        nested="commercetools._schemas._shipping_method.ShippingMethodReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingMethod",
    )
    deliveries = helpers.LazyNestedField(
        nested="commercetools._schemas._order.DeliverySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        missing=None,
    )
    discounted_price = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.DiscountedLineItemPriceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="discountedPrice",
    )
    shipping_method_state = marshmallow_enum.EnumField(
        types.ShippingMethodState, by_value=True, data_key="shippingMethodState"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.ShippingInfo(**data)


class ShippingRateInputDraftSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.ShippingRateInputDraft`."""

    type = marshmallow.fields.String(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ShippingRateInputDraft(**data)


class ShippingRateInputSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.ShippingRateInput`."""

    type = marshmallow.fields.String(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ShippingRateInput(**data)


class TaxPortionDraftSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.TaxPortionDraft`."""

    name = marshmallow.fields.String(allow_none=True, missing=None)
    rate = marshmallow.fields.Float(allow_none=True)
    amount = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.TaxPortionDraft(**data)


class TaxPortionSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.TaxPortion`."""

    name = marshmallow.fields.String(allow_none=True, missing=None)
    rate = marshmallow.fields.Float(allow_none=True)
    amount = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "centPrecision": "commercetools._schemas._common.CentPrecisionMoneySchema",
            "highPrecision": "commercetools._schemas._common.HighPrecisionMoneySchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.TaxPortion(**data)


class TaxedItemPriceSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.TaxedItemPrice`."""

    total_net = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "centPrecision": "commercetools._schemas._common.CentPrecisionMoneySchema",
            "highPrecision": "commercetools._schemas._common.HighPrecisionMoneySchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="totalNet",
    )
    total_gross = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "centPrecision": "commercetools._schemas._common.CentPrecisionMoneySchema",
            "highPrecision": "commercetools._schemas._common.HighPrecisionMoneySchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="totalGross",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.TaxedItemPrice(**data)


class TaxedPriceDraftSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.TaxedPriceDraft`."""

    total_net = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "centPrecision": "commercetools._schemas._common.CentPrecisionMoneyDraftSchema",
            "highPrecision": "commercetools._schemas._common.HighPrecisionMoneyDraftSchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="totalNet",
    )
    total_gross = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "centPrecision": "commercetools._schemas._common.CentPrecisionMoneyDraftSchema",
            "highPrecision": "commercetools._schemas._common.HighPrecisionMoneyDraftSchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="totalGross",
    )
    tax_portions = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.TaxPortionDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        data_key="taxPortions",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.TaxedPriceDraft(**data)


class TaxedPriceSchema(marshmallow.Schema):
    """Marshmallow schema for :class:`commercetools.types.TaxedPrice`."""

    total_net = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "centPrecision": "commercetools._schemas._common.CentPrecisionMoneySchema",
            "highPrecision": "commercetools._schemas._common.HighPrecisionMoneySchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="totalNet",
    )
    total_gross = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "centPrecision": "commercetools._schemas._common.CentPrecisionMoneySchema",
            "highPrecision": "commercetools._schemas._common.HighPrecisionMoneySchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="totalGross",
    )
    tax_portions = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.TaxPortionSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        data_key="taxPortions",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        return types.TaxedPrice(**data)


class CartAddCustomLineItemActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartAddCustomLineItemAction`."""

    money = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )
    name = LocalizedStringField(allow_none=True)
    quantity = marshmallow.fields.Integer(allow_none=True)
    slug = marshmallow.fields.String(allow_none=True)
    tax_category = helpers.LazyNestedField(
        nested="commercetools._schemas._tax_category.TaxCategoryResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="taxCategory",
    )
    custom = helpers.LazyNestedField(
        nested="commercetools._schemas._type.CustomFieldsDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    external_tax_rate = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ExternalTaxRateDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalTaxRate",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartAddCustomLineItemAction(**data)


class CartAddDiscountCodeActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartAddDiscountCodeAction`."""

    code = marshmallow.fields.String(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartAddDiscountCodeAction(**data)


class CartAddItemShippingAddressActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartAddItemShippingAddressAction`."""

    address = helpers.LazyNestedField(
        nested="commercetools._schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartAddItemShippingAddressAction(**data)


class CartAddLineItemActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartAddLineItemAction`."""

    custom = helpers.LazyNestedField(
        nested="commercetools._schemas._type.CustomFieldsDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    distribution_channel = helpers.LazyNestedField(
        nested="commercetools._schemas._channel.ChannelResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="distributionChannel",
    )
    external_tax_rate = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ExternalTaxRateDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalTaxRate",
    )
    product_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="productId"
    )
    variant_id = marshmallow.fields.Integer(
        allow_none=True, missing=None, data_key="variantId"
    )
    sku = marshmallow.fields.String(allow_none=True, missing=None)
    quantity = marshmallow.fields.Integer(allow_none=True, missing=None)
    supply_channel = helpers.LazyNestedField(
        nested="commercetools._schemas._channel.ChannelResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="supplyChannel",
    )
    external_price = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalPrice",
    )
    external_total_price = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ExternalLineItemTotalPriceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalTotalPrice",
    )
    shipping_details = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ItemShippingDetailsDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingDetails",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartAddLineItemAction(**data)


class CartAddPaymentActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartAddPaymentAction`."""

    payment = helpers.LazyNestedField(
        nested="commercetools._schemas._payment.PaymentResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartAddPaymentAction(**data)


class CartAddShoppingListActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartAddShoppingListAction`."""

    shopping_list = helpers.LazyNestedField(
        nested="commercetools._schemas._shopping_list.ShoppingListResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="shoppingList",
    )
    supply_channel = helpers.LazyNestedField(
        nested="commercetools._schemas._channel.ChannelResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="supplyChannel",
    )
    distribution_channel = helpers.LazyNestedField(
        nested="commercetools._schemas._channel.ChannelResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="distributionChannel",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartAddShoppingListAction(**data)


class CartApplyDeltaToCustomLineItemShippingDetailsTargetsActionSchema(
    CartUpdateActionSchema
):
    """Marshmallow schema for :class:`commercetools.types.CartApplyDeltaToCustomLineItemShippingDetailsTargetsAction`."""

    custom_line_item_id = marshmallow.fields.String(
        allow_none=True, data_key="customLineItemId"
    )
    targets_delta = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ItemShippingTargetSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        data_key="targetsDelta",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartApplyDeltaToCustomLineItemShippingDetailsTargetsAction(**data)


class CartApplyDeltaToLineItemShippingDetailsTargetsActionSchema(
    CartUpdateActionSchema
):
    """Marshmallow schema for :class:`commercetools.types.CartApplyDeltaToLineItemShippingDetailsTargetsAction`."""

    line_item_id = marshmallow.fields.String(allow_none=True, data_key="lineItemId")
    targets_delta = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ItemShippingTargetSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        data_key="targetsDelta",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartApplyDeltaToLineItemShippingDetailsTargetsAction(**data)


class CartChangeCustomLineItemMoneyActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartChangeCustomLineItemMoneyAction`."""

    custom_line_item_id = marshmallow.fields.String(
        allow_none=True, data_key="customLineItemId"
    )
    money = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartChangeCustomLineItemMoneyAction(**data)


class CartChangeCustomLineItemQuantityActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartChangeCustomLineItemQuantityAction`."""

    custom_line_item_id = marshmallow.fields.String(
        allow_none=True, data_key="customLineItemId"
    )
    quantity = marshmallow.fields.Integer(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartChangeCustomLineItemQuantityAction(**data)


class CartChangeLineItemQuantityActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartChangeLineItemQuantityAction`."""

    line_item_id = marshmallow.fields.String(allow_none=True, data_key="lineItemId")
    quantity = marshmallow.fields.Integer(allow_none=True)
    external_price = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalPrice",
    )
    external_total_price = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ExternalLineItemTotalPriceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalTotalPrice",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartChangeLineItemQuantityAction(**data)


class CartChangeTaxCalculationModeActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartChangeTaxCalculationModeAction`."""

    tax_calculation_mode = marshmallow_enum.EnumField(
        types.TaxCalculationMode, by_value=True, data_key="taxCalculationMode"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartChangeTaxCalculationModeAction(**data)


class CartChangeTaxModeActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartChangeTaxModeAction`."""

    tax_mode = marshmallow_enum.EnumField(
        types.TaxMode, by_value=True, data_key="taxMode"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartChangeTaxModeAction(**data)


class CartChangeTaxRoundingModeActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartChangeTaxRoundingModeAction`."""

    tax_rounding_mode = marshmallow_enum.EnumField(
        types.RoundingMode, by_value=True, data_key="taxRoundingMode"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartChangeTaxRoundingModeAction(**data)


class CartRecalculateActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartRecalculateAction`."""

    update_product_data = marshmallow.fields.Bool(
        allow_none=True, missing=None, data_key="updateProductData"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartRecalculateAction(**data)


class CartRemoveCustomLineItemActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartRemoveCustomLineItemAction`."""

    custom_line_item_id = marshmallow.fields.String(
        allow_none=True, data_key="customLineItemId"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartRemoveCustomLineItemAction(**data)


class CartRemoveDiscountCodeActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartRemoveDiscountCodeAction`."""

    discount_code = helpers.LazyNestedField(
        nested="commercetools._schemas._discount_code.DiscountCodeReferenceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="discountCode",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartRemoveDiscountCodeAction(**data)


class CartRemoveItemShippingAddressActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartRemoveItemShippingAddressAction`."""

    address_key = marshmallow.fields.String(allow_none=True, data_key="addressKey")

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartRemoveItemShippingAddressAction(**data)


class CartRemoveLineItemActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartRemoveLineItemAction`."""

    line_item_id = marshmallow.fields.String(allow_none=True, data_key="lineItemId")
    quantity = marshmallow.fields.Integer(allow_none=True, missing=None)
    external_price = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalPrice",
    )
    external_total_price = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ExternalLineItemTotalPriceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalTotalPrice",
    )
    shipping_details_to_remove = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ItemShippingDetailsDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingDetailsToRemove",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartRemoveLineItemAction(**data)


class CartRemovePaymentActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartRemovePaymentAction`."""

    payment = helpers.LazyNestedField(
        nested="commercetools._schemas._payment.PaymentResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartRemovePaymentAction(**data)


class CartSetAnonymousIdActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartSetAnonymousIdAction`."""

    anonymous_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="anonymousId"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartSetAnonymousIdAction(**data)


class CartSetBillingAddressActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartSetBillingAddressAction`."""

    address = helpers.LazyNestedField(
        nested="commercetools._schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartSetBillingAddressAction(**data)


class CartSetCartTotalTaxActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartSetCartTotalTaxAction`."""

    external_total_gross = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="externalTotalGross",
    )
    external_tax_portions = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.TaxPortionDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        many=True,
        missing=None,
        data_key="externalTaxPortions",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartSetCartTotalTaxAction(**data)


class CartSetCountryActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartSetCountryAction`."""

    country = marshmallow.fields.String(missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartSetCountryAction(**data)


class CartSetCustomFieldActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartSetCustomFieldAction`."""

    name = marshmallow.fields.String(allow_none=True)
    value = marshmallow.fields.Raw(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartSetCustomFieldAction(**data)


class CartSetCustomLineItemCustomFieldActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartSetCustomLineItemCustomFieldAction`."""

    custom_line_item_id = marshmallow.fields.String(
        allow_none=True, data_key="customLineItemId"
    )
    name = marshmallow.fields.String(allow_none=True)
    value = marshmallow.fields.Raw(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartSetCustomLineItemCustomFieldAction(**data)


class CartSetCustomLineItemCustomTypeActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartSetCustomLineItemCustomTypeAction`."""

    custom_line_item_id = marshmallow.fields.String(
        allow_none=True, data_key="customLineItemId"
    )
    type = helpers.LazyNestedField(
        nested="commercetools._schemas._type.TypeResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    fields = FieldContainerField(allow_none=True, missing=None)  # type: ignore

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartSetCustomLineItemCustomTypeAction(**data)


class CartSetCustomLineItemShippingDetailsActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartSetCustomLineItemShippingDetailsAction`."""

    custom_line_item_id = marshmallow.fields.String(
        allow_none=True, data_key="customLineItemId"
    )
    shipping_details = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ItemShippingDetailsDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingDetails",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartSetCustomLineItemShippingDetailsAction(**data)


class CartSetCustomLineItemTaxAmountActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartSetCustomLineItemTaxAmountAction`."""

    custom_line_item_id = marshmallow.fields.String(
        allow_none=True, data_key="customLineItemId"
    )
    external_tax_amount = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ExternalTaxAmountDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalTaxAmount",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartSetCustomLineItemTaxAmountAction(**data)


class CartSetCustomLineItemTaxRateActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartSetCustomLineItemTaxRateAction`."""

    custom_line_item_id = marshmallow.fields.String(
        allow_none=True, data_key="customLineItemId"
    )
    external_tax_rate = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ExternalTaxRateDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalTaxRate",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartSetCustomLineItemTaxRateAction(**data)


class CartSetCustomShippingMethodActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartSetCustomShippingMethodAction`."""

    shipping_method_name = marshmallow.fields.String(
        allow_none=True, data_key="shippingMethodName"
    )
    shipping_rate = helpers.LazyNestedField(
        nested="commercetools._schemas._shipping_method.ShippingRateDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        data_key="shippingRate",
    )
    tax_category = helpers.LazyNestedField(
        nested="commercetools._schemas._tax_category.TaxCategoryResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="taxCategory",
    )
    external_tax_rate = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ExternalTaxRateDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalTaxRate",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartSetCustomShippingMethodAction(**data)


class CartSetCustomTypeActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartSetCustomTypeAction`."""

    type = helpers.LazyNestedField(
        nested="commercetools._schemas._type.TypeResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    fields = FieldContainerField(allow_none=True, missing=None)  # type: ignore

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartSetCustomTypeAction(**data)


class CartSetCustomerEmailActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartSetCustomerEmailAction`."""

    email = marshmallow.fields.String(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartSetCustomerEmailAction(**data)


class CartSetCustomerGroupActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartSetCustomerGroupAction`."""

    customer_group = helpers.LazyNestedField(
        nested="commercetools._schemas._customer_group.CustomerGroupResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="customerGroup",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartSetCustomerGroupAction(**data)


class CartSetCustomerIdActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartSetCustomerIdAction`."""

    customer_id = marshmallow.fields.String(
        allow_none=True, missing=None, data_key="customerId"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartSetCustomerIdAction(**data)


class CartSetDeleteDaysAfterLastModificationActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartSetDeleteDaysAfterLastModificationAction`."""

    delete_days_after_last_modification = marshmallow.fields.Integer(
        allow_none=True, missing=None, data_key="deleteDaysAfterLastModification"
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartSetDeleteDaysAfterLastModificationAction(**data)


class CartSetLineItemCustomFieldActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartSetLineItemCustomFieldAction`."""

    line_item_id = marshmallow.fields.String(allow_none=True, data_key="lineItemId")
    name = marshmallow.fields.String(allow_none=True)
    value = marshmallow.fields.Raw(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartSetLineItemCustomFieldAction(**data)


class CartSetLineItemCustomTypeActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartSetLineItemCustomTypeAction`."""

    line_item_id = marshmallow.fields.String(allow_none=True, data_key="lineItemId")
    type = helpers.LazyNestedField(
        nested="commercetools._schemas._type.TypeResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )
    fields = FieldContainerField(allow_none=True, missing=None)  # type: ignore

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartSetLineItemCustomTypeAction(**data)


class CartSetLineItemDistributionChannelActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartSetLineItemDistributionChannelAction`."""

    line_item_id = marshmallow.fields.String(allow_none=True, data_key="lineItemId")
    distribution_channel = helpers.LazyNestedField(
        nested="commercetools._schemas._channel.ChannelResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="distributionChannel",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartSetLineItemDistributionChannelAction(**data)


class CartSetLineItemPriceActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartSetLineItemPriceAction`."""

    line_item_id = marshmallow.fields.String(allow_none=True, data_key="lineItemId")
    external_price = helpers.LazyNestedField(
        nested="commercetools._schemas._common.MoneySchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalPrice",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartSetLineItemPriceAction(**data)


class CartSetLineItemShippingDetailsActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartSetLineItemShippingDetailsAction`."""

    line_item_id = marshmallow.fields.String(allow_none=True, data_key="lineItemId")
    shipping_details = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ItemShippingDetailsDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingDetails",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartSetLineItemShippingDetailsAction(**data)


class CartSetLineItemTaxAmountActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartSetLineItemTaxAmountAction`."""

    line_item_id = marshmallow.fields.String(allow_none=True, data_key="lineItemId")
    external_tax_amount = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ExternalTaxAmountDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalTaxAmount",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartSetLineItemTaxAmountAction(**data)


class CartSetLineItemTaxRateActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartSetLineItemTaxRateAction`."""

    line_item_id = marshmallow.fields.String(allow_none=True, data_key="lineItemId")
    external_tax_rate = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ExternalTaxRateDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalTaxRate",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartSetLineItemTaxRateAction(**data)


class CartSetLineItemTotalPriceActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartSetLineItemTotalPriceAction`."""

    line_item_id = marshmallow.fields.String(allow_none=True, data_key="lineItemId")
    external_total_price = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ExternalLineItemTotalPriceSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalTotalPrice",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartSetLineItemTotalPriceAction(**data)


class CartSetLocaleActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartSetLocaleAction`."""

    locale = marshmallow.fields.String(allow_none=True, missing=None)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartSetLocaleAction(**data)


class CartSetShippingAddressActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartSetShippingAddressAction`."""

    address = helpers.LazyNestedField(
        nested="commercetools._schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartSetShippingAddressAction(**data)


class CartSetShippingMethodActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartSetShippingMethodAction`."""

    shipping_method = helpers.LazyNestedField(
        nested="commercetools._schemas._shipping_method.ShippingMethodResourceIdentifierSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingMethod",
    )
    external_tax_rate = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ExternalTaxRateDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalTaxRate",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartSetShippingMethodAction(**data)


class CartSetShippingMethodTaxAmountActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartSetShippingMethodTaxAmountAction`."""

    external_tax_amount = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ExternalTaxAmountDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalTaxAmount",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartSetShippingMethodTaxAmountAction(**data)


class CartSetShippingMethodTaxRateActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartSetShippingMethodTaxRateAction`."""

    external_tax_rate = helpers.LazyNestedField(
        nested="commercetools._schemas._cart.ExternalTaxRateDraftSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="externalTaxRate",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartSetShippingMethodTaxRateAction(**data)


class CartSetShippingRateInputActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartSetShippingRateInputAction`."""

    shipping_rate_input = helpers.Discriminator(
        discriminator_field=("type", "type"),
        discriminator_schemas={
            "Classification": "commercetools._schemas._cart.ClassificationShippingRateInputDraftSchema",
            "Score": "commercetools._schemas._cart.ScoreShippingRateInputDraftSchema",
        },
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
        missing=None,
        data_key="shippingRateInput",
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartSetShippingRateInputAction(**data)


class CartUpdateItemShippingAddressActionSchema(CartUpdateActionSchema):
    """Marshmallow schema for :class:`commercetools.types.CartUpdateItemShippingAddressAction`."""

    address = helpers.LazyNestedField(
        nested="commercetools._schemas._common.AddressSchema",
        unknown=marshmallow.EXCLUDE,
        allow_none=True,
    )

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["action"]
        return types.CartUpdateItemShippingAddressAction(**data)


class ClassificationShippingRateInputDraftSchema(ShippingRateInputDraftSchema):
    """Marshmallow schema for :class:`commercetools.types.ClassificationShippingRateInputDraft`."""

    key = marshmallow.fields.String(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ClassificationShippingRateInputDraft(**data)


class ClassificationShippingRateInputSchema(ShippingRateInputSchema):
    """Marshmallow schema for :class:`commercetools.types.ClassificationShippingRateInput`."""

    key = marshmallow.fields.String(allow_none=True)
    label = LocalizedStringField(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ClassificationShippingRateInput(**data)


class ScoreShippingRateInputDraftSchema(ShippingRateInputDraftSchema):
    """Marshmallow schema for :class:`commercetools.types.ScoreShippingRateInputDraft`."""

    score = marshmallow.fields.Integer(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ScoreShippingRateInputDraft(**data)


class ScoreShippingRateInputSchema(ShippingRateInputSchema):
    """Marshmallow schema for :class:`commercetools.types.ScoreShippingRateInput`."""

    score = marshmallow.fields.Integer(allow_none=True)

    class Meta:
        unknown = marshmallow.EXCLUDE

    @marshmallow.post_load
    def post_load(self, data, **kwargs):
        del data["type"]
        return types.ScoreShippingRateInput(**data)
