[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.1406979.svg)](https://doi.org/10.5281/zenodo.1406979)
[![License (LGPL version 3)](https://img.shields.io/badge/license-LGPLv3.0-blue.svg?style=flat-square)](http://opensource.org/licenses/LGPL-3.0)

<b><a href="https://orcid.org/0000-0002-4588-4925" title="0000-0002-4588-4925"><img src="./docs/images/orcid.png" height="15"/></a> Jan Grzegorzewski</b>
and
<b><a href="https://orcid.org/0000-0003-1725-179X" title="https://orcid.org/0000-0003-1725-179X"><img src="./docs/images/orcid.png" height="15" width="15"/></a> Matthias König</b>

# PK-DB - a pharmacokinetics database

* [Overview](https://github.com/matthiaskoenig/pkdb#overview)
* [How to cite](https://github.com/matthiaskoenig/pkdb#how-to-cite)
* [License](https://github.com/matthiaskoenig/pkdb#license)
* [Funding](https://github.com/matthiaskoenig/pkdb#funding)

## Overview
[[^]](https://github.com/matthiaskoenig/pkdb#pk-db---a-pharmacokinetics-database)
[PK-DB](https://pk-db.com) is a database and web interface for pharmacokinetics data and information from clinical trials 
as well as pre-clinical research. PK-DB allows to curate pharmacokinetics data integrated with the 
corresponding meta-information 
- characteristics of studied patient collectives and individuals (age, bodyweight, smoking status, ...) 
- applied interventions (e.g., dosing, substance, route of application)
- measured pharmacokinetics time courses and pharmacokinetics parameters (e.g., clearance, half-life, ...). 

Important features are 
- the representation of experimental errors and variation
- the representation and normalisation of units
- annotation of information to biological ontologies
- calculation of pharmacokinetics information from time courses (apparent clearance, half-life, ...)
- a workflow for collaborative data curation
- strong validation rules on data, and simple access via a REST API

PK-DB is available at https://pk-db.com

## How to cite
[[^]](https://github.com/matthiaskoenig/pkdb#pk-db---a-pharmacokinetics-database)
If you use PK-DB data or the web interface cite

> Grzegorzewski J, Brandhorst J, Green K, Eleftheriadou D, Duport Y, Barthorscht F, Köller A, Ke DYJ, De Angelis S, König M. 
> *PK-DB: pharmacokinetics database for individualized and stratified computational modeling*. 
> Nucleic Acids Res. 2020 Nov 5:gkaa990. doi: [10.1093/nar/gkaa990](https://doi.org/10.1093/nar/gkaa990). Epub ahead of print. PMID: [33151297](https://pubmed.ncbi.nlm.nih.gov/33151297/).

If you use PK-DB code cite in addition 

[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.1406979.svg)](https://doi.org/10.5281/zenodo.1406979)

## License
[[^]](https://github.com/matthiaskoenig/pkdb#pk-db---a-pharmacokinetics-database)
PK-DB code and documentation is licensed as
* Source Code: [LGPLv3](http://opensource.org/licenses/LGPL-3.0)
* Documentation: [CC BY-SA 4.0](http://creativecommons.org/licenses/by-sa/4.0/)

## Funding
[[^]](https://github.com/matthiaskoenig/pkdb#pk-db---a-pharmacokinetics-database)
Jan Grzegorzewski and Matthias König are supported by the Federal Ministry of Education and Research (BMBF, Germany)
within the research network Systems Medicine of the Liver ([LiSyM](http://www.lisym.org/), grant number 031L0054).


&copy; 2017-2020 Jan Grzegorzewski & Matthias König; https://livermetabolism.com.
