from setuptools import setup
from setuptools.command.install import install as _install
from setuptools.command.develop import develop as _develop
from setuptools.command.build_py import build_py as _build_py
from setuptools import find_packages
import re
import sys
from subprocess import run

with open('requirements.txt') as f:
    requirements = [l.strip() for l in f]

with open('dependency_links.txt') as f:
    dependency_links = [l.strip() for l in f]

# filter non-standard requirements
reqexp = re.compile(r"[^\w><=\.\s-]")
nonstandard = list(filter(reqexp.search, requirements))
requirements = list(filter(lambda w: not(reqexp.search(w)), requirements))

if nonstandard:
    if sys.argv[1] != "clean":
        print("Non-standard requirements found. These will have to installed manually. The non-standard requirements are:")
        print(nonstandard)

with open("README.md", "r") as f:
    long_description = f.read()

with open("LICENSE.txt", "r") as f:
    license_text = f.read()

versionRegex = re.compile("\d+[.]\d+[.]\d+[^\s]*")
with open("CHANGELOG.md", "r") as f:
    for line in f:
        versionMatch = versionRegex.match(line)
        if versionMatch:
            version = versionMatch.group()
            break

class BuildWrapper(_build_py):

    def run(self):
        print(f"Building version {version}")
        init_file = "gherkan/__init__.py"
        fileText = [
            '# This file was generated by the setup.py and will be rewritten at the next build\n',
            f'__version__ = "{version}"\n',
            '__name__ = "gherkan"'
        ]
        with open(init_file, "w") as f:
            f.writelines(fileText)
        _build_py.run(self)


class InstallWrapper(_install):

    def run(self):
        print(">>>>>>>>>>>>>>>>>>>>>>>>>>>")
        _install.run(self)
        print("<<<<<<<<<<<<<<<<<<<<<<<<<<<")
        self.execute(self._post_install, (),
                     msg="Running post install task")

    def _post_install(self):
        # TODO: check spacy file version SM/MD/LG
        print("installing neural coref")
        result = run(["pip", "install", "https://github.com/huggingface/neuralcoref-models/releases/download/en_coref_md-3.0.0/en_coref_md-3.0.0.tar.gz"])
        if result.returncode == 0:
            print(result.stdout)
        else:
            if result.stderr:
                print('Preprocess failed: ')
                print(result.stderr)
            print("Downloading neuralcoref failed, please run:\n'pip install https://github.com/huggingface/neuralcoref-models/releases/download/en_coref_md-3.0.0/en_coref_md-3.0.0.tar.gz'")
       
        print("Downloading en_core_web_sm")
        result = run(["python", "-m", "spacy", "link", "en_core_web_sm", "en", "--force"])  #, capture_output=True)
        if result.returncode == 0:
            print(result.stdout)
        else:
            if result.stderr:
                print('Preprocess failed: ')
                print(result.stderr)
            print("Downloading en_core_web_sm failed, please run:\n'python -m spacy download en_core_web_sm'")
        print("creating morphodita folder and downloading models")
        result = run(["sh", "install_morphodita.sh"])
        if result.returncode == 0:
            print(result.stdout)
        else:
            if result.stderr:
                print('Preprocess failed: ')
                print(result.stderr)
            print("Downloading morphodita failed, please make folder for morphodita and unzip there the remote model 'curl --remote-name-all","https://lindat.mff.cuni.cz/repository/xmlui/bitstream/handle/11234/1-1836{/czech-morfflex-pdt-161115.zip}'")
        


class DevelopWrapper(_develop):

    def run(self):
        print(">>>>>>>>>>>>>>>>>>>>>>>>>>>")
        _develop.run(self)
        print("<<<<<<<<<<<<<<<<<<<<<<<<<<<")
        self.execute(self._post_install, (),
                     msg="Running post install task")

    def _post_install(self):
        # TODO: check spacy file version SM/MD/LG
        print("installing neural coref")
        result = run(["pip", "install", "https://github.com/huggingface/neuralcoref-models/releases/download/en_coref_md-3.0.0/en_coref_md-3.0.0.tar.gz"])
        if result.returncode == 0:
            print(result.stdout)
        else:
            if result.stderr:
                print('Preprocess failed: ')
                print(result.stderr)
            print("Downloading neuralcoref failed, please run:\n'pip install https://github.com/huggingface/neuralcoref-models/releases/download/en_coref_md-3.0.0/en_coref_md-3.0.0.tar.gz'")       
        print("Downloading en_core_web_sm")
        result = run(["python", "-m", "spacy", "link", "en_core_web_sm", "en", "--force"])#, capture_output=True)
        if result.returncode == 0:
            print(result.stdout)
        else:
            if result.stderr:
                print('Preprocess failed: ')
                print(result.stderr)
            print("Downloading en_core_web_sm failed, please run:\n'python -m spacy download en_core_web_sm'")
        print("creating morphodita folder and downloading models")
        result = run(["sh", "install_morphodita.sh"])
        if result.returncode == 0:
            print(result.stdout)
        else:
            if result.stderr:
                print('Preprocess failed: ')
                print(result.stderr)
            print("Downloading morphodita failed, please make folder for morphodita and unzip there the remote model 'curl --remote-name-all","https://lindat.mff.cuni.cz/repository/xmlui/bitstream/handle/11234/1-1836{/czech-morfflex-pdt-161115.zip}'")
        

setup(
    name='gherkan',
    version=version,
    # use_scm_version=True,
    description='NL to Gherkin format translation tool',
    long_description=long_description,
    author='Imitation Learning Group CIIRC CVUT',
    maintainer_email='radoslav.skoviera@cvut.cz',
    url='',
    download_url='',
    license=license_text,
    install_requires=requirements,
    dependency_links=dependency_links,
    include_package_data=True,
    # setup_requires=['setuptools_scm'],
    packages=find_packages(exclude=["test", "data"]),
    cmdclass={
        'build_py': BuildWrapper,
        'install': InstallWrapper,
        'develop': DevelopWrapper
        },
    classifiers=[
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.6",
        "Programming Language :: Python :: 3.7",
        "Development Status :: 3 - Alpha",
        "Framework :: Flask",
        "Intended Audience :: Education",
        "Intended Audience :: Information Technology",
        "Intended Audience :: Science/Research",
        "Natural Language :: Czech",
        "Natural Language :: English",
        "Topic :: Scientific/Engineering :: Artificial Intelligence",
        "Topic :: Scientific/Engineering :: Human Machine Interfaces"
    ]
)
