/*
 * Decompiled with CFR 0.152.
 */
package org.capnproto;

import java.nio.ByteBuffer;
import org.capnproto.FromPointerReader;
import org.capnproto.FromPointerReaderBlobDefault;
import org.capnproto.SegmentReader;
import org.capnproto.StructReader;

public class ListReader {
    final SegmentReader segment;
    final int ptr;
    final int elementCount;
    final int step;
    final int structDataSize;
    final short structPointerCount;
    final int nestingLimit;

    public ListReader() {
        this.segment = null;
        this.ptr = 0;
        this.elementCount = 0;
        this.step = 0;
        this.structDataSize = 0;
        this.structPointerCount = 0;
        this.nestingLimit = Integer.MAX_VALUE;
    }

    public ListReader(SegmentReader segmentReader, int n2, int n3, int n4, int n5, short s2, int n6) {
        this.segment = segmentReader;
        this.ptr = n2;
        this.elementCount = n3;
        this.step = n4;
        this.structDataSize = n5;
        this.structPointerCount = s2;
        this.nestingLimit = n6;
    }

    public int size() {
        return this.elementCount;
    }

    protected boolean _getBooleanElement(int n2) {
        long l2 = (long)n2 * (long)this.step;
        byte by = this.segment.buffer.get(this.ptr + (int)(l2 / 8L));
        return (by & 1 << (int)(l2 % 8L)) != 0;
    }

    protected byte _getByteElement(int n2) {
        return this.segment.buffer.get(this.ptr + (int)((long)n2 * (long)this.step / 8L));
    }

    protected short _getShortElement(int n2) {
        return this.segment.buffer.getShort(this.ptr + (int)((long)n2 * (long)this.step / 8L));
    }

    protected int _getIntElement(int n2) {
        return this.segment.buffer.getInt(this.ptr + (int)((long)n2 * (long)this.step / 8L));
    }

    protected long _getLongElement(int n2) {
        return this.segment.buffer.getLong(this.ptr + (int)((long)n2 * (long)this.step / 8L));
    }

    protected float _getFloatElement(int n2) {
        return this.segment.buffer.getFloat(this.ptr + (int)((long)n2 * (long)this.step / 8L));
    }

    protected double _getDoubleElement(int n2) {
        return this.segment.buffer.getDouble(this.ptr + (int)((long)n2 * (long)this.step / 8L));
    }

    protected <T> T _getStructElement(StructReader.Factory<T> factory, int n2) {
        long l2 = (long)n2 * (long)this.step;
        int n3 = this.ptr + (int)(l2 / 8L);
        int n4 = n3 + this.structDataSize / 8;
        return factory.constructReader(this.segment, n3, n4 / 8, this.structDataSize, this.structPointerCount, this.nestingLimit - 1);
    }

    protected <T> T _getPointerElement(FromPointerReader<T> fromPointerReader, int n2) {
        return fromPointerReader.fromPointerReader(this.segment, (this.ptr + (int)((long)n2 * (long)this.step / 8L)) / 8, this.nestingLimit);
    }

    protected <T> T _getPointerElement(FromPointerReaderBlobDefault<T> fromPointerReaderBlobDefault, int n2, ByteBuffer byteBuffer, int n3, int n4) {
        return fromPointerReaderBlobDefault.fromPointerReaderBlobDefault(this.segment, (this.ptr + (int)((long)n2 * (long)this.step / 8L)) / 8, byteBuffer, n3, n4);
    }

    public static interface Factory<T> {
        public T constructReader(SegmentReader var1, int var2, int var3, int var4, int var5, short var6, int var7);
    }
}

