/*
 * Decompiled with CFR 0.152.
 */
package hex.genmodel.algos.tree;

import hex.genmodel.algos.tree.SharedTreeNode;
import hex.genmodel.tools.PrintMojo;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SharedTreeSubgraph {
    public final int subgraphNumber;
    public final String name;
    public SharedTreeNode rootNode;
    public int fontSize = 14;
    public boolean setDecimalPlaces = false;
    public int nPlaces = -1;
    public ArrayList<SharedTreeNode> nodesArray;

    SharedTreeSubgraph(int sn, String n2) {
        this.subgraphNumber = sn;
        this.name = n2;
        this.nodesArray = new ArrayList();
    }

    public SharedTreeNode makeRootNode() {
        assert (this.nodesArray.size() == 0);
        SharedTreeNode n2 = new SharedTreeNode(0, null, this.subgraphNumber, 0);
        n2.setInclusiveNa(true);
        this.nodesArray.add(n2);
        this.rootNode = n2;
        return n2;
    }

    public void setDecimalPlace(int nplaces) {
        this.setDecimalPlaces = true;
        this.nPlaces = nplaces;
    }

    public void setFontSize(int fontsize) {
        this.fontSize = fontsize;
    }

    public SharedTreeNode makeLeftChildNode(SharedTreeNode parent) {
        SharedTreeNode child = new SharedTreeNode(this.nodesArray.size(), parent, this.subgraphNumber, parent.getDepth() + 1);
        this.nodesArray.add(child);
        this.makeLeftEdge(parent, child);
        return child;
    }

    public SharedTreeNode makeRightChildNode(SharedTreeNode parent) {
        SharedTreeNode child = new SharedTreeNode(this.nodesArray.size(), parent, this.subgraphNumber, parent.getDepth() + 1);
        this.nodesArray.add(child);
        this.makeRightEdge(parent, child);
        return child;
    }

    private void makeLeftEdge(SharedTreeNode parent, SharedTreeNode child) {
        parent.setLeftChild(child);
    }

    private void makeRightEdge(SharedTreeNode parent, SharedTreeNode child) {
        parent.setRightChild(child);
    }

    public SharedTreeNode walkNodes(String path) {
        SharedTreeNode n2 = this.rootNode;
        block4: for (int i2 = 0; i2 < path.length(); ++i2) {
            if (n2 == null) {
                return null;
            }
            switch (path.charAt(i2)) {
                case 'L': {
                    n2 = n2.getLeftChild();
                    continue block4;
                }
                case 'R': {
                    n2 = n2.getRightChild();
                    continue block4;
                }
                default: {
                    throw new IllegalArgumentException("Invalid path specification '" + path + "'. Paths must only be made of 'L' and 'R' characters.");
                }
            }
        }
        return n2;
    }

    public float scoreTree(double[] data) {
        SharedTreeNode n2 = this.rootNode;
        while (!n2.isLeaf()) {
            int id = n2.next(data);
            n2 = this.nodesArray.get(id);
        }
        return n2.getPredValue();
    }

    void print() {
        System.out.println("");
        System.out.println("    ----- " + this.name + " -----");
        System.out.println("    Nodes");
        for (SharedTreeNode n2 : this.nodesArray) {
            n2.print();
        }
        System.out.println("");
        System.out.println("    Edges");
        this.rootNode.printEdges();
    }

    void printDot(PrintStream os, int maxLevelsToPrintPerEdge, boolean detail, String optionalTitle, PrintMojo.PrintTreeOptions treeOptions) {
        os.println("");
        os.println("subgraph cluster_" + this.subgraphNumber + " {");
        os.println("/* Nodes */");
        int maxLevel = -1;
        for (SharedTreeNode n2 : this.nodesArray) {
            if (n2.getDepth() <= maxLevel) continue;
            maxLevel = n2.getDepth();
        }
        for (int level = 0; level <= maxLevel; ++level) {
            os.println("");
            os.println("/* Level " + level + " */");
            os.println("{");
            this.rootNode.printDotNodesAtLevel(os, level, detail, treeOptions);
            os.println("}");
        }
        os.println("");
        os.println("/* Edges */");
        for (SharedTreeNode n2 : this.nodesArray) {
            n2.printDotEdges(os, maxLevelsToPrintPerEdge, this.rootNode.getWeight(), detail, treeOptions);
        }
        os.println("");
        os.println("fontsize=40");
        String title = SharedTreeNode.escapeQuotes(optionalTitle != null ? optionalTitle : this.name);
        os.println("label=\"" + title + "\"");
        os.println("}");
    }

    public void printDot(PrintStream os, int maxLevelsToPrintPerEdge, boolean detail, String optionalTitle, PrintMojo.PrintTreeOptions treeOptions, boolean isDirected) {
        os.println("");
        os.println((isDirected ? "digraph " : "subgraph cluster_") + this.subgraphNumber + " {");
        os.println("/* Nodes */");
        int maxLevel = -1;
        for (SharedTreeNode n2 : this.nodesArray) {
            if (n2.getDepth() <= maxLevel) continue;
            maxLevel = n2.getDepth();
        }
        for (int level = 0; level <= maxLevel; ++level) {
            os.println("");
            os.println("/* Level " + level + " */");
            os.println("{");
            this.rootNode.printDotNodesAtLevel(os, level, detail, treeOptions);
            os.println("}");
        }
        os.println("");
        os.println("/* Edges */");
        for (SharedTreeNode n2 : this.nodesArray) {
            n2.printDotEdges(os, maxLevelsToPrintPerEdge, this.rootNode.getWeight(), detail, treeOptions);
        }
        os.println("");
        os.println("fontsize=40");
        String title = SharedTreeNode.escapeQuotes(optionalTitle != null ? optionalTitle : this.name);
        os.println("label=\"" + title + "\"");
        os.println("}");
    }

    Map<String, Object> toJson() {
        HashMap<String, Object> json = new HashMap<String, Object>();
        json.put("index", this.subgraphNumber);
        json.put("name", this.name);
        json.put("root", this.rootNode.toJson());
        return json;
    }

    public boolean equals(Object o2) {
        if (this == o2) {
            return true;
        }
        if (o2 == null || this.getClass() != o2.getClass()) {
            return false;
        }
        SharedTreeSubgraph that = (SharedTreeSubgraph)o2;
        return this.subgraphNumber == that.subgraphNumber && Objects.equals(this.name, that.name) && Objects.equals(this.rootNode, that.rootNode) && Objects.equals(this.nodesArray, that.nodesArray);
    }

    public int hashCode() {
        return Objects.hash(this.subgraphNumber);
    }

    public String toString() {
        return "SharedTreeSubgraph{subgraphNumber=" + this.subgraphNumber + ", name='" + this.name + '\'' + '}';
    }
}

