/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.mojos.runtime.api.backend;

import ai.h2o.mojos.runtime.api.backend.ReaderBackend;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipFileReaderBackend
implements ReaderBackend {
    private final ZipFile zipFile;

    private ZipFileReaderBackend(ZipFile zipFile) {
        this.zipFile = zipFile;
    }

    public static ReaderBackend open(File zippedMojoFile) throws IOException {
        return new ZipFileReaderBackend(new ZipFile(zippedMojoFile));
    }

    @Override
    public InputStream getInputStream(String resourceName) throws IOException {
        ZipEntry entry = this.zipFile.getEntry(resourceName);
        if (entry == null) {
            throw new FileNotFoundException(resourceName);
        }
        return this.zipFile.getInputStream(entry);
    }

    @Override
    public boolean exists(String resourceName) {
        return this.zipFile.getEntry(resourceName) != null;
    }

    @Override
    public Collection<String> list() {
        ArrayList<String> result = new ArrayList<String>(this.zipFile.size());
        Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            result.add(zipEntry.getName());
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.zipFile.close();
    }

    public String toString() {
        return String.format("%s[%s]", this.getClass().getSimpleName(), this.zipFile.getName());
    }
}

