import typing, clr, abc
from System import SystemException, Exception, IDisposable, IEquatable_1, Action_1, Action, Action_2, IAsyncDisposable, TimeSpan, Array_1, MulticastDelegate, IAsyncResult, AsyncCallback, Func_1, MarshalByRefObject, LocalDataStoreSlot, AppDomain, UIntPtr, EventArgs, ApplicationException
from System.Collections import IDictionary
from System.Reflection import MethodBase, MethodInfo
from Microsoft.Win32.SafeHandles import SafeWaitHandle
from System.Threading.Tasks import ValueTask, ValueTask_1, Task, Task_1
from System.Runtime.Serialization import ISerializable, SerializationInfo, StreamingContext
from System.Runtime.ConstrainedExecution import CriticalFinalizerObject
from System.Globalization import CultureInfo
from System.Security.Principal import IPrincipal
from System.Collections.Generic import IList_1
from System.Runtime.InteropServices import SafeHandle

class AbandonedMutexException(SystemException):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, location: int, handle: WaitHandle) -> None: ...
    @typing.overload
    def __init__(self, message: str) -> None: ...
    @typing.overload
    def __init__(self, message: str, inner: Exception) -> None: ...
    @typing.overload
    def __init__(self, message: str, inner: Exception, location: int, handle: WaitHandle) -> None: ...
    @typing.overload
    def __init__(self, message: str, location: int, handle: WaitHandle) -> None: ...
    @property
    def Data(self) -> IDictionary: ...
    @property
    def HelpLink(self) -> str: ...
    @HelpLink.setter
    def HelpLink(self, value: str) -> str: ...
    @property
    def HResult(self) -> int: ...
    @HResult.setter
    def HResult(self, value: int) -> int: ...
    @property
    def InnerException(self) -> Exception: ...
    @property
    def Message(self) -> str: ...
    @property
    def Mutex(self) -> Mutex: ...
    @property
    def MutexIndex(self) -> int: ...
    @property
    def Source(self) -> str: ...
    @Source.setter
    def Source(self, value: str) -> str: ...
    @property
    def StackTrace(self) -> str: ...
    @property
    def TargetSite(self) -> MethodBase: ...


class ApartmentState(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    STA : ApartmentState # 0
    MTA : ApartmentState # 1
    Unknown : ApartmentState # 2


class AsyncFlowControl(IDisposable, IEquatable_1[AsyncFlowControl]):
    def Dispose(self) -> None: ...
    def GetHashCode(self) -> int: ...
    def __eq__(self, a: AsyncFlowControl, b: AsyncFlowControl) -> bool: ...
    def __ne__(self, a: AsyncFlowControl, b: AsyncFlowControl) -> bool: ...
    def Undo(self) -> None: ...
    # Skipped Equals due to it being static, abstract and generic.

    Equals : Equals_MethodGroup
    class Equals_MethodGroup:
        @typing.overload
        def __call__(self, obj: AsyncFlowControl) -> bool:...
        @typing.overload
        def __call__(self, obj: typing.Any) -> bool:...



class AsyncLocal_GenericClasses(abc.ABCMeta):
    Generic_AsyncLocal_GenericClasses_AsyncLocal_1_T = typing.TypeVar('Generic_AsyncLocal_GenericClasses_AsyncLocal_1_T')
    def __getitem__(self, types : typing.Type[Generic_AsyncLocal_GenericClasses_AsyncLocal_1_T]) -> typing.Type[AsyncLocal_1[Generic_AsyncLocal_GenericClasses_AsyncLocal_1_T]]: ...

AsyncLocal : AsyncLocal_GenericClasses

AsyncLocal_1_T = typing.TypeVar('AsyncLocal_1_T')
class AsyncLocal_1(typing.Generic[AsyncLocal_1_T]):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, valueChangedHandler: Action_1[AsyncLocalValueChangedArgs_1[AsyncLocal_1_T]]) -> None: ...
    @property
    def Value(self) -> AsyncLocal_1_T: ...
    @Value.setter
    def Value(self, value: AsyncLocal_1_T) -> AsyncLocal_1_T: ...


class AsyncLocalValueChangedArgs_GenericClasses(abc.ABCMeta):
    Generic_AsyncLocalValueChangedArgs_GenericClasses_AsyncLocalValueChangedArgs_1_T = typing.TypeVar('Generic_AsyncLocalValueChangedArgs_GenericClasses_AsyncLocalValueChangedArgs_1_T')
    def __getitem__(self, types : typing.Type[Generic_AsyncLocalValueChangedArgs_GenericClasses_AsyncLocalValueChangedArgs_1_T]) -> typing.Type[AsyncLocalValueChangedArgs_1[Generic_AsyncLocalValueChangedArgs_GenericClasses_AsyncLocalValueChangedArgs_1_T]]: ...

AsyncLocalValueChangedArgs : AsyncLocalValueChangedArgs_GenericClasses

AsyncLocalValueChangedArgs_1_T = typing.TypeVar('AsyncLocalValueChangedArgs_1_T')
class AsyncLocalValueChangedArgs_1(typing.Generic[AsyncLocalValueChangedArgs_1_T]):
    @property
    def CurrentValue(self) -> AsyncLocalValueChangedArgs_1_T: ...
    @property
    def PreviousValue(self) -> AsyncLocalValueChangedArgs_1_T: ...
    @property
    def ThreadContextChanged(self) -> bool: ...


class AutoResetEvent(EventWaitHandle):
    def __init__(self, initialState: bool) -> None: ...
    @property
    def Handle(self) -> int: ...
    @Handle.setter
    def Handle(self, value: int) -> int: ...
    @property
    def SafeWaitHandle(self) -> SafeWaitHandle: ...
    @SafeWaitHandle.setter
    def SafeWaitHandle(self, value: SafeWaitHandle) -> SafeWaitHandle: ...


class CancellationToken:
    def __init__(self, canceled: bool) -> None: ...
    @property
    def CanBeCanceled(self) -> bool: ...
    @property
    def IsCancellationRequested(self) -> bool: ...
    # Skipped property None since it is a reserved python word. Use reflection to access.
    @property
    def WaitHandle(self) -> WaitHandle: ...
    def GetHashCode(self) -> int: ...
    def __eq__(self, left: CancellationToken, right: CancellationToken) -> bool: ...
    def __ne__(self, left: CancellationToken, right: CancellationToken) -> bool: ...
    def ThrowIfCancellationRequested(self) -> None: ...
    # Skipped Equals due to it being static, abstract and generic.

    Equals : Equals_MethodGroup
    class Equals_MethodGroup:
        @typing.overload
        def __call__(self, other: CancellationToken) -> bool:...
        @typing.overload
        def __call__(self, other: typing.Any) -> bool:...

    # Skipped Register due to it being static, abstract and generic.

    Register : Register_MethodGroup
    class Register_MethodGroup:
        @typing.overload
        def __call__(self, callback: Action) -> CancellationTokenRegistration:...
        @typing.overload
        def __call__(self, callback: Action_2[typing.Any, CancellationToken], state: typing.Any) -> CancellationTokenRegistration:...
        @typing.overload
        def __call__(self, callback: Action_1[typing.Any], state: typing.Any) -> CancellationTokenRegistration:...
        @typing.overload
        def __call__(self, callback: Action, useSynchronizationContext: bool) -> CancellationTokenRegistration:...
        @typing.overload
        def __call__(self, callback: Action_1[typing.Any], state: typing.Any, useSynchronizationContext: bool) -> CancellationTokenRegistration:...

    # Skipped UnsafeRegister due to it being static, abstract and generic.

    UnsafeRegister : UnsafeRegister_MethodGroup
    class UnsafeRegister_MethodGroup:
        @typing.overload
        def __call__(self, callback: Action_2[typing.Any, CancellationToken], state: typing.Any) -> CancellationTokenRegistration:...
        @typing.overload
        def __call__(self, callback: Action_1[typing.Any], state: typing.Any) -> CancellationTokenRegistration:...



class CancellationTokenRegistration(IAsyncDisposable, IDisposable, IEquatable_1[CancellationTokenRegistration]):
    @property
    def Token(self) -> CancellationToken: ...
    def Dispose(self) -> None: ...
    def DisposeAsync(self) -> ValueTask: ...
    def GetHashCode(self) -> int: ...
    def __eq__(self, left: CancellationTokenRegistration, right: CancellationTokenRegistration) -> bool: ...
    def __ne__(self, left: CancellationTokenRegistration, right: CancellationTokenRegistration) -> bool: ...
    def Unregister(self) -> bool: ...
    # Skipped Equals due to it being static, abstract and generic.

    Equals : Equals_MethodGroup
    class Equals_MethodGroup:
        @typing.overload
        def __call__(self, other: CancellationTokenRegistration) -> bool:...
        @typing.overload
        def __call__(self, obj: typing.Any) -> bool:...



class CancellationTokenSource(IDisposable):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, delay: TimeSpan) -> None: ...
    @typing.overload
    def __init__(self, millisecondsDelay: int) -> None: ...
    @property
    def IsCancellationRequested(self) -> bool: ...
    @property
    def Token(self) -> CancellationToken: ...
    def Dispose(self) -> None: ...
    def TryReset(self) -> bool: ...
    # Skipped Cancel due to it being static, abstract and generic.

    Cancel : Cancel_MethodGroup
    class Cancel_MethodGroup:
        @typing.overload
        def __call__(self) -> None:...
        @typing.overload
        def __call__(self, throwOnFirstException: bool) -> None:...

    # Skipped CancelAfter due to it being static, abstract and generic.

    CancelAfter : CancelAfter_MethodGroup
    class CancelAfter_MethodGroup:
        @typing.overload
        def __call__(self, millisecondsDelay: int) -> None:...
        @typing.overload
        def __call__(self, delay: TimeSpan) -> None:...

    # Skipped CreateLinkedTokenSource due to it being static, abstract and generic.

    CreateLinkedTokenSource : CreateLinkedTokenSource_MethodGroup
    class CreateLinkedTokenSource_MethodGroup:
        @typing.overload
        def __call__(self, tokens: Array_1[CancellationToken]) -> CancellationTokenSource:...
        @typing.overload
        def __call__(self, token: CancellationToken) -> CancellationTokenSource:...
        @typing.overload
        def __call__(self, token1: CancellationToken, token2: CancellationToken) -> CancellationTokenSource:...



class CompressedStack(ISerializable):
    @staticmethod
    def Capture() -> CompressedStack: ...
    def CreateCopy(self) -> CompressedStack: ...
    @staticmethod
    def GetCompressedStack() -> CompressedStack: ...
    def GetObjectData(self, info: SerializationInfo, context: StreamingContext) -> None: ...
    @staticmethod
    def Run(compressedStack: CompressedStack, callback: ContextCallback, state: typing.Any) -> None: ...


class ContextCallback(MulticastDelegate):
    def __init__(self, object: typing.Any, method: int) -> None: ...
    @property
    def Method(self) -> MethodInfo: ...
    @property
    def Target(self) -> typing.Any: ...
    def BeginInvoke(self, state: typing.Any, callback: AsyncCallback, object: typing.Any) -> IAsyncResult: ...
    def EndInvoke(self, result: IAsyncResult) -> None: ...
    def Invoke(self, state: typing.Any) -> None: ...


class EventResetMode(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    AutoReset : EventResetMode # 0
    ManualReset : EventResetMode # 1


class EventWaitHandle(WaitHandle):
    @typing.overload
    def __init__(self, initialState: bool, mode: EventResetMode) -> None: ...
    @typing.overload
    def __init__(self, initialState: bool, mode: EventResetMode, name: str) -> None: ...
    @typing.overload
    def __init__(self, initialState: bool, mode: EventResetMode, name: str, createdNew: clr.Reference[bool]) -> None: ...
    @property
    def Handle(self) -> int: ...
    @Handle.setter
    def Handle(self, value: int) -> int: ...
    @property
    def SafeWaitHandle(self) -> SafeWaitHandle: ...
    @SafeWaitHandle.setter
    def SafeWaitHandle(self, value: SafeWaitHandle) -> SafeWaitHandle: ...
    @staticmethod
    def OpenExisting(name: str) -> EventWaitHandle: ...
    def Reset(self) -> bool: ...
    def Set(self) -> bool: ...
    @staticmethod
    def TryOpenExisting(name: str, result: clr.Reference[EventWaitHandle]) -> bool: ...


class ExecutionContext(ISerializable, IDisposable):
    @staticmethod
    def Capture() -> ExecutionContext: ...
    def CreateCopy(self) -> ExecutionContext: ...
    def Dispose(self) -> None: ...
    def GetObjectData(self, info: SerializationInfo, context: StreamingContext) -> None: ...
    @staticmethod
    def IsFlowSuppressed() -> bool: ...
    @staticmethod
    def Restore(executionContext: ExecutionContext) -> None: ...
    @staticmethod
    def RestoreFlow() -> None: ...
    @staticmethod
    def Run(executionContext: ExecutionContext, callback: ContextCallback, state: typing.Any) -> None: ...
    @staticmethod
    def SuppressFlow() -> AsyncFlowControl: ...


class Interlocked(abc.ABC):
    @staticmethod
    def MemoryBarrier() -> None: ...
    @staticmethod
    def MemoryBarrierProcessWide() -> None: ...
    # Skipped Add due to it being static, abstract and generic.

    Add : Add_MethodGroup
    class Add_MethodGroup:
        def __call__(self, location1: clr.Reference[int], value: int) -> int:...
        # Method Add(location1 : Int64&, value : Int64) was skipped since it collides with above method
        # Method Add(location1 : UInt32&, value : UInt32) was skipped since it collides with above method
        # Method Add(location1 : UInt64&, value : UInt64) was skipped since it collides with above method

    # Skipped And due to it being static, abstract and generic.

    And : And_MethodGroup
    class And_MethodGroup:
        def __call__(self, location1: clr.Reference[int], value: int) -> int:...
        # Method And(location1 : UInt32&, value : UInt32) was skipped since it collides with above method
        # Method And(location1 : Int64&, value : Int64) was skipped since it collides with above method
        # Method And(location1 : UInt64&, value : UInt64) was skipped since it collides with above method

    # Skipped CompareExchange due to it being static, abstract and generic.

    CompareExchange : CompareExchange_MethodGroup
    class CompareExchange_MethodGroup:
        def __getitem__(self, t:typing.Type[CompareExchange_1_T1]) -> CompareExchange_1[CompareExchange_1_T1]: ...

        CompareExchange_1_T1 = typing.TypeVar('CompareExchange_1_T1')
        class CompareExchange_1(typing.Generic[CompareExchange_1_T1]):
            CompareExchange_1_T = Interlocked.CompareExchange_MethodGroup.CompareExchange_1_T1
            def __call__(self, location1: clr.Reference[CompareExchange_1_T], value: CompareExchange_1_T, comparand: CompareExchange_1_T) -> CompareExchange_1_T:...

        @typing.overload
        def __call__(self, location1: clr.Reference[float], value: float, comparand: float) -> float:...
        # Method CompareExchange(location1 : Double&, value : Double, comparand : Double) was skipped since it collides with above method
        # Method CompareExchange(location1 : Int32&, value : Int32, comparand : Int32) was skipped since it collides with above method
        # Method CompareExchange(location1 : Int64&, value : Int64, comparand : Int64) was skipped since it collides with above method
        # Method CompareExchange(location1 : UInt32&, value : UInt32, comparand : UInt32) was skipped since it collides with above method
        # Method CompareExchange(location1 : UInt64&, value : UInt64, comparand : UInt64) was skipped since it collides with above method
        # Method CompareExchange(location1 : IntPtr&, value : IntPtr, comparand : IntPtr) was skipped since it collides with above method
        @typing.overload
        def __call__(self, location1: clr.Reference[typing.Any], value: typing.Any, comparand: typing.Any) -> typing.Any:...

    # Skipped Decrement due to it being static, abstract and generic.

    Decrement : Decrement_MethodGroup
    class Decrement_MethodGroup:
        def __call__(self, location: clr.Reference[int]) -> int:...
        # Method Decrement(location : Int64&) was skipped since it collides with above method
        # Method Decrement(location : UInt32&) was skipped since it collides with above method
        # Method Decrement(location : UInt64&) was skipped since it collides with above method

    # Skipped Exchange due to it being static, abstract and generic.

    Exchange : Exchange_MethodGroup
    class Exchange_MethodGroup:
        def __getitem__(self, t:typing.Type[Exchange_1_T1]) -> Exchange_1[Exchange_1_T1]: ...

        Exchange_1_T1 = typing.TypeVar('Exchange_1_T1')
        class Exchange_1(typing.Generic[Exchange_1_T1]):
            Exchange_1_T = Interlocked.Exchange_MethodGroup.Exchange_1_T1
            def __call__(self, location1: clr.Reference[Exchange_1_T], value: Exchange_1_T) -> Exchange_1_T:...

        @typing.overload
        def __call__(self, location1: clr.Reference[float], value: float) -> float:...
        # Method Exchange(location1 : Double&, value : Double) was skipped since it collides with above method
        # Method Exchange(location1 : Int32&, value : Int32) was skipped since it collides with above method
        # Method Exchange(location1 : Int64&, value : Int64) was skipped since it collides with above method
        # Method Exchange(location1 : UInt32&, value : UInt32) was skipped since it collides with above method
        # Method Exchange(location1 : UInt64&, value : UInt64) was skipped since it collides with above method
        # Method Exchange(location1 : IntPtr&, value : IntPtr) was skipped since it collides with above method
        @typing.overload
        def __call__(self, location1: clr.Reference[typing.Any], value: typing.Any) -> typing.Any:...

    # Skipped Increment due to it being static, abstract and generic.

    Increment : Increment_MethodGroup
    class Increment_MethodGroup:
        def __call__(self, location: clr.Reference[int]) -> int:...
        # Method Increment(location : Int64&) was skipped since it collides with above method
        # Method Increment(location : UInt32&) was skipped since it collides with above method
        # Method Increment(location : UInt64&) was skipped since it collides with above method

    # Skipped Or due to it being static, abstract and generic.

    Or : Or_MethodGroup
    class Or_MethodGroup:
        def __call__(self, location1: clr.Reference[int], value: int) -> int:...
        # Method Or(location1 : UInt32&, value : UInt32) was skipped since it collides with above method
        # Method Or(location1 : Int64&, value : Int64) was skipped since it collides with above method
        # Method Or(location1 : UInt64&, value : UInt64) was skipped since it collides with above method

    # Skipped Read due to it being static, abstract and generic.

    Read : Read_MethodGroup
    class Read_MethodGroup:
        def __call__(self, location: clr.Reference[int]) -> int:...
        # Method Read(location : UInt64&) was skipped since it collides with above method



class IOCompletionCallback(MulticastDelegate):
    def __init__(self, object: typing.Any, method: int) -> None: ...
    @property
    def Method(self) -> MethodInfo: ...
    @property
    def Target(self) -> typing.Any: ...
    def BeginInvoke(self, errorCode: int, numBytes: int, pOVERLAP: clr.Reference[NativeOverlapped], callback: AsyncCallback, object: typing.Any) -> IAsyncResult: ...
    def EndInvoke(self, result: IAsyncResult) -> None: ...
    def Invoke(self, errorCode: int, numBytes: int, pOVERLAP: clr.Reference[NativeOverlapped]) -> None: ...


class IThreadPoolWorkItem(typing.Protocol):
    @abc.abstractmethod
    def Execute(self) -> None: ...


class LazyInitializer(abc.ABC):
    # Skipped EnsureInitialized due to it being static, abstract and generic.

    EnsureInitialized : EnsureInitialized_MethodGroup
    class EnsureInitialized_MethodGroup:
        def __getitem__(self, t:typing.Type[EnsureInitialized_1_T1]) -> EnsureInitialized_1[EnsureInitialized_1_T1]: ...

        EnsureInitialized_1_T1 = typing.TypeVar('EnsureInitialized_1_T1')
        class EnsureInitialized_1(typing.Generic[EnsureInitialized_1_T1]):
            EnsureInitialized_1_T = LazyInitializer.EnsureInitialized_MethodGroup.EnsureInitialized_1_T1
            @typing.overload
            def __call__(self, target: clr.Reference[EnsureInitialized_1_T]) -> EnsureInitialized_1_T:...
            @typing.overload
            def __call__(self, target: clr.Reference[EnsureInitialized_1_T], valueFactory: Func_1[EnsureInitialized_1_T]) -> EnsureInitialized_1_T:...
            @typing.overload
            def __call__(self, target: clr.Reference[EnsureInitialized_1_T], initialized: clr.Reference[bool], syncLock: clr.Reference[typing.Any]) -> EnsureInitialized_1_T:...
            @typing.overload
            def __call__(self, target: clr.Reference[EnsureInitialized_1_T], syncLock: clr.Reference[typing.Any], valueFactory: Func_1[EnsureInitialized_1_T]) -> EnsureInitialized_1_T:...
            @typing.overload
            def __call__(self, target: clr.Reference[EnsureInitialized_1_T], initialized: clr.Reference[bool], syncLock: clr.Reference[typing.Any], valueFactory: Func_1[EnsureInitialized_1_T]) -> EnsureInitialized_1_T:...




class LazyThreadSafetyMode(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    None_ : LazyThreadSafetyMode # 0
    PublicationOnly : LazyThreadSafetyMode # 1
    ExecutionAndPublication : LazyThreadSafetyMode # 2


class LockRecursionException(Exception):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, message: str) -> None: ...
    @typing.overload
    def __init__(self, message: str, innerException: Exception) -> None: ...
    @property
    def Data(self) -> IDictionary: ...
    @property
    def HelpLink(self) -> str: ...
    @HelpLink.setter
    def HelpLink(self, value: str) -> str: ...
    @property
    def HResult(self) -> int: ...
    @HResult.setter
    def HResult(self, value: int) -> int: ...
    @property
    def InnerException(self) -> Exception: ...
    @property
    def Message(self) -> str: ...
    @property
    def Source(self) -> str: ...
    @Source.setter
    def Source(self, value: str) -> str: ...
    @property
    def StackTrace(self) -> str: ...
    @property
    def TargetSite(self) -> MethodBase: ...


class LockRecursionPolicy(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    NoRecursion : LockRecursionPolicy # 0
    SupportsRecursion : LockRecursionPolicy # 1


class ManualResetEvent(EventWaitHandle):
    def __init__(self, initialState: bool) -> None: ...
    @property
    def Handle(self) -> int: ...
    @Handle.setter
    def Handle(self, value: int) -> int: ...
    @property
    def SafeWaitHandle(self) -> SafeWaitHandle: ...
    @SafeWaitHandle.setter
    def SafeWaitHandle(self, value: SafeWaitHandle) -> SafeWaitHandle: ...


class ManualResetEventSlim(IDisposable):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, initialState: bool) -> None: ...
    @typing.overload
    def __init__(self, initialState: bool, spinCount: int) -> None: ...
    @property
    def IsSet(self) -> bool: ...
    @IsSet.setter
    def IsSet(self, value: bool) -> bool: ...
    @property
    def SpinCount(self) -> int: ...
    @SpinCount.setter
    def SpinCount(self, value: int) -> int: ...
    @property
    def WaitHandle(self) -> WaitHandle: ...
    def Dispose(self) -> None: ...
    def Reset(self) -> None: ...
    def Set(self) -> None: ...
    # Skipped Wait due to it being static, abstract and generic.

    Wait : Wait_MethodGroup
    class Wait_MethodGroup:
        @typing.overload
        def __call__(self) -> None:...
        @typing.overload
        def __call__(self, millisecondsTimeout: int) -> bool:...
        @typing.overload
        def __call__(self, timeout: TimeSpan) -> bool:...
        @typing.overload
        def __call__(self, cancellationToken: CancellationToken) -> None:...
        @typing.overload
        def __call__(self, millisecondsTimeout: int, cancellationToken: CancellationToken) -> bool:...
        @typing.overload
        def __call__(self, timeout: TimeSpan, cancellationToken: CancellationToken) -> bool:...



class Monitor(abc.ABC):
    @classmethod
    @property
    def LockContentionCount(cls) -> int: ...
    @staticmethod
    def Exit(obj: typing.Any) -> None: ...
    @staticmethod
    def IsEntered(obj: typing.Any) -> bool: ...
    @staticmethod
    def Pulse(obj: typing.Any) -> None: ...
    @staticmethod
    def PulseAll(obj: typing.Any) -> None: ...
    # Skipped Enter due to it being static, abstract and generic.

    Enter : Enter_MethodGroup
    class Enter_MethodGroup:
        @typing.overload
        def __call__(self, obj: typing.Any) -> None:...
        @typing.overload
        def __call__(self, obj: typing.Any, lockTaken: clr.Reference[bool]) -> None:...

    # Skipped TryEnter due to it being static, abstract and generic.

    TryEnter : TryEnter_MethodGroup
    class TryEnter_MethodGroup:
        @typing.overload
        def __call__(self, obj: typing.Any) -> bool:...
        @typing.overload
        def __call__(self, obj: typing.Any, millisecondsTimeout: int) -> bool:...
        @typing.overload
        def __call__(self, obj: typing.Any, timeout: TimeSpan) -> bool:...
        @typing.overload
        def __call__(self, obj: typing.Any, lockTaken: clr.Reference[bool]) -> None:...
        @typing.overload
        def __call__(self, obj: typing.Any, millisecondsTimeout: int, lockTaken: clr.Reference[bool]) -> None:...
        @typing.overload
        def __call__(self, obj: typing.Any, timeout: TimeSpan, lockTaken: clr.Reference[bool]) -> None:...

    # Skipped Wait due to it being static, abstract and generic.

    Wait : Wait_MethodGroup
    class Wait_MethodGroup:
        @typing.overload
        def __call__(self, obj: typing.Any) -> bool:...
        @typing.overload
        def __call__(self, obj: typing.Any, millisecondsTimeout: int) -> bool:...
        @typing.overload
        def __call__(self, obj: typing.Any, timeout: TimeSpan) -> bool:...
        @typing.overload
        def __call__(self, obj: typing.Any, millisecondsTimeout: int, exitContext: bool) -> bool:...
        @typing.overload
        def __call__(self, obj: typing.Any, timeout: TimeSpan, exitContext: bool) -> bool:...



class Mutex(WaitHandle):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, initiallyOwned: bool) -> None: ...
    @typing.overload
    def __init__(self, initiallyOwned: bool, name: str) -> None: ...
    @typing.overload
    def __init__(self, initiallyOwned: bool, name: str, createdNew: clr.Reference[bool]) -> None: ...
    @property
    def Handle(self) -> int: ...
    @Handle.setter
    def Handle(self, value: int) -> int: ...
    @property
    def SafeWaitHandle(self) -> SafeWaitHandle: ...
    @SafeWaitHandle.setter
    def SafeWaitHandle(self, value: SafeWaitHandle) -> SafeWaitHandle: ...
    @staticmethod
    def OpenExisting(name: str) -> Mutex: ...
    def ReleaseMutex(self) -> None: ...
    @staticmethod
    def TryOpenExisting(name: str, result: clr.Reference[Mutex]) -> bool: ...


class NativeOverlapped:
    EventHandle : int
    InternalHigh : int
    InternalLow : int
    OffsetHigh : int
    OffsetLow : int


class Overlapped:
    # Constructor .ctor(offsetLo : Int32, offsetHi : Int32, hEvent : Int32, ar : IAsyncResult) was skipped since it collides with above method
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, offsetLo: int, offsetHi: int, hEvent: int, ar: IAsyncResult) -> None: ...
    @property
    def AsyncResult(self) -> IAsyncResult: ...
    @AsyncResult.setter
    def AsyncResult(self, value: IAsyncResult) -> IAsyncResult: ...
    @property
    def EventHandle(self) -> int: ...
    @EventHandle.setter
    def EventHandle(self, value: int) -> int: ...
    @property
    def EventHandleIntPtr(self) -> int: ...
    @EventHandleIntPtr.setter
    def EventHandleIntPtr(self, value: int) -> int: ...
    @property
    def OffsetHigh(self) -> int: ...
    @OffsetHigh.setter
    def OffsetHigh(self, value: int) -> int: ...
    @property
    def OffsetLow(self) -> int: ...
    @OffsetLow.setter
    def OffsetLow(self, value: int) -> int: ...
    @staticmethod
    def Free(nativeOverlappedPtr: clr.Reference[NativeOverlapped]) -> None: ...
    @staticmethod
    def Unpack(nativeOverlappedPtr: clr.Reference[NativeOverlapped]) -> Overlapped: ...
    # Skipped Pack due to it being static, abstract and generic.

    Pack : Pack_MethodGroup
    class Pack_MethodGroup:
        @typing.overload
        def __call__(self, iocb: IOCompletionCallback) -> clr.Reference[NativeOverlapped]:...
        @typing.overload
        def __call__(self, iocb: IOCompletionCallback, userData: typing.Any) -> clr.Reference[NativeOverlapped]:...

    # Skipped UnsafePack due to it being static, abstract and generic.

    UnsafePack : UnsafePack_MethodGroup
    class UnsafePack_MethodGroup:
        @typing.overload
        def __call__(self, iocb: IOCompletionCallback) -> clr.Reference[NativeOverlapped]:...
        @typing.overload
        def __call__(self, iocb: IOCompletionCallback, userData: typing.Any) -> clr.Reference[NativeOverlapped]:...



class ParameterizedThreadStart(MulticastDelegate):
    def __init__(self, object: typing.Any, method: int) -> None: ...
    @property
    def Method(self) -> MethodInfo: ...
    @property
    def Target(self) -> typing.Any: ...
    def BeginInvoke(self, obj: typing.Any, callback: AsyncCallback, object: typing.Any) -> IAsyncResult: ...
    def EndInvoke(self, result: IAsyncResult) -> None: ...
    def Invoke(self, obj: typing.Any) -> None: ...


class PeriodicTimer(IDisposable):
    def __init__(self, period: TimeSpan) -> None: ...
    def Dispose(self) -> None: ...
    def WaitForNextTickAsync(self, cancellationToken: CancellationToken = ...) -> ValueTask_1[bool]: ...


class PreAllocatedOverlapped(IDisposable):
    def __init__(self, callback: IOCompletionCallback, state: typing.Any, pinData: typing.Any) -> None: ...
    def Dispose(self) -> None: ...
    @staticmethod
    def UnsafeCreate(callback: IOCompletionCallback, state: typing.Any, pinData: typing.Any) -> PreAllocatedOverlapped: ...


class ReaderWriterLockSlim(IDisposable):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, recursionPolicy: LockRecursionPolicy) -> None: ...
    @property
    def CurrentReadCount(self) -> int: ...
    @property
    def IsReadLockHeld(self) -> bool: ...
    @property
    def IsUpgradeableReadLockHeld(self) -> bool: ...
    @property
    def IsWriteLockHeld(self) -> bool: ...
    @property
    def RecursionPolicy(self) -> LockRecursionPolicy: ...
    @property
    def RecursiveReadCount(self) -> int: ...
    @property
    def RecursiveUpgradeCount(self) -> int: ...
    @property
    def RecursiveWriteCount(self) -> int: ...
    @property
    def WaitingReadCount(self) -> int: ...
    @property
    def WaitingUpgradeCount(self) -> int: ...
    @property
    def WaitingWriteCount(self) -> int: ...
    def Dispose(self) -> None: ...
    def EnterReadLock(self) -> None: ...
    def EnterUpgradeableReadLock(self) -> None: ...
    def EnterWriteLock(self) -> None: ...
    def ExitReadLock(self) -> None: ...
    def ExitUpgradeableReadLock(self) -> None: ...
    def ExitWriteLock(self) -> None: ...
    # Skipped TryEnterReadLock due to it being static, abstract and generic.

    TryEnterReadLock : TryEnterReadLock_MethodGroup
    class TryEnterReadLock_MethodGroup:
        @typing.overload
        def __call__(self, millisecondsTimeout: int) -> bool:...
        @typing.overload
        def __call__(self, timeout: TimeSpan) -> bool:...

    # Skipped TryEnterUpgradeableReadLock due to it being static, abstract and generic.

    TryEnterUpgradeableReadLock : TryEnterUpgradeableReadLock_MethodGroup
    class TryEnterUpgradeableReadLock_MethodGroup:
        @typing.overload
        def __call__(self, millisecondsTimeout: int) -> bool:...
        @typing.overload
        def __call__(self, timeout: TimeSpan) -> bool:...

    # Skipped TryEnterWriteLock due to it being static, abstract and generic.

    TryEnterWriteLock : TryEnterWriteLock_MethodGroup
    class TryEnterWriteLock_MethodGroup:
        @typing.overload
        def __call__(self, millisecondsTimeout: int) -> bool:...
        @typing.overload
        def __call__(self, timeout: TimeSpan) -> bool:...



class RegisteredWaitHandle(MarshalByRefObject):
    def Unregister(self, waitObject: WaitHandle) -> bool: ...


class Semaphore(WaitHandle):
    @typing.overload
    def __init__(self, initialCount: int, maximumCount: int) -> None: ...
    @typing.overload
    def __init__(self, initialCount: int, maximumCount: int, name: str) -> None: ...
    @typing.overload
    def __init__(self, initialCount: int, maximumCount: int, name: str, createdNew: clr.Reference[bool]) -> None: ...
    @property
    def Handle(self) -> int: ...
    @Handle.setter
    def Handle(self, value: int) -> int: ...
    @property
    def SafeWaitHandle(self) -> SafeWaitHandle: ...
    @SafeWaitHandle.setter
    def SafeWaitHandle(self, value: SafeWaitHandle) -> SafeWaitHandle: ...
    @staticmethod
    def OpenExisting(name: str) -> Semaphore: ...
    @staticmethod
    def TryOpenExisting(name: str, result: clr.Reference[Semaphore]) -> bool: ...
    # Skipped Release due to it being static, abstract and generic.

    Release : Release_MethodGroup
    class Release_MethodGroup:
        @typing.overload
        def __call__(self) -> int:...
        @typing.overload
        def __call__(self, releaseCount: int) -> int:...



class SemaphoreFullException(SystemException):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, message: str) -> None: ...
    @typing.overload
    def __init__(self, message: str, innerException: Exception) -> None: ...
    @property
    def Data(self) -> IDictionary: ...
    @property
    def HelpLink(self) -> str: ...
    @HelpLink.setter
    def HelpLink(self, value: str) -> str: ...
    @property
    def HResult(self) -> int: ...
    @HResult.setter
    def HResult(self, value: int) -> int: ...
    @property
    def InnerException(self) -> Exception: ...
    @property
    def Message(self) -> str: ...
    @property
    def Source(self) -> str: ...
    @Source.setter
    def Source(self, value: str) -> str: ...
    @property
    def StackTrace(self) -> str: ...
    @property
    def TargetSite(self) -> MethodBase: ...


class SemaphoreSlim(IDisposable):
    @typing.overload
    def __init__(self, initialCount: int) -> None: ...
    @typing.overload
    def __init__(self, initialCount: int, maxCount: int) -> None: ...
    @property
    def AvailableWaitHandle(self) -> WaitHandle: ...
    @property
    def CurrentCount(self) -> int: ...
    def Dispose(self) -> None: ...
    # Skipped Release due to it being static, abstract and generic.

    Release : Release_MethodGroup
    class Release_MethodGroup:
        @typing.overload
        def __call__(self) -> int:...
        @typing.overload
        def __call__(self, releaseCount: int) -> int:...

    # Skipped Wait due to it being static, abstract and generic.

    Wait : Wait_MethodGroup
    class Wait_MethodGroup:
        @typing.overload
        def __call__(self) -> None:...
        @typing.overload
        def __call__(self, millisecondsTimeout: int) -> bool:...
        @typing.overload
        def __call__(self, timeout: TimeSpan) -> bool:...
        @typing.overload
        def __call__(self, cancellationToken: CancellationToken) -> None:...
        @typing.overload
        def __call__(self, millisecondsTimeout: int, cancellationToken: CancellationToken) -> bool:...
        @typing.overload
        def __call__(self, timeout: TimeSpan, cancellationToken: CancellationToken) -> bool:...

    # Skipped WaitAsync due to it being static, abstract and generic.

    WaitAsync : WaitAsync_MethodGroup
    class WaitAsync_MethodGroup:
        @typing.overload
        def __call__(self) -> Task:...
        @typing.overload
        def __call__(self, millisecondsTimeout: int) -> Task_1[bool]:...
        @typing.overload
        def __call__(self, timeout: TimeSpan) -> Task_1[bool]:...
        @typing.overload
        def __call__(self, cancellationToken: CancellationToken) -> Task:...
        @typing.overload
        def __call__(self, millisecondsTimeout: int, cancellationToken: CancellationToken) -> Task_1[bool]:...
        @typing.overload
        def __call__(self, timeout: TimeSpan, cancellationToken: CancellationToken) -> Task_1[bool]:...



class SendOrPostCallback(MulticastDelegate):
    def __init__(self, object: typing.Any, method: int) -> None: ...
    @property
    def Method(self) -> MethodInfo: ...
    @property
    def Target(self) -> typing.Any: ...
    def BeginInvoke(self, state: typing.Any, callback: AsyncCallback, object: typing.Any) -> IAsyncResult: ...
    def EndInvoke(self, result: IAsyncResult) -> None: ...
    def Invoke(self, state: typing.Any) -> None: ...


class SpinLock:
    def __init__(self, enableThreadOwnerTracking: bool) -> None: ...
    @property
    def IsHeld(self) -> bool: ...
    @property
    def IsHeldByCurrentThread(self) -> bool: ...
    @property
    def IsThreadOwnerTrackingEnabled(self) -> bool: ...
    def Enter(self, lockTaken: clr.Reference[bool]) -> None: ...
    # Skipped Exit due to it being static, abstract and generic.

    Exit : Exit_MethodGroup
    class Exit_MethodGroup:
        @typing.overload
        def __call__(self) -> None:...
        @typing.overload
        def __call__(self, useMemoryBarrier: bool) -> None:...

    # Skipped TryEnter due to it being static, abstract and generic.

    TryEnter : TryEnter_MethodGroup
    class TryEnter_MethodGroup:
        @typing.overload
        def __call__(self, lockTaken: clr.Reference[bool]) -> None:...
        @typing.overload
        def __call__(self, millisecondsTimeout: int, lockTaken: clr.Reference[bool]) -> None:...
        @typing.overload
        def __call__(self, timeout: TimeSpan, lockTaken: clr.Reference[bool]) -> None:...



class SpinWait:
    @property
    def Count(self) -> int: ...
    @Count.setter
    def Count(self, value: int) -> int: ...
    @property
    def NextSpinWillYield(self) -> bool: ...
    def Reset(self) -> None: ...
    # Skipped SpinOnce due to it being static, abstract and generic.

    SpinOnce : SpinOnce_MethodGroup
    class SpinOnce_MethodGroup:
        @typing.overload
        def __call__(self) -> None:...
        @typing.overload
        def __call__(self, sleep1Threshold: int) -> None:...

    # Skipped SpinUntil due to it being static, abstract and generic.

    SpinUntil : SpinUntil_MethodGroup
    class SpinUntil_MethodGroup:
        @typing.overload
        def __call__(self, condition: Func_1[bool]) -> None:...
        @typing.overload
        def __call__(self, condition: Func_1[bool], millisecondsTimeout: int) -> bool:...
        @typing.overload
        def __call__(self, condition: Func_1[bool], timeout: TimeSpan) -> bool:...



class SynchronizationContext:
    def __init__(self) -> None: ...
    @classmethod
    @property
    def Current(cls) -> SynchronizationContext: ...
    def CreateCopy(self) -> SynchronizationContext: ...
    def IsWaitNotificationRequired(self) -> bool: ...
    def OperationCompleted(self) -> None: ...
    def OperationStarted(self) -> None: ...
    def Post(self, d: SendOrPostCallback, state: typing.Any) -> None: ...
    def Send(self, d: SendOrPostCallback, state: typing.Any) -> None: ...
    @staticmethod
    def SetSynchronizationContext(syncContext: SynchronizationContext) -> None: ...
    def Wait(self, waitHandles: Array_1[int], waitAll: bool, millisecondsTimeout: int) -> int: ...


class SynchronizationLockException(SystemException):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, message: str) -> None: ...
    @typing.overload
    def __init__(self, message: str, innerException: Exception) -> None: ...
    @property
    def Data(self) -> IDictionary: ...
    @property
    def HelpLink(self) -> str: ...
    @HelpLink.setter
    def HelpLink(self, value: str) -> str: ...
    @property
    def HResult(self) -> int: ...
    @HResult.setter
    def HResult(self, value: int) -> int: ...
    @property
    def InnerException(self) -> Exception: ...
    @property
    def Message(self) -> str: ...
    @property
    def Source(self) -> str: ...
    @Source.setter
    def Source(self, value: str) -> str: ...
    @property
    def StackTrace(self) -> str: ...
    @property
    def TargetSite(self) -> MethodBase: ...


class Thread(CriticalFinalizerObject):
    @typing.overload
    def __init__(self, start: ThreadStart) -> None: ...
    @typing.overload
    def __init__(self, start: ParameterizedThreadStart) -> None: ...
    @typing.overload
    def __init__(self, start: ThreadStart, maxStackSize: int) -> None: ...
    @typing.overload
    def __init__(self, start: ParameterizedThreadStart, maxStackSize: int) -> None: ...
    @property
    def ApartmentState(self) -> ApartmentState: ...
    @ApartmentState.setter
    def ApartmentState(self, value: ApartmentState) -> ApartmentState: ...
    @property
    def CurrentCulture(self) -> CultureInfo: ...
    @CurrentCulture.setter
    def CurrentCulture(self, value: CultureInfo) -> CultureInfo: ...
    @classmethod
    @property
    def CurrentPrincipal(cls) -> IPrincipal: ...
    @classmethod
    @CurrentPrincipal.setter
    def CurrentPrincipal(cls, value: IPrincipal) -> IPrincipal: ...
    @classmethod
    @property
    def CurrentThread(cls) -> Thread: ...
    @property
    def CurrentUICulture(self) -> CultureInfo: ...
    @CurrentUICulture.setter
    def CurrentUICulture(self, value: CultureInfo) -> CultureInfo: ...
    @property
    def ExecutionContext(self) -> ExecutionContext: ...
    @property
    def IsAlive(self) -> bool: ...
    @property
    def IsBackground(self) -> bool: ...
    @IsBackground.setter
    def IsBackground(self, value: bool) -> bool: ...
    @property
    def IsThreadPoolThread(self) -> bool: ...
    @IsThreadPoolThread.setter
    def IsThreadPoolThread(self, value: bool) -> bool: ...
    @property
    def ManagedThreadId(self) -> int: ...
    @property
    def Name(self) -> str: ...
    @Name.setter
    def Name(self, value: str) -> str: ...
    @property
    def Priority(self) -> ThreadPriority: ...
    @Priority.setter
    def Priority(self, value: ThreadPriority) -> ThreadPriority: ...
    @property
    def ThreadState(self) -> ThreadState: ...
    @staticmethod
    def AllocateDataSlot() -> LocalDataStoreSlot: ...
    @staticmethod
    def AllocateNamedDataSlot(name: str) -> LocalDataStoreSlot: ...
    @staticmethod
    def BeginCriticalRegion() -> None: ...
    @staticmethod
    def BeginThreadAffinity() -> None: ...
    def DisableComObjectEagerCleanup(self) -> None: ...
    @staticmethod
    def EndCriticalRegion() -> None: ...
    @staticmethod
    def EndThreadAffinity() -> None: ...
    @staticmethod
    def FreeNamedDataSlot(name: str) -> None: ...
    def GetApartmentState(self) -> ApartmentState: ...
    def GetCompressedStack(self) -> CompressedStack: ...
    @staticmethod
    def GetCurrentProcessorId() -> int: ...
    @staticmethod
    def GetData(slot: LocalDataStoreSlot) -> typing.Any: ...
    @staticmethod
    def GetDomain() -> AppDomain: ...
    @staticmethod
    def GetDomainID() -> int: ...
    def GetHashCode(self) -> int: ...
    @staticmethod
    def GetNamedDataSlot(name: str) -> LocalDataStoreSlot: ...
    def Interrupt(self) -> None: ...
    @staticmethod
    def MemoryBarrier() -> None: ...
    @staticmethod
    def ResetAbort() -> None: ...
    def Resume(self) -> None: ...
    def SetApartmentState(self, state: ApartmentState) -> None: ...
    def SetCompressedStack(self, stack: CompressedStack) -> None: ...
    @staticmethod
    def SetData(slot: LocalDataStoreSlot, data: typing.Any) -> None: ...
    @staticmethod
    def SpinWait(iterations: int) -> None: ...
    def Suspend(self) -> None: ...
    def TrySetApartmentState(self, state: ApartmentState) -> bool: ...
    @staticmethod
    def Yield() -> bool: ...
    # Skipped Abort due to it being static, abstract and generic.

    Abort : Abort_MethodGroup
    class Abort_MethodGroup:
        @typing.overload
        def __call__(self) -> None:...
        @typing.overload
        def __call__(self, stateInfo: typing.Any) -> None:...

    # Skipped Join due to it being static, abstract and generic.

    Join : Join_MethodGroup
    class Join_MethodGroup:
        @typing.overload
        def __call__(self) -> None:...
        @typing.overload
        def __call__(self, millisecondsTimeout: int) -> bool:...
        @typing.overload
        def __call__(self, timeout: TimeSpan) -> bool:...

    # Skipped Sleep due to it being static, abstract and generic.

    Sleep : Sleep_MethodGroup
    class Sleep_MethodGroup:
        @typing.overload
        def __call__(self, millisecondsTimeout: int) -> None:...
        @typing.overload
        def __call__(self, timeout: TimeSpan) -> None:...

    # Skipped Start due to it being static, abstract and generic.

    Start : Start_MethodGroup
    class Start_MethodGroup:
        @typing.overload
        def __call__(self) -> None:...
        @typing.overload
        def __call__(self, parameter: typing.Any) -> None:...

    # Skipped UnsafeStart due to it being static, abstract and generic.

    UnsafeStart : UnsafeStart_MethodGroup
    class UnsafeStart_MethodGroup:
        @typing.overload
        def __call__(self) -> None:...
        @typing.overload
        def __call__(self, parameter: typing.Any) -> None:...

    # Skipped VolatileRead due to it being static, abstract and generic.

    VolatileRead : VolatileRead_MethodGroup
    class VolatileRead_MethodGroup:
        @typing.overload
        def __call__(self, address: clr.Reference[float]) -> float:...
        # Method VolatileRead(address : Single&) was skipped since it collides with above method
        # Method VolatileRead(address : Byte&) was skipped since it collides with above method
        # Method VolatileRead(address : Int16&) was skipped since it collides with above method
        # Method VolatileRead(address : Int32&) was skipped since it collides with above method
        # Method VolatileRead(address : Int64&) was skipped since it collides with above method
        # Method VolatileRead(address : IntPtr&) was skipped since it collides with above method
        # Method VolatileRead(address : SByte&) was skipped since it collides with above method
        # Method VolatileRead(address : UInt16&) was skipped since it collides with above method
        # Method VolatileRead(address : UInt32&) was skipped since it collides with above method
        # Method VolatileRead(address : UInt64&) was skipped since it collides with above method
        @typing.overload
        def __call__(self, address: clr.Reference[UIntPtr]) -> UIntPtr:...
        @typing.overload
        def __call__(self, address: clr.Reference[typing.Any]) -> typing.Any:...

    # Skipped VolatileWrite due to it being static, abstract and generic.

    VolatileWrite : VolatileWrite_MethodGroup
    class VolatileWrite_MethodGroup:
        @typing.overload
        def __call__(self, address: clr.Reference[float], value: float) -> None:...
        # Method VolatileWrite(address : Single&, value : Single) was skipped since it collides with above method
        # Method VolatileWrite(address : Byte&, value : Byte) was skipped since it collides with above method
        # Method VolatileWrite(address : Int16&, value : Int16) was skipped since it collides with above method
        # Method VolatileWrite(address : Int32&, value : Int32) was skipped since it collides with above method
        # Method VolatileWrite(address : Int64&, value : Int64) was skipped since it collides with above method
        # Method VolatileWrite(address : IntPtr&, value : IntPtr) was skipped since it collides with above method
        # Method VolatileWrite(address : SByte&, value : SByte) was skipped since it collides with above method
        # Method VolatileWrite(address : UInt16&, value : UInt16) was skipped since it collides with above method
        # Method VolatileWrite(address : UInt32&, value : UInt32) was skipped since it collides with above method
        # Method VolatileWrite(address : UInt64&, value : UInt64) was skipped since it collides with above method
        @typing.overload
        def __call__(self, address: clr.Reference[UIntPtr], value: UIntPtr) -> None:...
        @typing.overload
        def __call__(self, address: clr.Reference[typing.Any], value: typing.Any) -> None:...



class ThreadAbortException(SystemException):
    @property
    def Data(self) -> IDictionary: ...
    @property
    def ExceptionState(self) -> typing.Any: ...
    @property
    def HelpLink(self) -> str: ...
    @HelpLink.setter
    def HelpLink(self, value: str) -> str: ...
    @property
    def HResult(self) -> int: ...
    @HResult.setter
    def HResult(self, value: int) -> int: ...
    @property
    def InnerException(self) -> Exception: ...
    @property
    def Message(self) -> str: ...
    @property
    def Source(self) -> str: ...
    @Source.setter
    def Source(self, value: str) -> str: ...
    @property
    def StackTrace(self) -> str: ...
    @property
    def TargetSite(self) -> MethodBase: ...


class ThreadExceptionEventArgs(EventArgs):
    def __init__(self, t: Exception) -> None: ...
    @property
    def Exception(self) -> Exception: ...


class ThreadExceptionEventHandler(MulticastDelegate):
    def __init__(self, object: typing.Any, method: int) -> None: ...
    @property
    def Method(self) -> MethodInfo: ...
    @property
    def Target(self) -> typing.Any: ...
    def BeginInvoke(self, sender: typing.Any, e: ThreadExceptionEventArgs, callback: AsyncCallback, object: typing.Any) -> IAsyncResult: ...
    def EndInvoke(self, result: IAsyncResult) -> None: ...
    def Invoke(self, sender: typing.Any, e: ThreadExceptionEventArgs) -> None: ...


class ThreadInterruptedException(SystemException):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, message: str) -> None: ...
    @typing.overload
    def __init__(self, message: str, innerException: Exception) -> None: ...
    @property
    def Data(self) -> IDictionary: ...
    @property
    def HelpLink(self) -> str: ...
    @HelpLink.setter
    def HelpLink(self, value: str) -> str: ...
    @property
    def HResult(self) -> int: ...
    @HResult.setter
    def HResult(self, value: int) -> int: ...
    @property
    def InnerException(self) -> Exception: ...
    @property
    def Message(self) -> str: ...
    @property
    def Source(self) -> str: ...
    @Source.setter
    def Source(self, value: str) -> str: ...
    @property
    def StackTrace(self) -> str: ...
    @property
    def TargetSite(self) -> MethodBase: ...


class ThreadLocal_GenericClasses(abc.ABCMeta):
    Generic_ThreadLocal_GenericClasses_ThreadLocal_1_T = typing.TypeVar('Generic_ThreadLocal_GenericClasses_ThreadLocal_1_T')
    def __getitem__(self, types : typing.Type[Generic_ThreadLocal_GenericClasses_ThreadLocal_1_T]) -> typing.Type[ThreadLocal_1[Generic_ThreadLocal_GenericClasses_ThreadLocal_1_T]]: ...

ThreadLocal : ThreadLocal_GenericClasses

ThreadLocal_1_T = typing.TypeVar('ThreadLocal_1_T')
class ThreadLocal_1(typing.Generic[ThreadLocal_1_T], IDisposable):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, trackAllValues: bool) -> None: ...
    @typing.overload
    def __init__(self, valueFactory: Func_1[ThreadLocal_1_T]) -> None: ...
    @typing.overload
    def __init__(self, valueFactory: Func_1[ThreadLocal_1_T], trackAllValues: bool) -> None: ...
    @property
    def IsValueCreated(self) -> bool: ...
    @property
    def Value(self) -> ThreadLocal_1_T: ...
    @Value.setter
    def Value(self, value: ThreadLocal_1_T) -> ThreadLocal_1_T: ...
    @property
    def Values(self) -> IList_1[ThreadLocal_1_T]: ...
    def Dispose(self) -> None: ...
    def ToString(self) -> str: ...


class ThreadPool(abc.ABC):
    @classmethod
    @property
    def CompletedWorkItemCount(cls) -> int: ...
    @classmethod
    @property
    def PendingWorkItemCount(cls) -> int: ...
    @classmethod
    @property
    def ThreadCount(cls) -> int: ...
    @staticmethod
    def GetAvailableThreads(workerThreads: clr.Reference[int], completionPortThreads: clr.Reference[int]) -> None: ...
    @staticmethod
    def GetMaxThreads(workerThreads: clr.Reference[int], completionPortThreads: clr.Reference[int]) -> None: ...
    @staticmethod
    def GetMinThreads(workerThreads: clr.Reference[int], completionPortThreads: clr.Reference[int]) -> None: ...
    @staticmethod
    def SetMaxThreads(workerThreads: int, completionPortThreads: int) -> bool: ...
    @staticmethod
    def SetMinThreads(workerThreads: int, completionPortThreads: int) -> bool: ...
    @staticmethod
    def UnsafeQueueNativeOverlapped(overlapped: clr.Reference[NativeOverlapped]) -> bool: ...
    # Skipped BindHandle due to it being static, abstract and generic.

    BindHandle : BindHandle_MethodGroup
    class BindHandle_MethodGroup:
        @typing.overload
        def __call__(self, osHandle: int) -> bool:...
        @typing.overload
        def __call__(self, osHandle: SafeHandle) -> bool:...

    # Skipped QueueUserWorkItem due to it being static, abstract and generic.

    QueueUserWorkItem : QueueUserWorkItem_MethodGroup
    class QueueUserWorkItem_MethodGroup:
        def __getitem__(self, t:typing.Type[QueueUserWorkItem_1_T1]) -> QueueUserWorkItem_1[QueueUserWorkItem_1_T1]: ...

        QueueUserWorkItem_1_T1 = typing.TypeVar('QueueUserWorkItem_1_T1')
        class QueueUserWorkItem_1(typing.Generic[QueueUserWorkItem_1_T1]):
            QueueUserWorkItem_1_TState = ThreadPool.QueueUserWorkItem_MethodGroup.QueueUserWorkItem_1_T1
            def __call__(self, callBack: Action_1[QueueUserWorkItem_1_TState], state: QueueUserWorkItem_1_TState, preferLocal: bool) -> bool:...

        @typing.overload
        def __call__(self, callBack: WaitCallback) -> bool:...
        @typing.overload
        def __call__(self, callBack: WaitCallback, state: typing.Any) -> bool:...

    # Skipped RegisterWaitForSingleObject due to it being static, abstract and generic.

    RegisterWaitForSingleObject : RegisterWaitForSingleObject_MethodGroup
    class RegisterWaitForSingleObject_MethodGroup:
        @typing.overload
        def __call__(self, waitObject: WaitHandle, callBack: WaitOrTimerCallback, state: typing.Any, millisecondsTimeOutInterval: int, executeOnlyOnce: bool) -> RegisteredWaitHandle:...
        # Method RegisterWaitForSingleObject(waitObject : WaitHandle, callBack : WaitOrTimerCallback, state : Object, millisecondsTimeOutInterval : Int32, executeOnlyOnce : Boolean) was skipped since it collides with above method
        # Method RegisterWaitForSingleObject(waitObject : WaitHandle, callBack : WaitOrTimerCallback, state : Object, millisecondsTimeOutInterval : Int64, executeOnlyOnce : Boolean) was skipped since it collides with above method
        @typing.overload
        def __call__(self, waitObject: WaitHandle, callBack: WaitOrTimerCallback, state: typing.Any, timeout: TimeSpan, executeOnlyOnce: bool) -> RegisteredWaitHandle:...

    # Skipped UnsafeQueueUserWorkItem due to it being static, abstract and generic.

    UnsafeQueueUserWorkItem : UnsafeQueueUserWorkItem_MethodGroup
    class UnsafeQueueUserWorkItem_MethodGroup:
        def __getitem__(self, t:typing.Type[UnsafeQueueUserWorkItem_1_T1]) -> UnsafeQueueUserWorkItem_1[UnsafeQueueUserWorkItem_1_T1]: ...

        UnsafeQueueUserWorkItem_1_T1 = typing.TypeVar('UnsafeQueueUserWorkItem_1_T1')
        class UnsafeQueueUserWorkItem_1(typing.Generic[UnsafeQueueUserWorkItem_1_T1]):
            UnsafeQueueUserWorkItem_1_TState = ThreadPool.UnsafeQueueUserWorkItem_MethodGroup.UnsafeQueueUserWorkItem_1_T1
            def __call__(self, callBack: Action_1[UnsafeQueueUserWorkItem_1_TState], state: UnsafeQueueUserWorkItem_1_TState, preferLocal: bool) -> bool:...

        @typing.overload
        def __call__(self, callBack: WaitCallback, state: typing.Any) -> bool:...
        @typing.overload
        def __call__(self, callBack: IThreadPoolWorkItem, preferLocal: bool) -> bool:...

    # Skipped UnsafeRegisterWaitForSingleObject due to it being static, abstract and generic.

    UnsafeRegisterWaitForSingleObject : UnsafeRegisterWaitForSingleObject_MethodGroup
    class UnsafeRegisterWaitForSingleObject_MethodGroup:
        @typing.overload
        def __call__(self, waitObject: WaitHandle, callBack: WaitOrTimerCallback, state: typing.Any, millisecondsTimeOutInterval: int, executeOnlyOnce: bool) -> RegisteredWaitHandle:...
        # Method UnsafeRegisterWaitForSingleObject(waitObject : WaitHandle, callBack : WaitOrTimerCallback, state : Object, millisecondsTimeOutInterval : Int32, executeOnlyOnce : Boolean) was skipped since it collides with above method
        # Method UnsafeRegisterWaitForSingleObject(waitObject : WaitHandle, callBack : WaitOrTimerCallback, state : Object, millisecondsTimeOutInterval : Int64, executeOnlyOnce : Boolean) was skipped since it collides with above method
        @typing.overload
        def __call__(self, waitObject: WaitHandle, callBack: WaitOrTimerCallback, state: typing.Any, timeout: TimeSpan, executeOnlyOnce: bool) -> RegisteredWaitHandle:...



class ThreadPoolBoundHandle(IDisposable):
    @property
    def Handle(self) -> SafeHandle: ...
    @staticmethod
    def BindHandle(handle: SafeHandle) -> ThreadPoolBoundHandle: ...
    def Dispose(self) -> None: ...
    def FreeNativeOverlapped(self, overlapped: clr.Reference[NativeOverlapped]) -> None: ...
    @staticmethod
    def GetNativeOverlappedState(overlapped: clr.Reference[NativeOverlapped]) -> typing.Any: ...
    def UnsafeAllocateNativeOverlapped(self, callback: IOCompletionCallback, state: typing.Any, pinData: typing.Any) -> clr.Reference[NativeOverlapped]: ...
    # Skipped AllocateNativeOverlapped due to it being static, abstract and generic.

    AllocateNativeOverlapped : AllocateNativeOverlapped_MethodGroup
    class AllocateNativeOverlapped_MethodGroup:
        @typing.overload
        def __call__(self, preAllocated: PreAllocatedOverlapped) -> clr.Reference[NativeOverlapped]:...
        @typing.overload
        def __call__(self, callback: IOCompletionCallback, state: typing.Any, pinData: typing.Any) -> clr.Reference[NativeOverlapped]:...



class ThreadPriority(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Lowest : ThreadPriority # 0
    BelowNormal : ThreadPriority # 1
    Normal : ThreadPriority # 2
    AboveNormal : ThreadPriority # 3
    Highest : ThreadPriority # 4


class ThreadStart(MulticastDelegate):
    def __init__(self, object: typing.Any, method: int) -> None: ...
    @property
    def Method(self) -> MethodInfo: ...
    @property
    def Target(self) -> typing.Any: ...
    def BeginInvoke(self, callback: AsyncCallback, object: typing.Any) -> IAsyncResult: ...
    def EndInvoke(self, result: IAsyncResult) -> None: ...
    def Invoke(self) -> None: ...


class ThreadStartException(SystemException):
    @property
    def Data(self) -> IDictionary: ...
    @property
    def HelpLink(self) -> str: ...
    @HelpLink.setter
    def HelpLink(self, value: str) -> str: ...
    @property
    def HResult(self) -> int: ...
    @HResult.setter
    def HResult(self, value: int) -> int: ...
    @property
    def InnerException(self) -> Exception: ...
    @property
    def Message(self) -> str: ...
    @property
    def Source(self) -> str: ...
    @Source.setter
    def Source(self, value: str) -> str: ...
    @property
    def StackTrace(self) -> str: ...
    @property
    def TargetSite(self) -> MethodBase: ...


class ThreadState(typing.SupportsInt):
    @typing.overload
    def __init__(self, value : int) -> None: ...
    @typing.overload
    def __init__(self, value : int, force_if_true: bool) -> None: ...
    def __int__(self) -> int: ...
    
    # Values:
    Running : ThreadState # 0
    StopRequested : ThreadState # 1
    SuspendRequested : ThreadState # 2
    Background : ThreadState # 4
    Unstarted : ThreadState # 8
    Stopped : ThreadState # 16
    WaitSleepJoin : ThreadState # 32
    Suspended : ThreadState # 64
    AbortRequested : ThreadState # 128
    Aborted : ThreadState # 256


class ThreadStateException(SystemException):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, message: str) -> None: ...
    @typing.overload
    def __init__(self, message: str, innerException: Exception) -> None: ...
    @property
    def Data(self) -> IDictionary: ...
    @property
    def HelpLink(self) -> str: ...
    @HelpLink.setter
    def HelpLink(self, value: str) -> str: ...
    @property
    def HResult(self) -> int: ...
    @HResult.setter
    def HResult(self, value: int) -> int: ...
    @property
    def InnerException(self) -> Exception: ...
    @property
    def Message(self) -> str: ...
    @property
    def Source(self) -> str: ...
    @Source.setter
    def Source(self, value: str) -> str: ...
    @property
    def StackTrace(self) -> str: ...
    @property
    def TargetSite(self) -> MethodBase: ...


class Timeout(abc.ABC):
    Infinite : int
    InfiniteTimeSpan : TimeSpan


class Timer(MarshalByRefObject, IAsyncDisposable, IDisposable):
    # Constructor .ctor(callback : TimerCallback, state : Object, dueTime : UInt32, period : UInt32) was skipped since it collides with above method
    # Constructor .ctor(callback : TimerCallback, state : Object, dueTime : Int64, period : Int64) was skipped since it collides with above method
    @typing.overload
    def __init__(self, callback: TimerCallback) -> None: ...
    @typing.overload
    def __init__(self, callback: TimerCallback, state: typing.Any, dueTime: int, period: int) -> None: ...
    @typing.overload
    def __init__(self, callback: TimerCallback, state: typing.Any, dueTime: TimeSpan, period: TimeSpan) -> None: ...
    @classmethod
    @property
    def ActiveCount(cls) -> int: ...
    def DisposeAsync(self) -> ValueTask: ...
    # Skipped Change due to it being static, abstract and generic.

    Change : Change_MethodGroup
    class Change_MethodGroup:
        @typing.overload
        def __call__(self, dueTime: int, period: int) -> bool:...
        # Method Change(dueTime : UInt32, period : UInt32) was skipped since it collides with above method
        # Method Change(dueTime : Int64, period : Int64) was skipped since it collides with above method
        @typing.overload
        def __call__(self, dueTime: TimeSpan, period: TimeSpan) -> bool:...

    # Skipped Dispose due to it being static, abstract and generic.

    Dispose : Dispose_MethodGroup
    class Dispose_MethodGroup:
        @typing.overload
        def __call__(self) -> None:...
        @typing.overload
        def __call__(self, notifyObject: WaitHandle) -> bool:...



class TimerCallback(MulticastDelegate):
    def __init__(self, object: typing.Any, method: int) -> None: ...
    @property
    def Method(self) -> MethodInfo: ...
    @property
    def Target(self) -> typing.Any: ...
    def BeginInvoke(self, state: typing.Any, callback: AsyncCallback, object: typing.Any) -> IAsyncResult: ...
    def EndInvoke(self, result: IAsyncResult) -> None: ...
    def Invoke(self, state: typing.Any) -> None: ...


class Volatile(abc.ABC):
    # Skipped Read due to it being static, abstract and generic.

    Read : Read_MethodGroup
    class Read_MethodGroup:
        def __getitem__(self, t:typing.Type[Read_1_T1]) -> Read_1[Read_1_T1]: ...

        Read_1_T1 = typing.TypeVar('Read_1_T1')
        class Read_1(typing.Generic[Read_1_T1]):
            Read_1_T = Volatile.Read_MethodGroup.Read_1_T1
            def __call__(self, location: clr.Reference[Read_1_T]) -> Read_1_T:...

        @typing.overload
        def __call__(self, location: clr.Reference[float]) -> float:...
        # Method Read(location : Single&) was skipped since it collides with above method
        # Method Read(location : Byte&) was skipped since it collides with above method
        # Method Read(location : Int16&) was skipped since it collides with above method
        # Method Read(location : Int32&) was skipped since it collides with above method
        # Method Read(location : Int64&) was skipped since it collides with above method
        # Method Read(location : IntPtr&) was skipped since it collides with above method
        # Method Read(location : SByte&) was skipped since it collides with above method
        # Method Read(location : UInt16&) was skipped since it collides with above method
        # Method Read(location : UInt32&) was skipped since it collides with above method
        # Method Read(location : UInt64&) was skipped since it collides with above method
        @typing.overload
        def __call__(self, location: clr.Reference[UIntPtr]) -> UIntPtr:...
        # Method Read(location : Boolean&) was skipped since it collides with above method

    # Skipped Write due to it being static, abstract and generic.

    Write : Write_MethodGroup
    class Write_MethodGroup:
        def __getitem__(self, t:typing.Type[Write_1_T1]) -> Write_1[Write_1_T1]: ...

        Write_1_T1 = typing.TypeVar('Write_1_T1')
        class Write_1(typing.Generic[Write_1_T1]):
            Write_1_T = Volatile.Write_MethodGroup.Write_1_T1
            def __call__(self, location: clr.Reference[Write_1_T], value: Write_1_T) -> None:...

        @typing.overload
        def __call__(self, location: clr.Reference[float], value: float) -> None:...
        # Method Write(location : Single&, value : Single) was skipped since it collides with above method
        # Method Write(location : Byte&, value : Byte) was skipped since it collides with above method
        # Method Write(location : Int16&, value : Int16) was skipped since it collides with above method
        # Method Write(location : Int32&, value : Int32) was skipped since it collides with above method
        # Method Write(location : Int64&, value : Int64) was skipped since it collides with above method
        # Method Write(location : IntPtr&, value : IntPtr) was skipped since it collides with above method
        # Method Write(location : SByte&, value : SByte) was skipped since it collides with above method
        # Method Write(location : UInt16&, value : UInt16) was skipped since it collides with above method
        # Method Write(location : UInt32&, value : UInt32) was skipped since it collides with above method
        # Method Write(location : UInt64&, value : UInt64) was skipped since it collides with above method
        @typing.overload
        def __call__(self, location: clr.Reference[UIntPtr], value: UIntPtr) -> None:...
        # Method Write(location : Boolean&, value : Boolean) was skipped since it collides with above method



class WaitCallback(MulticastDelegate):
    def __init__(self, object: typing.Any, method: int) -> None: ...
    @property
    def Method(self) -> MethodInfo: ...
    @property
    def Target(self) -> typing.Any: ...
    def BeginInvoke(self, state: typing.Any, callback: AsyncCallback, object: typing.Any) -> IAsyncResult: ...
    def EndInvoke(self, result: IAsyncResult) -> None: ...
    def Invoke(self, state: typing.Any) -> None: ...


class WaitHandle(MarshalByRefObject, IDisposable):
    WaitTimeout : int
    @property
    def Handle(self) -> int: ...
    @Handle.setter
    def Handle(self, value: int) -> int: ...
    @property
    def SafeWaitHandle(self) -> SafeWaitHandle: ...
    @SafeWaitHandle.setter
    def SafeWaitHandle(self, value: SafeWaitHandle) -> SafeWaitHandle: ...
    def Close(self) -> None: ...
    def Dispose(self) -> None: ...
    # Skipped SignalAndWait due to it being static, abstract and generic.

    SignalAndWait : SignalAndWait_MethodGroup
    class SignalAndWait_MethodGroup:
        @typing.overload
        def __call__(self, toSignal: WaitHandle, toWaitOn: WaitHandle) -> bool:...
        @typing.overload
        def __call__(self, toSignal: WaitHandle, toWaitOn: WaitHandle, millisecondsTimeout: int, exitContext: bool) -> bool:...
        @typing.overload
        def __call__(self, toSignal: WaitHandle, toWaitOn: WaitHandle, timeout: TimeSpan, exitContext: bool) -> bool:...

    # Skipped WaitAll due to it being static, abstract and generic.

    WaitAll : WaitAll_MethodGroup
    class WaitAll_MethodGroup:
        @typing.overload
        def __call__(self, waitHandles: Array_1[WaitHandle]) -> bool:...
        @typing.overload
        def __call__(self, waitHandles: Array_1[WaitHandle], millisecondsTimeout: int) -> bool:...
        @typing.overload
        def __call__(self, waitHandles: Array_1[WaitHandle], timeout: TimeSpan) -> bool:...
        @typing.overload
        def __call__(self, waitHandles: Array_1[WaitHandle], millisecondsTimeout: int, exitContext: bool) -> bool:...
        @typing.overload
        def __call__(self, waitHandles: Array_1[WaitHandle], timeout: TimeSpan, exitContext: bool) -> bool:...

    # Skipped WaitAny due to it being static, abstract and generic.

    WaitAny : WaitAny_MethodGroup
    class WaitAny_MethodGroup:
        @typing.overload
        def __call__(self, waitHandles: Array_1[WaitHandle]) -> int:...
        @typing.overload
        def __call__(self, waitHandles: Array_1[WaitHandle], millisecondsTimeout: int) -> int:...
        @typing.overload
        def __call__(self, waitHandles: Array_1[WaitHandle], timeout: TimeSpan) -> int:...
        @typing.overload
        def __call__(self, waitHandles: Array_1[WaitHandle], millisecondsTimeout: int, exitContext: bool) -> int:...
        @typing.overload
        def __call__(self, waitHandles: Array_1[WaitHandle], timeout: TimeSpan, exitContext: bool) -> int:...

    # Skipped WaitOne due to it being static, abstract and generic.

    WaitOne : WaitOne_MethodGroup
    class WaitOne_MethodGroup:
        @typing.overload
        def __call__(self) -> bool:...
        @typing.overload
        def __call__(self, millisecondsTimeout: int) -> bool:...
        @typing.overload
        def __call__(self, timeout: TimeSpan) -> bool:...
        @typing.overload
        def __call__(self, millisecondsTimeout: int, exitContext: bool) -> bool:...
        @typing.overload
        def __call__(self, timeout: TimeSpan, exitContext: bool) -> bool:...



class WaitHandleCannotBeOpenedException(ApplicationException):
    @typing.overload
    def __init__(self) -> None: ...
    @typing.overload
    def __init__(self, message: str) -> None: ...
    @typing.overload
    def __init__(self, message: str, innerException: Exception) -> None: ...
    @property
    def Data(self) -> IDictionary: ...
    @property
    def HelpLink(self) -> str: ...
    @HelpLink.setter
    def HelpLink(self, value: str) -> str: ...
    @property
    def HResult(self) -> int: ...
    @HResult.setter
    def HResult(self, value: int) -> int: ...
    @property
    def InnerException(self) -> Exception: ...
    @property
    def Message(self) -> str: ...
    @property
    def Source(self) -> str: ...
    @Source.setter
    def Source(self, value: str) -> str: ...
    @property
    def StackTrace(self) -> str: ...
    @property
    def TargetSite(self) -> MethodBase: ...


class WaitHandleExtensions(abc.ABC):
    @staticmethod
    def GetSafeWaitHandle(waitHandle: WaitHandle) -> SafeWaitHandle: ...
    @staticmethod
    def SetSafeWaitHandle(waitHandle: WaitHandle, value: SafeWaitHandle) -> None: ...


class WaitOrTimerCallback(MulticastDelegate):
    def __init__(self, object: typing.Any, method: int) -> None: ...
    @property
    def Method(self) -> MethodInfo: ...
    @property
    def Target(self) -> typing.Any: ...
    def BeginInvoke(self, state: typing.Any, timedOut: bool, callback: AsyncCallback, object: typing.Any) -> IAsyncResult: ...
    def EndInvoke(self, result: IAsyncResult) -> None: ...
    def Invoke(self, state: typing.Any, timedOut: bool) -> None: ...

