import { Schedule } from 'aws-cdk-lib/aws-events';
import { ITopic } from 'aws-cdk-lib/aws-sns';
import { Construct } from 'constructs';
/**
 * Properties for a SslServerTest
 */
export interface SslServerTestProps {
    /**
     * The hostname to test
     */
    readonly host: string;
    /**
     * Minimum grade for the test. The grade is calculated
     * using the worst grade of all endpoints.
     *
     * Used to send the results to an alarm SNS topic.
     *
     * @default SslServerTestGrade.A_PLUS
     */
    readonly minimumGrade?: SslServerTestGrade;
    /**
     * The topic to which the results must be sent when the
     * grade is below the minimum grade.
     *
     * @default - a new topic is created
     */
    readonly alarmTopic?: ITopic;
    /**
     * The schedule for the test
     *
     * @default - every day
     */
    readonly schedule?: Schedule;
}
/**
 * SSL Server test grade
 */
export declare enum SslServerTestGrade {
    A_PLUS = "A+",
    A = "A",
    A_MINUS = "A-",
    B = "B",
    C = "C",
    D = "D",
    E = "E",
    F = "F"
}
/**
 * Perform SSL server test for a hostname
 */
export declare class SslServerTest extends Construct {
    /**
     * The topic to which the SSL test results are sent when the grade is
     * below the minimum grade
     */
    readonly alarmTopic: ITopic;
    constructor(scope: Construct, id: string, props: SslServerTestProps);
}
