/*
 * Decompiled with CFR 0.152.
 */
package ai.h2o.com.google.protobuf;

import ai.h2o.com.google.protobuf.ByteString;
import ai.h2o.com.google.protobuf.CodedInputStream;
import ai.h2o.com.google.protobuf.CodedOutputStream;
import ai.h2o.com.google.protobuf.InvalidProtocolBufferException;
import ai.h2o.com.google.protobuf.MessageLiteToString;
import ai.h2o.com.google.protobuf.WireFormat;
import java.io.IOException;
import java.util.Arrays;

public final class UnknownFieldSetLite {
    private static final int MIN_CAPACITY = 8;
    private static final UnknownFieldSetLite DEFAULT_INSTANCE = new UnknownFieldSetLite(0, new int[0], new Object[0], false);
    private int count;
    private int[] tags;
    private Object[] objects;
    private int memoizedSerializedSize = -1;
    private boolean isMutable;

    public static UnknownFieldSetLite getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    static UnknownFieldSetLite newInstance() {
        return new UnknownFieldSetLite();
    }

    static UnknownFieldSetLite mutableCopyOf(UnknownFieldSetLite first, UnknownFieldSetLite second) {
        int n2 = first.count + second.count;
        int[] nArray = Arrays.copyOf(first.tags, n2);
        System.arraycopy(second.tags, 0, nArray, first.count, second.count);
        Object[] objectArray = Arrays.copyOf(first.objects, n2);
        System.arraycopy(second.objects, 0, objectArray, first.count, second.count);
        return new UnknownFieldSetLite(n2, nArray, objectArray, true);
    }

    private UnknownFieldSetLite() {
        this(0, new int[8], new Object[8], true);
    }

    private UnknownFieldSetLite(int count, int[] tags, Object[] objects, boolean isMutable) {
        this.count = count;
        this.tags = tags;
        this.objects = objects;
        this.isMutable = isMutable;
    }

    public final void makeImmutable() {
        this.isMutable = false;
    }

    final void checkMutable() {
        if (!this.isMutable) {
            throw new UnsupportedOperationException();
        }
    }

    public final void writeTo(CodedOutputStream output) throws IOException {
        block7: for (int i2 = 0; i2 < this.count; ++i2) {
            int n2 = this.tags[i2];
            int n3 = WireFormat.getTagFieldNumber(n2);
            switch (WireFormat.getTagWireType(n2)) {
                case 0: {
                    output.writeUInt64(n3, (Long)this.objects[i2]);
                    continue block7;
                }
                case 5: {
                    output.writeFixed32(n3, (Integer)this.objects[i2]);
                    continue block7;
                }
                case 1: {
                    output.writeFixed64(n3, (Long)this.objects[i2]);
                    continue block7;
                }
                case 2: {
                    output.writeBytes(n3, (ByteString)this.objects[i2]);
                    continue block7;
                }
                case 3: {
                    output.writeTag(n3, 3);
                    ((UnknownFieldSetLite)this.objects[i2]).writeTo(output);
                    output.writeTag(n3, 4);
                    continue block7;
                }
                default: {
                    throw InvalidProtocolBufferException.invalidWireType();
                }
            }
        }
    }

    public final void writeAsMessageSetTo(CodedOutputStream output) throws IOException {
        for (int i2 = 0; i2 < this.count; ++i2) {
            int n2 = WireFormat.getTagFieldNumber(this.tags[i2]);
            output.writeRawMessageSetExtension(n2, (ByteString)this.objects[i2]);
        }
    }

    public final int getSerializedSizeAsMessageSet() {
        int n2 = this.memoizedSerializedSize;
        if (n2 != -1) {
            return n2;
        }
        n2 = 0;
        for (int i2 = 0; i2 < this.count; ++i2) {
            int n3 = this.tags[i2];
            int n4 = WireFormat.getTagFieldNumber(n3);
            n2 += CodedOutputStream.computeRawMessageSetExtensionSize(n4, (ByteString)this.objects[i2]);
        }
        this.memoizedSerializedSize = n2;
        return n2;
    }

    public final int getSerializedSize() {
        int n2 = this.memoizedSerializedSize;
        if (n2 != -1) {
            return n2;
        }
        n2 = 0;
        block7: for (int i2 = 0; i2 < this.count; ++i2) {
            int n3 = this.tags[i2];
            int n4 = WireFormat.getTagFieldNumber(n3);
            switch (WireFormat.getTagWireType(n3)) {
                case 0: {
                    n2 += CodedOutputStream.computeUInt64Size(n4, (Long)this.objects[i2]);
                    continue block7;
                }
                case 5: {
                    n2 += CodedOutputStream.computeFixed32Size(n4, (Integer)this.objects[i2]);
                    continue block7;
                }
                case 1: {
                    n2 += CodedOutputStream.computeFixed64Size(n4, (Long)this.objects[i2]);
                    continue block7;
                }
                case 2: {
                    n2 += CodedOutputStream.computeBytesSize(n4, (ByteString)this.objects[i2]);
                    continue block7;
                }
                case 3: {
                    n2 += (CodedOutputStream.computeTagSize(n4) << 1) + ((UnknownFieldSetLite)this.objects[i2]).getSerializedSize();
                    continue block7;
                }
                default: {
                    throw new IllegalStateException(InvalidProtocolBufferException.invalidWireType());
                }
            }
        }
        this.memoizedSerializedSize = n2;
        return n2;
    }

    private static boolean equals(int[] tags1, int[] tags2, int count) {
        for (int i2 = 0; i2 < count; ++i2) {
            if (tags1[i2] == tags2[i2]) continue;
            return false;
        }
        return true;
    }

    private static boolean equals(Object[] objects1, Object[] objects2, int count) {
        for (int i2 = 0; i2 < count; ++i2) {
            if (objects1[i2].equals(objects2[i2])) continue;
            return false;
        }
        return true;
    }

    public final boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UnknownFieldSetLite)) {
            return false;
        }
        UnknownFieldSetLite unknownFieldSetLite = (UnknownFieldSetLite)obj;
        return this.count == unknownFieldSetLite.count && UnknownFieldSetLite.equals(this.tags, unknownFieldSetLite.tags, this.count) && UnknownFieldSetLite.equals(this.objects, unknownFieldSetLite.objects, this.count);
    }

    private static int hashCode(int[] tags, int count) {
        int n2 = 17;
        for (int i2 = 0; i2 < count; ++i2) {
            n2 = n2 * 31 + tags[i2];
        }
        return n2;
    }

    private static int hashCode(Object[] objects, int count) {
        int n2 = 17;
        for (int i2 = 0; i2 < count; ++i2) {
            n2 = n2 * 31 + objects[i2].hashCode();
        }
        return n2;
    }

    public final int hashCode() {
        int n2 = 527 + this.count;
        n2 = n2 * 31 + UnknownFieldSetLite.hashCode(this.tags, this.count);
        n2 = n2 * 31 + UnknownFieldSetLite.hashCode(this.objects, this.count);
        return n2;
    }

    final void printWithIndent(StringBuilder buffer, int indent) {
        for (int i2 = 0; i2 < this.count; ++i2) {
            int n2 = WireFormat.getTagFieldNumber(this.tags[i2]);
            MessageLiteToString.printField(buffer, indent, String.valueOf(n2), this.objects[i2]);
        }
    }

    final void storeField(int tag, Object value) {
        this.checkMutable();
        this.ensureCapacity();
        this.tags[this.count] = tag;
        this.objects[this.count] = value;
        ++this.count;
    }

    private void ensureCapacity() {
        if (this.count == this.tags.length) {
            int n2 = this.count < 4 ? 8 : this.count >> 1;
            int n3 = this.count + n2;
            this.tags = Arrays.copyOf(this.tags, n3);
            this.objects = Arrays.copyOf(this.objects, n3);
        }
    }

    final boolean mergeFieldFrom(int tag, CodedInputStream input) throws IOException {
        this.checkMutable();
        int n2 = WireFormat.getTagFieldNumber(tag);
        switch (WireFormat.getTagWireType(tag)) {
            case 0: {
                this.storeField(tag, input.readInt64());
                return true;
            }
            case 5: {
                this.storeField(tag, input.readFixed32());
                return true;
            }
            case 1: {
                this.storeField(tag, input.readFixed64());
                return true;
            }
            case 2: {
                this.storeField(tag, input.readBytes());
                return true;
            }
            case 3: {
                UnknownFieldSetLite unknownFieldSetLite = new UnknownFieldSetLite();
                unknownFieldSetLite.mergeFrom(input);
                input.checkLastTagWas(WireFormat.makeTag(n2, 4));
                this.storeField(tag, unknownFieldSetLite);
                return true;
            }
            case 4: {
                return false;
            }
        }
        throw InvalidProtocolBufferException.invalidWireType();
    }

    final UnknownFieldSetLite mergeVarintField(int fieldNumber, int value) {
        this.checkMutable();
        if (fieldNumber == 0) {
            throw new IllegalArgumentException("Zero is not a valid field number.");
        }
        this.storeField(WireFormat.makeTag(fieldNumber, 0), value);
        return this;
    }

    final UnknownFieldSetLite mergeLengthDelimitedField(int fieldNumber, ByteString value) {
        this.checkMutable();
        if (fieldNumber == 0) {
            throw new IllegalArgumentException("Zero is not a valid field number.");
        }
        this.storeField(WireFormat.makeTag(fieldNumber, 2), value);
        return this;
    }

    private UnknownFieldSetLite mergeFrom(CodedInputStream input) throws IOException {
        int n2;
        while ((n2 = input.readTag()) != 0 && this.mergeFieldFrom(n2, input)) {
        }
        return this;
    }
}

