from __future__ import annotations

from typing import Final

DEFAULT_HANDSHAKE_TIMEOUT: Final[int] = 60
DEFAULT_SEND_TIMEOUT: Final[int] = 20
MAX_CONNECT_TIMEOUT: Final[int] = 60
TIMEOUT_INCREASE_FACTOR: Final[float] = 1.2

# CID to types mapping for Description Parser
DESCRIPTION_TYPES: Final = {
    1: "boolean",
    2: "integer",
    3: "enumeration",
    4: "float",
    5: "string",
    6: "dateTime",
    7: "temperatureCelsius",
    8: "temperatureFahrenheit",
    10: "hexBinary",
    16: "timeSpan",
    17: "percent",
    18: "dbm",
    19: "weight",
    20: "liquidVolume",
    21: "uidValue",
    22: "date",
    23: "time",
    24: "waterHardness",
    25: "point2D",
    26: "pose2D",
    27: "line2D",
    30: "rgb",
    31: "rpm",
    32: "flowRate",
    33: "length",
    34: "area",
    35: "power",
    36: "energy",
    37: "bigInteger",
    38: "identifier",
    39: "speed",
    40: "programInstruction",
    41: "weightPound",
    42: "localeString",
    43: "teaspoon",
    44: "tablespoon",
    45: "cup",
    46: "piece",
    47: "byteLength",
    48: "uuid",
    49: "timezone",
    50: "csv",
    51: "leaf",
    52: "bunch",
    53: "casket",
    54: "pinch",
    55: "stalk",
    56: "stick",
    57: "branch",
    58: "tray",
    59: "portion",
    61: "utcDateTime",
    62: "programRunSummary",
    63: "programSessionSummary",
    64: "liquidVolumeThroughput",
    65: "weightOunces",
    129: "booleanList",
    130: "integerList",
    131: "enumerationList",
    132: "floatList",
    133: "stringList",
    134: "dateTimeList",
    135: "temperatureCelsiusList",
    136: "temperatureFahrenheitList",
    138: "hexBinaryList",
    144: "timeSpanList",
    145: "percentList",
    146: "dBmList",
    147: "weightList",
    148: "liquidVolumeList",
    149: "uidValueList",
    150: "dateList",
    151: "timeList",
    152: "waterHardnessList",
    153: "point2DList",
    154: "pose2DList",
    155: "line2DList",
    156: "path",
    157: "polygon",
    158: "rgbList",
    159: "rpmList",
    160: "flowRateList",
    161: "lengthList",
    162: "areaList",
    163: "powerList",
    164: "energyList",
    165: "bigIntegerList",
    166: "identifierList",
    167: "speedList",
    168: "programInstructionList",
    169: "weightPoundList",
    170: "localeStringList",
    171: "teaspoonList",
    172: "tablespoonList",
    173: "cupList",
    174: "pieceList",
    175: "byteLengthList",
    176: "uuidList",
    177: "timezoneList",
    178: "csvList",
    179: "leafList",
    180: "bunchList",
    181: "casketList",
    182: "pinchList",
    183: "stalkList",
    184: "stickList",
    185: "branchList",
    186: "trayList",
    187: "portionList",
    189: "utcDateTimeList",
    190: "programRunSummaryList",
    191: "programSessionSummaryList",
    192: "liquidVolumeThroughputList",
    193: "weightOuncesList",
}

# CID to protocol type mapping for Description Parser
DESCRIPTION_PROTOCOL_TYPES: Final = {
    1: "Boolean",
    2: "Integer",
    3: "Integer",
    4: "Float",
    5: "String",
    6: "String",
    7: "Float",
    8: "Float",
    10: "String",
    16: "Integer",
    17: "Float",
    18: "Integer",
    19: "Integer",
    20: "Integer",
    21: "Integer",
    22: "String",
    23: "String",
    24: "Integer",
    25: "Object",
    26: "Object",
    27: "Object",
    30: "String",
    31: "Integer",
    32: "Integer",
    33: "Float",
    34: "Float",
    35: "Float",
    36: "Float",
    37: "Integer",
    38: "Integer",
    39: "Float",
    40: "Object",
    41: "Float",
    42: "Object",
    43: "Float",
    44: "Float",
    45: "Float",
    46: "Float",
    47: "Integer",
    48: "String",
    49: "Object",
    50: "String",
    51: "Float",
    52: "Float",
    53: "Float",
    54: "Float",
    55: "Float",
    56: "Float",
    57: "Float",
    58: "Integer",
    59: "Integer",
    61: "String",
    62: "Object",
    63: "Object",
    64: "Float",
    65: "Float",
    129: "Object",
    130: "Object",
    131: "Object",
    132: "Object",
    133: "Object",
    134: "Object",
    135: "Object",
    136: "Object",
    138: "Object",
    144: "Object",
    145: "Object",
    146: "Object",
    147: "Object",
    148: "Object",
    149: "Object",
    150: "Object",
    151: "Object",
    152: "Object",
    153: "Object",
    154: "Object",
    155: "Object",
    156: "Object",
    157: "Object",
    158: "Object",
    159: "Object",
    160: "Object",
    161: "Object",
    162: "Object",
    163: "Object",
    164: "Object",
    165: "Object",
    166: "Object",
    167: "Object",
    168: "Object",
    169: "Object",
    170: "Object",
    171: "Object",
    172: "Object",
    173: "Object",
    174: "Object",
    175: "Object",
    176: "Object",
    177: "Object",
    178: "Object",
    179: "Object",
    180: "Object",
    181: "Object",
    182: "Object",
    183: "Object",
    184: "Object",
    185: "Object",
    186: "Object",
    187: "Object",
    189: "Object",
    190: "Object",
    191: "Object",
    192: "Object",
    193: "Object",
}

ERROR_CODES = {
    200: "200 OK",
    202: "202 Accepted",
    400: "400 BadRequest",
    403: "403 Forbidden",
    404: "404 NotFound",
    405: "405 MethodNotAllowed",
    413: "413 RequestEntityTooLong",
    412: "414 RequestUriTooLong",
    429: "429 TooManyRequests",
    500: "500 InternalServerError",
    501: "501 NotImplemented",
    502: "502 BadGateway",
    503: "503 ServiceUnavailable",
    504: "504 GatewayTimeout",
    507: "507 InsufficientMemory",
    542: "BackendNotConnected",
    515: "Busy",
    535: "CmdViolation",
    540: "DeviceStateNotCompliant",
    543: "EnergyManagementNotConnected",
    533: "Incomplete",
    534: "Inconsistent",
    536: "InvalidFormat",
    532: "InvalidUIDValue",
    539: "LockedByLocalControl",
    518: "NoAccess",
    521: "NoAccessByList",
    530: "NoExecution",
    524: "NotAvailable",
    527: "NotAvailableByList",
    544: "NotInLocalWiFi",
    541: "ProcessStateNotCompliant",
    517: "ReadRequest Busy",
    520: "ReadRequest NoAccess",
    523: "ReadRequest NoAccessByList",
    526: "ReadRequest NotAvailable",
    529: "ReadRequest NotAvailableByList",
    514: "ReadRequest UnknownUID",
    537: "RemoteControlNotActive",
    538: "RemoteStartNotActive",
    512: "UnknownUID",
    531: "ValueOutOfRange",
    516: "WriteRequest Busy",
    519: "WriteRequest NoAccess",
    522: "WriteRequest NoAccessByList",
    525: "WriteRequest NotAvailable",
    528: "WriteRequest NotAvailableByList",
    513: "WriteRequest UnknownUID",
}
