# Generated by Django 2.1.9 on 2020-02-19 19:05

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import uuid


def fill_mymodel_uuid(apps, schema_editor):
    db_alias = schema_editor.connection.alias
    MyModel = apps.get_model('pyfb_reporting', 'cdr')
    for obj in MyModel.objects.using(db_alias).all():
        obj.uuid = uuid.uuid4()
        obj.save()


class Migration(migrations.Migration):

    dependencies = [
        ('pyfb_rating', '0005_auto_20190520_1604'),
        ('pyfb_reporting', '0006_cdr_route_json'),
    ]

    operations = [
        migrations.CreateModel(
            name='RREvent',
            fields=[
                ('pkid', models.BigAutoField(editable=False, primary_key=True, serialize=False)),
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, unique=True)),
                ('aleg_uuid', models.CharField(max_length=100, null=True, verbose_name='a leg call-ID')),
                ('bleg_uuid', models.CharField(default='', max_length=100, null=True, verbose_name='b leg call-ID')),
                ('route_json', django.contrib.postgres.fields.jsonb.JSONField()),
                ('cust_country_rate_id', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='rrevents', to='pyfb_rating.CustomerCountryRate', verbose_name='customer rate')),
                ('cust_country_type_rate_id', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='rrevents', to='pyfb_rating.CustomerCountryTypeRate', verbose_name='customer rate')),
                ('cust_def_rate_id', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='cdrs', to='pyfb_rating.CustomerDefaultRate', verbose_name='customer rate')),
                ('cust_dest_rate_id', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='rrevents', to='pyfb_rating.CustomerDestinationRate', verbose_name='customer rate')),
                ('cust_prefix_rate_id', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='rrevents', to='pyfb_rating.CustomerPrefixRate', verbose_name='customer rate')),
                ('cust_region_rate_id', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='rrevents', to='pyfb_rating.CustomerRegionRate', verbose_name='customer rate')),
                ('cust_region_type_rate_id', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='rrevents', to='pyfb_rating.CustomerRegionTypeRate', verbose_name='customer rate')),
                ('ratecard_id', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='rrevents', to='pyfb_rating.CustomerRatecard', verbose_name='ratecard')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.RemoveField(
            model_name='cdr',
            name='route_json',
        ),
        migrations.AddField(
            model_name='cdr',
            name='uuid',
            field=models.UUIDField(null=True),
        ),
        migrations.RunPython(fill_mymodel_uuid, migrations.RunPython.noop),
        migrations.AlterField(
            model_name='cdr',
            name='uuid',
            field=models.UUIDField(default=uuid.uuid4, editable=False, unique=True),
        ),
        migrations.RemoveField('cdr', 'id'),
        migrations.RenameField(
            model_name='cdr',
            old_name='uuid',
            new_name='id'
        ),
        migrations.AddField(
            model_name='cdr',
            name='pkid',
            field=models.BigAutoField(editable=False, primary_key=True, serialize=False),
            preserve_default=False,
        ),
    ]
